/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.util.Validate;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorAsyncHandle<T>
extends AsyncHandle<T> {
    private final AsyncHandle<T> ah;
    private final Executor executor;
    private static Logger logger = LoggerFactory.getLogger(ExecutorAsyncHandle.class);

    public ExecutorAsyncHandle(AsyncHandle<T> ah, Executor executor) {
        Validate.notNull(ah);
        Validate.notNull(executor);
        this.ah = ah;
        this.executor = executor;
    }

    @Override
    public void updateProgress(final DataValue progress) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    logger.trace("Progress update delegated to another thread.");
                    ExecutorAsyncHandle.this.ah.updateProgress(progress);
                }
                catch (RuntimeException ex) {
                    logger.debug("Unexpected error has occurred in the client code on updateProgress.", (Throwable)ex);
                }
            }
        };
        this.executor.execute(task);
    }

    @Override
    public void setResult(final T result) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    logger.trace("Result processing delegated to another thread.");
                    ExecutorAsyncHandle.this.ah.setResult(result);
                }
                catch (RuntimeException ex) {
                    logger.debug("Unexpected error has occurred in the client code on setResult.", (Throwable)ex);
                }
            }
        };
        this.executor.execute(task);
    }

    @Override
    public void setError(final RuntimeException error) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    logger.trace("Error processing delegated to another thread.");
                    ExecutorAsyncHandle.this.ah.setError(error);
                }
                catch (RuntimeException ex) {
                    logger.debug("Unexpected error has occurred in the client code on setError.", (Throwable)ex);
                }
            }
        };
        this.executor.execute(task);
    }
}

