/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.vmware.vapi.CoreException;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.dsig.json.CanonicalizationUtil;
import com.vmware.vapi.internal.protocol.common.json.JsonApiRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonApiResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonError;
import com.vmware.vapi.internal.protocol.common.json.JsonInvokeRequestParams2;
import com.vmware.vapi.internal.protocol.common.json.JsonSerializer;
import com.vmware.vapi.protocol.common.json.JsonRpcSerializer;
import java.io.IOException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMsgSerializer2
implements JsonSerializer,
JsonRpcSerializer {
    private static final Logger logger = LoggerFactory.getLogger(JsonMsgSerializer2.class);
    private static SimpleModule module = new SimpleModule("vAPI", new Version(0, 1, 0, null, null, null));
    private static final String METHOD_RESULT_OUTPUT = "output";
    private static final String METHOD_RESULT_ERROR = "error";
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonMsgSerializer2() {
        this.mapper.registerModule((Module)module);
    }

    @Override
    public byte[] serialize(Object object) {
        try {
            return this.mapper.writeValueAsBytes(object);
        }
        catch (IOException e) {
            logger.error("Failed to serialize JSON request", (Throwable)e);
            throw JsonMsgSerializer2.toVapiCoreException(e);
        }
    }

    @Override
    public String serializeDataValue(DataValue dataValue) {
        return this.serializeToString(dataValue);
    }

    public String serializeToString(Object object) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.error("Failed to serialize JSON request", (Throwable)e);
            throw JsonMsgSerializer2.toVapiCoreException(e);
        }
    }

    private static CoreException toVapiCoreException(Exception ex) {
        return new CoreException(MessageFactory.getMessage("vapi.json.serialize.ioerror", ex.getMessage()), (Throwable)ex);
    }

    static {
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new VoidValueSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new BooleanValueSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new IntegerValueSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new DoubleValueSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new StringValueSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new BlobValueSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new OptionalValueSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new ListValueSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new StructValueSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new SecretValueSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new BooleanValueSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new ErrorValueSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new MethodResultSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new AppContextSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new ApiRequestSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new ApiResponseSerializer());
        module.addSerializer((com.fasterxml.jackson.databind.JsonSerializer)new JsonErrorSerializer());
    }

    private static class JsonErrorSerializer
    extends StdSerializer<JsonError> {
        public JsonErrorSerializer() {
            super(JsonError.class);
        }

        public void serialize(JsonError error, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeNumberField("code", error.getCode());
            jgen.writeStringField("message", error.getMessage());
            if (error.getData() != null) {
                jgen.writeStringField("data", error.getData());
            }
            jgen.writeEndObject();
        }
    }

    private static class ApiResponseSerializer
    extends StdSerializer<JsonApiResponse> {
        public ApiResponseSerializer() {
            super(JsonApiResponse.class);
        }

        public void serialize(JsonApiResponse response, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField("jsonrpc", "2.0");
            jgen.writeStringField("id", response.getId());
            jgen.writeObjectField("result", (Object)response.getResult());
        }
    }

    private static class ApiRequestSerializer
    extends StdSerializer<JsonApiRequest> {
        public ApiRequestSerializer() {
            super(JsonApiRequest.class);
        }

        public void serialize(JsonApiRequest request, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField("jsonrpc", "2.0");
            jgen.writeStringField("id", request.getId());
            jgen.writeStringField("method", request.getMethod());
            JsonInvokeRequestParams2 params = (JsonInvokeRequestParams2)request.getParams();
            jgen.writeFieldName("params");
            jgen.writeStartObject();
            jgen.writeStringField("serviceId", params.getServiceId());
            jgen.writeStringField("operationId", params.getOperationId());
            jgen.writeObjectField("ctx", (Object)params.getCtx());
            jgen.writeObjectField("input", (Object)params.getInput());
            jgen.writeEndObject();
            jgen.writeEndObject();
        }
    }

    private static class AppContextSerializer
    extends StdSerializer<ExecutionContext> {
        private static final String APP_CTX = "appCtx";

        public AppContextSerializer() {
            super(ExecutionContext.class);
        }

        public void serialize(ExecutionContext ctx, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            ExecutionContext.ApplicationData additionalRequestData = ctx.retrieveApplicationData();
            if (additionalRequestData != null) {
                provider.defaultSerializeField(APP_CTX, additionalRequestData.getAllProperties(), jgen);
            } else {
                provider.defaultSerializeField(APP_CTX, Collections.emptyMap(), jgen);
            }
            jgen.writeEndObject();
        }
    }

    private static class MethodResultSerializer
    extends StdSerializer<MethodResult> {
        public MethodResultSerializer() {
            super(MethodResult.class);
        }

        public void serialize(MethodResult methodResult, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            DataValue output = methodResult.getOutput();
            ErrorValue error = methodResult.getError();
            jgen.writeStartObject();
            if (null != output) {
                provider.defaultSerializeField(JsonMsgSerializer2.METHOD_RESULT_OUTPUT, (Object)output, jgen);
            } else if (null != error) {
                provider.defaultSerializeField(JsonMsgSerializer2.METHOD_RESULT_ERROR, (Object)error, jgen);
            }
            jgen.writeEndObject();
        }
    }

    private static class SecretValueSerializer
    extends StdSerializer<SecretValue> {
        public SecretValueSerializer() {
            super(SecretValue.class);
        }

        public void serialize(SecretValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField(value.getType().getValue(), new String(value.getValue()));
            jgen.writeEndObject();
        }
    }

    private static class ErrorValueSerializer
    extends StdSerializer<ErrorValue> {
        public ErrorValueSerializer() {
            super(ErrorValue.class);
        }

        public void serialize(ErrorValue error, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeObjectFieldStart(error.getType().getValue());
            jgen.writeObjectField(error.getName(), error.getFields());
            jgen.writeEndObject();
            jgen.writeEndObject();
        }
    }

    private static class StructValueSerializer
    extends StdSerializer<StructValue> {
        public StructValueSerializer() {
            super(StructValue.class);
        }

        public void serialize(StructValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeObjectFieldStart(value.getType().getValue());
            jgen.writeObjectField(value.getName(), value.getFields());
            jgen.writeEndObject();
            jgen.writeEndObject();
        }
    }

    private static class ListValueSerializer
    extends StdSerializer<ListValue> {
        public ListValueSerializer() {
            super(ListValue.class);
        }

        public void serialize(ListValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartArray();
            for (DataValue serializeValue : value.getList()) {
                jgen.writeObject((Object)serializeValue);
            }
            jgen.writeEndArray();
        }
    }

    private static class OptionalValueSerializer
    extends StdSerializer<OptionalValue> {
        public OptionalValueSerializer() {
            super(OptionalValue.class);
        }

        public void serialize(OptionalValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeFieldName(value.getType().getValue());
            if (value.isSet()) {
                jgen.writeObject((Object)value.getValue());
            } else {
                jgen.writeNull();
            }
            jgen.writeEndObject();
        }
    }

    private static class BlobValueSerializer
    extends StdSerializer<BlobValue> {
        public BlobValueSerializer() {
            super(BlobValue.class);
        }

        public void serialize(BlobValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            provider.defaultSerializeField(value.getType().getValue(), (Object)value.getValue(), jgen);
            jgen.writeEndObject();
        }
    }

    private static class StringValueSerializer
    extends StdSerializer<StringValue> {
        public StringValueSerializer() {
            super(StringValue.class);
        }

        public void serialize(StringValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.getValue());
        }
    }

    private static class DoubleValueSerializer
    extends StdSerializer<DoubleValue> {
        public DoubleValueSerializer() {
            super(DoubleValue.class);
        }

        public void serialize(DoubleValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(CanonicalizationUtil.canonicalizeDouble(value.getValue()));
        }
    }

    private static class IntegerValueSerializer
    extends StdSerializer<IntegerValue> {
        public IntegerValueSerializer() {
            super(IntegerValue.class);
        }

        public void serialize(IntegerValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(value.getValue());
        }
    }

    private static class BooleanValueSerializer
    extends StdSerializer<BooleanValue> {
        public BooleanValueSerializer() {
            super(BooleanValue.class);
        }

        public void serialize(BooleanValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeBoolean(value.getValue());
        }
    }

    private static class VoidValueSerializer
    extends StdSerializer<VoidValue> {
        public VoidValueSerializer() {
            super(VoidValue.class);
        }

        public void serialize(VoidValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNull();
        }
    }
}

