/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.tracing.otel;

import com.vmware.vapi.internal.tracing.otel.OtelTracingSpan;
import com.vmware.vapi.internal.tracing.otel.TracingAttributeKey;
import com.vmware.vapi.internal.tracing.otel.TracingRequestAdapter;
import com.vmware.vapi.tracing.Tracer;
import com.vmware.vapi.tracing.TracingLevel;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtelTracer
implements Tracer {
    private static final String TRACER_NAME = "com.vmware.vapi";
    private static final Logger LOGGER = LoggerFactory.getLogger(OtelTracer.class);
    private static final short USER_AGENT_MAX_LEN = 128;
    private final TracingLevel tracingLevel;
    private final OpenTelemetry otel;
    private final io.opentelemetry.api.trace.Tracer tracer;

    public OtelTracer(OpenTelemetry otel, TracingLevel tracingLevel) {
        this.otel = Objects.requireNonNull(otel);
        this.tracingLevel = Objects.requireNonNull(tracingLevel);
        this.tracer = otel.getTracer(TRACER_NAME);
    }

    @Override
    public OtelTracingSpan attachServerSpan(HttpServletRequest request) {
        TextMapPropagator propagator = this.otel.getPropagators().getTextMapPropagator();
        Context context = propagator.extract(Context.current(), (Object)request, (TextMapGetter)new TracingRequestAdapter());
        Span decorated = this.tracer.spanBuilder("vapi-name-unset").setParent(context).setSpanKind(SpanKind.SERVER).startSpan();
        OtelTracingSpan span = new OtelTracingSpan(this.otel, decorated, this.tracingLevel);
        span.setAttribute(TracingAttributeKey.COMPONENT, "VAPI");
        String agent = OtelTracer.formatUserAgent(request);
        if (agent != null) {
            span.setAttribute(TracingAttributeKey.HTTP_USER_AGENT, agent);
        }
        LOGGER.trace("Started new span {}", (Object)decorated);
        return span;
    }

    static String formatUserAgent(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return null;
        }
        if (agent.length() > 128) {
            return agent.substring(0, 127);
        }
        return agent;
    }

    @Override
    public OtelTracingSpan createClientSpan(String name) {
        Span decorated = this.tracer.spanBuilder(name).setSpanKind(SpanKind.CLIENT).startSpan();
        OtelTracingSpan otelSpan = new OtelTracingSpan(this.otel, decorated, this.tracingLevel);
        otelSpan.setAttribute(TracingAttributeKey.COMPONENT, "VAPI");
        otelSpan.addEvent("user >> vAPI client", TracingAttributeKey.THREAD_NAME, Thread.currentThread().getName());
        LOGGER.trace("Started new span {}", (Object)decorated);
        return otelSpan;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.otel;
    }

    public TracingLevel getTraceLevel() {
        return this.tracingLevel;
    }
}

