/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vapi.internal.util.Validate;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonUtil.class);
    public static final JsonFactory JSON_FACTORY = new JsonFactory();

    public static JsonNode readObjectFieldValue(Reader jsonReader, String fieldName) throws JsonParseException, IOException {
        Validate.notNull(fieldName);
        Validate.notNull(jsonReader);
        SerializedString serializedNodeName = new SerializedString(fieldName);
        ObjectMapper mapper = new ObjectMapper();
        try (JsonParser parser = JSON_FACTORY.createParser(jsonReader);){
            parser.nextToken();
            while (!parser.nextFieldName((SerializableString)serializedNodeName)) {
                if (!parser.hasCurrentToken()) {
                    LOGGER.warn("JSON node {} not found", (Object)fieldName);
                    JsonNode jsonNode = null;
                    return jsonNode;
                }
                parser.skipChildren();
            }
            parser.nextToken();
            JsonNode jsonNode = (JsonNode)mapper.readTree(parser);
            return jsonNode;
        }
    }
}

