/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.exception.InternalException;
import com.vmware.vim.vmomi.client.http.HttpProtocolBinding;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.core.types.ManagedObjectFactory;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClient
implements Client {
    private static final Log _logger = LogFactory.getLog(HttpClient.class);
    private final HttpProtocolBinding _binding;
    private final ManagedObjectFactory _managedObjectFactory;
    private final Future<VmodlVersion> _version;
    private final VmodlContext _context;

    HttpClient(Future<VmodlVersion> version, HttpProtocolBinding binding, ManagedObjectFactory factory, VmodlContext context) {
        this._binding = binding;
        this._version = version;
        this._managedObjectFactory = factory;
        this._context = context;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Created VLSI client (@" + this.hashCode() + ")"));
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)"Dumping stack trace of the invocation:", (Throwable)new RuntimeException("VLSI client creation stack trace (not a real exception)"));
            }
        }
    }

    @Override
    public <T extends ManagedObject> T createStub(Class<T> clazz, ManagedObjectReference moRef) {
        try {
            return (T)((ManagedObject)clazz.cast(this._managedObjectFactory.createManagedObject(this._context, this._context.getVmodlTypeMap(), this.getVersion(), this.resolveMoRef(clazz, moRef))));
        }
        catch (InstantiationException e) {
            throw new InternalException(String.format("Error creating ManagedObjectReference '%1$s'", moRef), e);
        }
    }

    @Override
    public <T extends ManagedObject> T createStub(Class<T> clazz, String moId) {
        VmodlType type = this._context.getVmodlTypeMap().getLoadedVmodlType(clazz);
        if (type == null) {
            throw new IllegalArgumentException(String.format("Unable to determine type of '%1$s' in the client VMODL context", clazz));
        }
        return this.createStub(clazz, new ManagedObjectReference(type.getWsdlName(), moId));
    }

    private ManagedObjectReference resolveMoRef(Class<?> clazz, ManagedObjectReference moRef) {
        if (moRef.getType() != null) {
            return moRef;
        }
        ManagedObjectType moType = (ManagedObjectType)this._context.getVmodlTypeMap().getLoadedVmodlType(clazz);
        if (moType == null) {
            throw new IllegalArgumentException("No VMODL type registered for " + clazz);
        }
        ManagedObjectReference resolved = new ManagedObjectReference(moType.getWsdlName(), moRef.getValue(), moRef.getServerGuid());
        return resolved;
    }

    @Override
    public ProtocolBinding getBinding() {
        return this._binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        HttpConfigurationImpl httpConfig;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Shutting down VLSI client (@" + this.hashCode() + ")"));
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)"Dumping stack trace of the invocation:", (Throwable)new RuntimeException("VLSI client shutdown stack trace (not a real exception)"));
            }
        }
        HttpConfigurationImpl httpConfigurationImpl = httpConfig = (HttpConfigurationImpl)this._binding.getConfiguration();
        synchronized (httpConfigurationImpl) {
            httpConfig.getCompiledConfiguration().release(this);
        }
    }

    public ManagedObjectFactory getManagedObjectFactory() {
        return this._managedObjectFactory;
    }

    @Override
    public VmodlVersion getVersion() {
        try {
            return this._version.get();
        }
        catch (Exception e) {
            throw new InternalException("Error resolving version", e);
        }
    }
}

