/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.groups;

import com.vmware.srm.client.impex.configurables.groups.IeSrmConfigVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.StorageProviderSettingsConverter;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.storageProvider.DatastoreRecoverySpec;
import com.vmware.vim.binding.dr.storageProvider.GroupProtectionDetails;
import com.vmware.vim.binding.dr.storageProvider.GroupRecoveryDetails;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SrmConfigStorageProviderSettingsConverter
extends StorageProviderSettingsConverter<IeSrmConfigVmProtectionGroup> {
    public SrmConfigStorageProviderSettingsConverter(PcResult pcResult) {
        super(pcResult);
    }

    @Override
    protected void convertProtectionDetails(ManagedObjectReference vmProtectionGroup, GroupProtectionDetails details, IeSrmConfigVmProtectionGroup ieProtectionGroup) {
        super.convertProtectionDetails(vmProtectionGroup, details, ieProtectionGroup);
        ManagedObjectReference[] datastores = details.datastore;
        if (datastores == null) {
            return;
        }
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        List<String> datastoreIds = Arrays.stream(datastores).map(idBuilder::buildId).collect(Collectors.toList());
        ieProtectionGroup.setDatastores(datastoreIds);
    }

    @Override
    protected void convertRecoveryDetails(ManagedObjectReference vmProtectionGroup, GroupRecoveryDetails details, IeSrmConfigVmProtectionGroup ieProtectionGroup) {
        super.convertRecoveryDetails(vmProtectionGroup, details, ieProtectionGroup);
        DatastoreRecoverySpec[] specs = details.datastore;
        if (specs == null) {
            return;
        }
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        List<String> datastoreIds = Arrays.stream(specs).map(DatastoreRecoverySpec::getProtectedDatastore).filter(Objects::nonNull).flatMap(Arrays::stream).map(idBuilder::buildId).collect(Collectors.toList());
        ieProtectionGroup.setDatastores(datastoreIds);
    }
}

