/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.mappings;

import com.vmware.srm.client.impex.configurables.mappings.IeFolderMapping;
import com.vmware.srm.client.impex.configurables.mappings.IeMapping;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.vim.binding.dr.InventoryMapperBase;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderMappingsConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderMappingsConverter.class);

    public static IeFolderMapping[] fromVmodl(InventoryMapperBase.FolderMapping[] mappings) {
        if (ArrayUtils.isEmpty((Object[])mappings)) {
            return new IeFolderMapping[0];
        }
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        return (IeFolderMapping[])Arrays.stream(mappings).map(mapping -> new IeFolderMapping(idBuilder.buildId(mapping.primaryObject), idBuilder.buildId(mapping.secondaryObject))).filter(IeMapping::fromCurrentPair).toArray(IeFolderMapping[]::new);
    }

    public static InventoryMapperBase.FolderMapping[] toVmodl(IeFolderMapping[] ieMappings, InventoryExtractor.InventoryLookup inventory) {
        if (ArrayUtils.isEmpty((Object[])ieMappings)) {
            return null;
        }
        return (InventoryMapperBase.FolderMapping[])Arrays.stream(ieMappings).map(ieMapping -> {
            String primaryId = ieMapping.getPrimary();
            ManagedObjectReference primary = (ManagedObjectReference)inventory.get(primaryId);
            if (primary == null) {
                String message = ImpexL10N.localize("mappings.folder.primary", primaryId);
                LOGGER.warn(message);
                ImpexImportSrmContext.get().addError(message);
                return null;
            }
            String secondaryId = ieMapping.getSecondary();
            ManagedObjectReference secondary = (ManagedObjectReference)inventory.get(secondaryId);
            if (secondary == null) {
                String message = ImpexL10N.localize("mappings.folder.secondary", secondaryId);
                LOGGER.warn(message);
                ImpexImportSrmContext.get().addError(message);
                return null;
            }
            LOGGER.info("Adding folder mapping with ids {} {}.", (Object)primaryId, (Object)secondaryId);
            InventoryMapperBase.FolderMapping mapping = new InventoryMapperBase.FolderMapping();
            mapping.primaryObject = primary;
            mapping.secondaryObject = secondary;
            return mapping;
        }).filter(Objects::nonNull).toArray(InventoryMapperBase.FolderMapping[]::new);
    }
}

