/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.mappings;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.configurables.mappings.IeIPCustomizationRule;
import com.vmware.srm.client.impex.configurables.mappings.IeNetworkMapping;
import com.vmware.srm.client.impex.configurables.mappings.IpCustomizationRuleConverter;
import com.vmware.srm.client.impex.configurables.mappings.NetworkMappingsConverter;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.srm.client.impex.utils.MappingUtil;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.vim.binding.dr.IPMapping;
import com.vmware.vim.binding.dr.InventoryMapper;
import com.vmware.vim.binding.dr.InventoryMapperBase;
import com.vmware.vim.binding.dr.IpSubnetMapper;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkMappingsImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkMappingsImporter.class);
    private final boolean _local;
    private final InventoryMapper _mapper;
    private final IeNetworkMapping[] _ieNetworkMappings;
    private final InventoryExtractor.InventoryLookup _inventory;

    public NetworkMappingsImporter(boolean local, InventoryMapper mapper, IeNetworkMapping[] ieNetworkMappings, InventoryExtractor.InventoryLookup inventory) {
        this._local = local;
        this._mapper = mapper;
        this._ieNetworkMappings = ieNetworkMappings;
        this._inventory = inventory;
    }

    public Promise<Void> create() {
        return MappingUtil.getIpSubnetMapper(IContextUtil.getSrmService(this._local), IContextUtil.getSrmContent(this._local)).onError(error -> {
            LOGGER.warn("Could not get IPSubnetMapper for server with guid '{}'.", (Object)this._mapper._getRef(), error);
            ImpexImportSrmContext.get().addError(ImpexL10N.localize("mappings.network.subnetMapper", new Object[0]), (Exception)error);
        }).thenCompose(remoteIpSubnetMapper -> this.createNetworkMappings(this._mapper, (IpSubnetMapper)remoteIpSubnetMapper, this._ieNetworkMappings)).onError(error -> LOGGER.warn("Could not create network mappings with length '{}' for server with guid '{}'.", new Object[]{this._ieNetworkMappings.length, this._mapper._getRef(), error}));
    }

    private Promise<Void> createNetworkMappings(InventoryMapper mapper, IpSubnetMapper ipSubnetMapper, IeNetworkMapping[] networkMappings) {
        Map<InventoryMapperBase.NetworkMapping, IeIPCustomizationRule[]> mappingToRule = NetworkMappingsConverter.toVmodl(networkMappings, this._inventory);
        if (MapUtils.isEmpty(mappingToRule)) {
            LOGGER.debug("No network mappings added.");
            return Promises.resolve(null);
        }
        FuturePromise mappingsPromise = new FuturePromise();
        mapper.addNetworkMappings(mappingToRule.keySet().toArray(new InventoryMapperBase.NetworkMapping[mappingToRule.size()]), (Future)mappingsPromise);
        return mappingsPromise.thenCompose(ready -> {
            List<Promise<Void>> promises = this.createIPCustomizationRules(ipSubnetMapper, mappingToRule);
            if (promises.isEmpty()) {
                LOGGER.debug("No IP customization added.");
                return Promises.resolve(null);
            }
            return Promises.all((Promise[])promises.toArray(new Promise[promises.size()])).thenApply(unused -> null);
        });
    }

    private List<Promise<Void>> createIPCustomizationRules(IpSubnetMapper ipSubnetMapper, Map<InventoryMapperBase.NetworkMapping, IeIPCustomizationRule[]> mappingToRule) {
        return mappingToRule.entrySet().stream().map(entry -> {
            InventoryMapperBase.NetworkMapping mapping = (InventoryMapperBase.NetworkMapping)entry.getKey();
            IeIPCustomizationRule[] rules = (IeIPCustomizationRule[])entry.getValue();
            return this.createIPCustomizationRule(ipSubnetMapper, rules, mapping.primaryObject, mapping.secondaryObject);
        }).collect(Collectors.toList());
    }

    private Promise<Void> createIPCustomizationRule(IpSubnetMapper ipSubnetMapper, IeIPCustomizationRule[] rules, ManagedObjectReference primary, ManagedObjectReference secondary) {
        IPMapping ipMapping = IpCustomizationRuleConverter.toVmodl(rules, ipSubnetMapper._getRef().getServerGuid());
        if (ipMapping == null) {
            return Promises.resolve(null);
        }
        FuturePromise addMappingFp = new FuturePromise();
        ipSubnetMapper.addIpMapping(primary, secondary, ipMapping, (Future)addMappingFp);
        return addMappingFp;
    }
}

