/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.dr.recovery.RecoveryPlan;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.dr.recovery.RECOVERY_PLAN;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class PlanUtil {
    public static ManagedObjectReference getRootFolder(String guid) {
        return ClientUtils.createMoRef((String)"DrFolder", (String)"DrRecoveryRootFolder", (String)guid);
    }

    public static Promise<PcResult> getBasicRecoveryPlans(ServersView view, ManagedObjectReference root) {
        String[] stringArray;
        if (ImpexImportSrmContext.get().getImportConfig().allowOverrideProtectionSettings()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = RECOVERY_PLAN.INFO_.NAME;
            stringArray = stringArray2;
            stringArray2[1] = "localSettings";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = RECOVERY_PLAN.INFO_.NAME;
        }
        String[] props = stringArray;
        PropertyCollector.PropertySpec recoveryPlanSpec = PCUtil.createPropertySpec((String)"DrRecoveryRecoveryPlan", (String[])props);
        return PlanUtil.getRecoveryPlans(view, root, recoveryPlanSpec);
    }

    public static Promise<PcResult> getRecoveryPlanStatuses(ServersView view, String guid) {
        ManagedObjectReference root = PlanUtil.getRootFolder(guid);
        PropertyCollector.PropertySpec recoveryPlanSpec = PCUtil.createPropertySpec((String)"DrRecoveryRecoveryPlan", (String[])new String[]{RECOVERY_PLAN.INFO_.NAME, RECOVERY_PLAN.INFO_.STATE_INFO, "vmRecoveryStatus"});
        return PlanUtil.getRecoveryPlans(view, root, recoveryPlanSpec);
    }

    public static List<ManagedObjectReference> getRecoveryPlanMoRefs(PcResult pcResult) {
        if (pcResult == null) {
            return Collections.emptyList();
        }
        return pcResult.getMoRefs().stream().filter(moRef -> "DrRecoveryRecoveryPlan".equals(moRef.getType())).collect(Collectors.toList());
    }

    public static Promise<PcResult> getRecoveryPlans(ServersView view, ManagedObjectReference root, PropertyCollector.PropertySpec recoveryPlanSpec) {
        PropertyCollector.PropertySpec folderSpec = PCUtil.createPropertySpec((String)"DrFolder", (String[])new String[]{"name", "childEntity"});
        ObjectSpecBuilder specBuilder = new ObjectSpecBuilder(root);
        ObjectSpecBuilder.TraversalSpecBuilder rootTraversal = specBuilder.traverseTo("childEntity");
        rootTraversal.loopTo(rootTraversal.getName());
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec(new PropertyCollector.PropertySpec[]{recoveryPlanSpec, folderSpec}, new PropertyCollector.ObjectSpec[]{specBuilder.build()}, Boolean.valueOf(true));
        return PCUtil.retrieveProperties((ServersView)view, (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{filterSpec});
    }

    public static boolean isRecoverySiteLocal(RecoveryPlan.RecoveryState state) throws IllegalArgumentException {
        if (state == null) {
            throw new IllegalArgumentException("No recovery plan state provided");
        }
        switch (state) {
            case readySending: 
            case peerFailedOver: 
            case peerReprotectIncomplete: {
                return false;
            }
            case readyReceiving: 
            case noProtectionGroups: 
            case readyMixed: 
            case deleting: 
            case testInProgress: 
            case groupsInUse: 
            case testComplete: 
            case testInterrupted: 
            case cleanupInProgress: 
            case cleanupIncomplete: 
            case cleanupInterrupted: 
            case failoverInProgress: 
            case failedOver: 
            case partialFailover: 
            case failedOverSplit: 
            case failoverIncomplete: 
            case failoverInterrupted: 
            case reprotectInProgress: 
            case reprotectIncomplete: 
            case partialReprotect: 
            case reprotectInterrupted: 
            case unknownState: 
            case syncConflict: 
            case testInitiated: 
            case failoverInitiated: 
            case rollbackInitiated: 
            case reprotectInitiated: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown recovery plan state: " + state.toString());
    }
}

