/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.tool.io.InputWaiterRequester;
import com.vmware.srm.client.impex.tool.io.data.ArrayManagerCredentials;
import com.vmware.srm.client.impex.tool.io.data.Credentials;
import com.vmware.srm.client.impex.tool.io.data.KeyStoreData;
import com.vmware.srm.client.impex.tool.io.data.Lspp;
import com.vmware.srm.client.impex.tool.io.data.SrmPairInfo;
import com.vmware.srm.client.impex.tool.io.data.UserInputProperties;
import com.vmware.srm.client.impex.tool.io.request.FinalRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class FileInputWR
extends InputWaiterRequester {
    private final UserInputProperties _properties;
    private final AtomicBoolean _localCredentialsRequested = new AtomicBoolean(false);
    private final AtomicBoolean _remoteCredentialsRequested = new AtomicBoolean(false);
    private final Set<String> _requestedAms = Collections.synchronizedSet(new HashSet());

    public FileInputWR(IOHelper ioHelper, UserInputProperties properties) {
        super(ioHelper);
        this._properties = properties;
    }

    @Override
    public Promise<Lspp> promptForLspp() {
        return Promises.resolve((Object)this._properties.getLspp());
    }

    @Override
    public Promise<Boolean> promptForThumbprint(String host, String thumbprint) {
        return Promises.resolve((Object)true);
    }

    @Override
    public Promise<Boolean> promptForUsingLocalKeyStore(String host) {
        return Promises.resolve((Object)this._properties.isLocalUseKeyStore());
    }

    @Override
    public Promise<Boolean> promptForUsingLocalServiceAccount(String host) {
        return Promises.resolve((Object)this._properties.isLocalUseServiceAccount());
    }

    @Override
    public Promise<String> promptForLocalSAPath() {
        return Promises.resolve((Object)this._properties.getLocalSAPath());
    }

    @Override
    public Promise<Credentials> promptForLocalCredentials(String host) {
        if (this._localCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Local credentials have already been requested."));
        }
        return this.validateCredentials(this._properties.getLocalCredentials(), host);
    }

    @Override
    public Promise<KeyStoreData> promptForLocalKeyStoreData() {
        if (this._localCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Local keystore data has already been requested."));
        }
        return Promises.resolve((Object)this._properties.getLocalKeyStoreData());
    }

    @Override
    public Promise<String> promptForSrmServer(ArrayList<SrmPairInfo> srmPairInfos) {
        return this.promptForServer(srmPairInfos, this._properties.getLocalSrmName(), this._properties.getLocalSrmGuid());
    }

    private Promise<String> promptForServer(ArrayList<SrmPairInfo> srmPairInfos, String serverName, String serverGuid) {
        boolean haveSiteNameDuplicates;
        Map<String, String> matchingServersGuidToName = srmPairInfos.stream().filter(srmPairInfo -> srmPairInfo.getLocalName().equals(serverName)).collect(Collectors.toMap(SrmPairInfo::getLocalGuid, SrmPairInfo::getLocalName));
        boolean bl = haveSiteNameDuplicates = matchingServersGuidToName.size() > 1;
        if (!haveSiteNameDuplicates) {
            String guid = (String)matchingServersGuidToName.keySet().stream().iterator().next();
            if (Objects.isNull(guid)) {
                return Promises.reject((Exception)new IllegalArgumentException("No server named '" + serverName + "' is found."));
            }
            return Promises.resolve((Object)guid);
        }
        if (serverGuid == null) {
            this._ioHelper.writeln(String.format("Multiple servers with identical names: '%s'", serverName));
            for (Map.Entry<String, String> entry : matchingServersGuidToName.entrySet()) {
                this._ioHelper.writeln(String.format("- %s (%s)", entry.getValue(), entry.getKey()));
            }
            return Promises.reject((Exception)new IllegalArgumentException("Multiple SRM servers with identical names found. Provide Local SRM GUID and try again.\nCheck the list of servers with guids above."));
        }
        String guid = matchingServersGuidToName.keySet().stream().filter(serverGuid::equals).findFirst().orElse(null);
        if (Objects.isNull(guid)) {
            return Promises.reject((Exception)new IllegalArgumentException("Local srm guid: '" + serverGuid + "' listed in properties does not match the server name: '" + serverName + "'."));
        }
        return Promises.resolve((Object)guid);
    }

    @Override
    public Promise<Boolean> promptForUsingRemoteKeyStore(String host) {
        return Promises.resolve((Object)this._properties.isRemoteUseKeyStore());
    }

    @Override
    public Promise<Boolean> promptForUsingRemoteServiceAccount(String host) {
        return Promises.resolve((Object)this._properties.isRemoteUseServiceAccount());
    }

    @Override
    public Promise<String> promptForRemoteSAPath(String host) {
        return Promises.resolve((Object)this._properties.getRemoteSAPath());
    }

    @Override
    public Promise<Credentials> promptForRemoteCredentials(String srmName) {
        if (this._remoteCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Remote credentials have already been requested."));
        }
        return this.validateCredentials(this._properties.getRemoteCredentials(), srmName);
    }

    @Override
    public Promise<KeyStoreData> promptForRemoteKeyStoreData() {
        if (this._remoteCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Remote keystore data has already been requested."));
        }
        return Promises.resolve((Object)this._properties.getRemoteKeyStoreData());
    }

    @Override
    public InputWaiterRequester.AmErrorHandling continueOnAmError() {
        if (this._properties.continueAfterAmError()) {
            return InputWaiterRequester.AmErrorHandling.CONTINUE;
        }
        return InputWaiterRequester.AmErrorHandling.INTERRUPT;
    }

    @Override
    public Promise<Credentials> promptForAmCredentials(String amName) {
        ArrayManagerCredentials amCredentials = this._properties.getArrayManagerCredentials(amName);
        if (Objects.isNull(amCredentials)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException(String.format("Missing array manager properties for array manager '%s'.", amName)));
        }
        if (amCredentials.doSkip()) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("User rejected."));
        }
        if (!this._requestedAms.add(amName)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException(String.format("Credentials for array manger '%s' already requested.", amName)));
        }
        Credentials credentials = amCredentials.getCredentials();
        return this.validateCredentials(credentials, amName);
    }

    @Override
    public void complete(int exitCode, String completionMessage) {
        this._requests.add(new FinalRequest(exitCode, completionMessage));
    }

    private Promise<Credentials> validateCredentials(Credentials credentials, String target) {
        if (Objects.isNull((Object)credentials)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("No credentials provided for: " + target));
        }
        return Promises.resolve((Object)((Object)credentials));
    }
}

