/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io.data;

import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class KeyStoreData {
    private final String keyStoreType;
    private final String keyStorePath;
    private final char[] keyStorePass;
    private final String certAlias;
    private final String keyAlias;
    private final char[] keyPass;

    public KeyStoreData(String keyStoreType, String keyStorePath, String keyStorePass, String certAlias, String keyAlias, String keyPass) {
        Validate.notEmpty(keyStoreType, "keyStoreType");
        Validate.notEmpty(keyStorePath, "keyStorePath");
        Validate.notNull(keyStorePass, "keyStorePass");
        Validate.notEmpty(certAlias, "certAlias");
        Validate.notEmpty(keyAlias, "keyAlias");
        Validate.notNull(keyPass, "keyPass");
        this.keyStoreType = keyStoreType;
        this.keyStorePath = keyStorePath;
        this.keyStorePass = keyStorePass.toCharArray();
        this.certAlias = certAlias;
        this.keyAlias = keyAlias;
        this.keyPass = keyPass.toCharArray();
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public char[] getKeyStorePass() {
        return this.keyStorePass;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public char[] getKeyPass() {
        return this.keyPass;
    }

    public void reset() {
        KeyStoreData.reset(this.keyStorePass);
        KeyStoreData.reset(this.keyPass);
    }

    private static void reset(char[] pass) {
        Arrays.fill(pass, '\u0000');
    }

    public String toString() {
        return "KeyStoreData {" + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"keyStoreType = ", (Object)this.keyStoreType)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"keyStorePath = ", (Object)this.keyStorePath)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"certAlias = ", (Object)this.certAlias)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"keyAlias = ", (Object)this.keyAlias)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"keyPass = ", (Object)"***")), (boolean)false) + "\n}";
    }
}

