/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io.request;

import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.tool.io.data.SrmPairInfo;
import com.vmware.srm.client.impex.tool.io.request.Request;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class SrmSelectionRequest
extends Request<String> {
    private final IOHelper _ioHelper;
    private final ArrayList<SrmPairInfo> _srmPairInfos;

    public SrmSelectionRequest(IOHelper ioHelper, ArrayList<SrmPairInfo> srmPairInfos) {
        super(false);
        this._ioHelper = ioHelper;
        this._srmPairInfos = srmPairInfos;
    }

    @Override
    public String handle() {
        return this.collect();
    }

    private String collect() {
        int index;
        switch (this._srmPairInfos.size()) {
            case 0: {
                this._ioHelper.writeln("No SRM servers found.");
                return null;
            }
            case 1: {
                SrmPairInfo selectedSrm = this._srmPairInfos.get(0);
                this._ioHelper.writeln(String.format("One SRM server found: %s (%s)", selectedSrm.getLocalName(), selectedSrm.getLocalGuid()));
                return selectedSrm.getLocalGuid();
            }
        }
        this._ioHelper.writeln("Available SRM servers:");
        for (int i = 0; i < this._srmPairInfos.size(); ++i) {
            SrmPairInfo pairInfo = this._srmPairInfos.get(i);
            boolean isLocalSrmNameEqualToRemote = pairInfo.getLocalName().equals(pairInfo.getRemoteName());
            if (isLocalSrmNameEqualToRemote) {
                this._ioHelper.writeln(String.format("[%s] %s (%s) -> %s (%s)", i, pairInfo.getLocalName(), pairInfo.getLocalGuid(), pairInfo.getRemoteName(), pairInfo.getRemoteGuid()));
                continue;
            }
            this._ioHelper.writeln(String.format("[%s] %s -> %s", i, pairInfo.getLocalName(), pairInfo.getRemoteName()));
        }
        while (true) {
            String input;
            if (!StringUtils.isNumeric(input = this._ioHelper.readln())) {
                this._ioHelper.writeln("Enter a number:");
                continue;
            }
            index = Integer.parseInt(input);
            if (index >= 0 && index < this._srmPairInfos.size()) break;
            this._ioHelper.writeln(String.format("Enter a number in range [0:%s]:", this._srmPairInfos.size() - 1));
        }
        return this._srmPairInfos.get(index).getLocalGuid();
    }
}

