/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.oauth2;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.infrastructure.vapi.AsyncCallbackPromise;
import com.vmware.srm.client.infrastructure.vapi.VapiServiceImpl;
import com.vmware.srm.client.infrastructure.websso.LsppQuery;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.lspp.Types;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.vcenter.identity.Providers;
import com.vmware.vcenter.identity.ProvidersTypes;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import java.net.URI;
import java.security.KeyStore;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class OAuth2VapiUtils {
    private static final String VAPI_SERVICE_PRODUCT = "com.vmware.cis";
    private static final String VAPI_SERVICE_TYPE = "cs.vapi";
    private static final String VAPI_EP_TYPE = "com.vmware.vapi.endpoint";
    private static final String VAPI_EP_PROTOCOL = "vapi.json.https";

    static Promise<List<ProvidersTypes.Summary>> listIdentityProviders(LsppServiceEndpoint ep) {
        KeyStore sslStore;
        Validate.notNull((Object)ep, (String)"vApi endpoint");
        try {
            sslStore = CertificateUtils.createTrustStore((Collection)ep.getCertificates());
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
        return OAuth2VapiUtils.listIdentityProviders(ep.url, sslStore);
    }

    static Promise<LsppService> getServerRegistration() {
        String hostGuid;
        String lsppThumbprint;
        URI lsppUrl;
        try {
            lsppUrl = Config.get().getLsppUrl();
            lsppThumbprint = Config.get().getLsppThumbprint();
            hostGuid = Config.get().getServerGuid();
        }
        catch (Exception exc) {
            return Promises.reject((Exception)exc);
        }
        Promise<LsppService> srmReg = OAuth2VapiUtils.getSrmByGuid(lsppUrl, lsppThumbprint, hostGuid);
        Promise<LsppService> hmsReg = OAuth2VapiUtils.getHmsByGuid(lsppUrl, lsppThumbprint, hostGuid);
        return Promises.anyOf((Promise[])new Promise[]{srmReg, hmsReg});
    }

    static Promise<ProvidersTypes.Info> getProviderInfo(LsppServiceEndpoint ep, String provider) {
        KeyStore sslStore;
        try {
            sslStore = CertificateUtils.createTrustStore((Collection)ep.getCertificates());
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
        return OAuth2VapiUtils.getProviderInfo(ep.url, sslStore, provider);
    }

    private static Promise<ProvidersTypes.Info> getProviderInfo(URI vapiUrl, KeyStore vapiSslStore, String provider) {
        int socketTimeout;
        int connectTimeout;
        try {
            connectTimeout = (int)Config.get().getConnectTimeout();
            socketTimeout = (int)Config.get().getSocketTimeout();
        }
        catch (Exception exc) {
            return Promises.reject((Exception)exc);
        }
        VapiServiceImpl service = new VapiServiceImpl(vapiUrl, vapiSslStore, connectTimeout, socketTimeout);
        Providers providers = service.createStub(Providers.class);
        AsyncCallbackPromise<ProvidersTypes.Info> result = new AsyncCallbackPromise<ProvidersTypes.Info>();
        result.materialize().onSuccess(unused -> service.dispose());
        providers.get(provider, result);
        return result;
    }

    private static Promise<List<ProvidersTypes.Summary>> listIdentityProviders(URI vapiUrl, KeyStore vapiSslStore) {
        int socketTimeout;
        int connectTimeout;
        try {
            connectTimeout = (int)Config.get().getConnectTimeout();
            socketTimeout = (int)Config.get().getSocketTimeout();
        }
        catch (Exception exc) {
            return Promises.reject((Exception)exc);
        }
        VapiServiceImpl service = new VapiServiceImpl(vapiUrl, vapiSslStore, connectTimeout, socketTimeout);
        Providers providers = service.createStub(Providers.class);
        AsyncCallbackPromise<List<ProvidersTypes.Summary>> result = new AsyncCallbackPromise<List<ProvidersTypes.Summary>>();
        result.materialize().onSuccess(unused -> service.dispose());
        providers.list(result);
        return result;
    }

    public static Promise<LsppServiceEndpoint> getVapiLsppEndpoint() {
        String hostGuid;
        String lsppThumbprint;
        URI lsppUrl;
        try {
            lsppUrl = Config.get().getLsppUrl();
            lsppThumbprint = Config.get().getLsppThumbprint();
            hostGuid = Config.get().getServerGuid();
        }
        catch (Exception exc) {
            return Promises.reject((Exception)exc);
        }
        return OAuth2VapiUtils.getVapiLsppEndpoint(lsppUrl, lsppThumbprint, hostGuid);
    }

    public static Promise<LsppServiceEndpoint> getVapiLsppEndpoint(URI lsppUrl, String lsppThumbprint, String hostGuid) {
        Promise<LsppService> srmVc = OAuth2VapiUtils.getVcForSrm(lsppUrl, lsppThumbprint, hostGuid);
        Promise<LsppService> hmsVc = OAuth2VapiUtils.getVcForHms(lsppUrl, lsppThumbprint, hostGuid);
        return Promises.anyOf((Promise[])new Promise[]{srmVc, hmsVc}).thenCompose(vcReg -> OAuth2VapiUtils.getVapiLsppEndpointNodeId(lsppUrl, lsppThumbprint, vcReg.getNodeId()));
    }

    private static Promise<LsppServiceEndpoint> getVapiLsppEndpointNodeId(URI lsppUrl, String lsppThumbprint, String vcNodeId) {
        LsppQuery lq = new LsppQuery(lsppUrl, lsppThumbprint);
        Promise<Set<LsppService>> serviceRegs = lq.query(OAuth2VapiUtils.createLsppFilter(vcNodeId));
        serviceRegs.materialize().onSuccess(unused -> lq.dispose());
        return serviceRegs.thenApply(vApiRegs -> vApiRegs.stream().flatMap(service -> service.getEndpoints().stream()).findFirst().orElse(null));
    }

    private static ServiceRegistration.Filter createLsppFilter(String nodeId) {
        ServiceRegistration.Filter result = new ServiceRegistration.Filter();
        result.setNodeId(nodeId);
        result.setServiceType(new ServiceRegistration.ServiceType(VAPI_SERVICE_PRODUCT, VAPI_SERVICE_TYPE));
        result.setEndpointType(new ServiceRegistration.EndpointType(VAPI_EP_PROTOCOL, VAPI_EP_TYPE));
        return result;
    }

    private static Promise<LsppService> getServerRegByGuid(URI lsppUrl, String lsppThumbprint, Types.LsppType serviceType, String guid) {
        LsppQuery lq = new LsppQuery(lsppUrl, lsppThumbprint);
        Promise<Set<LsppService>> serviceRegs = lq.query(serviceType);
        serviceRegs.materialize().onSuccess(unused -> lq.dispose());
        return serviceRegs.thenApply(regs -> regs.stream().filter(sr -> sr.getId().equals(guid)).findFirst().orElseThrow(() -> OAuth2VapiUtils.getNotFoundExc(serviceType, guid)));
    }

    private static RuntimeException getNotFoundExc(Types.LsppType type, String guid) {
        return new RuntimeException(L10N.localize("oauth2.server.type.not.found", type.name(), guid));
    }

    private static Promise<LsppService> getVcForSrm(URI lsppUrl, String lsppThumbprint, String srmGuid) {
        return OAuth2VapiUtils.getSrmByGuid(lsppUrl, lsppThumbprint, srmGuid).thenApply(srmReg -> {
            String[] guids = LsppHelper.extractVcAndSrmGuid((LsppService)srmReg);
            if (guids == null) {
                throw new RuntimeException("Malformed SRM registration: " + srmReg);
            }
            return guids[0];
        }).thenCompose(vcGuid -> OAuth2VapiUtils.getServerRegByGuid(lsppUrl, lsppThumbprint, Types.LsppType.Vc, vcGuid));
    }

    private static Promise<LsppService> getVcForHms(URI lsppUrl, String lsppThumbprint, String hmsGuid) {
        return OAuth2VapiUtils.getHmsByGuid(lsppUrl, lsppThumbprint, hmsGuid).thenApply(hmsReg -> {
            String[] guids = LsppHelper.extractVcAndHmsGuid((LsppService)hmsReg);
            if (guids == null) {
                throw new RuntimeException("Malformed HMS registration: " + hmsReg);
            }
            return guids[0];
        }).thenCompose(vcGuid -> OAuth2VapiUtils.getServerRegByGuid(lsppUrl, lsppThumbprint, Types.LsppType.Vc, vcGuid));
    }

    public static Promise<LsppService> getSrmByGuid(URI lsppUrl, String lsppThumbprint, String guid) {
        return OAuth2VapiUtils.getServerRegByGuid(lsppUrl, lsppThumbprint, Types.LsppType.Srm, guid);
    }

    public static Promise<LsppService> getHmsByGuid(URI lsppUrl, String lsppThumbprint, String guid) {
        return OAuth2VapiUtils.getServerRegByGuid(lsppUrl, lsppThumbprint, Types.LsppType.Hms, guid);
    }
}

