/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.version.impl;

import com.vmware.vim.vmomi.client.version.VersionProvider;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FallbackVersionProvider
implements VersionProvider {
    private static final Log LOG = LogFactory.getLog(FallbackVersionProvider.class);
    private final List<VersionProvider> versionProviders;

    private FallbackVersionProvider(List<VersionProvider> versionProviders) {
        this.versionProviders = versionProviders;
    }

    @Override
    public CompletionStage<VmodlVersion> getVersionAsync(VersionProvider.GetVersionSpec spec) {
        CompletableFuture<VmodlVersion> future = new CompletableFuture<VmodlVersion>();
        FallbackVersionProvider.completeWithNextProvider(future, this.versionProviders.iterator(), spec);
        return future;
    }

    private static void completeWithNextProvider(CompletableFuture<VmodlVersion> future, Iterator<VersionProvider> iterator, VersionProvider.GetVersionSpec spec) {
        iterator.next().getVersionAsync(spec).whenComplete((version, ex) -> {
            if (ex != null) {
                if (iterator.hasNext() && ex instanceof VersionProvider.UnsupportedNegotiationMechanismException) {
                    LOG.debug((Object)"Unsupported negotiation encountered", ex);
                    FallbackVersionProvider.completeWithNextProvider(future, iterator, spec);
                    return;
                }
                future.completeExceptionally((Throwable)ex);
                return;
            }
            future.complete((VmodlVersion)version);
        });
    }

    public static class Builder {
        private List<VersionProvider> providers = new ArrayList<VersionProvider>(3);

        public Builder addProvider(VersionProvider provider) {
            this.providers.add(provider);
            return this;
        }

        public FallbackVersionProvider build() {
            if (this.providers.isEmpty()) {
                throw new IllegalStateException("At least one provider must be specified");
            }
            return new FallbackVersionProvider(this.providers);
        }
    }
}

