/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.importers.replications;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsPairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.vim.binding.hms.DatastorePath;
import com.vmware.vim.binding.hms.Disk;
import com.vmware.vim.binding.hms.Group;
import com.vmware.vim.binding.hms.ReplicationManager;
import com.vmware.vim.binding.hms.ServiceInstanceContent;
import com.vmware.vim.binding.hms.VirtualMachine;
import com.vmware.vim.binding.hms.fault.AlreadyReplicatedVmFault;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vr.client.impex.configurables.replications.IeDisk;
import com.vmware.vr.client.impex.configurables.replications.IeReplicationGroup;
import com.vmware.vr.client.impex.configurables.replications.IeVmInfo;
import com.vmware.vr.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.vr.client.impex.tool.HmsServersDataWrapper;
import com.vmware.vr.client.impex.tool.ImpexImportHmsContext;
import com.vmware.vr.client.impex.utils.DataStoreUtil;
import com.vmware.vr.client.impex.utils.HmsUtil;
import com.vmware.vr.client.impex.utils.IContextUtil;
import com.vmware.vr.client.impex.utils.VersionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ReplicationGroupsImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicationGroupsImporter.class);
    private static final String HMS_VERSION_831 = "8.3.1";
    private final boolean _local;
    private final InventoryExtractor.InventoryLookup _inventory;
    private final Profile[] _remoteProfiles;
    private final HmsServer _server;
    private final HmsService _remoteHmsService;
    private final ServiceInstanceContent _remoteServiceContent;
    private final ReplicationManager _replicationManager;
    private final VcServer _remoteVc;
    private final String _remoteGuid;

    public ReplicationGroupsImporter(boolean local, InventoryExtractor.InventoryLookup inventory, Profile[] remoteProfiles) {
        this._local = local;
        this._inventory = inventory;
        this._remoteProfiles = remoteProfiles;
        this._server = IContextUtil.getHmsServer(local);
        this._replicationManager = (ReplicationManager)((HmsService)this._server.service()).createStub(IContextUtil.getHmsContent(local).getReplicationManager());
        this._remoteHmsService = (HmsService)IContextUtil.getHmsServer(!local).service();
        HmsServersDataWrapper serversData = ImpexImportHmsContext.get().getServersDataWrapper();
        this._remoteServiceContent = this._local ? serversData.getRemoteContent() : serversData.getLocalContent();
        this._remoteVc = this._local ? ((HmsServer)serversData.getRemotePair().server()).vc() : ((HmsServer)serversData.getLocalPair().server()).vc();
        this._remoteGuid = this._local ? ((HmsServer)serversData.getRemotePair().server()).guid() : ((HmsServer)serversData.getLocalPair().server()).guid();
    }

    public Promise<Collection<ManagedObjectReference>> create() {
        List<IeReplicationGroup> groups = ImpexImportHmsContext.get().getConfigurablesWrapper().getReplicationGroups().stream().filter(group -> group.isLocal() == this._local).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(groups)) {
            LOGGER.info("No Replication Group will be imported on server [{}]:[{}].", (Object)this._server.getName(), (Object)this._server.guid());
            return Promises.resolve(null);
        }
        LOGGER.info("[{}] Replication Groups will be imported on server [{}]:[{}].", new Object[]{groups.size(), this._server.getName(), this._server.guid()});
        return this.configureReplications(groups);
    }

    private Promise<Collection<ManagedObjectReference>> configureReplications(List<IeReplicationGroup> ieReplicationGroups) {
        return Streams.from(ieReplicationGroups).flatMap(group -> this._server.getPairByGuid(this._remoteGuid).thenCompose(hmsPairSetup -> this.configureReplicationBy((HmsPairSetup)hmsPairSetup, (IeReplicationGroup)group)).materialize().thenApply(pr -> {
            if (pr.isSuccessful()) {
                return (ManagedObjectReference)pr.getResult();
            }
            Exception error = pr.getError();
            if (error instanceof UnsupportedOperationException) {
                return null;
            }
            throw new RuntimeException(error);
        })).collect().onError(error -> LOGGER.warn("Error while importing Replication Groups for server with guid '{}'.", (Object)this._server.guid(), error));
    }

    private Promise<ManagedObjectReference> configureReplicationBy(HmsPairSetup hmsPairSetup, IeReplicationGroup ieReplicationGroup) {
        String vmName = ieReplicationGroup.getSettings() == null ? "NULL" : ieReplicationGroup.getSettings().getName();
        return this.buildVcReplicationSpec(ieReplicationGroup).onError(e -> ImpexImportHmsContext.get().addError(String.format("Unable to build vc replication spec for group: [%s].", vmName), (Exception)e)).thenCompose(replicationSpec -> this.configureReplication((Group.VcReplicationSpec)replicationSpec, hmsPairSetup.pairServerVmomiRef())).materialize().thenApply(pr -> {
            if (pr.isSuccessful()) {
                LOGGER.info("Replication group '{}' is successfully created.", (Object)vmName);
                ImpexImportHmsContext.get().addImportedGroupName(vmName);
                return (ManagedObjectReference)pr.getResult();
            }
            Exception error = pr.getError();
            LOGGER.warn("Unable to configure replication for vm '{}': ", (Object)vmName, (Object)error);
            ImpexImportHmsContext.get().addError(String.format("Unable to configure replication for vm '%s'.", vmName), error);
            if (error instanceof AlreadyReplicatedVmFault) {
                LOGGER.warn("Vm '{}' (in xml) already replicated, skipping configuring replication '{}'.", (Object)ieReplicationGroup.getVmInfo().getVm(), (Object)vmName);
            }
            return null;
        });
    }

    private String getStorageProfileIdByName(String name) {
        return Arrays.stream(this._remoteProfiles).filter(profile -> profile.getName().equals(name)).findFirst().orElseThrow(() -> new RuntimeException("Failed to Storage Profile name by name: " + name)).getProfileId().getUniqueId();
    }

    private Promise<Group.VcReplicationSpec> buildVcReplicationSpec(IeReplicationGroup group) {
        IeVmInfo vmInfo = group.getVmInfo();
        if (group.getSettings() == null) {
            new RuntimeException(String.format("Unexpected NULL settings in Replication group, cannot create replication!", new Object[0]));
        }
        if (Objects.isNull(vmInfo.getConfigFileLocation())) {
            return Promises.reject((Exception)new RuntimeException("Config File Location is null in vm with ID: " + vmInfo.getVm()));
        }
        if (Objects.isNull(vmInfo.getConfigFileLocation().getFriendlyName()) && Objects.isNull(vmInfo.getConfigFileLocation().getPath())) {
            return Promises.reject((Exception)new RuntimeException("Both FriendlyName and Path in ConfigFileLocation are null in vm with ID: " + vmInfo.getVm()));
        }
        if (Objects.isNull(this._inventory.get(vmInfo.getVm()))) {
            return Promises.reject((Exception)new RuntimeException("Inventory does not find the vm: " + vmInfo.getVm()));
        }
        String remoteProfileId = vmInfo.getStorageProfile() == null ? null : this.getStorageProfileIdByName(vmInfo.getStorageProfile().getName());
        ManagedObjectReference datastore = (ManagedObjectReference)this._inventory.get(vmInfo.getConfigFileLocation().getDatastore());
        String folderName = Objects.isNull(vmInfo.getConfigFileLocation().getFriendlyName()) ? vmInfo.getConfigFileLocation().getPath() : vmInfo.getConfigFileLocation().getFriendlyName();
        Promise<ManagedObjectReference> hbrsrvPromise = Promises.resolve(null);
        if (group.getSettings().getTargetHbrServerName() != null) {
            hbrsrvPromise = HmsUtil.getHbrSrvByName(this._remoteHmsService, this._remoteServiceContent, group.getSettings().getTargetHbrServerName());
        }
        DatastorePath location = new DatastorePath();
        location.setPath(folderName);
        List<Disk> disks = this.buildDisks(vmInfo.getDisks());
        location.setDatastore(datastore);
        VirtualMachine.VcReplicationVmSpec vmSpec = new VirtualMachine.VcReplicationVmSpec();
        vmSpec.setConfigFileLocation(location);
        vmSpec.setVm((ManagedObjectReference)this._inventory.get(vmInfo.getVm()));
        vmSpec.setExcludedDisks(vmInfo.getExcludedDisks());
        if (vmInfo.getStorageProfile() != null && remoteProfileId != null) {
            LOGGER.info("Setting profile ID: '{}' Name: '{}' for VM '{}'.", new Object[]{remoteProfileId, vmInfo.getStorageProfile().getName(), vmInfo.getVm()});
            vmSpec.setStorageProfileId(new ProfileId(remoteProfileId));
        }
        if (vmInfo.getDisks() != null && !vmInfo.getDisks().isEmpty()) {
            vmSpec.setDisks(disks.toArray(new Disk[disks.size()]));
        }
        Group.VcReplicationSpec groupSpec = new Group.VcReplicationSpec();
        groupSpec.settings = new Group.Settings();
        groupSpec.settings.setName(group.getSettings().getName());
        groupSpec.settings.setRpo(group.getSettings().getRpo());
        groupSpec.settings.setQuiesceGuestEnabled(group.getSettings().isQuiesceGuestEnabled());
        groupSpec.settings.setNetworkCompressionEnabled(group.getSettings().isNetworkCompressionEnabled());
        groupSpec.settings.setLwdEncryptionEnabled(group.getSettings().getLwdEncryptionEnabled());
        if (Objects.nonNull(group.getSettings().getRetentionPolicy()) && ArrayUtils.isNotEmpty(group.getSettings().getRetentionPolicy().getTiers())) {
            groupSpec.settings.setRetentionPolicy(new Group.RetentionPolicy((Group.RetentionPolicy.Tier[])Arrays.stream(group.getSettings().getRetentionPolicy().getTiers()).map(ieTier -> new Group.RetentionPolicy.Tier(ieTier.getGranularityMinutes(), ieTier.getNumSlots())).toArray(Group.RetentionPolicy.Tier[]::new)));
        }
        groupSpec.setVms(new VirtualMachine.VcReplicationVmSpec[]{vmSpec});
        Promise remoteHmsVersionPromise = this._remoteHmsService.getContent().thenApply(content -> content.getAbout().getVersion());
        Promise<Void> createFoldersPromise = this.ensureDirectoriesExist(vmSpec);
        return hbrsrvPromise.thenCombine(createFoldersPromise, (hbrsrv, createFolders) -> {
            groupSpec.settings.setTargetHbrServer(hbrsrv);
            return groupSpec;
        }).thenCombine(remoteHmsVersionPromise, (spec, hmsVersion) -> {
            if (VersionUtil.compareVersion(hmsVersion, HMS_VERSION_831) >= 0) {
                spec.settings.setAutoReplicateNewDisks(group.getSettings().getAutoReplicateNewDisks());
            }
            LOGGER.info("Replication spec is '{}'.", (Object)groupSpec);
            return spec;
        });
    }

    private List<Disk> buildDisks(Collection<IeDisk> ieDisks) {
        return ieDisks.stream().map(ieDisk -> this.buildDisk((IeDisk)ieDisk)).collect(Collectors.toList());
    }

    private Disk buildDisk(IeDisk ieDisk) {
        if (Objects.isNull(ieDisk.getDestination())) {
            throw new RuntimeException("Destination is null in Disk : " + ieDisk);
        }
        ManagedObjectReference datastore = (ManagedObjectReference)this._inventory.get(ieDisk.getDestination().getDatastore());
        String remoteProfileId = ieDisk.getStorageProfile() == null ? null : this.getStorageProfileIdByName(ieDisk.getStorageProfile().getName());
        String folderName = Objects.isNull(ieDisk.getDestination().getFriendlyName()) ? ieDisk.getDestination().getPath() : ieDisk.getDestination().getFriendlyName();
        DatastorePath diskLocation = new DatastorePath();
        Disk disk = new Disk();
        disk.setUseOfflineCopy(Boolean.valueOf(true));
        diskLocation.setPath(folderName);
        diskLocation.setDatastore(datastore);
        diskLocation.setFileName(ieDisk.getDestination().getFileName());
        disk.setDestination(diskLocation);
        disk.setDeviceKey(ieDisk.getDeviceKey());
        disk.setSkipDiskUuidValidation(Boolean.valueOf(ieDisk.isSkipDiskUuidValidation()));
        disk.setVirtualDiskType(ieDisk.getVirtualDiskType());
        if (ieDisk.getStorageProfile() != null && remoteProfileId != null) {
            LOGGER.info("Setting profile ID: '{}' Name: '{}' for Disk '{}'.", new Object[]{remoteProfileId, ieDisk.getStorageProfile().getName(), ieDisk.getDestination().getFileName()});
            disk.setStorageProfileId(new ProfileId(remoteProfileId));
        }
        LOGGER.debug("Disk properties are: '{}'.", (Object)disk.toString());
        return disk;
    }

    private Promise<ManagedObjectReference> configureReplication(Group.VcReplicationSpec groupSpec, ManagedObjectReference remoteServerRef) {
        LOGGER.info("Configuring replication for '{}' .", (Object)groupSpec);
        FuturePromise vmTasksPromise = new FuturePromise();
        this._replicationManager.configureReplication(remoteServerRef, groupSpec, "fake", (Future)vmTasksPromise);
        return vmTasksPromise.materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return ImpexImportHmsContext.get().monitor((ManagedObjectReference)pr.getResult());
            }
            return Promises.reject((Exception)pr.getError());
        });
    }

    private Promise<Void> ensureDirectoriesExist(VirtualMachine.VcReplicationVmSpec vmSpec) {
        return this._remoteHmsService.getContent().thenCompose(content -> {
            Set<Folder> folderSet = this.getVmfolders(vmSpec);
            ArrayList<Promise> createFoldersPromise = new ArrayList<Promise>();
            for (Folder folder : folderSet) {
                Promise<ManagedObjectReference> datacenterPromise = DataStoreUtil.getDatacenter(this._remoteVc, folder.getDatastore());
                Promise createFolderPromise = datacenterPromise.thenCompose(datacenter -> DataStoreUtil.createDirectory(this._remoteVc, datacenter, folder.getDatastore(), folder.getFolderPath()));
                createFoldersPromise.add(createFolderPromise);
            }
            return Promises.all((Promise[])createFoldersPromise.toArray(new Promise[createFoldersPromise.size()])).thenApply(unused -> null);
        });
    }

    private Set<Folder> getVmfolders(VirtualMachine.VcReplicationVmSpec vmSpec) {
        HashSet<Folder> vmFoldersSet = new HashSet<Folder>();
        vmFoldersSet.add(new Folder(vmSpec.getConfigFileLocation().getDatastore(), vmSpec.getConfigFileLocation().getPath()));
        for (Disk disk : vmSpec.getDisks()) {
            vmFoldersSet.add(new Folder(disk.getDestination().getDatastore(), disk.getDestination().getPath()));
        }
        return vmFoldersSet;
    }

    private static class Folder {
        private final ManagedObjectReference _datastore;
        private final String _folderPath;

        public Folder(ManagedObjectReference datastore, String folderPath) {
            this._datastore = datastore;
            this._folderPath = folderPath;
        }

        public ManagedObjectReference getDatastore() {
            return this._datastore;
        }

        public String getFolderPath() {
            return this._folderPath;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Folder)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            Folder other = (Folder)obj;
            return this._datastore.getValue().equals(other._datastore.getValue()) && this._datastore.getServerGuid().equals(other._datastore.getServerGuid()) && this._folderPath.equals(other._folderPath);
        }

        public int hashCode() {
            return Objects.hash(this._datastore.getValue(), this._folderPath);
        }
    }
}

