/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso.external;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.topology.impl.http.AsyncHttpUtils;
import com.vmware.srm.client.topology.impl.sso.external.ExternalTokenData;
import com.vmware.srm.client.topology.impl.sso.external.RefreshTokenResponse;
import com.vmware.srm.client.topology.impl.sso.external.jwt.JwtUtils;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.http.HttpStatus;

public class ExternalTokenClient {
    public static final ObjectMapper MAPPER = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enable(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    private final URI _remoteUIUri;
    private final ThumbprintVerifier _thumbprintVerifier;
    private final KeyStore _trustStore;
    private final Function<String, Promise<SamlToken>> _tokenCreator;

    public ExternalTokenClient(URI remoteUIUri, ThumbprintVerifier thumbprintVerifier, KeyStore trustStore, Function<String, Promise<SamlToken>> tokenCreator) {
        this._remoteUIUri = remoteUIUri;
        this._thumbprintVerifier = thumbprintVerifier;
        this._trustStore = trustStore;
        this._tokenCreator = tokenCreator;
    }

    void refreshToken(String refreshToken, CompletableFuture<ExternalTokenData> result) {
        HttpPost post = new HttpPost(this._remoteUIUri);
        List<BasicNameValuePair> params = Collections.singletonList(new BasicNameValuePair("refresh_token", refreshToken));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        AsyncHttpUtils.doPost(post, this._trustStore, this._thumbprintVerifier).thenCompose(response -> {
            RefreshTokenResponse refreshResponse;
            byte[] content;
            HttpStatus status = HttpStatus.valueOf((int)response.getStatusLine().getStatusCode());
            if (status.series() == HttpStatus.Series.CLIENT_ERROR || status.series() == HttpStatus.Series.SERVER_ERROR) {
                return Promises.reject((Exception)new RuntimeException("Failed to refresh token: " + response.getStatusLine()));
            }
            try {
                content = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            }
            catch (Exception e) {
                return Promises.reject((Exception)e);
            }
            if (content == null) {
                return Promises.reject((Exception)new RuntimeException("No content in response."));
            }
            try {
                refreshResponse = (RefreshTokenResponse)MAPPER.readValue(content, RefreshTokenResponse.class);
            }
            catch (Exception e) {
                return Promises.reject((Exception)new RuntimeException(e));
            }
            return this.fromResponse(refreshResponse);
        }).onSuccess(result::complete).onError(result::completeExceptionally);
    }

    private Promise<ExternalTokenData> fromResponse(RefreshTokenResponse refreshResponse) {
        Date expDate = JwtUtils.getExpClaim(refreshResponse.getRefreshToken());
        return this._tokenCreator.apply(refreshResponse.getSamlTokenAsXml()).thenApply(samlToken -> new ExternalTokenData((SamlToken)samlToken, expDate, refreshResponse.getRefreshToken()));
    }
}

