/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings;

import emitters.NsVersionAliases;
import emitters.Services;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.MetaVersion;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.SyntheticVersion;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PythonStubEmitter
extends VmodlEmitter {
    private final String _filename;
    private final boolean _isInternal;

    public PythonStubEmitter(String filename, boolean isInternal) {
        this._filename = filename;
        this._isInternal = isInternal;
        this.setHideInternalDecls(!isInternal);
        this.setHideUndocumentedDecls(!isInternal);
    }

    public boolean shouldEmit(Version version) {
        switch (version.getKind()) {
            case LTS: {
                return true;
            }
            case MILESTONE: 
            case FEATURE: {
                return false;
            }
        }
        return this._isInternal;
    }

    private SimplifiedVersion simplifyVersion(Parameter param) {
        if (!this.shouldGenerateFor(param)) {
            return new SimplifiedVersion();
        }
        return new SimplifiedVersion(param.getVersion());
    }

    private SimplifiedVersion simplifyVersion(VmodlApi vmodlApi) {
        if (!this.shouldGenerate(vmodlApi)) {
            return new SimplifiedVersion();
        }
        return new SimplifiedVersion(vmodlApi.getVersion());
    }

    private String privqq(String privilegeId) {
        if (privilegeId == null) {
            return "None";
        }
        return PythonStubEmitter.qq(privilegeId);
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.beginFile(this._filename);
        this.emitLine("# ******* WARNING - AUTO GENERATED CODE - DO NOT EDIT *******");
        this.emitLine("from .VmomiSupport import CreateDataType, CreateManagedType");
        this.emitLine("from .VmomiSupport import CreateEnumType");
        this.emitLine("from .VmomiSupport import AddVersion, AddVersionParent");
        this.emitLine("from .VmomiSupport import AddBreakingChangesInfo");
        this.emitLine("from .VmomiSupport import F_LINK, F_LINKABLE");
        this.emitLine("from .VmomiSupport import F_OPTIONAL, F_SECRET");
        this.emitLine("from .VmomiSupport import newestVersions, ltsVersions");
        this.emitLine("from .VmomiSupport import dottedVersions, oldestVersions");
        this.emitLine();
        MetaVersion mv = Versions.getMetaVersion(Versions.getVmodlNamespace());
        if (mv != null) {
            for (Map.Entry<String, Integer> e : mv.getBreakingChanges()) {
                this.emitLine("AddBreakingChangesInfo(" + PythonStubEmitter.qq(e.getKey()) + ", " + PythonStubEmitter.qq(Versions.getVmodlNamespace()) + ", " + e.getValue() + ")");
            }
        }
        Version targetVersion = Versions.getTargetVersion();
        for (Version version : Versions.getVersions()) {
            if (!this.shouldEmit(version) || !targetVersion.isAncestor(version)) continue;
            String printableWireId = version.getPrintableWireId();
            this.emitLine("AddVersion(" + PythonStubEmitter.qq(version.getVmodlName()) + ", " + PythonStubEmitter.qq(version.getWireNs()) + ", " + PythonStubEmitter.qq(printableWireId) + ", " + (version.isLegacy() ? "1" : "0") + ", " + PythonStubEmitter.qq(Services.schemaNamespaceId(version)) + ")");
        }
        for (Version version : Versions.getVersions()) {
            if (!this.shouldEmit(version) || !targetVersion.isAncestor(version)) continue;
            for (Version parent : Versions.getVersions()) {
                if (!version.isAncestor(parent) || !this.shouldEmit(parent)) continue;
                this.emitLine("AddVersionParent(" + PythonStubEmitter.qq(version.getVmodlName()) + ", " + PythonStubEmitter.qq(parent.getVmodlName()) + ")");
            }
        }
        if (this.emitMaturityInfo()) {
            this.emitLine();
            for (NsVersionAliases.Entry entry : Versions.getNsVersionAliases()) {
                if (!this.shouldEmit(entry.version)) continue;
                this.emitLine(entry.label.toLowerCase() + "Versions.Add(" + PythonStubEmitter.qq(entry.version.getVmodlName()) + ")");
            }
        }
        this.emitLine();
        for (VmodlObject obj : objects) {
            this.emitObject(obj);
        }
        this.endFile();
    }

    private boolean emitMaturityInfo() {
        boolean isBlacklisted = this._filename.contains("_typeinfo_core") || this._filename.contains("_typeinfo_query") || this._filename.contains("_typeinfo_hostd");
        return !isBlacklisted;
    }

    private void emitObject(VmodlObject obj) {
        switch (obj.getKind()) {
            case DataObject: {
                this.emitDataObject((DataObject)obj);
                break;
            }
            case Enum: {
                this.emitEnum((Enum)obj);
                break;
            }
            case ManagedObject: {
                this.emitManagedObject((ManagedObject)obj);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected object type");
            }
        }
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.emitObject(nestedObj);
        }
    }

    private void emitManagedObject(ManagedObject obj) {
        SimplifiedVersion sv = this.simplifyVersion(obj);
        if (!sv._emitAPIs) {
            return;
        }
        String str = "CreateManagedType(";
        str = str + PythonStubEmitter.qq(obj.getQualifiedVmodlType()) + ", ";
        str = str + PythonStubEmitter.qq(obj.getWsdlName()) + ", ";
        str = str + PythonStubEmitter.qq(obj.getBaseObject().getQualifiedVmodlType()) + ", ";
        str = str + PythonStubEmitter.qq(sv._version.getVmodlName()) + ", ";
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<String> methods = new ArrayList<String>();
        for (Property property : obj.getPropertyList()) {
            sv = this.simplifyVersion(property);
            if (!sv._emitAPIs) continue;
            properties.add("(" + PythonStubEmitter.qq(property.getName()) + ", " + PythonStubEmitter.qq(PythonStubEmitter.vmodlTypeName(property.getDecl())) + ", " + PythonStubEmitter.qq(sv._version.getVmodlName()) + ", " + this.fieldFlags(property.getDecl()) + ", " + this.privqq(property.getPrivilegeId()) + ")");
        }
        for (Method method : obj.getMethodList()) {
            sv = this.simplifyVersion(method);
            if (!sv._emitAPIs) continue;
            String s = "(" + PythonStubEmitter.qq(method.getName()) + ", ";
            s = s + PythonStubEmitter.qq(method.getWsdlName()) + ", ";
            s = s + PythonStubEmitter.qq(sv._version.getVmodlName()) + ", (";
            for (Parameter param : method.getParameterList()) {
                sv = this.simplifyVersion(param);
                if (!sv._emitAPIs) continue;
                s = s + "(" + PythonStubEmitter.qq(param.getName()) + ", " + PythonStubEmitter.qq(PythonStubEmitter.vmodlTypeName(param.getDecl())) + ", " + PythonStubEmitter.qq(sv._version.getVmodlName()) + ", " + this.fieldFlags(param.getDecl()) + ", " + this.privqq(param.getPrivilegeId()) + "),";
            }
            s = s + "), ";
            VmodlDecl methodReturnDecl = method.getReturnDecl();
            VmodlDecl decl = method.isTask() && Method.taskReturnDecl() != null ? Method.taskReturnDecl() : methodReturnDecl;
            s = s + "(" + this.fieldFlags(methodReturnDecl) + ", " + PythonStubEmitter.qq(PythonStubEmitter.vmodlTypeName(decl)) + ", " + PythonStubEmitter.qq(PythonStubEmitter.vmodlTypeName(methodReturnDecl)) + "), ";
            s = s + this.privqq(method.getPrivilegeId()) + ", ";
            List<DataObject> faults = method.getFaultList();
            if (faults != null && faults.size() > 0) {
                s = s + "[";
                for (VmodlObject vmodlObject : faults) {
                    s = s + PythonStubEmitter.qq(vmodlObject.getQualifiedVmodlType()) + ", ";
                }
                s = s + "]";
            } else {
                s = s + "None";
            }
            s = s + ")";
            methods.add(s);
        }
        str = properties.size() > 0 ? str + "[" + PythonStubEmitter.join(properties, ", ") + "]" : str + "None";
        str = str + ", ";
        str = methods.size() > 0 ? str + "[" + PythonStubEmitter.join(methods, ", ") + "]" : str + "None";
        str = str + ")";
        this.emitLine(str);
    }

    private void emitDataObject(DataObject obj) {
        SimplifiedVersion sv = this.simplifyVersion(obj);
        if (!sv._emitAPIs) {
            return;
        }
        String str = "CreateDataType(";
        str = str + PythonStubEmitter.qq(obj.getQualifiedVmodlType()) + ", ";
        str = str + PythonStubEmitter.qq(obj.getWsdlName()) + ", ";
        str = str + PythonStubEmitter.qq(obj.getBaseObject().getQualifiedVmodlType()) + ", ";
        str = str + PythonStubEmitter.qq(sv._version.getVmodlName()) + ", ";
        ArrayList<String> properties = new ArrayList<String>();
        for (Property property : obj.getPropertyList()) {
            sv = this.simplifyVersion(property);
            if (!sv._emitAPIs) continue;
            VmodlDecl decl = property.getDecl();
            properties.add("(" + PythonStubEmitter.qq(property.getName()) + ", " + PythonStubEmitter.qq(PythonStubEmitter.vmodlTypeName(decl)) + ", " + PythonStubEmitter.qq(sv._version.getVmodlName()) + ", " + this.fieldFlags(decl) + ")");
        }
        str = properties.size() > 0 ? str + "[" + PythonStubEmitter.join(properties, ", ") + "]" : str + "None";
        str = str + ")";
        this.emitLine(str);
    }

    private String fieldFlags(VmodlDecl decl) {
        String result;
        ArrayList<String> flags = new ArrayList<String>();
        if (decl.isLink()) {
            flags.add("F_LINK");
        }
        if (decl.isLinkable()) {
            flags.add("F_LINKABLE");
        }
        if (decl.isOptional()) {
            flags.add("F_OPTIONAL");
        }
        if (decl.isSecret()) {
            flags.add("F_SECRET");
        }
        return (result = PythonStubEmitter.join(flags, " | ")).isEmpty() ? "0" : result;
    }

    private void emitEnum(Enum obj) {
        SimplifiedVersion sv = this.simplifyVersion(obj);
        if (!sv._emitAPIs) {
            return;
        }
        String str = "CreateEnumType(";
        str = str + PythonStubEmitter.qq(obj.getQualifiedVmodlType()) + ", ";
        str = str + PythonStubEmitter.qq(obj.getWsdlName()) + ", ";
        str = str + PythonStubEmitter.qq(sv._version.getVmodlName()) + ", ";
        ArrayList<String> values = new ArrayList<String>();
        for (String value : obj.getValueList()) {
            values.add(PythonStubEmitter.qq(value));
        }
        str = str + "[" + PythonStubEmitter.join(values, ", ") + "])";
        this.emitLine(str);
    }

    public static String vmodlTypeName(VmodlDecl decl) {
        String typeName;
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                typeName = "boolean";
                break;
            }
            case BYTE: {
                typeName = "byte";
                break;
            }
            case SHORT: {
                typeName = "short";
                break;
            }
            case INT: {
                typeName = "int";
                break;
            }
            case LONG: {
                typeName = "long";
                break;
            }
            case FLOAT: {
                typeName = "float";
                break;
            }
            case DOUBLE: {
                typeName = "double";
                break;
            }
            case STRING: {
                typeName = "string";
                break;
            }
            case DATETIME: {
                typeName = "vmodl.DateTime";
                break;
            }
            case TYPENAME: {
                typeName = "vmodl.TypeName";
                break;
            }
            case METHODNAME: {
                typeName = "vmodl.MethodName";
                break;
            }
            case PROPPATH: {
                typeName = "vmodl.PropertyPath";
                break;
            }
            case URI: {
                typeName = "vmodl.URI";
                break;
            }
            case BINARY: {
                typeName = "vmodl.Binary";
                break;
            }
            case ANY: {
                typeName = "anyType";
                break;
            }
            case VOID: {
                typeName = "void";
                break;
            }
            case ENUM: 
            case MANAGED: 
            case DATA: {
                VmodlObject obj = decl.getObject();
                if (obj != null) {
                    typeName = obj.getQualifiedVmodlType();
                    break;
                }
                if (decl.isData()) {
                    typeName = "vmodl.DataObject";
                    break;
                }
                typeName = "vmodl.ManagedObject";
                break;
            }
            default: {
                throw new RuntimeException("Unexpected object type");
            }
        }
        if (decl.isArray()) {
            typeName = typeName + "[]";
        }
        return typeName;
    }

    private class SimplifiedVersion {
        final boolean _emitAPIs;
        final Version _version;

        SimplifiedVersion() {
            this._emitAPIs = false;
            this._version = null;
        }

        SimplifiedVersion(Version version) {
            switch (version.getKind()) {
                case LTS: {
                    this._emitAPIs = true;
                    this._version = version;
                    break;
                }
                case MILESTONE: 
                case FEATURE: {
                    this._emitAPIs = PythonStubEmitter.this._isInternal;
                    SyntheticVersion sv = (SyntheticVersion)version;
                    MetaVersion metaVersion2 = sv.getMetaVersion();
                    this._version = metaVersion2.getDevVersion();
                    break;
                }
                default: {
                    this._emitAPIs = PythonStubEmitter.this._isInternal;
                    this._version = version;
                }
            }
        }
    }
}

