/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.ObjectRegistry;
import emitters.generators.joap.JoapEmitter;
import emitters.model.DataObject;
import emitters.model.DataProperty;
import emitters.model.Entity;
import emitters.model.Field;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class VMODL2
extends JoapEmitter {
    private static final String ASTERISK = "&#42;";
    private static final String END_COMMENT = "&#42;/";
    private final DataProperty _discriminatorProperty;
    private static final SuffixMapping[] SUFFIX_MAPPINGS = new SuffixMapping[]{new SuffixMapping(PARAMS + ".array", "Parameters" + ARRAY), new SuffixMapping(".array", ARRAY), new SuffixMapping(".enum", ENUM), new SuffixMapping(".params", PARAMS), new SuffixMapping(PARAMS, "Parameters"), new SuffixMapping(".ID", ".IDENTIFIER"), new SuffixMapping(".Id", ".Identifier")};
    private static final String VMODL2_PACKAGE_PREFIX = "com.vmware.management.";

    public VMODL2(Map<String, String> options, String folder) {
        super(folder, true);
        List<Property> anyProperties = this._Any.getPropertyList();
        this._discriminatorProperty = (DataProperty)anyProperties.iterator().next();
        this.setIndentSpaces("    ");
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.processObjectList(ObjectRegistry.getAllObjects());
        this.emitParamsObjects();
        this.emitCoreObjects();
    }

    private void processObjectList(Collection<VmodlObject> objects) {
        for (VmodlObject object : objects) {
            if (!VMODL2.shouldEmit(object) || CORE_OBJECTS.contains(object)) continue;
            switch (object.getKind()) {
                case ManagedObject: {
                    ManagedObject managedObject = (ManagedObject)object;
                    this.emitManagedObject(managedObject);
                    break;
                }
                case DataObject: {
                    DataObject dataObject = (DataObject)object;
                    this.emitDataObject(dataObject);
                    this.emitDataObject(this.createBoxedArray(dataObject));
                    break;
                }
            }
            this.processObjectList(object.getNestedList());
        }
    }

    private void emitManagedObject(ManagedObject managedObject) {
        this._moTypesList.add(managedObject);
        String typeName = this.beginFile(managedObject);
        this.emitLine("import com.vmware.vapi.std.errors.*;");
        this.emitLine();
        this.emitComment(managedObject);
        this.emitLine("interface ", typeName, " {");
        String moType = managedObject.getJsonName();
        String namespace = _targetVersion.getNamespace();
        String version = _targetVersion.getWireId();
        this.indent();
        this.emitMethods(managedObject, moType, namespace, version);
        this.emitManagedProperties(managedObject, moType, namespace, version);
        this.unindent();
        this.emitLine("}");
        this.endFile();
    }

    private void emitMethods(ManagedObject managedObject, String moType, String namespace, String version) {
        for (Method method : managedObject.getMethodList()) {
            if (!VMODL2.shouldEmit(method)) continue;
            this.emitLine();
            this.emitComment(method, managedObject);
            this.emitLine("@RequestMapping(value=\"/", namespace, "/", version, "/", moType, "/{moId}/", method.getName(), "\",");
            this.emitLine("                method=RequestMethod.POST,");
            this.emitLine("                contentType=\"application/json\",");
            this.emitLine("                accept=\"application/json\")");
            VmodlDecl result = method.isTask() ? Method.taskReturnDecl() : method.getReturnDecl();
            this.emitPartial(this.getVmodl2Decl(result), " ", method.getName(), "(@PathVariable(\"moId\") String moId");
            DataObject methodParams = this.registerMethodParams(managedObject, method);
            if (methodParams != null) {
                this.indent();
                this.emitPartial(", @RequestBody ", VMODL2.getVmodl2TypeName(methodParams), " params");
                this.unindent();
            }
            this.emitLine(");");
            this.unindent();
        }
    }

    private void emitManagedProperties(ManagedObject managedObject, String moType, String namespace, String version) {
        for (Property property : managedObject.getPropertyListWithOverrides()) {
            if (!VMODL2.shouldEmit(property)) continue;
            String name = property.getName();
            this.emitLine();
            this.emitComment(property, managedObject);
            this.emitLine("@RequestMapping(value=\"/", namespace, "/", version, "/", moType, "/{moId}/", name, "\",");
            this.emitLine("                method=RequestMethod.GET,");
            this.emitLine("                contentType=\"application/json\",");
            this.emitLine("                accept=\"application/json\")");
            this.emitLine(this.getVmodl2Decl(property.getDecl()), " get", VMODL2.capitalize(name), "(@PathVariable(\"moId\") String moId);");
        }
    }

    private void emitDataObject(DataObject dataObject) {
        String typeName = this.beginFile(dataObject);
        this.emitLine();
        this.emitComment(dataObject);
        VmodlObject baseObject = dataObject.getBaseObject();
        if (baseObject != null || dataObject == this._Any) {
            this.emitStringTag("@DiscriminatedBy", dataObject.getJsonName());
            this.emitLine("@Includable");
        }
        if (baseObject != null) {
            this.emitLine("@Include(", VMODL2.getVmodl2TypeName(baseObject), ".class)");
        }
        this.emitDataObjectDefinition(dataObject, typeName);
        this.endFile();
    }

    private void emitDataObjectDefinition(DataObject dataObject, String typeName) {
        this.emitLine("class ", typeName, " {");
        this.indent();
        for (Field field : dataObject.getPropertyListWithOverrides()) {
            if (!VMODL2.shouldEmit(field)) continue;
            this.emitLine();
            this.emitComment(field, dataObject);
            String name = field.getName();
            this.emitStringTag("@SerializationName", name);
            if (field == this._discriminatorProperty) {
                this.emitLine("@Discriminator");
            }
            this.emitLine(this.getVmodl2Decl(field.getDecl()), " ", name, ";");
        }
        this.emitLine(UNINDENT, "}");
    }

    private void emitStringTag(String tagName, String content) {
        this.emitLine(tagName, "(\"", content, "\")");
    }

    private void emitParamsObjects() {
        for (DataObject methodParams : this._methodParams) {
            this.emitDataObject(methodParams);
        }
    }

    private void emitCoreObjects() {
        this.emitDataObject(this._Any);
        this.emitMoRefSchema();
        for (JoapEmitter.Primitive primitive : PRIMITIVES) {
            this.emitBoxedPrimitive(primitive);
        }
    }

    private void emitMoRefSchema() {
        String typeName = this.beginFile(this._MoRef);
        this.emitLine();
        this.emitDataObjectDefinition(this._MoRef, typeName);
        this.endFile();
    }

    private void emitBoxedPrimitive(JoapEmitter.Primitive primitive) {
        JoapEmitter.BoxedPair boxedPair = this.createBoxedPrimitive(primitive);
        VMODL2.setVmodl2TypeName(boxedPair._boxedObject, "com.vmware.management.core." + primitive.typeName + "Value");
        this.emitDataObject(boxedPair._boxedObject);
        this.emitDataObject(boxedPair._boxedArray);
    }

    private void emitComment(VmodlObject object) {
        this.emitComment(object, object);
    }

    private void emitComment(Entity entity, VmodlObject context) {
        this.emitComment(this.updateJavadocLinks(entity.getComment(), context));
    }

    private void emitComment(String comment) {
        if (comment == null) {
            return;
        }
        this.emitLine("/**", INDENT);
        for (String line : comment.split("\n")) {
            int endCommentPos = line.indexOf(END_COMMENT);
            if (endCommentPos != -1) {
                line = line.substring(0, endCommentPos) + " " + ASTERISK + " " + line.substring(endCommentPos + ASTERISK.length());
            }
            this.emitLine(line);
        }
        this.emitLine(UNINDENT, " */");
        this.emitLine();
    }

    @Override
    protected String getLink(VmodlObject object) {
        return VMODL2.getVmodl2TypeName(object);
    }

    private String getVmodl2Decl(VmodlDecl decl) {
        String result = this.getVmodl2Type(decl);
        if (decl.isArray()) {
            result = "List<" + result + ">";
        }
        if (decl.isOptional()) {
            result = "Optional<" + result + ">";
        }
        return result;
    }

    private String getVmodl2Type(VmodlDecl decl) {
        boolean shouldBox = decl.isOptional() || decl.isArray();
        switch (decl.getTypeId()) {
            case VOID: {
                return "void";
            }
            case BOOLEAN: {
                return shouldBox ? "Boolean" : "boolean";
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return shouldBox ? "Long" : "long";
            }
            case FLOAT: 
            case DOUBLE: {
                return shouldBox ? "Double" : "double";
            }
            case BINARY: {
                return "Binary";
            }
            case DATETIME: {
                return "DateTime";
            }
            case URI: 
            case METHODNAME: 
            case PROPPATH: 
            case TYPENAME: {
                return "String";
            }
            case STRING: {
                return decl.isSecret() ? "Secret" : "String";
            }
            case ANY: {
                return VMODL2.getVmodl2TypeName(this._Any);
            }
            case MANAGED: {
                return VMODL2.getVmodl2TypeName(this._MoRef);
            }
            case ENUM: {
                return "String";
            }
            case DATA: {
                return VMODL2.getVmodl2TypeName(decl.getObject());
            }
        }
        throw new RuntimeException("Unknown type");
    }

    private String beginFile(VmodlObject object) {
        String vmodl2name = VMODL2.getVmodl2TypeName(object);
        int dotPos = vmodl2name.lastIndexOf(46);
        String vmodl2package = vmodl2name.substring(0, dotPos);
        String srcSubdir = vmodl2package.replace(".", File.separator).toLowerCase();
        String typeName = vmodl2name.substring(dotPos + 1);
        this.beginFile(this._folderPrefix + srcSubdir + File.separator + typeName + ".vmodl");
        this.emitLine("/* ******************************************* *");
        this.emitLine(" *                                             *");
        this.emitLine(" *  AUTOMATICALLY GENERATED CODE, DO NOT EDIT  *");
        this.emitLine(" *                                             *");
        this.emitLine(" * ******************************************* */");
        this.emitLine();
        this.emitLine("package ", vmodl2package, ";");
        this.emitLine();
        this.emitLine("import vmodl.lang.*;");
        this.emitLine("import vmodl.rest.*;");
        return typeName;
    }

    private static String getVmodl2TypeName(VmodlObject obj) {
        String vmodl2name = obj.getCustomName2();
        return vmodl2name != null ? vmodl2name : VMODL2.setVmodl2TypeName(obj, VMODL2.evalVmodl2TypeName(obj));
    }

    private static String setVmodl2TypeName(VmodlObject object, String vmodl2name) {
        object.setCustomName2(vmodl2name);
        return vmodl2name;
    }

    private static String evalVmodl2TypeName(VmodlObject object) {
        String jsonName = VMODL2.getJsonNameNormalized(object);
        int dotPos = jsonName.lastIndexOf(46);
        String packagePrefix = jsonName.substring(0, dotPos + 1).toLowerCase();
        String sourceName = jsonName.substring(dotPos + 1);
        return VMODL2_PACKAGE_PREFIX + packagePrefix + sourceName;
    }

    private static String getJsonNameNormalized(VmodlObject object) {
        String jsonName = object.getJsonName();
        for (SuffixMapping suffixMapping : SUFFIX_MAPPINGS) {
            if (!jsonName.endsWith(suffixMapping.suffix)) continue;
            int pos = jsonName.length() - suffixMapping.suffix.length();
            return jsonName.substring(0, pos) + suffixMapping.mapping;
        }
        return jsonName;
    }

    private static class SuffixMapping {
        String suffix;
        String mapping;

        SuffixMapping(String suffix_, String mapping_) {
            this.suffix = suffix_;
            this.mapping = mapping_;
        }
    }
}

