/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.model.DataObject;
import emitters.model.Parameter;
import emitters.model.SourcePos;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import vmodl.ssoToken;

public class Method
implements VmodlApi {
    private final VmodlObject _container;
    private final String _name;
    private String _wsdlName;
    private final String _comment;
    private final VmodlDecl _returnDecl;
    private final List<Parameter> _parameterList = new ArrayList<Parameter>();
    private final List<DataObject> _faultList = new ArrayList<DataObject>();
    private List<String> _events;
    private final String _privId;
    private boolean _isDynamicPrivs;
    private Map<String, String> _subclassPrivs;
    private ssoToken _ssoToken;
    private boolean _isTask;
    private boolean _isMultibody;
    private boolean _isUndocumented;
    private boolean _isDeprecated;
    private boolean _isContinuous;
    private final Version _version;
    private boolean _isInternal;
    private boolean _isExplicitlyInternal;
    private Version _internalBefore;
    private String _customName;
    private SourcePos _sourcePos;
    private static VmodlDecl _taskReturnDecl;

    public Method(VmodlObject container, String name, VmodlDecl returnDecl, String privId, Version version, String comment) {
        this._container = container;
        this._name = name;
        this._comment = comment;
        this._returnDecl = returnDecl;
        this._privId = privId;
        this._version = version;
    }

    Method(VmodlObject container, String name, VmodlDecl returnDecl, Version version, String comment) {
        this(container, name, returnDecl, null, version, comment);
    }

    Method(Method m, String privId) {
        this._container = m._container;
        this._name = m._name;
        this._wsdlName = m._wsdlName;
        this._comment = m._comment;
        this._returnDecl = m._returnDecl;
        this._parameterList.addAll(m._parameterList);
        this._faultList.addAll(m._faultList);
        this._privId = privId;
        this._isTask = m._isTask;
        this._isMultibody = m._isMultibody;
        this._isDeprecated = m._isDeprecated;
        this._isUndocumented = m._isUndocumented;
        this._isContinuous = m._isContinuous;
        this._version = m._version;
        this._isInternal = m._isInternal;
        this._isExplicitlyInternal = m._isExplicitlyInternal;
    }

    public void setWsdlName(String wsdlName2) {
        if (this._wsdlName != null) {
            throw new RuntimeException("WSDL name redefinition");
        }
        this._wsdlName = wsdlName2;
    }

    public void addParameter(Parameter parameter) {
        this._parameterList.add(parameter);
    }

    public void addFault(DataObject fault) {
        this._faultList.add(fault);
    }

    public void addEvent(String event2) {
        if (this._events == null) {
            this._events = new ArrayList<String>();
        }
        this._events.add(event2);
    }

    public void setIsDynamicPrivs(boolean isDynamic) {
        this._isDynamicPrivs = isDynamic;
    }

    public void setSubclassPrivileges(Map<String, String> subclassPrivs) {
        this._subclassPrivs = subclassPrivs;
    }

    public void setSSOToken(ssoToken ssoToken2) {
        this._ssoToken = ssoToken2;
    }

    public void setTask() {
        this._isTask = true;
    }

    public void setMultibody() {
        this._isMultibody = true;
    }

    public void setUndocumented() {
        this._isUndocumented = true;
    }

    public void setDeprecated() {
        this._isDeprecated = true;
    }

    public void setInternal() {
        this._isInternal = true;
    }

    public void setExplicitlyInternal(boolean internal2) {
        this._isExplicitlyInternal = internal2;
    }

    public void setInternalBefore(Version internalBefore2) {
        this._internalBefore = internalBefore2;
    }

    public void setContinuous() {
        this._isContinuous = true;
    }

    public void setCustomName(String customName) {
        if (this._customName != null) {
            throw new RuntimeException(this._container.getFullClassName() + "." + this.getName() + ": the custom ID is already set to " + this._customName);
        }
        this._customName = customName;
    }

    @Override
    public void setSourcePos(SourcePos sourcePos) {
        this._sourcePos = sourcePos;
    }

    public VmodlObject getContainer() {
        return this._container;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getVmodlName() {
        return this.getQualifiedName();
    }

    @Override
    public String getWsdlName() {
        return this._wsdlName;
    }

    public String getQualifiedName() {
        return this._container.getQualifiedVmodlType() + "." + this._name;
    }

    @Override
    public String getComment() {
        return this._comment;
    }

    public VmodlDecl getReturnDecl() {
        return this._returnDecl;
    }

    public List<Parameter> getParameterList() {
        return this._parameterList;
    }

    public List<DataObject> getFaultList() {
        return this._faultList;
    }

    public Iterable<String> getEvents() {
        return this._events;
    }

    public String getPrivilegeId() {
        return this._privId;
    }

    public boolean isDynamicPrivs() {
        return this._isDynamicPrivs;
    }

    public Map<String, String> getSubclassPrivileges() {
        return this._subclassPrivs;
    }

    public ssoToken getSSOToken() {
        return this._ssoToken;
    }

    public boolean isTask() {
        return this._isTask;
    }

    public boolean isMultibody() {
        return this._isMultibody;
    }

    @Override
    public boolean isUndocumented() {
        return this._isUndocumented;
    }

    public boolean isDeprecated() {
        return this._isDeprecated;
    }

    public boolean isContinuous() {
        return this._isContinuous;
    }

    @Override
    public Version getVersion() {
        return this._version;
    }

    @Override
    public boolean isInternal() {
        return this._isInternal;
    }

    public boolean isExplicitlyInternal() {
        return this._isExplicitlyInternal;
    }

    @Override
    public Version getInternalBefore() {
        return this._internalBefore;
    }

    public String getCustomName() {
        return this._customName;
    }

    @Override
    public SourcePos getSourcePos() {
        return this._sourcePos;
    }

    void enqueueDigest() {
        if (this._version != this._container.getVersion()) {
            this._version.enqueueDigestPartOf(this._container);
        }
        this._version.enqueueDigestMethod(this);
        this._returnDecl.enqueDigestDefiniton(this._version);
        for (Parameter parameter : this._parameterList) {
            parameter.enqueueDigest(this);
        }
        for (DataObject fault : this._faultList) {
            this._version.enqueueDigestFault(fault);
        }
    }

    void print() {
        System.out.print("   ");
        System.out.print("Name: " + this._name);
        System.out.print(", WSDL name: " + (this._wsdlName != null ? this._wsdlName : "None"));
        if (this._isTask) {
            System.out.print(", @task");
        }
        if (this._isInternal) {
            System.out.print(", @internal");
        }
        if (this._isContinuous) {
            System.out.print(", @continuous");
        }
        System.out.print(", Version: " + this._version.getVmodlName());
        if (this._internalBefore != null) {
            System.out.print(" internal before: " + this._internalBefore.getVmodlName());
        }
        System.out.println();
        if (this._returnDecl != null) {
            System.out.print("      ");
            System.out.print("Returns: ");
            this._returnDecl.print();
            System.out.println();
        }
        if (!this._parameterList.isEmpty()) {
            System.out.print("      ");
            System.out.println("Parameters:");
        }
        for (Parameter parameter : this._parameterList) {
            System.out.print("      ");
            parameter.print("   ");
            System.out.println();
        }
        if (!this._faultList.isEmpty()) {
            System.out.print("      ");
            System.out.print("Faults:");
            for (DataObject fault : this._faultList) {
                System.out.print(" " + fault.getQualifiedVmodlType());
            }
            System.out.println();
        }
    }

    public static void resetTaskReturnDecl() {
        _taskReturnDecl = null;
    }

    public static void setTaskReturnType(VmodlDecl decl) {
        if (_taskReturnDecl != null) {
            throw new RuntimeException("Task return type should only be set once");
        }
        _taskReturnDecl = decl;
    }

    public static VmodlDecl taskReturnDecl() {
        return _taskReturnDecl;
    }
}

