/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.model.Version;
import emitters.model.VmodlObject;
import java.util.EnumSet;
import java.util.Set;
import vmodl.Any;
import vmodl.Binary;
import vmodl.DateTime;
import vmodl.MethodName;
import vmodl.PropertyPath;
import vmodl.TypeName;
import vmodl.URI;

public class VmodlDecl {
    private VmodlObject _object;
    private TypeId _typeId;
    private EnumSet<TypeFlag> flags = EnumSet.noneOf(TypeFlag.class);
    private static final Set<TypeFlag> COLLECTION_FLAGS = EnumSet.of(TypeFlag.LIST, TypeFlag.SET, TypeFlag.MAP);
    public static final VmodlDecl voidType = new VmodlDecl(TypeId.VOID);
    public static final String StringClassName = String.class.getName();
    public static final String DateTimeClassName = DateTime.class.getName();
    public static final String TypeNameClassName = TypeName.class.getName();
    public static final String MethodNameClassName = MethodName.class.getName();
    public static final String PropPathClassName = PropertyPath.class.getName();
    public static final String AnyClassName = Any.class.getName();
    public static final String UriClassName = URI.class.getName();
    public static final String BinaryClassName = Binary.class.getName();

    public VmodlDecl(TypeId typeId) {
        this(typeId, null);
    }

    public VmodlDecl(TypeId typeId, VmodlObject obj) {
        this._typeId = typeId;
        this._object = obj;
        if (!this.isManaged()) {
            boolean hasObject;
            boolean bl = hasObject = this.isEnum() || this.isData();
            if (hasObject && this._object == null || !hasObject && this._object != null) {
                throw new RuntimeException("Invalid type specification");
            }
        }
    }

    public void setOptional() {
        this.setFlag(TypeFlag.OPTIONAL);
    }

    public void setArray() {
        this.setFlag(TypeFlag.ARRAY);
    }

    public void setInternal() {
        this.setFlag(TypeFlag.INTERNAL);
    }

    public void setSecret() {
        this.setFlag(TypeFlag.SECRET);
    }

    public void setSilent() {
        this.setFlag(TypeFlag.SILENT);
    }

    public void setLocalizable() {
        this.setFlag(TypeFlag.LOCALIZABLE);
    }

    public void setUndocumented() {
        this.setFlag(TypeFlag.UNDOCUMENTED);
    }

    public void setDeprecated() {
        this.setFlag(TypeFlag.DEPRECATED);
    }

    public void setLink() {
        this.setFlag(TypeFlag.LINK);
    }

    public void setLinkable() {
        this.setFlag(TypeFlag.LINKABLE);
    }

    private void setFlag(TypeFlag flag) {
        if (!this.flags.add(flag)) {
            throw new RuntimeException("Invalid type specification: multiple use of " + flag.toString().toLowerCase());
        }
    }

    public void setList() {
        this.setCollectionFlag(TypeFlag.LIST);
    }

    public void setSet() {
        this.setCollectionFlag(TypeFlag.SET);
    }

    public void setMap() {
        this.setCollectionFlag(TypeFlag.MAP);
    }

    private void setCollectionFlag(TypeFlag flag) {
        if (this.flags.removeAll(COLLECTION_FLAGS)) {
            throw new RuntimeException("Invalid type specification: multi-use of @list|@set|@map");
        }
        this.flags.add(flag);
    }

    public TypeId getTypeId() {
        return this._typeId;
    }

    public VmodlObject getObject() {
        return this._object;
    }

    public boolean isVoid() {
        return this._typeId == TypeId.VOID;
    }

    public boolean isBoolean() {
        return this._typeId == TypeId.BOOLEAN;
    }

    public boolean isString() {
        return this._typeId == TypeId.STRING;
    }

    public boolean isEnum() {
        return this._typeId == TypeId.ENUM;
    }

    public boolean isPropPath() {
        return this._typeId == TypeId.PROPPATH;
    }

    public boolean isManaged() {
        return this._typeId == TypeId.MANAGED;
    }

    public boolean isData() {
        return this._typeId == TypeId.DATA;
    }

    public boolean isAny() {
        return this._typeId == TypeId.ANY;
    }

    public boolean isPrimitive() {
        return this._typeId.isPrimitive();
    }

    public boolean isValue() {
        return this.isPrimitive() || this.isLink();
    }

    public boolean isSingleValue() {
        return this.isValue() && !this.isArray();
    }

    public boolean isOptional() {
        return this.flags.contains((Object)TypeFlag.OPTIONAL);
    }

    public boolean isArray() {
        return this.flags.contains((Object)TypeFlag.ARRAY);
    }

    public boolean isInternal() {
        return this.flags.contains((Object)TypeFlag.INTERNAL);
    }

    public boolean isSecret() {
        return this.flags.contains((Object)TypeFlag.SECRET);
    }

    public boolean isSilent() {
        return this.flags.contains((Object)TypeFlag.SILENT);
    }

    public boolean isLocalizable() {
        return this.flags.contains((Object)TypeFlag.LOCALIZABLE);
    }

    public boolean isUndocumented() {
        return this.flags.contains((Object)TypeFlag.UNDOCUMENTED);
    }

    public boolean isDeprecated() {
        return this.flags.contains((Object)TypeFlag.DEPRECATED);
    }

    public boolean isLink() {
        return this.flags.contains((Object)TypeFlag.LINK);
    }

    public boolean isLinkable() {
        return this.flags.contains((Object)TypeFlag.LINKABLE);
    }

    public boolean isList() {
        return this.flags.contains((Object)TypeFlag.LIST);
    }

    public boolean isSet() {
        return this.flags.contains((Object)TypeFlag.SET);
    }

    public boolean isMap() {
        return this.flags.contains((Object)TypeFlag.MAP);
    }

    void enqueDigestDefiniton(Version version) {
        for (TypeFlag typeFlag : this.flags) {
            typeFlag.enqueueDigest(version);
        }
        this._typeId.enqueueDigest(version);
        if (this._object != null) {
            version.enqueueDigestObjectRef(this._object);
        }
    }

    void print() {
        System.out.print("Type: " + (Object)((Object)this._typeId));
        if (this.isOptional()) {
            System.out.print(" @optional");
        }
        if (this.isArray()) {
            System.out.print(" []");
        }
        if (this._object != null) {
            System.out.print(" " + this._object.getQualifiedVmodlType());
        }
    }

    public static VmodlDecl getCoreType(String className) {
        if (className.equals(StringClassName)) {
            return new VmodlDecl(TypeId.STRING);
        }
        if (className.equals(DateTimeClassName)) {
            return new VmodlDecl(TypeId.DATETIME);
        }
        if (className.equals(TypeNameClassName)) {
            return new VmodlDecl(TypeId.TYPENAME);
        }
        if (className.equals(MethodNameClassName)) {
            return new VmodlDecl(TypeId.METHODNAME);
        }
        if (className.equals(PropPathClassName)) {
            return new VmodlDecl(TypeId.PROPPATH);
        }
        if (className.equals(AnyClassName)) {
            return new VmodlDecl(TypeId.ANY);
        }
        if (className.equals(UriClassName)) {
            return new VmodlDecl(TypeId.URI);
        }
        if (className.equals(BinaryClassName)) {
            return new VmodlDecl(TypeId.BINARY);
        }
        return null;
    }

    public static enum TypeId {
        VOID(true),
        BOOLEAN(true),
        BYTE(true),
        SHORT(true),
        INT(true),
        LONG(true),
        FLOAT(true),
        DOUBLE(true),
        STRING(true),
        DATETIME(true),
        URI(true),
        BINARY(true),
        ENUM(true),
        TYPENAME(true),
        PROPPATH(true),
        METHODNAME(true),
        MANAGED(false),
        DATA(false),
        ANY(false);

        private final boolean _isPrimitive;
        private String _id;

        private TypeId(boolean isPrimitive) {
            this._isPrimitive = isPrimitive;
        }

        boolean isPrimitive() {
            return this._isPrimitive;
        }

        void enqueueDigest(Version version) {
            version.enqueueDigestTypeId(this._id);
        }

        static {
            int radix = 20;
            int counter = 0;
            for (TypeId typeId : EnumSet.allOf(TypeId.class)) {
                typeId._id = Integer.toString(counter++, 20);
            }
        }
    }

    private static enum TypeFlag {
        ARRAY,
        LINK,
        LINKABLE,
        OPTIONAL,
        LIST,
        SET,
        MAP,
        SECRET,
        SILENT,
        DEPRECATED,
        LOCALIZABLE,
        INTERNAL,
        UNDOCUMENTED;

        private String _id;

        void enqueueDigest(Version version) {
            version.enqueueDigestTypeFlag(this._id);
        }

        static {
            int counter = 0;
            for (TypeFlag typeFlag : EnumSet.allOf(TypeFlag.class)) {
                typeFlag._id = Integer.toString(counter++, 16);
            }
        }
    }
}

