/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.dr.ui.tools.utilities.ContextApplier;
import com.vmware.dr.ui.tools.utilities.ContextApplierImpl;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import com.vmware.dr.ui.tools.utilities.threadcontexthelpers.LogContextSetter;
import java.util.concurrent.Callable;

public class SessionInfo {
    private static final String DIAGNOSTIC_USERNAME = "drUsername";
    private static final String DIAGNOSTIC_SESSION_ID = "drSessionIdAlias";
    private static final ThreadLocal<SessionInfo> SESSION_DATA = ThreadLocal.withInitial(() -> new SessionInfo("UNKNOWN", "UNKNOWN_SESSION_ID"));
    private final String _username;
    private final String _sessionIdHash;

    public static <T> Callable<T> withSessionInfo(Callable<T> task, String username, String sessionIdHash) {
        SessionInfo si = new SessionInfo(username, sessionIdHash);
        Callable call = () -> ThreadContext.extendContext((Callable)task, (ContextApplier)new ContextApplierImpl(SESSION_DATA, (Object)si));
        call = LogContextSetter.withLogContext(call, (String)DIAGNOSTIC_USERNAME, (String)username);
        return LogContextSetter.withLogContext((Callable)call, (String)DIAGNOSTIC_SESSION_ID, (String)sessionIdHash);
    }

    public static SessionInfo getSessionData() {
        return SESSION_DATA.get();
    }

    public String getUsername() {
        return this._username;
    }

    public String getSessionIdHash() {
        return this._sessionIdHash;
    }

    private SessionInfo(String username, String sessionIdHash) {
        this._username = username;
        this._sessionIdHash = sessionIdHash;
    }
}

