/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class SerializationUtil {
    public static final ObjectMapper MAPPER = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enable(SerializationFeature.WRITE_ENUMS_USING_INDEX);

    public static <T> T fromString(String content, Class<T> inputClass) throws IOException {
        Validate.notNull(inputClass, (String)"inputClass");
        if (StringUtils.isEmpty((String)content)) {
            throw new IllegalArgumentException("No input data.");
        }
        return (T)MAPPER.readValue(content, inputClass);
    }

    public static <T> String toString(T data) throws IOException {
        return MAPPER.writeValueAsString(data);
    }

    public static <T> T fromByteArray(byte[] inputBuffer, Class<T> inputClass) throws IOException {
        if (inputClass == null) {
            throw new IllegalArgumentException("No input class.");
        }
        if (inputBuffer == null || inputBuffer.length == 0) {
            throw new IllegalArgumentException("No input data.");
        }
        return (T)MAPPER.readValue(inputBuffer, inputClass);
    }

    public static <T> byte[] toByteArray(T data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("No data.");
        }
        return MAPPER.writeValueAsBytes(data);
    }
}

