#!/bin/sh -e
# You need to set 2 env variables: AXIS2_HOME and JAVAHOME, or modify the 2
# values here

SAMPLEDIR=.

if [ "${AXIS2_HOME}" == "" ] ; then
    echo "AXIS2_HOME not defined.  Must be defined to run java apps.">&2
    exit 2
fi

if [ "${JAVAHOME}" == "" ] ; then
    echo "JAVAHOME not defined.  Must be defined to run java apps.">&2
    exit 2
fi

PATH="${JAVAHOME}/bin:${AXIS2_HOME}/bin:${PATH}"
export PATH

# update classpath
LOCALCLASSPATH="${PWD}"
for f in "$AXIS2_HOME"/lib/*.jar
do
  LOCALCLASSPATH="${LOCALCLASSPATH}":$f
done
LOCALCLASSPATH="${LOCALCLASSPATH}:${CLASSPATH}"

pushd ../..
"${JAVAHOME}/bin/java" -cp "${LOCALCLASSPATH}" -Xmx1024M $*

echo Done.
