/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.client.view.availability.srm;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;

public interface SrmServer
extends ExtensionServer<SrmService> {
    @Override
    default public Promise<String> getName() {
        return ((SrmService)this.service()).getServiceInstance().thenCompose(si -> {
            FuturePromise contentPromise = new FuturePromise();
            si.retrieveContent((Future)contentPromise);
            return contentPromise;
        }).thenApply(content -> content.getSiteName());
    }

    default public Promise<SrmPairSetup> getPair() {
        return this.getPairs().reduce(new ArrayList(1), (list, pair) -> {
            list.add(pair);
            return list;
        }).thenApply(list -> {
            if (list.isEmpty()) {
                return null;
            }
            return (SrmPairSetup)list.get(0);
        });
    }

    @Override
    public Stream<SrmPairSetup> getPairs();

    public static class ReconfigureNeededException
    extends ExtensionServer.GetPairFailedException {
        private static final long serialVersionUID = -796357042242052402L;
        private final ManagedObjectReference _rsRef;
        private final String _pairSrmUuid;

        public ReconfigureNeededException(URI url, ManagedObjectReference remoteSiteRef, String pairSrmUuid) {
            super(L10N.localize("srmServer.reconfigureNeeded", url));
            Validate.notNull((Object)remoteSiteRef, (String)"remoteSiteRef");
            Validate.notEmpty((String)pairSrmUuid, (String)"pairSrmUuid");
            this._rsRef = remoteSiteRef;
            this._pairSrmUuid = pairSrmUuid;
        }

        public ManagedObjectReference getRemoteSiteRef() {
            return this._rsRef;
        }

        public String getPairSrmUuid() {
            return this._pairSrmUuid;
        }
    }
}

