/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.common;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.ExecuteOnceOpWrapper;
import com.vmware.dr.ui.tools.utilities.OperationWaiter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;

public class AsyncOpRetryWrapper<T> {
    private final Supplier<Promise<T>> _opProvider;
    private final AtomicReference<ExecuteOnceOpWrapper<Promise<T>>> _resultRef = new AtomicReference<Object>(null);
    private final AtomicBoolean _resetable = new AtomicBoolean(false);

    public AsyncOpRetryWrapper(Supplier<Promise<T>> opSupplier) {
        Validate.notNull(opSupplier, (String)"opSupplier");
        this._opProvider = () -> ((Promise)opSupplier.get()).thenApply(result -> {
            this._resetable.set(true);
            return result;
        });
    }

    public Promise<T> get() {
        Promise result;
        ExecuteOnceOpWrapper myWrapper = null;
        do {
            ExecuteOnceOpWrapper<Promise<T>> current;
            if ((current = this._resultRef.get()) != null) {
                try {
                    return (Promise)current.invoke().get();
                }
                catch (OperationWaiter.OperationWaiterException e) {
                    return Promises.reject((Exception)((Object)e));
                }
            }
            if (myWrapper != null) continue;
            myWrapper = new ExecuteOnceOpWrapper(this::startOp);
        } while (!this._resultRef.compareAndSet(null, myWrapper));
        try {
            result = (Promise)myWrapper.invoke().get();
        }
        catch (OperationWaiter.OperationWaiterException e) {
            this._resultRef.set(null);
            return Promises.reject((Exception)((Object)e));
        }
        return result.onError(err -> this._resultRef.set(null));
    }

    public boolean reset() {
        if (this._resetable.getAndSet(false)) {
            this._resultRef.set(null);
            return true;
        }
        return false;
    }

    private Promise<T> startOp() {
        return this._opProvider.get();
    }
}

