/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.dr.ui.tools.utilities.HashUtils;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.utils.L10N;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.Validate;

public class LsppConsistencyWatcher {
    private final LsppConsistencyListener _listener;
    private final AtomicBoolean _notified = new AtomicBoolean(false);
    private final Object _lock = new Object();
    private Map<LsppSupplier, Set<Key>> _serviceBySupplier = new HashMap<LsppSupplier, Set<Key>>();
    private Set<Key> _allServices = new HashSet<Key>();

    public LsppConsistencyWatcher(LsppConsistencyListener listener) {
        this._listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAdd(Set<LsppService> lsppFederation, LsppSupplier supplier) {
        boolean changed;
        block13: {
            HashSet<Key> federation = new HashSet<Key>();
            for (LsppService lspp : lsppFederation) {
                federation.add(new Key(lspp));
            }
            changed = false;
            Object object = this._lock;
            synchronized (object) {
                Set<Key> current = this._serviceBySupplier.get(supplier);
                if (current != null) {
                    changed = !current.equals(federation);
                    break block13;
                }
                HashSet temp = new HashSet(federation);
                if (temp.retainAll(this._allServices)) {
                    if (temp.isEmpty()) {
                        this._serviceBySupplier.put(supplier, federation);
                        this._allServices.addAll(federation);
                    } else {
                        changed = true;
                    }
                    break block13;
                }
                for (Set<Key> registered : this._serviceBySupplier.values()) {
                    if (temp.equals(registered)) break;
                    if (temp.retainAll(registered)) {
                        if (!temp.isEmpty()) {
                            changed = true;
                            break block13;
                        }
                    } else {
                        changed = true;
                        break block13;
                    }
                    temp = new HashSet(federation);
                }
                this._serviceBySupplier.put(supplier, federation);
                this._allServices.addAll(federation);
            }
        }
        if (changed && this._notified.compareAndSet(false, true)) {
            this._listener.federationChanged(this, supplier.getLsppUrl());
        }
        return !changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(LsppSupplier supplier) {
        Object object = this._lock;
        synchronized (object) {
            Set<Key> removed = this._serviceBySupplier.remove(supplier);
            if (removed != null) {
                for (Set<Key> registered : this._serviceBySupplier.values()) {
                    if (!registered.equals(removed)) continue;
                    return;
                }
                this._allServices.removeAll(removed);
            }
        }
    }

    private static final class Key {
        private final LsppService _lspp;
        private Integer _hash;

        Key(LsppService lspp) {
            Validate.notNull((Object)lspp, (String)"lspp");
            this._lspp = lspp;
        }

        public int hashCode() {
            if (this._hash == null) {
                this._hash = HashUtils.getHashCode((Object[])new Object[]{this._lspp.getId()});
            }
            return this._hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return HashUtils.areEqual((Object)this._lspp.getId(), (Object)other._lspp.getId());
        }
    }

    public static class LsppFederationChangedException
    extends Topology.TopologyException {
        private static final long serialVersionUID = 2652406711241397813L;

        public LsppFederationChangedException(URI lsppUrl) {
            super(L10N.localize("lcWatcher.federationChanged", lsppUrl));
        }
    }

    public static interface LsppConsistencyListener {
        public void federationChanged(LsppConsistencyWatcher var1, URI var2);
    }

    public static interface LsppSupplier {
        public URI getLsppUrl();
    }
}

