/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.http;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.concurrent.CancellationException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;

public class AsyncHttpUtils {
    private static CloseableHttpAsyncClient createClientInt(KeyStore keyStore, ThumbprintVerifier verifier, int connectTimeout, int socketTimeout) throws IOException, GeneralSecurityException {
        return AsyncHttpUtils.createClientInt((NHttpClientConnectionManager)AsyncHttpUtils.createConnectionManager(keyStore, verifier), connectTimeout, socketTimeout);
    }

    private static CloseableHttpAsyncClient createClientInt(NHttpClientConnectionManager connectionManager, int connectTimeout, int socketTimeout) {
        return HttpAsyncClients.custom().setConnectionManager(connectionManager).setDefaultRequestConfig(AsyncHttpUtils.createRequestConfig(null, connectTimeout, socketTimeout)).build();
    }

    private static PoolingNHttpClientConnectionManager createConnectionManager(KeyStore keyStore, ThumbprintVerifier verifier) throws IOException, GeneralSecurityException {
        ThumbprintTrustManager trustManager = new ThumbprintTrustManager(keyStore, verifier);
        return AsyncHttpUtils.createConnectionManager(trustManager);
    }

    private static ConnectingIOReactor createIOReactor() throws IOReactorException {
        Config config = Config.get();
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout((int)config.getSocketTimeout()).setConnectTimeout((int)config.getConnectTimeout()).build();
        return new DefaultConnectingIOReactor(ioReactorConfig);
    }

    private static PoolingNHttpClientConnectionManager createConnectionManager(ThumbprintTrustManager trustManager) throws IOException, GeneralSecurityException {
        TrustManager[] trustAllCerts = new TrustManager[]{trustManager};
        SSLContext ctx = SSLContext.getInstance("TLSv1.2");
        ctx.init(null, trustAllCerts, null);
        ConnectingIOReactor ioReactor = AsyncHttpUtils.createIOReactor();
        Registry<SchemeIOSessionStrategy> schemeRegistry = AsyncHttpUtils.createSchemeRegistry(ctx, trustManager);
        return new PoolingNHttpClientConnectionManager(ioReactor, schemeRegistry);
    }

    private static Registry<SchemeIOSessionStrategy> createSchemeRegistry(SSLContext sslContext, ThumbprintTrustManager trustManager) {
        RegistryBuilder builder = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE);
        builder.register("https", (Object)new SSLIOSessionStrategy(sslContext, null, null, (HostnameVerifier)new ThumbprintTrustManager.HostnameVerifier(trustManager)));
        return builder.build();
    }

    public static RequestConfig createRequestConfig(URI proxy) {
        return AsyncHttpUtils.createRequestConfig(proxy, (int)Config.get().getConnectTimeout(), (int)Config.get().getSocketTimeout());
    }

    public static RequestConfig createRequestConfig(URI proxy, int connectTimeout, int socketTimeout) {
        return RequestConfig.custom().setExpectContinueEnabled(false).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).setConnectTimeout((int)Config.get().getConnectTimeout()).setCookieSpec("standard").setProxy(proxy == null ? null : new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getScheme())).build();
    }

    public static CloseableHttpAsyncClient createClient(KeyStore sslStore, ThumbprintVerifier verifier) {
        return AsyncHttpUtils.createClient(sslStore, verifier, (int)Config.get().getConnectTimeout(), (int)Config.get().getSocketTimeout());
    }

    public static CloseableHttpAsyncClient createClient(KeyStore sslStore, ThumbprintVerifier verifier, int connectTimeout, int socketTimeout) {
        try {
            return AsyncHttpUtils.createClientInt(sslStore, verifier, connectTimeout, socketTimeout);
        }
        catch (Exception e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
    }

    public static Promise<HttpResponse> doGet(URI url, KeyStore sslStore, ThumbprintVerifier verifier) {
        Validate.notNull((Object)url, (String)"url");
        HttpGet request = new HttpGet(url);
        CloseableHttpAsyncClient http = AsyncHttpUtils.createClient(sslStore, verifier);
        return AsyncHttpUtils.doRequest((HttpUriRequest)request, http);
    }

    public static Promise<HttpResponse> doPost(HttpPost post, KeyStore sslStore, ThumbprintVerifier verifier) {
        CloseableHttpAsyncClient http = AsyncHttpUtils.createClient(sslStore, verifier);
        return AsyncHttpUtils.doRequest((HttpUriRequest)post, http);
    }

    private static Promise<HttpResponse> doRequest(HttpUriRequest request, CloseableHttpAsyncClient http) {
        HttpResponsePromise result = new HttpResponsePromise();
        result.materialize().onSuccess(unused -> {
            try {
                http.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        try {
            http.start();
            http.execute(request, result);
        }
        catch (RuntimeException e) {
            result.failed(e);
        }
        return result;
    }

    static final class HttpResponsePromise<T>
    extends PromiseImpl<T>
    implements FutureCallback<T> {
        HttpResponsePromise() {
        }

        public void cancelled() {
            this.setError(new CancellationException());
        }

        public void completed(T result) {
            this.setResult(result);
        }

        public void failed(Exception exc) {
            this.setError(exc);
        }
    }
}

