/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi.requestcontext;

import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.request.RequestContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.CallbackHelper;
import net.sf.cglib.proxy.Dispatcher;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang.Validate;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrHttpClientWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrHttpClientWrapper.class);
    private static final Factory PROTOTYPE;
    private static final Callback[] CALLBACKS;

    public static CloseableHttpAsyncClient wrap(CloseableHttpAsyncClient toWrap) {
        Validate.notNull((Object)toWrap, (String)"toWrap");
        return (CloseableHttpAsyncClient)PROTOTYPE.newInstance(DrHttpClientWrapper.getCallbacks(toWrap));
    }

    private static Callback[] getCallbacks(CloseableHttpAsyncClient client) {
        return (Callback[])Arrays.stream(CALLBACKS).map(callback -> callback instanceof ExecuteHandler ? new ExecuteHandler(client) : new DelegateHandler(client)).toArray(Callback[]::new);
    }

    static {
        final ExecuteHandler eh = new ExecuteHandler();
        final DelegateHandler dh = new DelegateHandler();
        FilterImpl filter = new FilterImpl(){

            protected Object getCallback(Method method) {
                return EXECUTE.equals(method) ? eh : dh;
            }
        };
        CALLBACKS = filter.getCallbacks();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(CloseableHttpAsyncClient.class);
        enhancer.setUseFactory(true);
        enhancer.setCallbackFilter((CallbackFilter)filter);
        enhancer.setCallbackTypes(filter.getCallbackTypes());
        enhancer.setCallbacks(CALLBACKS);
        PROTOTYPE = (Factory)enhancer.create(new Class[0], new Object[0]);
    }

    private static abstract class FilterImpl
    extends CallbackHelper {
        static final Method EXECUTE;

        public FilterImpl() {
            super(CloseableHttpAsyncClient.class, new Class[0]);
        }

        static {
            try {
                EXECUTE = CloseableHttpAsyncClient.class.getMethod("execute", HttpAsyncRequestProducer.class, HttpAsyncResponseConsumer.class, HttpContext.class, FutureCallback.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class DelegateHandler
    implements Dispatcher {
        private final CloseableHttpAsyncClient _delegate;

        private DelegateHandler() {
            this._delegate = null;
        }

        private DelegateHandler(CloseableHttpAsyncClient delegate) {
            Validate.notNull((Object)delegate, (String)"delegate");
            this._delegate = delegate;
        }

        public Object loadObject() {
            if (this._delegate == null) {
                throw new IllegalStateException();
            }
            return this._delegate;
        }
    }

    private static final class ExecuteHandler
    implements MethodInterceptor {
        private final CloseableHttpAsyncClient _delegate;

        private ExecuteHandler() {
            this._delegate = null;
        }

        private ExecuteHandler(CloseableHttpAsyncClient delegate) {
            Validate.notNull((Object)delegate, (String)"delegate");
            this._delegate = delegate;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            FutureCallbackImpl impl;
            if (this._delegate == null) {
                throw new IllegalStateException();
            }
            FutureCallback callback = (FutureCallback)args[args.length - 1];
            args[args.length - 1] = impl = new FutureCallbackImpl(callback);
            Future result = (Future)proxy.invoke((Object)this._delegate, args);
            impl.setResultFuture(result);
            return result;
        }
    }

    private static final class FutureCallbackImpl<T>
    implements FutureCallback<T> {
        private final FuturePromise<T> _promise = new FuturePromise();
        private final FutureCallback<T> _delegate;

        private FutureCallbackImpl(FutureCallback<T> delegate) {
            this._delegate = delegate;
        }

        public void completed(T t) {
            this._promise.set(t);
            this._delegate.completed(t);
        }

        public void failed(Exception e) {
            this._promise.setException(e);
            this._delegate.failed(e);
        }

        public void cancelled() {
            this._promise.setException((Exception)new CancellationException());
            this._delegate.cancelled();
        }

        void setResultFuture(Future<T> resultFuture) {
            this._promise.onError(exc -> {
                if (exc instanceof RequestContext.RequestCompleted && resultFuture.cancel(true)) {
                    LOGGER.debug("Cancelled http invocation.");
                }
            });
        }
    }
}

