/*
 * Decompiled with CFR 0.152.
 */
package emitters;

import emitters.backend.Platform;
import emitters.model.VmodlObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ObjectRegistry {
    private static Map<String, VmodlObject> _objNameMap;
    private static boolean _finalized;

    public static void reset() {
        _objNameMap = new HashMap<String, VmodlObject>();
    }

    public static void registerObject(String fullName, VmodlObject obj) {
        _objNameMap.put(fullName, obj);
    }

    public static boolean hasObject(String name) {
        return _objNameMap.containsKey(name);
    }

    public static VmodlObject getObject(String name) {
        return _objNameMap.get(name);
    }

    public static Collection<VmodlObject> getAllObjects() {
        return _objNameMap.values();
    }

    public static void verifyWireNameConsistency(boolean checkWsdl) {
        if (_finalized) {
            return;
        }
        HashMap<String, VmodlObject> processedObjectsByJsonName = new HashMap<String, VmodlObject>();
        HashMap<String, VmodlObject> processedObjectsByWsdlName = new HashMap<String, VmodlObject>();
        StringBuilder sb = new StringBuilder("Conflicting names:\n");
        boolean haveConflict = false;
        for (VmodlObject obj : _objNameMap.values()) {
            if (checkWsdl && ObjectRegistry.checkConflict(processedObjectsByWsdlName, obj, sb, obj.getWsdlName(), "WSDL")) {
                haveConflict = true;
            }
            if (!ObjectRegistry.checkConflict(processedObjectsByJsonName, obj, sb, obj.getJsonName(), "VI/JSON")) continue;
            haveConflict = true;
        }
        if (haveConflict) {
            Platform.printError(sb.toString());
        }
        _finalized = true;
    }

    private static boolean checkConflict(Map<String, VmodlObject> processed, VmodlObject obj, StringBuilder message, String wireName, String nameType) {
        if (processed.containsKey(wireName)) {
            message.append("\t-> [").append(nameType).append("] ").append(wireName).append(": ").append(processed.get(wireName).getQualifiedVmodlType()).append(" ").append(obj.getQualifiedVmodlType()).append("\n");
            return true;
        }
        processed.put(wireName, obj);
        return false;
    }

    public static void print() {
        for (VmodlObject vmodlObject : _objNameMap.values()) {
            vmodlObject.print();
        }
    }

    public static void unregisterObject(String name) {
        _objNameMap.remove(name);
    }

    static {
        _finalized = false;
    }
}

