/*
 * Decompiled with CFR 0.152.
 */
package emitters.doc;

import com.sun.source.util.DocTreePath;
import emitters.ObjectRegistry;
import emitters.javac.Platform;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.VmodlApi;
import emitters.model.VmodlObject;
import java.util.Collection;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public final class JavadocElements {
    private JavadocElements() {
    }

    public static VmodlApi getVmodlElement(Element e) {
        if (e instanceof TypeElement) {
            return JavadocElements.getObject((TypeElement)e);
        }
        Element parent = e.getEnclosingElement();
        if (!(parent instanceof TypeElement)) {
            throw new IllegalArgumentException();
        }
        String name = e.getSimpleName().toString();
        TypeElement type = (TypeElement)parent;
        VmodlObject obj = JavadocElements.getObject(type);
        switch (obj.getKind()) {
            case ManagedObject: {
                return JavadocElements.findInManagedObject(name, (ManagedObject)obj);
            }
            case DataObject: {
                return JavadocElements.findInVmodlObject(name, obj);
            }
            case Enum: {
                return obj;
            }
        }
        throw new IllegalStateException();
    }

    private static VmodlObject getObject(TypeElement type) {
        String fqn = type.getQualifiedName().toString();
        return ObjectRegistry.getObject(fqn);
    }

    public static Element getElement(DocTreePath link) {
        return Platform.getTrees().getElement(link);
    }

    private static VmodlApi findInManagedObject(String name, ManagedObject obj) {
        Optional<Method> method = JavadocElements.find(name, obj.getMethodList());
        if (method.isPresent()) {
            return method.get();
        }
        VmodlApi property = JavadocElements.findInVmodlObject(name, obj);
        if (property != null) {
            return property;
        }
        method = JavadocElements.find(name, obj.getFullMethodList());
        if (method.isPresent()) {
            return method.get();
        }
        return null;
    }

    private static VmodlApi findInVmodlObject(String name, VmodlObject obj) {
        Optional<Property> prop = JavadocElements.find(name, obj.getPropertyList());
        if (prop.isPresent()) {
            return prop.get();
        }
        prop = JavadocElements.find(name, obj.getFullPropertyList());
        if (prop.isPresent()) {
            return prop.get();
        }
        return null;
    }

    private static <T extends VmodlApi> Optional<T> find(String name, Collection<T> col) {
        return col.stream().filter(e -> e.getName().equals(name)).findAny();
    }
}

