/*
 * Decompiled with CFR 0.152.
 */
package emitters.doc;

import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.util.DocTreePathScanner;
import emitters.doc.Issue;
import emitters.doc.JavadocLinkResolver;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Name;
import javax.tools.Diagnostic;

class JavadocToMarkdown
extends DocTreePathScanner<Issue, JavadocLinkResolver.LinkContext> {
    private static final Pattern WS_RESERVED_SYMBOLS = Pattern.compile("\\s+|[\\\\`*_\\[\\]]");
    private static final Predicate<String> SINGLE_TICK = Pattern.compile("(^|[^`])`([^`]|$)").asPredicate();
    private static final int TEXT_FOUND = Integer.MIN_VALUE;
    private static final Integer UNORDERED_START = Integer.MIN_VALUE;
    private final JavadocLinkResolver _linkResolver;
    private final StringBuilder _buffer;
    private final Deque<Integer> _listStack = new ArrayDeque<Integer>(0);
    private int _indent;
    private int _blockquoteIndent = -1;
    private boolean _escape = true;
    private List<? extends DocTree> _label;
    private int _lastListEnding = -1;
    private int _lastBlockStart = 0;
    private int _lastNewLine = 0;
    private int _lastListItemStart = -1;
    private int _lastDeprecatedStart = -1;

    public JavadocToMarkdown(JavadocLinkResolver linkResolver) {
        this(linkResolver, new StringBuilder());
    }

    public JavadocToMarkdown(JavadocLinkResolver linkResolver, StringBuilder buffer) {
        this._linkResolver = linkResolver;
        this._buffer = buffer;
    }

    @Override
    public Issue reduce(Issue r1, Issue r2) {
        if (r1 == null || r1 == Issue.NONE) {
            return r2 == null ? Issue.NONE : r2;
        }
        if (r2 == null || r2 == Issue.NONE) {
            return r1;
        }
        r1.previous = r2;
        return r1;
    }

    @Override
    public Issue visitDocComment(DocCommentTree node, JavadocLinkResolver.LinkContext context) {
        Issue issue = (Issue)this.scan(node.getFirstSentence(), context);
        this.paragraph();
        issue = this.reduce((Issue)this.scan(node.getBody(), context), issue);
        this.paragraph();
        return this.reduce((Issue)this.scan(node.getBlockTags(), context), issue);
    }

    @Override
    public Issue visitEntity(EntityTree node, JavadocLinkResolver.LinkContext context) {
        if (this._escape) {
            this._buffer.append(node);
            return Issue.NONE;
        }
        Name entity = node.getName();
        if (entity.contentEquals("lt")) {
            this._buffer.append('<');
        } else if (entity.contentEquals("gt")) {
            this._buffer.append('>');
        } else if (entity.contentEquals("amp")) {
            this._buffer.append('&');
        } else if (entity.contentEquals("quot")) {
            this._buffer.append('\"');
        } else if (entity.contentEquals("apos")) {
            this._buffer.append('\'');
        } else if (entity.length() > 1 && entity.charAt(0) == '#' && Character.isDigit(entity.charAt(1))) {
            try {
                int numbered = Integer.parseInt(entity.subSequence(1, entity.length()).toString());
                char[] chars = Character.toChars(numbered);
                this._buffer.append(chars);
            }
            catch (NumberFormatException e) {
                return new Issue(Diagnostic.Kind.ERROR, "invalid HTML entity (" + entity + ")", node);
            }
        } else {
            return new Issue(Diagnostic.Kind.ERROR, "unknown HTML entity (" + entity + ") inside code block", node);
        }
        return (Issue)super.visitEntity(node, context);
    }

    @Override
    public Issue visitLiteral(LiteralTree node, JavadocLinkResolver.LinkContext context) {
        String literal = node.getBody().getBody();
        if (literal.indexOf(10) > -1) {
            if (this._escape) {
                return new Issue("Multiline {@code} and {@literal} blocks are allowed inside <pre> only", node);
            }
            this.code(literal);
            return Issue.NONE;
        }
        String marker = "`";
        if (SINGLE_TICK.test(literal)) {
            marker = "``";
        }
        this._buffer.append(marker);
        if (literal.startsWith("`")) {
            this._buffer.append(' ');
        }
        this._buffer.append(literal);
        if (literal.endsWith("`")) {
            this._buffer.append(' ');
        }
        this._buffer.append(marker);
        return Issue.NONE;
    }

    @Override
    public Issue visitText(TextTree node, JavadocLinkResolver.LinkContext context) {
        String text = node.getBody();
        if (this._escape) {
            this.markdown(text);
        } else {
            this.code(text, this.isStartingNewBlock() ? this.findCodeStart(text) : 0);
        }
        return (Issue)super.visitText(node, context);
    }

    @Override
    public Issue visitLink(LinkTree node, JavadocLinkResolver.LinkContext context) {
        this._label = node.getLabel();
        Issue result = (Issue)this.scan(node.getReference(), context);
        this._label = null;
        return result;
    }

    @Override
    public Issue visitReference(ReferenceTree node, JavadocLinkResolver.LinkContext context) {
        boolean renderLink;
        Issue result = Issue.NONE;
        String destination = this._linkResolver.getDestination(this.getCurrentPath(), context);
        if (destination == null) {
            result = new Issue(Diagnostic.Kind.ERROR, "reference not found", node);
        }
        this._buffer.append((renderLink = this._linkResolver.enabled(context)) ? (char)'[' : '*');
        if (this._label == null || this._label.isEmpty()) {
            String label = this._linkResolver.getLabel(this.getCurrentPath(), context);
            if (label == null) {
                label = node.getSignature();
            }
            this._buffer.append(label);
        } else {
            this.scan(this._label, context);
        }
        if (renderLink) {
            this._buffer.append("](");
            if (destination != null) {
                this._buffer.append(destination);
            }
            this._buffer.append(')');
        } else {
            this._buffer.append('*');
        }
        return result;
    }

    @Override
    public Issue visitDeprecated(DeprecatedTree node, JavadocLinkResolver.LinkContext context) {
        this.paragraph();
        this.markdown("Deprecated ");
        this.startDeprecated();
        Issue issue = (Issue)super.visitDeprecated(node, context);
        this.trimToContent();
        if (this._buffer.charAt(this._buffer.length() - 1) != '.') {
            this._buffer.append('.');
        }
        this.paragraph();
        return issue;
    }

    @Override
    public Issue visitStartElement(StartElementTree node, JavadocLinkResolver.LinkContext context) {
        Name tag = node.getName();
        if (!this._escape) {
            if (tag.contentEquals("code")) {
                return Issue.NONE;
            }
            return new Issue("Tags inside <pre> are not supported", node);
        }
        if (tag.contentEquals("p")) {
            this.paragraph();
        } else if (tag.contentEquals("li")) {
            Integer number = this._listStack.peek();
            if (number == null) {
                return new Issue("No list defined for this list item", node);
            }
            if (number == UNORDERED_START) {
                this.startUnorderedListItem();
            } else {
                this.trimToContent();
                this._listStack.pop();
                this._listStack.push(number + 1);
                this.endOfLine(this._indent - (2 + String.valueOf(number - 1).length()));
                this._buffer.append(number).append(". ");
                if (number % 10 == 0) {
                    ++this._indent;
                }
                this.startNewListItem();
            }
        } else if (tag.contentEquals("ul")) {
            this.startUnorderedList();
        } else if (tag.contentEquals("ol")) {
            int start = 1;
            this._listStack.push(start);
            if (!this.separateFromLastList() && start > 1) {
                this.paragraph();
            }
            this._indent += 2 + String.valueOf(start - 1).length();
        } else if (tag.contentEquals("pre")) {
            this._escape = false;
            boolean followsList = this.separateFromLastList();
            this._indent += 4;
            if (followsList) {
                this.unconditionalLine();
                this.startNewBlock();
            } else {
                this.paragraph();
            }
        } else if (tag.contentEquals("blockquote")) {
            if (this._blockquoteIndent > -1) {
                return new Issue("Nesting blockquotes is not supported", node);
            }
            this._blockquoteIndent = this._indent;
            this._indent = 0;
            this.trimToContent();
            if (this._buffer.length() == 0) {
                this._buffer.append("> ");
            } else {
                this.unconditionalLine();
            }
            this.startNewBlock();
        } else if (tag.contentEquals("br")) {
            this.breakLine();
        } else if (tag.contentEquals("em") || tag.contentEquals("i")) {
            this._buffer.append('_');
        } else if (tag.contentEquals("strong") || tag.contentEquals("b")) {
            this._buffer.append("**");
        } else if (this.renderAsHtml(tag)) {
            this._buffer.append(node);
        } else {
            return new Issue("Unsupported HTML tag (" + tag + ")", node);
        }
        return (Issue)super.visitStartElement(node, context);
    }

    @Override
    public Issue visitEndElement(EndElementTree node, JavadocLinkResolver.LinkContext context) {
        Name tag = node.getName();
        if (!this._escape && !tag.contentEquals("pre")) {
            if (tag.contentEquals("code")) {
                return Issue.NONE;
            }
            return new Issue("Tags inside <pre> are not supported", node);
        }
        if (tag.contentEquals("em") || tag.contentEquals("i")) {
            this._buffer.append('_');
        } else if (tag.contentEquals("strong") || tag.contentEquals("b")) {
            this._buffer.append("**");
        } else if (tag.contentEquals("ul") || tag.contentEquals("ol")) {
            if (this._listStack.isEmpty()) {
                return new Issue("No list found opened", node);
            }
            if (tag.contentEquals("ul")) {
                this.endUnorderedList();
            } else {
                Integer number = this._listStack.pop();
                this._indent -= 2 + number.toString().length();
                this.paragraph();
                this.endList();
            }
        } else if (tag.contentEquals("pre")) {
            this._escape = true;
            this._indent -= 4;
            this.trimToContent();
            this.unconditionalLine();
        } else if (tag.contentEquals("blockquote")) {
            this._indent = this._blockquoteIndent;
            this._blockquoteIndent = -1;
            this.paragraph();
        } else if (this.renderAsHtml(tag)) {
            this._buffer.append(node);
        }
        return (Issue)super.visitEndElement(node, context);
    }

    @Override
    public Issue visitErroneous(ErroneousTree node, JavadocLinkResolver.LinkContext context) {
        return new Issue(Diagnostic.Kind.ERROR, node.getDiagnostic().getMessage(null), node);
    }

    public String toString() {
        this.trimToContent();
        return this._buffer.toString();
    }

    private void trimToContent() {
        this._buffer.setLength(this.findContentEnd(this._buffer));
    }

    private int findContentEnd(CharSequence text) {
        int index;
        for (index = text.length() - 1; index >= 0 && Character.isWhitespace(text.charAt(index)); --index) {
        }
        return index + 1;
    }

    private boolean separateFromLastList() {
        if (this.isEndingList()) {
            this.trimToContent();
            this.unconditionalLine();
            this._buffer.append("<!-- -->");
            return true;
        }
        return false;
    }

    private boolean renderAsHtml(Name tag) {
        return tag.contentEquals("code") || tag.contentEquals("u") || tag.contentEquals("a") || tag.contentEquals("table") || tag.contentEquals("thead") || tag.contentEquals("th") || tag.contentEquals("tbody") || tag.contentEquals("tr") || tag.contentEquals("td") || tag.contentEquals("tfoot") || tag.contentEquals("colgroup") || tag.contentEquals("col") || tag.contentEquals("caption") || tag.contentEquals("dd") || tag.contentEquals("dt") || tag.contentEquals("dl") || tag.contentEquals("sup");
    }

    private void markdown(String text) {
        int length = text.length();
        if (length == 0) {
            return;
        }
        int lastIndex = 0;
        Matcher matcher = WS_RESERVED_SYMBOLS.matcher(text);
        while (matcher.find()) {
            this.markdown(text, lastIndex, matcher.start());
            if (Character.isWhitespace(text.charAt(matcher.start()))) {
                if (!this.isStartingNewBlock()) {
                    if (matcher.group().indexOf(10) == -1) {
                        this.space();
                    } else {
                        this.endOfLine();
                    }
                }
            } else {
                this._buffer.append('\\').append(matcher.group());
            }
            lastIndex = matcher.end();
        }
        this.markdown(text, lastIndex, length);
    }

    private void markdown(CharSequence text, int start, int end) {
        if (start == end) {
            return;
        }
        assert (start < end);
        if (this.isStartingDeprecated()) {
            char c = text.charAt(start);
            if (Character.isUpperCase(c)) {
                this._buffer.append(Character.toLowerCase(c));
                ++start;
            }
        } else if (this.isStartingNewBlock() || this.isStartingNewLine()) {
            char c = text.charAt(start);
            if (Character.isDigit(c)) {
                do {
                    this._buffer.append(c);
                    if (++start != end) continue;
                    return;
                } while (Character.isDigit(c = text.charAt(start)));
                if ((c == '.' || c == ')') && text.length() > start + 1 && text.charAt(start + 1) == ' ') {
                    this._buffer.append('\\');
                }
            } else if (c == '#' || c == '-' || c == '=') {
                this._buffer.append('\\');
            }
        }
        this._buffer.append(text, start, end);
    }

    private void code(String text, int startIndex) {
        int indexOfEol;
        int length = text.length();
        int lastIndex = startIndex;
        while (lastIndex < length && (indexOfEol = text.indexOf(10, lastIndex)) > -1) {
            this._buffer.append(text, lastIndex, indexOfEol);
            this.unconditionalLine();
            lastIndex = indexOfEol + 1;
        }
        if (lastIndex < length) {
            this._buffer.append(text, lastIndex, length);
        }
    }

    protected JavadocToMarkdown code(String text) {
        this.code(text, 0);
        return this;
    }

    private int findCodeStart(String text) {
        char c;
        int length = text.length();
        int lastEol = 0;
        for (int whitespaceIndex = 0; whitespaceIndex < length && Character.isWhitespace(c = text.charAt(whitespaceIndex)); ++whitespaceIndex) {
            if (c != '\n') continue;
            lastEol = whitespaceIndex;
        }
        return lastEol;
    }

    private void breakLine() {
        int length = this._buffer.length();
        if (length == 0 || this._buffer.charAt(length - 1) != ' ') {
            this._buffer.append("  ");
        } else if (length == 1 || this._buffer.charAt(this._buffer.length() - 2) != ' ') {
            this._buffer.append(' ');
        }
        this.unconditionalLine();
    }

    private void endOfLine() {
        this.endOfLine(this._indent);
    }

    private void endOfLine(int indentation) {
        int eol = this.endsWithEndOfLine();
        if (eol == Integer.MIN_VALUE) {
            this.unconditionalLine(indentation);
            return;
        }
        this.adjustIndentation(indentation, eol);
    }

    protected JavadocToMarkdown paragraph() {
        int eol = this.endsWithEndOfLine();
        if (eol != Integer.MIN_VALUE) {
            if (this.endsWithEndOfLine(eol - 1) != Integer.MIN_VALUE) {
                this.adjustIndentation(this._indent, eol);
                this.startNewBlock();
                return this;
            }
            this.unconditionalLine();
            this.startNewBlock();
            return this;
        }
        this.unconditionalLine();
        this.unconditionalLine();
        this.startNewBlock();
        return this;
    }

    private int endsWithEndOfLine() {
        return this.endsWithEndOfLine(this._buffer.length() - 1);
    }

    private int endsWithEndOfLine(int end) {
        if (this._blockquoteIndent > -1) {
            return this.endsWithBlockquoteFollowingEndOfLine(end);
        }
        while (end >= 0) {
            char c = this._buffer.charAt(end);
            if (c == '\n') {
                return end;
            }
            if (!Character.isWhitespace(c)) {
                return Integer.MIN_VALUE;
            }
            --end;
        }
        return end;
    }

    private int endsWithBlockquoteFollowingEndOfLine(int end) {
        while (end >= 0) {
            char c = this._buffer.charAt(end);
            if (c == '>') {
                int blockquoteStart = end + 1;
                --end;
                while (end >= 0) {
                    c = this._buffer.charAt(end);
                    if (!Character.isWhitespace(c)) {
                        return Integer.MIN_VALUE;
                    }
                    if (c == '\n') break;
                    --end;
                }
                return blockquoteStart;
            }
            if (!Character.isWhitespace(c)) {
                return Integer.MIN_VALUE;
            }
            --end;
        }
        return end;
    }

    private void adjustIndentation(int indentation, int eol) {
        int lastLineIndent = this._buffer.length() - (eol + 1);
        if (lastLineIndent == indentation) {
            return;
        }
        if (lastLineIndent > indentation) {
            this._buffer.setLength(this._buffer.length() - (lastLineIndent - indentation));
            return;
        }
        while (indentation > lastLineIndent) {
            this._buffer.append(' ');
            ++lastLineIndent;
        }
    }

    private void unconditionalLine() {
        this.unconditionalLine(this._indent);
    }

    private void unconditionalLine(int indentation) {
        int i;
        if (this.isStartingNewListItem()) {
            this._buffer.append("&shy;");
        }
        this._buffer.append('\n');
        if (this._blockquoteIndent > -1) {
            for (i = 0; i < this._blockquoteIndent; ++i) {
                this._buffer.append(' ');
            }
            this._buffer.append("> ");
        }
        for (i = 0; i < indentation; ++i) {
            this._buffer.append(' ');
        }
        this._lastNewLine = this._buffer.length();
    }

    private void space() {
        int length = this._buffer.length();
        if (length == 0 || Character.isWhitespace(this._buffer.charAt(length - 1))) {
            return;
        }
        this._buffer.append(' ');
    }

    private boolean isStartingNewBlock() {
        return this._lastBlockStart == this._buffer.length();
    }

    private void startNewBlock() {
        this._lastBlockStart = this._buffer.length();
    }

    private boolean isStartingNewListItem() {
        return this._lastListItemStart == this._buffer.length();
    }

    private void startNewListItem() {
        this.startNewBlock();
        this._lastListItemStart = this._buffer.length();
    }

    private boolean isEndingList() {
        return this._lastListEnding == this._buffer.length();
    }

    private void endList() {
        this._lastListEnding = this._buffer.length();
    }

    private boolean isStartingNewLine() {
        return this._lastNewLine == this._buffer.length();
    }

    private boolean isStartingDeprecated() {
        return this._lastDeprecatedStart == this._buffer.length();
    }

    private void startDeprecated() {
        this._lastDeprecatedStart = this._buffer.length();
    }

    protected JavadocToMarkdown startUnorderedList() {
        this._listStack.push(UNORDERED_START);
        this.separateFromLastList();
        this._indent += 2;
        return this;
    }

    protected JavadocToMarkdown startUnorderedListItem() {
        this.trimToContent();
        this.endOfLine(this._indent - 2);
        this._buffer.append("- ");
        this.startNewListItem();
        return this;
    }

    protected JavadocToMarkdown endUnorderedList() {
        this._listStack.pop();
        this._indent -= 2;
        this.paragraph();
        this.endList();
        return this;
    }
}

