/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Version;
import emitters.model.VmodlObject;
import java.util.Collection;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;

public class ObjectsEnumerator {
    private final Collection<VmodlObject> _objects;
    private final Filter _filter;
    private final NavigableSet<ManagedObject> _managedObjectSet;
    private final NavigableSet<DataObject> _dataObjectSet;
    private final NavigableSet<Enum> _enumSet;
    private final String _defaultNamespace;
    private final Comparator<ManagedObject> MO_COMPARATOR = new Comparator<ManagedObject>(){

        @Override
        public int compare(ManagedObject lhs, ManagedObject rhs) {
            Version lhsVersion = lhs.getVersion();
            Version rhsVersion = rhs.getVersion();
            boolean rhsNamespaceIsDefault = rhsVersion.isBaseNamespace(ObjectsEnumerator.this._defaultNamespace);
            if (lhsVersion.isBaseNamespace(ObjectsEnumerator.this._defaultNamespace)) {
                if (rhsNamespaceIsDefault) {
                    return this.compareWireNames(lhs, rhs);
                }
                return -1;
            }
            if (rhsNamespaceIsDefault) {
                return 1;
            }
            int namespaceComp = lhsVersion.getNamespace().compareTo(rhsVersion.getNamespace());
            if (namespaceComp != 0) {
                return namespaceComp;
            }
            return this.compareWireNames(lhs, rhs);
        }

        private int compareWireNames(ManagedObject lhs, ManagedObject rhs) {
            return lhs.getJsonName().compareTo(rhs.getJsonName());
        }
    };

    public ObjectsEnumerator(Collection<VmodlObject> objects, Filter filter, String defaultNamespace) {
        this._objects = objects;
        this._filter = filter;
        this._defaultNamespace = defaultNamespace;
        this._dataObjectSet = new TreeSet<DataObject>();
        this._managedObjectSet = new TreeSet<ManagedObject>(this.MO_COMPARATOR);
        this._enumSet = new TreeSet<Enum>();
        this.enumerate(this._objects);
    }

    private void enumerate(Iterable<VmodlObject> objects) {
        for (VmodlObject object : objects) {
            if (!this._filter.shouldEmit(object)) continue;
            switch (object.getKind()) {
                case ManagedObject: {
                    this._managedObjectSet.add((ManagedObject)object);
                    break;
                }
                case DataObject: {
                    this._dataObjectSet.add((DataObject)object);
                    break;
                }
                case Enum: {
                    this._enumSet.add((Enum)object);
                }
            }
            this.enumerate(object.getNestedList());
        }
    }

    public NavigableSet<ManagedObject> getManagedObjects() {
        return this._managedObjectSet;
    }

    public NavigableSet<DataObject> getDataObjects() {
        return this._dataObjectSet;
    }

    public NavigableSet<Enum> getEnums() {
        return this._enumSet;
    }

    public static interface Filter {
        public boolean shouldEmit(VmodlObject var1);
    }
}

