/*
 * Decompiled with CFR 0.152.
 */
package emitters.javac;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.TreePath;
import emitters.javac.Platform;
import emitters.javac.Tools;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

class DocumentationSupplier
implements Supplier<DocTreePath> {
    private final Element _element;

    DocumentationSupplier(Element element) {
        this._element = element;
    }

    @Override
    public DocTreePath get() {
        TreePath treePath = Platform.getTrees().getPath(this._element);
        DocCommentTree comment = Platform.getTrees().getDocCommentTree(treePath);
        DocumentationSupplier.checkForDeprecationDiscrepancy(this._element, treePath, comment);
        if (comment == null) {
            return null;
        }
        return new DocTreePath(treePath, comment);
    }

    static void checkForDeprecationDiscrepancy(Element el, TreePath treePath, DocCommentTree comment) {
        boolean markedDeprecated = Tools.hasTag(el, Deprecated.class);
        boolean documentedDeprecated = false;
        if (comment != null) {
            documentedDeprecated = comment.getBlockTags().stream().anyMatch(t -> t.getKind() == DocTree.Kind.DEPRECATED);
        }
        if (markedDeprecated != documentedDeprecated) {
            Platform.getTrees().printMessage(Diagnostic.Kind.ERROR, "Incomplete deprecation - use both @Deprecated on the element and @deprecated in its documentation", treePath.getLeaf(), treePath.getCompilationUnit());
        }
    }
}

