/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.Utils;
import emitters.model.DataObject;
import emitters.model.Field;
import emitters.model.MetaVersion;
import emitters.model.Method;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlObject;
import java.security.MessageDigest;
import java.util.ArrayList;

public class SyntheticVersion
extends Version {
    private final MetaVersion _metaVersion;
    private StringBuilder _content;
    public static boolean sDebugDigest = false;

    public SyntheticVersion(MetaVersion metaVersion2, String simpleName, Version.Kind kind) {
        super(metaVersion2.getVersionsPrefix() + simpleName, metaVersion2.getService(), kind);
        this._metaVersion = metaVersion2;
        this.setWireNs(metaVersion2.getWireNs());
        this.setDisplayName(this._namespace + " " + simpleName + " version");
    }

    public void setWireId() {
        if (this._wireId != null) {
            this._content = null;
            return;
        }
        String prefix = this.getWireIdPrefix();
        if (prefix == null) {
            this._wireId = "";
            return;
        }
        MessageDigest messageDigest = Utils.initDigest();
        ArrayList parents = new ArrayList(this._directParents);
        parents.sort(null);
        for (Version version : parents) {
            String parentId;
            if (version instanceof SyntheticVersion) {
                ((SyntheticVersion)version).setWireId();
                parentId = version._package + "." + version._wireId;
            } else {
                parentId = version._vmodlName;
            }
            Utils.updateDigest(messageDigest, parentId);
        }
        Utils.updateDigest(messageDigest, this._vmodlName);
        if (this._content != null) {
            String content = this._content.toString();
            this._content = null;
            if (sDebugDigest) {
                System.err.println("Digesting version " + this._vmodlName);
                System.err.print("- content: ");
                System.err.println(content);
            }
            Utils.updateDigest(messageDigest, content);
        }
        byte[] digest = messageDigest.digest();
        this._wireId = String.format("%s%02X%02X%02X%02X", prefix, digest[0], digest[1], digest[2], digest[3]);
        if (sDebugDigest) {
            System.err.println("Wire id for " + this._vmodlName + ": " + this._wireId);
        }
    }

    private String getWireIdPrefix() {
        switch (this._kind) {
            case DEV: {
                return "u";
            }
            case MILESTONE: {
                return "m";
            }
            case FEATURE: {
                return "f";
            }
        }
        return null;
    }

    public void initDigest() {
        this._content = new StringBuilder(4096);
    }

    @Override
    public void enqueueDigestPartOf(VmodlApi vmodlApi) {
        this._content.append('@');
        this._content.append(vmodlApi.getVmodlName());
    }

    @Override
    public void enqueueDigestObject(VmodlObject object) {
        this._content.append('+');
        this._content.append(object.getVmodlName());
        this.enqueueDigestWsdlName(object);
    }

    @Override
    public void enqueueDigestBaseObject(VmodlObject object) {
        this._content.append('|');
        this._content.append(object.getVmodlName());
    }

    @Override
    public void enqueueDigestMethod(Method method) {
        this._content.append('$');
        this._content.append(method.getName());
        this.enqueueDigestWsdlName(method);
    }

    @Override
    public void enqueueDigestFault(DataObject fault) {
        this._content.append('!');
        this._content.append(fault.getVmodlName());
    }

    @Override
    public void enqueueDigestTypeFlag(String flagId) {
        this._content.append('/');
        this._content.append(flagId);
    }

    @Override
    public void enqueueDigestTypeId(String typeId) {
        this._content.append('%');
        this._content.append(typeId);
    }

    @Override
    public void enqueueDigestObjectRef(VmodlObject object) {
        this._content.append('#');
        this._content.append(object.getVmodlName());
    }

    @Override
    public void enqueueDigestField(Field field) {
        this._content.append(':');
        this._content.append(field.getName());
    }

    @Override
    public void enqueueDigestEnum(String value) {
        this._content.append('&');
        this._content.append(value);
    }

    @Override
    public void enqueueDigestWsdlName(VmodlApi vmodlApi) {
        this._content.append('^');
        this._content.append(vmodlApi.getWsdlName());
    }

    public MetaVersion getMetaVersion() {
        return this._metaVersion;
    }
}

