/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.common;

import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import java.io.InputStream;

public interface Response {
    public void setResponse(Status var1, InputStream var2);

    public void setError(Exception var1);

    public static enum Status {
        Ok(200, "OK"),
        MovedPermanently(301, "Moved Permanently"),
        BadRequest(400, "Bad Request"),
        NotFound(404, "Not Found"),
        Fault(500, "Internal Server Error"),
        InvalidSslCertificate(526, "Invalid SSL Certificate");

        private final int _code;
        private final String _text;

        private Status(int code, String text) {
            this._code = code;
            this._text = text;
        }

        public int getCode() {
            return this._code;
        }

        public String getText() {
            return this._text;
        }

        public static Status getStatus(int code) {
            switch (code) {
                case 200: {
                    return Ok;
                }
                case 404: {
                    return NotFound;
                }
                case 500: {
                    return Fault;
                }
            }
            throw new UnexpectedStatusCodeException(code);
        }
    }
}

