/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;

public class Graph<T> {
    private final Set<Node> _roots = new HashSet<Node>();
    private final Map<T, Node> _nodeByValue = new HashMap<T, Node>();
    private final Object _lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoot(T value) {
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        Object object = this._lock;
        synchronized (object) {
            Node node = this._nodeByValue.get(value);
            if (node == null) {
                node = new Node(value);
                this._nodeByValue.put(value, node);
            }
            this._roots.add(node);
        }
    }

    public void removeRoot(T value) {
        this.removeNode(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<T> getRoots() {
        Object object = this._lock;
        synchronized (object) {
            if (this._roots.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet result = new HashSet();
            for (Node root : this._roots) {
                result.add(root.getValue());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(T value) {
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        Object object = this._lock;
        synchronized (object) {
            Node node = this._nodeByValue.get(value);
            if (node == null) {
                node = new Node(value);
                this._nodeByValue.put(value, node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(T value) {
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        Object object = this._lock;
        synchronized (object) {
            Node node = this._nodeByValue.remove(value);
            if (node == null) {
                return;
            }
            this._roots.remove(node);
            for (Node n : this._nodeByValue.values()) {
                n.removeNeighbour(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNeighbour(T from, T to) {
        if (from == null) {
            throw new IllegalArgumentException("from");
        }
        if (to == null) {
            throw new IllegalArgumentException("to");
        }
        Object object = this._lock;
        synchronized (object) {
            Node toNode;
            Node fromNode = this._nodeByValue.get(from);
            if (fromNode == null) {
                fromNode = new Node(from);
                this._nodeByValue.put(from, fromNode);
            }
            if ((toNode = this._nodeByValue.get(to)) == null) {
                toNode = new Node(to);
                this._nodeByValue.put(to, toNode);
            }
            fromNode.addNeighbour(toNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNeighbour(T from, T to) {
        if (from == null) {
            throw new IllegalArgumentException("from");
        }
        if (to == null) {
            throw new IllegalArgumentException("to");
        }
        Object object = this._lock;
        synchronized (object) {
            Node fromNode = this._nodeByValue.get(from);
            if (fromNode == null) {
                return;
            }
            Node toNode = this._nodeByValue.get(to);
            if (toNode == null) {
                return;
            }
            fromNode.removeNeighbour(toNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> getNeighbours(T value) {
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        Object object = this._lock;
        synchronized (object) {
            Node node = this._nodeByValue.get(value);
            if (node == null) {
                return Collections.emptySet();
            }
            HashSet result = new HashSet();
            for (Node neighbour : node.getNeighbours()) {
                result.add(neighbour.getValue());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> getAll() {
        Object object = this._lock;
        synchronized (object) {
            if (this._nodeByValue.isEmpty()) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(this._nodeByValue.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> purge() {
        HashSet reachable = new HashSet();
        HashSet<T> unreachable = new HashSet<T>();
        Object object = this._lock;
        synchronized (object) {
            unreachable.addAll(this._nodeByValue.keySet());
            IteratorImpl iter = new IteratorImpl();
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                reachable.add(node.getValue());
            }
            this._nodeByValue.keySet().retainAll(reachable);
        }
        unreachable.removeAll(reachable);
        return unreachable;
    }

    private class IteratorImpl
    implements Iterator<Node> {
        private final Set<Node> _visited = Collections.newSetFromMap(new IdentityHashMap());
        private final Queue<Node> _toVisit = new LinkedList<Node>();

        IteratorImpl() {
            this._toVisit.addAll(Graph.this._roots);
        }

        @Override
        public boolean hasNext() {
            Node node = null;
            while ((node = this._toVisit.peek()) != null && this._visited.contains(node)) {
                this._toVisit.poll();
            }
            return !this._toVisit.isEmpty();
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node node = this._toVisit.poll();
            this._toVisit.addAll(node.getNeighbours());
            this._visited.add(node);
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Node {
        private final T _value;
        private final Map<T, Node> _neighbourByValue = new HashMap();

        Node(T value) {
            if (value == null) {
                throw new IllegalArgumentException("value");
            }
            this._value = value;
        }

        public T getValue() {
            return this._value;
        }

        public Collection<Node> getNeighbours() {
            return Collections.unmodifiableCollection(this._neighbourByValue.values());
        }

        boolean addNeighbour(Node node) {
            if (node == null) {
                throw new IllegalArgumentException("node");
            }
            if (this._neighbourByValue.containsKey(node._value)) {
                return false;
            }
            this._neighbourByValue.put(node._value, node);
            return true;
        }

        boolean removeNeighbour(Node n) {
            return this._neighbourByValue.values().remove(n);
        }
    }
}

