/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.configurables.inventory.datacenter;

import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vr.client.impex.configurables.ConfigurableConverter;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.IeResourcePool;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.IeVirtualMachine;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.VirtualAppConverter;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.VirtualMachineConverter;
import com.vmware.vr.client.impex.tool.IdBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;

public class ResourcePoolConverter
implements ConfigurableConverter {
    public static IeResourcePool fromVmodl(IdBuilder idBuilder, PcResult pcResult, ManagedObjectReference entity, boolean extractVms) {
        if (entity == null) {
            return null;
        }
        if ("ResourcePool".equals(entity.getType())) {
            IeResourcePool ieResourcePool = new IeResourcePool();
            ResourcePoolConverter.setResourcePoolInfo(idBuilder, pcResult, ieResourcePool, entity, extractVms);
            if (extractVms) {
                ResourcePoolConverter.setResourcePoolVms(idBuilder, pcResult, ieResourcePool, entity);
            }
            return ieResourcePool;
        }
        if ("VirtualApp".equals(entity.getType())) {
            return VirtualAppConverter.fromVmodl(idBuilder, pcResult, entity);
        }
        throw new IllegalStateException("ResourcePool conversion");
    }

    static void setResourcePoolInfo(IdBuilder idBuilder, PcResult pcResult, IeResourcePool ieResourcePool, ManagedObjectReference entity, boolean extractVms) {
        ieResourcePool.setId(idBuilder.buildId(entity));
        String name = (String)pcResult.getProperty(entity, "name");
        ieResourcePool.setName(name);
        Object[] children = (ManagedObjectReference[])pcResult.getProperty(entity, "resourcePool");
        List<IeResourcePool> ieChildren = ArrayUtils.isEmpty(children) ? Collections.emptyList() : Arrays.stream(children).map(child -> ResourcePoolConverter.fromVmodl(idBuilder, pcResult, child, extractVms)).collect(Collectors.toList());
        ieResourcePool.setChildren(ieChildren);
    }

    static void setResourcePoolVms(IdBuilder idBuilder, PcResult pcResult, IeResourcePool ieResourcePool, ManagedObjectReference entity) {
        Object[] vms = (ManagedObjectReference[])pcResult.getProperty(entity, "vm");
        List<IeVirtualMachine> ieVms = ArrayUtils.isEmpty(vms) ? Collections.emptyList() : Arrays.stream(vms).map(vm -> VirtualMachineConverter.fromVmodl(idBuilder, pcResult, vm)).filter(Objects::nonNull).collect(Collectors.toList());
        ieResourcePool.setVirtualMachines(ieVms);
    }
}

