/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.importers.replications;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsPairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.vim.binding.hms.DatastorePath;
import com.vmware.vim.binding.hms.Disk;
import com.vmware.vim.binding.hms.ExcludedDiskSpec;
import com.vmware.vim.binding.hms.ExtendedDatastorePath;
import com.vmware.vim.binding.hms.Group;
import com.vmware.vim.binding.hms.ReplicationManager;
import com.vmware.vim.binding.hms.ServiceInstanceContent;
import com.vmware.vim.binding.hms.VirtualMachine;
import com.vmware.vim.binding.hms.fault.AlreadyReplicatedVmFault;
import com.vmware.vim.binding.hms.fault.SeedDiskNotFoundFault;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vr.client.impex.configurables.replications.IeDisk;
import com.vmware.vr.client.impex.configurables.replications.IeReplicationGroup;
import com.vmware.vr.client.impex.configurables.replications.IeVmInfo;
import com.vmware.vr.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.vr.client.impex.tool.HmsServersDataWrapper;
import com.vmware.vr.client.impex.tool.ImpexImportHmsContext;
import com.vmware.vr.client.impex.utils.DataStoreUtil;
import com.vmware.vr.client.impex.utils.HmsUtil;
import com.vmware.vr.client.impex.utils.IContextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ReplicationGroupsImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicationGroupsImporter.class);
    private final boolean _local;
    private final InventoryExtractor.InventoryLookup _inventory;
    private final Profile[] _remoteProfiles;
    private final HmsServer _server;
    private final HmsService _remoteHmsService;
    private final ServiceInstanceContent _remoteServiceContent;
    private final ReplicationManager _replicationManager;
    private final VcServer _remoteVc;
    private final String _remoteGuid;
    private final boolean _isEnhancedReplication;

    public ReplicationGroupsImporter(boolean local, InventoryExtractor.InventoryLookup inventory, Profile[] remoteProfiles) {
        this._local = local;
        this._inventory = inventory;
        this._remoteProfiles = remoteProfiles;
        this._server = IContextUtil.getHmsServer(local);
        this._replicationManager = (ReplicationManager)((HmsService)this._server.service()).createStub(IContextUtil.getHmsContent(local).getReplicationManager());
        this._remoteHmsService = (HmsService)IContextUtil.getHmsServer(!local).service();
        HmsServersDataWrapper serversData = ImpexImportHmsContext.get().getServersDataWrapper();
        this._remoteServiceContent = this._local ? serversData.getRemoteContent() : serversData.getLocalContent();
        this._remoteVc = this._local ? ((HmsServer)serversData.getRemotePair().server()).vc() : ((HmsServer)serversData.getLocalPair().server()).vc();
        this._remoteGuid = this._local ? ((HmsServer)serversData.getRemotePair().server()).guid() : ((HmsServer)serversData.getLocalPair().server()).guid();
        this._isEnhancedReplication = ImpexImportHmsContext.get().isEnhancedReplication();
    }

    public Promise<Collection<ManagedObjectReference>> create() {
        List<IeReplicationGroup> groups = ImpexImportHmsContext.get().getConfigurablesWrapper().getReplicationGroups().stream().filter(group -> group.isLocal() == this._local).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(groups)) {
            LOGGER.info("No Replication Group will be imported on server [{}]:[{}].", (Object)this._server.getName(), (Object)this._server.guid());
            return Promises.resolve(Collections.emptyList());
        }
        LOGGER.info("{} Replication Groups will be imported on server [{}]:[{}].", new Object[]{groups.size(), this._server.getName(), this._server.guid()});
        return this.configureReplications(groups);
    }

    private Promise<Collection<ManagedObjectReference>> configureReplications(List<IeReplicationGroup> ieReplicationGroups) {
        return Streams.from(ieReplicationGroups).flatMap(group -> this._server.getPairByGuid(this._remoteGuid).thenCompose(hmsPairSetup -> this.configureReplicationBy((HmsPairSetup)hmsPairSetup, (IeReplicationGroup)group, false)).materialize().thenApply(pr -> Objects.nonNull(pr) && pr.isSuccessful() ? (ManagedObjectReference)pr.getResult() : null)).filter(Objects::nonNull).collect().onError(error -> LOGGER.warn("Error while importing Replication Groups for server with guid '{}'.", (Object)this._server.guid(), error));
    }

    private Promise<ManagedObjectReference> configureReplicationBy(HmsPairSetup hmsPairSetup, IeReplicationGroup ieReplicationGroup, boolean checkDiskExisiting) {
        String vmName = ieReplicationGroup.getSettings() == null ? "NULL" : ieReplicationGroup.getSettings().getName();
        return this.buildVcReplicationSpec(ieReplicationGroup, checkDiskExisiting).onError(e -> ImpexImportHmsContext.get().addError(String.format("Unable to build vc replication spec for group: '%s'.", vmName), (Exception)e)).thenCompose(replicationSpec -> this.configureReplication((Group.VcReplicationSpec)replicationSpec, hmsPairSetup.pairServerVmomiRef())).materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                LOGGER.info("Replication group '{}' is successfully created.", (Object)vmName);
                ImpexImportHmsContext.get().addImportedGroupName(vmName);
                return Promises.resolve((Object)((ManagedObjectReference)pr.getResult()));
            }
            Exception error = pr.getError();
            LOGGER.warn("Unable to configure replication for vm '{}': ", (Object)vmName, (Object)error);
            if (error instanceof SeedDiskNotFoundFault) {
                return this.unconfigureReplicationTask(ieReplicationGroup.getVmInfo().getVm()).materialize().thenCompose(unconfigurePr -> {
                    if (unconfigurePr.isSuccessful()) {
                        LOGGER.info("Replication group '{}' is successfully removed.", (Object)vmName);
                        return this.createReplicationWithoutSeedDisk(hmsPairSetup, ieReplicationGroup).materialize().thenApply(recreatePr -> {
                            if (recreatePr.isSuccessful()) {
                                return (ManagedObjectReference)recreatePr.getResult();
                            }
                            Exception recreateError = recreatePr.getError();
                            LOGGER.warn("Unable to recreate replication for vm '{}': ", (Object)vmName, (Object)recreateError);
                            ImpexImportHmsContext.get().addError(String.format("Unable to recreate replication for vm '%s'.", vmName), recreateError);
                            return null;
                        });
                    }
                    Exception unconfigureError = unconfigurePr.getError();
                    LOGGER.warn("Unable to remove replication for vm '{}': ", (Object)vmName, (Object)unconfigureError);
                    ImpexImportHmsContext.get().addError(String.format("Unable to remove replication for vm '%s'.", vmName), unconfigureError);
                    return Promises.resolve(null);
                });
            }
            ImpexImportHmsContext.get().addError(String.format("Unable to configure replication for vm '%s'.", vmName), error);
            if (error instanceof AlreadyReplicatedVmFault) {
                LOGGER.warn("Vm '{}' (in xml) is already replicated, skipping configuring replication for '{}'.", (Object)ieReplicationGroup.getVmInfo().getVm(), (Object)vmName);
            }
            return Promises.resolve(null);
        });
    }

    private String getStorageProfileIdByName(String name) {
        return Arrays.stream(this._remoteProfiles).filter(profile -> profile.getName().equals(name)).findFirst().orElseThrow(() -> new RuntimeException("Failed to Storage Profile name by name: " + name)).getProfileId().getUniqueId();
    }

    private Promise<Group.VcReplicationSpec> buildVcReplicationSpec(IeReplicationGroup group, boolean checkDiskExisiting) {
        boolean scaleOut;
        if (group.getSettings() == null) {
            return Promises.reject((Exception)new RuntimeException(String.format("Unexpected NULL settings in Replication group, cannot create replication!", new Object[0])));
        }
        IeVmInfo vmInfo = group.getVmInfo();
        if (Objects.isNull(vmInfo.getConfigFileLocation())) {
            return Promises.reject((Exception)new RuntimeException("Config File Location is null in vm with ID: " + vmInfo.getVm()));
        }
        if (Objects.isNull(vmInfo.getConfigFileLocation().getFriendlyName()) && Objects.isNull(vmInfo.getConfigFileLocation().getPath())) {
            return Promises.reject((Exception)new RuntimeException("Both FriendlyName and Path in ConfigFileLocation are null in vm with ID: " + vmInfo.getVm()));
        }
        if (Objects.isNull(this._inventory.get(vmInfo.getVm()))) {
            return Promises.reject((Exception)new RuntimeException("Inventory does not find the vm: " + vmInfo.getVm()));
        }
        Promise<ManagedObjectReference> hbrsrvPromise = Promises.resolve(null);
        boolean bl = scaleOut = this._isEnhancedReplication ? true : Boolean.TRUE.equals(group.getSettings().getScaleOut());
        if (!scaleOut && group.getSettings().getTargetHbrServerName() != null) {
            hbrsrvPromise = HmsUtil.getHbrSrvByName(this._remoteHmsService, this._remoteServiceContent, group.getSettings().getTargetHbrServerName());
        }
        Group.VcReplicationSpec groupSpec = new Group.VcReplicationSpec();
        groupSpec.settings = new Group.Settings();
        groupSpec.settings.setName(group.getSettings().getName());
        groupSpec.settings.setRpo(group.getSettings().getRpo());
        groupSpec.settings.setQuiesceGuestEnabled(group.getSettings().isQuiesceGuestEnabled());
        groupSpec.settings.setNetworkCompressionEnabled(group.getSettings().isNetworkCompressionEnabled());
        groupSpec.settings.setLwdEncryptionEnabled(group.getSettings().getLwdEncryptionEnabled());
        if (Objects.nonNull(group.getSettings().getRetentionPolicy()) && ArrayUtils.isNotEmpty(group.getSettings().getRetentionPolicy().getTiers())) {
            groupSpec.settings.setRetentionPolicy(new Group.RetentionPolicy((Group.RetentionPolicy.Tier[])Arrays.stream(group.getSettings().getRetentionPolicy().getTiers()).map(ieTier -> new Group.RetentionPolicy.Tier(ieTier.getGranularityMinutes(), ieTier.getNumSlots())).toArray(Group.RetentionPolicy.Tier[]::new)));
        }
        Promise<VirtualMachine.VcReplicationVmSpec> vmSpecPromise = this.buildVmSpec(vmInfo, checkDiskExisiting);
        return hbrsrvPromise.thenApply(hbrsrv -> {
            groupSpec.settings.setAutoReplicateNewDisks(group.getSettings().getAutoReplicateNewDisks());
            Boolean dataSetsReplicationEnabled = false;
            if (Objects.nonNull(group.getSettings().getDataSetsReplicationEnabled())) {
                dataSetsReplicationEnabled = group.getSettings().getDataSetsReplicationEnabled();
            }
            groupSpec.settings.setDataSetsReplicationEnabled(dataSetsReplicationEnabled);
            groupSpec.settings.setScaleOut(Boolean.valueOf(scaleOut));
            groupSpec.settings.setTargetHbrServer(hbrsrv);
            LOGGER.info("Replication spec for '{}' is '{}'.", (Object)group.getSettings().getName(), (Object)groupSpec);
            return groupSpec;
        }).thenCombine(vmSpecPromise, (groupSpec1, vmSpec1) -> {
            groupSpec1.setVms(new VirtualMachine.VcReplicationVmSpec[]{vmSpec1});
            return groupSpec1;
        });
    }

    private Promise<VirtualMachine.VcReplicationVmSpec> buildVmSpec(IeVmInfo vmInfo, boolean checkDiskExisiting) {
        String remoteProfileId = vmInfo.getStorageProfile() == null ? null : this.getStorageProfileIdByName(vmInfo.getStorageProfile().getName());
        ManagedObjectReference datastore = (ManagedObjectReference)this._inventory.get(vmInfo.getConfigFileLocation().getDatastore());
        String folderName = Objects.isNull(vmInfo.getConfigFileLocation().getFriendlyName()) ? vmInfo.getConfigFileLocation().getPath() : vmInfo.getConfigFileLocation().getFriendlyName();
        ExtendedDatastorePath location = new ExtendedDatastorePath();
        location.setPath(folderName);
        location.setDatastore(datastore);
        String dsClusterId = vmInfo.getConfigFileLocation().getDsClusterId();
        if (dsClusterId != null && !dsClusterId.isEmpty()) {
            location.setDsCluster((ManagedObjectReference)this._inventory.get(dsClusterId));
        }
        VirtualMachine.VcReplicationVmSpec vmSpec = new VirtualMachine.VcReplicationVmSpec();
        vmSpec.setConfigFileLocation((DatastorePath)location);
        vmSpec.setVm((ManagedObjectReference)this._inventory.get(vmInfo.getVm()));
        if (vmInfo.getExcludedDisks() != null && vmInfo.getExcludedDisks().length > 0) {
            vmSpec.setExcludedDiskSpecs((ExcludedDiskSpec[])Arrays.stream(vmInfo.getExcludedDisks()).boxed().map(diskKey -> new ExcludedDiskSpec(diskKey.intValue(), Boolean.valueOf(true))).toArray(ExcludedDiskSpec[]::new));
        }
        if (vmInfo.getStorageProfile() != null && remoteProfileId != null) {
            LOGGER.info("Setting profile ID: '{}' Name: '{}' for VM '{}'.", new Object[]{remoteProfileId, vmInfo.getStorageProfile().getName(), vmInfo.getVm()});
            vmSpec.setStorageProfileId(new ProfileId(remoteProfileId));
        }
        if (vmInfo.getDisks() == null || vmInfo.getDisks().isEmpty()) {
            LOGGER.info("Replication for vm {} does not have any replicated disk.", (Object)vmInfo.getVm());
            return Promises.resolve((Object)vmSpec);
        }
        Promise<List<Disk>> diskListPromise = this.buildDisks(vmInfo.getDisks(), checkDiskExisiting);
        return diskListPromise.thenApply(diskList -> {
            if (diskList != null && !diskList.isEmpty()) {
                vmSpec.setDisks(diskList.toArray(new Disk[diskList.size()]));
            }
            return vmSpec;
        });
    }

    private Promise<List<Disk>> buildDisks(Collection<IeDisk> ieDisks, boolean checkDiskExisiting) {
        List<Promise> buildDisksPromise = ieDisks.stream().map(ieDisk -> this.buildDisk((IeDisk)ieDisk, checkDiskExisiting)).collect(Collectors.toList());
        return Promises.all((Promise[])buildDisksPromise.toArray(new Promise[buildDisksPromise.size()])).thenApply(resultAccessor -> {
            ArrayList<Disk> diskList = new ArrayList<Disk>();
            for (Promise diskPromise : buildDisksPromise) {
                diskList.add((Disk)resultAccessor.getResult(diskPromise));
            }
            return diskList;
        });
    }

    private Promise<Disk> buildDisk(IeDisk ieDisk, boolean checkDiskExisiting) {
        if (Objects.isNull(ieDisk.getDestination())) {
            throw new RuntimeException("Destination is null in Disk : " + ieDisk);
        }
        ManagedObjectReference datastore = (ManagedObjectReference)this._inventory.get(ieDisk.getDestination().getDatastore());
        String remoteProfileId = ieDisk.getStorageProfile() == null ? null : this.getStorageProfileIdByName(ieDisk.getStorageProfile().getName());
        String folderName = Objects.isNull(ieDisk.getDestination().getFriendlyName()) ? ieDisk.getDestination().getPath() : ieDisk.getDestination().getFriendlyName();
        Disk disk = new Disk();
        disk.setDeviceKey(ieDisk.getDeviceKey());
        disk.setSkipDiskUuidValidation(Boolean.valueOf(ieDisk.isSkipDiskUuidValidation()));
        disk.setVirtualDiskType(ieDisk.getVirtualDiskType());
        if (ieDisk.getStorageProfile() != null && remoteProfileId != null) {
            LOGGER.info("Setting profile ID: '{}' Name: '{}' for Disk '{}'.", new Object[]{remoteProfileId, ieDisk.getStorageProfile().getName(), ieDisk.getDestination().getFileName()});
            disk.setStorageProfileId(new ProfileId(remoteProfileId));
        }
        ExtendedDatastorePath diskLocation = new ExtendedDatastorePath();
        diskLocation.setDatastore(datastore);
        diskLocation.setFileName(ieDisk.getDestination().getFileName());
        diskLocation.setPath(folderName);
        disk.setDestination((DatastorePath)diskLocation);
        String dsClusterId = ieDisk.getDestination().getDsClusterId();
        if (dsClusterId != null && !dsClusterId.isEmpty()) {
            diskLocation.setDsCluster((ManagedObjectReference)this._inventory.get(dsClusterId));
        }
        if (!checkDiskExisiting) {
            disk.setUseOfflineCopy(Boolean.valueOf(true));
            return Promises.resolve((Object)disk);
        }
        return DataStoreUtil.fileExists(this._remoteVc, (ManagedObjectReference)this._inventory.get(ieDisk.getDestination().getDatastore()), ieDisk.getDestination().getFriendlyName(), ieDisk.getDestination().getFileName(), true).thenApply(fileExists -> {
            if (fileExists.booleanValue()) {
                disk.setUseOfflineCopy(Boolean.valueOf(true));
            } else {
                disk.setUseOfflineCopy(Boolean.valueOf(false));
            }
            return disk;
        });
    }

    private Promise<ManagedObjectReference> configureReplication(Group.VcReplicationSpec groupSpec, ManagedObjectReference remoteServerRef) {
        LOGGER.info("Configuring replication with spec '{}' .", (Object)groupSpec);
        FuturePromise vmTasksPromise = new FuturePromise();
        this._replicationManager.configureReplication(remoteServerRef, groupSpec, "fake", (Future)vmTasksPromise);
        return vmTasksPromise.materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return ImpexImportHmsContext.get().monitor((ManagedObjectReference)pr.getResult());
            }
            return Promises.reject((Exception)pr.getError());
        });
    }

    private Promise<ManagedObjectReference> unconfigureReplicationTask(String vm) {
        LOGGER.info("Unconfiguring replication for '{}' .", (Object)vm);
        FuturePromise findGroupPromise = new FuturePromise();
        this._replicationManager.findReplicationGroup(new ManagedObjectReference[]{(ManagedObjectReference)this._inventory.get(vm)}, (Future)findGroupPromise);
        return findGroupPromise.thenCompose(groupKeyedValues -> {
            FuturePromise unconfigureGroupTaskPromise = new FuturePromise();
            Group group = (Group)((HmsService)this._server.service()).createStub(groupKeyedValues[0].getValue());
            group.unconfigure(Boolean.valueOf(true), (Future)unconfigureGroupTaskPromise);
            return unconfigureGroupTaskPromise;
        }).materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return ImpexImportHmsContext.get().monitor((ManagedObjectReference)pr.getResult());
            }
            return Promises.reject((Exception)pr.getError());
        });
    }

    private Promise<ManagedObjectReference> createReplicationWithoutSeedDisk(HmsPairSetup hmsPairSetup, IeReplicationGroup ieReplicationGroup) {
        LOGGER.info("Recreating replication for '{}' .", (Object)ieReplicationGroup.getVmInfo().getVm());
        return this.configureReplicationBy(hmsPairSetup, ieReplicationGroup, true);
    }
}

