/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool;

import com.vmware.dr.ui.tools.utilities.ContextApplier;
import com.vmware.dr.ui.tools.utilities.ContextApplierImpl;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vr.client.impex.tool.HmsServersDataWrapper;
import com.vmware.vr.client.impex.tool.IdBuilder;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;

public class ImpexExportHmsContext {
    private static final ThreadLocal<ImpexExportHmsContext> IMPEX_CONTEXT = new ThreadLocal();
    private final HmsServersDataWrapper _serversDataWrapper;
    private final IdBuilder _idBuilder;
    private final Map<String, Datastore.Info> _datastoreInfoCache = new ConcurrentHashMap<String, Datastore.Info>();

    public static <T> T executeWith(Callable<T> task, HmsServersDataWrapper serversWrapper) throws Exception {
        ImpexExportHmsContext context = new ImpexExportHmsContext(serversWrapper);
        return (T)ThreadContext.extendContext(task, (ContextApplier)new ContextApplierImpl(IMPEX_CONTEXT, (Object)context));
    }

    public static HmsServersDataWrapper getServersDataWrapper() {
        return ImpexExportHmsContext.get()._serversDataWrapper;
    }

    public static IdBuilder getIdBuilder() {
        return ImpexExportHmsContext.get()._idBuilder;
    }

    public static ImpexExportHmsContext get() {
        ImpexExportHmsContext impexContext = IMPEX_CONTEXT.get();
        Validate.notNull(impexContext, "impexContext");
        return impexContext;
    }

    private ImpexExportHmsContext(HmsServersDataWrapper serversDataWrapper) {
        this._serversDataWrapper = serversDataWrapper;
        this._idBuilder = new IdBuilder(((HmsServer)serversDataWrapper.getLocalPair().server()).vc().guid(), ((HmsServer)serversDataWrapper.getRemotePair().server()).vc().guid());
    }

    public Datastore.Info getDatastoreInfoBy(String datastoreId) {
        return this._datastoreInfoCache.get(datastoreId);
    }

    public Datastore.Info addDatastoreInfo(String dsIdWithVcId, Datastore.Info datastoreInfo) {
        return this._datastoreInfoCache.put(dsIdWithVcId, datastoreInfo);
    }

    public void clearDatastoreInfoCache() {
        this._datastoreInfoCache.clear();
    }
}

