/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.utilities.ContextApplier;
import com.vmware.dr.ui.tools.utilities.ContextApplierImpl;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrFault;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrFaultImpl;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vr.client.impex.tool.HmsConfigurablesWrapper;
import com.vmware.vr.client.impex.tool.HmsServersDataWrapper;
import com.vmware.vr.client.impex.utils.HmsTaskMonitorImpl;
import com.vmware.vr.client.impex.utils.ImpexL10N;
import com.vmware.vr.client.impex.utils.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;

public class ImpexImportHmsContext {
    private static final ThreadLocal<ImpexImportHmsContext> IMPEX_CONTEXT = new ThreadLocal();
    private final HmsServersDataWrapper _serversDataWrapper;
    private final HmsConfigurablesWrapper _configurablesWrapper;
    private final List<DrFault> _errors;
    private final TaskMonitor _taskMonitor;
    private final List<String> _importedGroupName;
    private final Map<String, Datastore.Info> _datastoreInfoCache;
    private final boolean _isEnhancedReplication;
    private final Map<String, ManagedObjectReference> _datastoreParentDatacenterCache;

    public static <T> T executeWith(Callable<T> task, HmsServersDataWrapper serversWrapper, HmsConfigurablesWrapper configurablesWrapper, boolean isEnhancedReplication) throws Exception {
        ImpexImportHmsContext context = new ImpexImportHmsContext(serversWrapper, configurablesWrapper, isEnhancedReplication);
        return (T)ThreadContext.extendContext(task, (ContextApplier)new ContextApplierImpl(IMPEX_CONTEXT, (Object)context));
    }

    public static ImpexImportHmsContext get() {
        ImpexImportHmsContext impexContext = IMPEX_CONTEXT.get();
        Validate.notNull(impexContext, "impexContext");
        return impexContext;
    }

    private ImpexImportHmsContext(HmsServersDataWrapper serversDataWrapper, HmsConfigurablesWrapper configurablesWrapper, boolean isEnhancedReplication) {
        if (configurablesWrapper.getData().size() == 0) {
            throw new InvalidFileException(ImpexL10N.localize("readFile.invalidFile", new Object[0]));
        }
        this._serversDataWrapper = serversDataWrapper;
        this._configurablesWrapper = configurablesWrapper;
        this._isEnhancedReplication = isEnhancedReplication;
        this._errors = Collections.synchronizedList(new ArrayList());
        this._taskMonitor = new HmsTaskMonitorImpl(serversDataWrapper);
        this._importedGroupName = Collections.synchronizedList(new ArrayList(configurablesWrapper.getData().values().size() * 3 / 2));
        this._datastoreInfoCache = new ConcurrentHashMap<String, Datastore.Info>();
        this._datastoreParentDatacenterCache = new ConcurrentHashMap<String, ManagedObjectReference>();
    }

    public HmsServersDataWrapper getServersDataWrapper() {
        return this._serversDataWrapper;
    }

    public HmsConfigurablesWrapper getConfigurablesWrapper() {
        return this._configurablesWrapper;
    }

    public boolean isEnhancedReplication() {
        return this._isEnhancedReplication;
    }

    public void addError(String message, Exception error) {
        Validate.notNull(message);
        this._errors.add((DrFault)DrFaultImpl.from((String)message, (Exception)error));
    }

    public List<DrFault> getErrors() {
        return new ArrayList<DrFault>(this._errors);
    }

    public void addImportedGroupName(String name) {
        Validate.notNull(name);
        this._importedGroupName.add(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAndResetImportedGroupName() {
        List<String> list = this._importedGroupName;
        synchronized (list) {
            ArrayList<String> result = new ArrayList<String>(this._importedGroupName);
            this._importedGroupName.clear();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DrFault> getAndResetErrors() {
        List<DrFault> list = this._errors;
        synchronized (list) {
            ArrayList<DrFault> result = new ArrayList<DrFault>(this._errors);
            this._errors.clear();
            return result;
        }
    }

    public Datastore.Info getDatastoreInfoBy(String datastoreId) {
        return this._datastoreInfoCache.get(datastoreId);
    }

    public Datastore.Info addDatastoreInfo(String dsIdWithVcId, Datastore.Info datastoreInfo) {
        return this._datastoreInfoCache.put(dsIdWithVcId, datastoreInfo);
    }

    public void clearDatastoreInfoCache() {
        this._datastoreInfoCache.clear();
    }

    public ManagedObjectReference getParentDatacenterBy(String dsIdWithVcId) {
        return this._datastoreParentDatacenterCache.get(dsIdWithVcId);
    }

    public ManagedObjectReference addParentDatacenter(String dsIdWithVcId, ManagedObjectReference datacenter) {
        return this._datastoreParentDatacenterCache.put(dsIdWithVcId, datacenter);
    }

    public void clearParentDatacenterCache() {
        this._datastoreParentDatacenterCache.clear();
    }

    public <T> Promise<T> monitor(ManagedObjectReference taskRef) {
        return ImpexImportHmsContext.get()._taskMonitor.monitor(taskRef);
    }

    static class InvalidFileException
    extends RuntimeException {
        InvalidFileException(String message) {
            super(message);
        }
    }
}

