/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool.io;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.vr.client.impex.tool.io.IOHelper;
import com.vmware.vr.client.impex.tool.io.InputWaiterRequester;
import com.vmware.vr.client.impex.tool.io.data.Credentials;
import com.vmware.vr.client.impex.tool.io.data.Lspp;
import com.vmware.vr.client.impex.tool.io.request.BooleanRequest;
import com.vmware.vr.client.impex.tool.io.request.CredentialsRequest;
import com.vmware.vr.client.impex.tool.io.request.FinalRequest;
import com.vmware.vr.client.impex.tool.io.request.HmsSelectionRequest;
import com.vmware.vr.client.impex.tool.io.request.LsppRequest;
import java.util.Map;

public class ConsoleInputWR
extends InputWaiterRequester {
    public ConsoleInputWR(IOHelper ioHelper) {
        super(ioHelper);
    }

    @Override
    public Promise<Lspp> promptForLspp() {
        LsppRequest lsppRequest = new LsppRequest(this._ioHelper);
        this._requests.add(lsppRequest);
        return lsppRequest.getResult();
    }

    @Override
    public Promise<Boolean> promptForThumbprint(String host, String thumbprint) {
        return this.promptForBoolAnswer(String.format("Host %s has untrusted certificate with SHA-1 Thumbprint: %s .\nAccept thumbprint?", host, thumbprint));
    }

    @Override
    public Promise<Credentials> promptForLocalCredentials(String host) {
        return this.promptForCredentials(host);
    }

    @Override
    public Promise<String> promptForLocalHmsServer(Map<String, String> guidToName) {
        HmsSelectionRequest hmsSelectionRequest = new HmsSelectionRequest(this._ioHelper, guidToName, true);
        this._requests.add(hmsSelectionRequest);
        return hmsSelectionRequest.getResult();
    }

    @Override
    public Promise<String> promptForRemoteHmsServer(Map<String, String> guidToName) {
        HmsSelectionRequest hmsSelectionRequest = new HmsSelectionRequest(this._ioHelper, guidToName, false);
        this._requests.add(hmsSelectionRequest);
        return hmsSelectionRequest.getResult();
    }

    @Override
    public Promise<Credentials> promptForRemoteCredentials(String serverame) {
        return this.promptForCredentials(String.format("pair site '%s'", serverame));
    }

    @Override
    public void complete(int exitCode, String completionMessage) {
        this._requests.add(new FinalRequest(exitCode, completionMessage));
    }

    private Promise<Boolean> promptForBoolAnswer(String question) {
        BooleanRequest booleanRequest = new BooleanRequest(this._ioHelper, question);
        this._requests.add(booleanRequest);
        return booleanRequest.getResult();
    }

    private Promise<Credentials> promptForCredentials(String target) {
        CredentialsRequest credentialsRequest = new CredentialsRequest(this._ioHelper, target);
        this._requests.add(credentialsRequest);
        return credentialsRequest.getResult();
    }
}

