/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool.io;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.vr.client.impex.tool.io.IOHelper;
import com.vmware.vr.client.impex.tool.io.data.Credentials;
import com.vmware.vr.client.impex.tool.io.data.Lspp;
import com.vmware.vr.client.impex.tool.io.request.Request;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class InputWaiterRequester {
    protected final BlockingQueue<Request> _requests = new LinkedBlockingQueue<Request>();
    protected final IOHelper _ioHelper;

    protected InputWaiterRequester(IOHelper ioHelper) {
        this._ioHelper = ioHelper;
    }

    public ExitStatus waitForInput() throws InterruptedException {
        Request request;
        do {
            request = this._requests.take();
            request.execute();
        } while (!request.isFinal());
        return request.getExitStatus();
    }

    public abstract Promise<Lspp> promptForLspp();

    public abstract Promise<Boolean> promptForThumbprint(String var1, String var2);

    public abstract Promise<Credentials> promptForLocalCredentials(String var1);

    public abstract Promise<String> promptForLocalHmsServer(Map<String, String> var1);

    public abstract Promise<String> promptForRemoteHmsServer(Map<String, String> var1);

    public abstract Promise<Credentials> promptForRemoteCredentials(String var1);

    public abstract void complete(int var1, String var2);

    public static class ExitStatus {
        private final int _code;
        private final String _message;

        public ExitStatus(int code, String message) {
            this._code = code;
            this._message = message;
        }

        public int getCode() {
            return this._code;
        }

        public String getMessage() {
            return this._message;
        }
    }

    public static class RejectedException
    extends RuntimeException {
        public RejectedException(String message) {
            super(message);
        }
    }
}

