/*
 * iCom.h
 *
 * Copyright (C) 2001 Michael Anderson, IBM Corporation
 *
 * Serial device driver include file.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef TRACE_ONLY

#define DIAG_MAIN_START				0xCD700100
#define DIAG_MAIN_INIT				0xCD700102
#define DIAG_MAIN_BIST				0xCD700104
#define DIAG_MAIN_MEMORY			0xCD700106
#define DIAG_MAIN_INTERRUPT			0xCD700108
#define DIAG_MAIN_INSTRUCTION			0xCD70010A
#define DIAG_MAIN_REGISTER			0xCD70010C
#define DIAG_MAIN_RVX_STATUS			0xCD70010E
#define DIAG_MAIN_RVX_INTERNAL_WRAP		0xCD700110
#define DIAG_MAIN_END				0xCD7001FF

#define DIAG_INIT_ERROR_DATA			0xCD700200
#define DIAG_INIT_SET_GLOBAL_REGS		0xCD700210
#define DIAG_INIT_END				0xCD700220

#define DIAG_INTHANDLE_START			0xCD700300
#define DIAG_INTHANDLE_CHECK_FOR_INTS		0xCD700310
#define DIAG_INTHANDLE_END			0xCD700320

#define DIAG_LOAD_STOP_PROC			0xCD700400
#define DIAG_LOAD_ZERO_DRAM			0xCD700410
#define DIAG_LOAD_LOAD_CODE			0xCD700420
#define DIAG_LOAD_DONE				0xCD700430

#define DIAG_BIST_CLEAR_INTS			0xCD700500
#define DIAG_BIST_SAVE_PCI_CMD_REG		0xCD700510
#define DIAG_BIST_READ_PCI_CMD_FAIL		0xCD700520
#define DIAG_BIST_SAVE_CMD_REG			0xCD700530
#define DIAG_BIST_READ_CMD_REG_FAIL		0xCD700540
#define DIAG_BIST_SAVE_BAR0_REG			0xCD700550
#define DIAG_BIST_HOOK_INT_LINE			0xCD700570
#define DIAG_BIST_HOOK_INT_HANDLER_FAIL		0xCD700580
#define DIAG_BIST_START_BIST			0xCD700590
#define DIAG_BIST_START_BIST_FAIL		0xCD7005A0
#define DIAG_BIST_WAIT_FOR_INT			0xCD7005B0
#define DIAG_BIST_CHECK_INT_REGS		0xCD7005C0
#define DIAG_BIST_NO_BIST_INT_FAIL		0xCD7005D0
#define DIAG_CHECK_READ_BIST_REG		0xCD7005E0
#define DIAG_BIST_READ_CONFIG_OFFSET_0C_FAIL	0xCD7005F0
#define DIAG_BIST_CHECK_MISR_AND_PRPG		0xCD700600
#define DIAG_BIST_INCORRECT_MISR_OR_PRPG	0xCD700610
#define DIAG_BIST_CHECK_BAR0			0xCD700620
#define DIAG_BIST_READ_BAR0_FAIL		0xCD700630
#define DIAG_BIST_CHECK_BAR0_RESET_VALUE	0xCD700644
#define DIAG_BIST_BAR0_RESET_FAIL		0xCD700652
#define DIAG_BIST_RESTORE_BAR0_REG		0xCD700664
#define DIAG_BIST_WRITE_BAR0_FAIL		0xCD700670
#define DIAG_BIST_RESTORE_PCI_CMD_REG		0xCD700680
#define DIAG_BIST_WRITE_PCI_COMMAND_FAIL	0xCD700690
#define DIAG_BIST_RETURN_INT_HANDLE		0xCD7006A0

#define DIAG_MEM_FOR_EVERY_PORT			0xCD700700
#define DIAG_MEM_STOP_PROC			0xCD700710
#define DIAG_MEM_INVALID_PORT_SELECT		0xCD700720
#define DIAG_MEM_CALL_MEM_TEST			0xCD700730

#define DIAG_MEM_WRITE_ADDR_TAG			0xCD700800
#define DIAG_MEM_CHECK_ADDR_TAG			0xCD700810
#define DIAG_MEM_ADDR_TAG_TEST_FAILED		0xCD700820
#define DIAG_MEM_WRITE_AA			0xCD700830
#define DIAG_MEM_CHECK_AA			0xCD700840
#define DIAG_MEM_AA_TEST_FAIL			0xCD700850
#define DIAG_MEM_CHECK_55			0xCD700860
#define DIAG_MEM_55_TEST_FAIL			0xCD700870
#define DIAG_MEM_CHECK_00			0xCD700880
#define DIAG_MEM_00_TEST_FAIL			0xCD700890

#define DIAG_INT_CLEAR_INTS			0xCD700900
#define DIAG_INT_GET_INT_HANDLE			0xCD700910
#define DIAG_INT_GET_IRQ_LINE_FAIL		0xCD700920
#define DIAG_INT_LOAD_PROCS			0xCD700930
#define DIAG_INT_CLEAR_INT_VARS			0xCD700940
#define DIAG_INT_START_PROCS			0xCD700950
#define DIAG_INT_START_TESTS			0xCD700954
#define DIAG_INT_DETERMINE_INTS_TO_CHECK_FOR	0xCD700960
#define DIAG_INT_WAIT_FOR_INTS			0xCD700970
#define DIAG_INT_CHECK_FOR_INTS			0xCD700980
#define DIAG_INT_WRONG_INT_FAIL			0xCD700990
#define DIAG_INT_STOP_PROCS			0xCD7009A0
#define DIAG_INT_FREE_INT_HANDLE		0xCD7009B0
#define DIAG_INT_END				0xCD7009C0

#define DIAG_INST_CLEAR_INTS			0xCD700A00
#define DIAG_INST_GET_INT_HANDLE		0xCD700A10
#define DIAG_INST_GET_IRQ_LINE_FAIL		0xCD700A20
#define DIAG_INST_LOAD_PROCS			0xCD700A30
#define DIAG_INST_CLEAR_INT_VARS		0xCD700A40
#define DIAG_INST_START_PROCS			0xCD700A50
#define DIAG_INST_START_TESTS			0xCD700A54
#define DIAG_INST_DETERMINE_INTS_TO_CHECK_FOR	0xCD700A60
#define DIAG_INST_WAIT_FOR_INTS			0xCD700A70
#define DIAG_INST_CHECK_FOR_INTS		0xCD700A80
#define DIAG_INST_WRONG_INT_FAIL		0xCD700A90
#define DIAG_INST_STOP_PROCS			0xCD700AA0
#define DIAG_INST_CHECK_RESULTS			0xCD700AB0
#define DIAG_INST_BAD_RESULTS_DATA_FAIL		0xCD000AC0
#define DIAG_INST_FREE_INT_HANDLE		0xCD700AD0
#define DIAG_INST_END				0xCD700AE0

#define DIAG_REG_CLEAR_INTS			0xCD700B00
#define DIAG_REG_GET_INT_HANDLE			0xCD700B10
#define DIAG_REG_GET_IRQ_LINE_FAIL		0xCD700B20
#define DIAG_REG_LOAD_PROCS			0xCD700B30
#define DIAG_REG_CLEAR_INT_VARS			0xCD700B40
#define DIAG_REG_START_PROCS			0xCD700B50
#define DIAG_REG_DETERMINE_INTS_TO_CHECK_FOR	0xCD700B60
#define DIAG_REG_WAIT_FOR_INTS			0xCD700B70
#define DIAG_REG_CHECK_FOR_INTS			0xCD700B80
#define DIAG_REG_WRONG_INT_FAIL			0xCD700B90
#define DIAG_REG_STOP_PROCS			0xCD700BA0
#define DIAG_REG_CHECK_RESULTS			0xCD700BB0
#define DIAG_REG_BAD_RESULTS_DATA_FAIL		0xCD000BC0
#define DIAG_REG_FREE_INT_HANDLE		0xCD700BD0
#define DIAG_REG_END				0xCD700BE0

/* The following REG2 TPR's are for the second pass. */
/* It is the same test as REG but with different pico code */
#define DIAG_REG2_CLEAR_INTS			0xCD700C00
#define DIAG_REG2_GET_INT_HANDLE		0xCD700C10
#define DIAG_REG2_GET_IRQ_LINE_FAIL		0xCD700C20
#define DIAG_REG2_LOAD_PROCS			0xCD700C30
#define DIAG_REG2_CLEAR_INT_VARS		0xCD700C40
#define DIAG_REG2_START_PROCS			0xCD700C50
#define DIAG_REG2_DETERMINE_INTS_TO_CHECK_FOR	0xCD700C60
#define DIAG_REG2_WAIT_FOR_INTS			0xCD700C70
#define DIAG_REG2_CHECK_FOR_INTS		0xCD700C80
#define DIAG_REG2_WRONG_INT_FAIL		0xCD700C90
#define DIAG_REG2_STOP_PROCS			0xCD700CA0
#define DIAG_REG2_CHECK_RESULTS			0xCD700CB0
#define DIAG_REG2_BAD_RESULTS_DATA_FAIL		0xCD000CC0
#define DIAG_REG2_FREE_INT_HANDLE		0xCD700CD0
#define DIAG_REG2_END				0xCD700CE0

#define DIAG_RVXSTS_CLEAR_INTS			0xCD700D00
#define DIAG_RVXSTS_GET_INT_HANDLE		0xCD700D10
#define DIAG_RVXSTS_GET_IRQ_LINE_FAIL		0xCD700D20
#define DIAG_RVXSTS_LOAD_PROCS			0xCD700D30
#define DIAG_RVXSTS_CLEAR_INT_VARS		0xCD700D40
#define DIAG_RVXSTS_START_PROCS			0xCD700D50
#define DIAG_RVXSTS_DETERMINE_INTS_TO_CHECK_FOR	0xCD700D60
#define DIAG_RVXSTS_WAIT_FOR_INTS		0xCD700D70
#define DIAG_RVXSTS_CHECK_FOR_INTS		0xCD700D80
#define DIAG_RVXSTS_WRONG_INT_FAIL		0xCD700D90
#define DIAG_RVXSTS_STOP_PROCS			0xCD700DA0
#define DIAG_RVXSTS_CHECK_RESULTS		0xCD700DB0
#define DIAG_RVXSTS_BAD_RESULTS_DATA_FAIL	0xCD000DC0
#define DIAG_RVXSTS_FREE_INT_HANDLE		0xCD700DD0
#define DIAG_RVXSTS_END				0xCD700DE0

#define DIAG_RVXINTWRP_CLEAR_INTS		0xCD700E00
#define DIAG_RVXINTWRP_GET_INT_HANDLE		0xCD700E10
#define DIAG_RVXINTWRP_GET_IRQ_LINE_FAIL	0xCD700E20
#define DIAG_RVXINTWRP_LOAD_PROCS		0xCD700E30
#define DIAG_RVXINTWRP_CLEAR_INT_VARS		0xCD700E40
#define DIAG_RVXINTWRP_START_PROCS		0xCD700E50
#define DIAG_RVXINTWRP_DETERMINE_INTS_TO_CHECK_FOR 0xCD700E60
#define DIAG_RVXINTWRP_WAIT_FOR_INTS		0xCD700E70
#define DIAG_RVXINTWRP_CHECK_FOR_INTS		0xCD700E80
#define DIAG_RVXINTWRP_WRONG_INT_FAIL		0xCD700E90
#define DIAG_RVXINTWRP_STOP_PROCS		0xCD700EA0
#define DIAG_RVXINTWRP_CHECK_RESULTS		0xCD700EB0
#define DIAG_RVXINTWRP_BAD_RESULTS_DATA_FAIL	0xCD000EC0
#define DIAG_RVXINTWRP_FREE_INT_HANDLE		0xCD700ED0
#define DIAG_RVXINTWRP_END			0xCD700EE0

#define DIAG_SMINTWRP_START_TPR			0xCD700F00
#define DIAG_SMINTWRP_DISABLE_COMP_TPR          0xCD700F10
#define DIAG_SMINTWRP_WAIT_FOR_DATA_TPR         0xCD700F20
#define DIAG_SMINTWRP_SET_LOOPBACK_TPR          0xCD700F30
#define DIAG_SMINTWRP_WAIT_FOR_DATA2_TPR        0xCD700F30
#define DIAG_SMINTWRP_SEND_U_TPR                0xCD700F40
#define DIAG_SMINTWRP_WAIT_FOR_DATA4_TPR        0xCD700F50
#define DIAG_SMINTWRP_SEND_ATH_TPR              0xCD700F60
#define DIAG_SMINTWRP_WAIT_FOR_ATH_OK_TPR       0xCD700F70
#define DIAG_SMINTWRP_NOT_OK_FAIL_TPR           0xCD700F80
#define DIAG_SMINTWRP_NOT_U_FAIL_TPR            0xCD700F90
#define DIAG_SMINTWRP_NOT_CONNECT_FAIL_TPR      0xCD700FA0
#define DIAG_SMINTWRP_NOT_OK_FAIL1_TPR          0xCD700FB0
#define DIAG_SMINTWRP_END_TPR                   0xCD700FC0

#endif

static unsigned char callSetup[1968] = 
          {0xBD,0xD9,0x23,0x00,0xDD,0xDD,0x18,0x05,0x23,0x80,0x3E,0x7F,0x23,0x00,0x3E,0x7C,
           0x23,0x10,0x3E,0xB7,0x3E,0xB5,0x23,0x20,0x3E,0xB6,0x3E,0xB4,0xA2,0x0A,0x86,0x0A,
           0xAE,0x0A,0xBE,0x0A,0x23,0x80,0x3E,0x01,0x23,0x2A,0x3E,0x02,0x3D,0xDA,0x23,0xFF,
           0x3E,0x03,0x22,0x86,0xD9,0xDD,0x10,0x1D,0x22,0x08,0x2F,0xF0,0xD9,0xF1,0x18,0x56,
           0xD9,0xDD,0x18,0x33,0x23,0x00,0x3E,0x06,0x3E,0x46,0x3E,0x86,0x3E,0xC6,0x21,0xF0,
           0x37,0xFA,0x2F,0xFA,0x3E,0x08,0x23,0x00,0x3E,0x07,0x3E,0x87,0x3E,0xC7,0x23,0xFF,
           0x3E,0x09,0x3E,0x47,0x00,0x3A,0x23,0x00,0x3E,0x06,0x3E,0x08,0x23,0x13,0x3E,0x07,
           0x23,0x01,0x3E,0x09,0xA2,0xFC,0xA2,0xF6,0xCD,0xF0,0x10,0x3F,0x82,0xFC,0xD9,0xDD,
           0x18,0x4F,0x23,0xFF,0x3E,0x87,0x68,0x70,0x23,0x14,0x68,0x62,0x3F,0x20,0x23,0x00,
           0x3E,0x87,0x68,0x70,0x23,0x14,0x68,0x62,0x3F,0x20,0x22,0x86,0x00,0x54,0x68,0x70,
           0x23,0x14,0x68,0x62,0x3F,0x20,0x22,0x08,0x2F,0xF0,0x3D,0xF5,0x3B,0xB0,0x10,0x6E,
           0x23,0x00,0x3E,0x02,0x23,0x01,0x3E,0x7C,0x23,0x14,0x3E,0x03,0x23,0x00,0x3E,0x7C,
           0x23,0x80,0xDD,0xF2,0x1B,0xA3,0x68,0x69,0x3B,0x00,0x10,0x61,0x23,0x09,0x3E,0x02,
           0x3D,0xDA,0x23,0x08,0xDD,0xDD,0x18,0x6D,0x23,0x88,0x3E,0x7F,0x21,0xDA,0xC9,0xF0,
           0x10,0x72,0x33,0x04,0x3E,0x02,0x3D,0xDA,0xD9,0xF1,0x10,0x79,0x23,0x00,0x3D,0xF1,
           0x00,0xA1,0x21,0xF5,0x2F,0xF0,0x3B,0xE0,0x10,0x7F,0x23,0x22,0x00,0x98,0x3B,0x60,
           0x10,0x83,0x23,0x22,0x00,0x98,0x3B,0xC0,0x10,0x87,0x23,0xEE,0x00,0x98,0x3B,0xB0,
           0x10,0x8B,0x23,0x44,0x00,0x98,0x3B,0x20,0x10,0x8F,0x23,0xC4,0x00,0x98,0x3B,0x30,
           0x10,0x93,0x23,0x22,0x00,0x98,0x3B,0xF0,0x1B,0xA7,0x00,0xBE,0xD9,0xDD,0x18,0x99,
           0x3E,0x46,0x23,0x11,0x68,0x69,0x3B,0x00,0x10,0x9A,0x22,0x06,0x37,0xFF,0x3D,0xEF,
           0x81,0xF5,0x0A,0xE0,0x08,0xC4,0x08,0xE3,0x0A,0x5B,0x0B,0x5D,0xDD,0xF3,0x10,0xA1,
           0xBD,0xF3,0x9D,0xD9,0x21,0xDE,0x3B,0x00,0x18,0xB5,0x5D,0x00,0x4B,0xC8,0x41,0xE0,
           0x22,0x7F,0x33,0x40,0x3E,0x7F,0x21,0xDE,0x4D,0xC8,0x58,0x00,0x4B,0xC8,0x41,0xFC,
           0x22,0x7F,0x2F,0xBF,0x3E,0x7F,0x21,0xF7,0x4D,0xC8,0x00,0xBD,0x23,0xDD,0x3D,0xF4,
           0x0B,0xC6,0x96,0xF4,0x9E,0xF6,0x00,0xC3,0xDD,0xE6,0x68,0x6E,0xC5,0xE6,0x68,0x6F,
           0xC1,0xE6,0x18,0xD4,0x81,0xE6,0x68,0x70,0x43,0xC8,0x45,0xCA,0x21,0xE4,0x68,0x62,
           0x21,0xE5,0x68,0x74,0x47,0xD4,0x68,0x6D,0x41,0xD2,0x43,0xC8,0x50,0x00,0x47,0xC8,
           0x41,0xC8,0x68,0x71,0x68,0x6E,0xC1,0xE6,0x68,0x6E,0x85,0xE6,0x8A,0xF4,0xC1,0xE6,
           0x68,0x6F,0xA5,0xE6,0x68,0x6D,0x21,0xE7,0x2F,0x0F,0x3D,0xCA,0x2F,0x0C,0x3B,0x0C,
           0x68,0x6E,0x21,0xE7,0xDE,0xF0,0x1A,0x4F,0xDA,0xF0,0x19,0x0C,0xA2,0x0A,0x99,0xE7,
           0x23,0x00,0x3D,0xD6,0x3D,0xE8,0x21,0xCA,0x3B,0x0F,0x10,0xFE,0x23,0x81,0x3E,0x01,
           0x21,0xDA,0x3E,0x02,0x23,0x7E,0x3E,0x03,0x92,0xF1,0x01,0x0A,0x23,0x40,0x3E,0x01,
           0x21,0xC6,0x3E,0x02,0x21,0xC7,0x3E,0x03,0x21,0xCA,0x3B,0x0C,0x23,0x00,0x11,0x09,
           0x23,0x01,0x3D,0xD7,0x82,0x0A,0x68,0x6D,0x21,0xCA,0x3B,0x0F,0x19,0x4A,0x21,0xE7,
           0xDE,0xF0,0x1A,0x4F,0xD6,0xF0,0x11,0x30,0x68,0x70,0x43,0xC8,0x21,0xCA,0xC2,0xF0,
           0x21,0xC9,0x68,0x64,0xDD,0xD7,0x11,0x26,0x3D,0xC8,0x21,0xCA,0xC6,0xF0,0x21,0xC8,
           0x68,0x64,0x3D,0xC8,0x21,0xCA,0xCA,0xF0,0x21,0xC8,0x68,0x64,0x68,0x6B,0x29,0xD8,
           0x3B,0x7F,0xDA,0xF1,0x21,0xE7,0x2F,0x0F,0x3D,0xCA,0x11,0x30,0x91,0xE7,0x02,0x14,
           0xDE,0x04,0x68,0x6E,0x68,0x70,0x43,0xC8,0x21,0xCA,0xC2,0xF0,0x21,0xC9,0x68,0x64,
           0x3D,0xD8,0x21,0xCA,0x3D,0xCB,0xDD,0xD7,0x11,0x47,0x21,0xCA,0xC6,0xF0,0x21,0xD8,
           0x68,0x64,0x3D,0xD8,0x21,0xCA,0xCA,0xF0,0x21,0xD8,0x68,0x64,0x3D,0xD8,0x21,0xE7,
           0x2F,0x0F,0x3D,0xCA,0xDE,0x04,0x68,0x6E,0x22,0x00,0xCA,0x0A,0x11,0x56,0xA2,0x0A,
           0x99,0xE8,0x21,0xCA,0x3B,0x0F,0x1A,0x56,0x82,0x0A,0x68,0x6D,0x3D,0xC8,0x22,0x04,
           0x3D,0xC9,0x21,0xCA,0x3B,0x0F,0x11,0x66,0x21,0xC9,0x2F,0x38,0x3B,0x00,0x11,0x63,
           0x21,0xC8,0x3E,0xB0,0x01,0xFA,0xD5,0xE7,0x68,0x6E,0x02,0x14,0x21,0xC9,0xD6,0xF0,
           0x11,0x6A,0x95,0xE8,0xCE,0xF0,0x11,0x6D,0x9D,0xE8,0x21,0xD7,0x3B,0x00,0x19,0xF9,
           0xDE,0xF0,0x11,0x7A,0xDA,0xF0,0x19,0xBC,0x21,0xC8,0x3B,0x54,0x11,0xFA,0x23,0xC2,
           0x3D,0xD7,0x01,0xFA,0x3B,0x01,0x11,0x80,0x21,0xC8,0x3B,0x52,0x11,0xF7,0x01,0xF3,
           0x3B,0x02,0x11,0x86,0x21,0xC8,0x3B,0x4F,0x11,0xF7,0x01,0xF3,0x3B,0x03,0x11,0x8C,
           0x21,0xC8,0x3B,0x42,0x11,0xF7,0x01,0xF3,0x3B,0x04,0x11,0x92,0x21,0xC8,0x3B,0x47,
           0x11,0xF7,0x01,0xF3,0x3B,0x05,0x11,0x98,0x21,0xC8,0x3B,0x20,0x11,0xF7,0x01,0xF3,
           0x3B,0x06,0x11,0x9E,0x21,0xC8,0x3B,0x54,0x11,0xF7,0x01,0xF3,0x3B,0x07,0x11,0xA4,
           0x21,0xC8,0x3B,0x4F,0x11,0xF7,0x01,0xF3,0x3B,0x08,0x11,0xAA,0x21,0xC8,0x3B,0x4E,
           0x11,0xF7,0x01,0xF3,0x3B,0x09,0x11,0xF7,0x21,0xC8,0x3B,0x59,0x11,0xF7,0x23,0x80,
           0x3D,0xD7,0x21,0xCB,0xC6,0xF0,0x21,0xD8,0x68,0x64,0x3D,0xD8,0x21,0xCB,0xCA,0xF0,
           0x21,0xD8,0x68,0x64,0x3D,0xD8,0x01,0xFA,0x2F,0x3F,0x3B,0x02,0x11,0xC3,0x21,0xC8,
           0x3B,0x4F,0x11,0xF0,0x01,0xF3,0x3B,0x03,0x11,0xC9,0x21,0xC8,0x3B,0x4E,0x11,0xF0,
           0x01,0xF3,0x3B,0x04,0x11,0xCF,0x21,0xC8,0x3B,0x59,0x11,0xF0,0x01,0xF3,0x3B,0x05,
           0x11,0xD5,0x21,0xC8,0x3B,0x20,0x11,0xF0,0x01,0xF3,0x3B,0x06,0x11,0xDB,0x21,0xC8,
           0x3B,0x52,0x11,0xF0,0x01,0xF3,0x3B,0x07,0x11,0xE1,0x21,0xC8,0x3B,0x4F,0x11,0xF0,
           0x01,0xF3,0x3B,0x08,0x11,0xE7,0x21,0xC8,0x3B,0x42,0x11,0xF0,0x01,0xF3,0x3B,0x09,
           0x11,0xF0,0x21,0xC8,0x3B,0x47,0x11,0xF0,0x21,0xE8,0x33,0x01,0x3D,0xE8,0x01,0xFA,
           0x23,0x80,0x3D,0xD7,0x01,0x74,0x21,0xD7,0x68,0x68,0x3D,0xD7,0x01,0xF9,0x23,0x00,
           0x3D,0xD7,0x95,0xE7,0xD1,0xE8,0x1A,0x23,0x45,0xDE,0xDE,0xF1,0x12,0x01,0x91,0xE8,
           0x02,0x16,0x51,0xCC,0x21,0xD6,0x68,0x62,0x21,0xC8,0x68,0x67,0x45,0xDE,0x23,0x01,
           0x68,0x63,0x47,0xDE,0x21,0xD6,0x68,0x68,0x3D,0xD6,0x21,0xE8,0x2F,0x07,0x3B,0x01,
           0x1A,0x14,0x21,0xD6,0x3B,0x08,0x12,0x23,0xD1,0xE8,0x1A,0x23,0x21,0xD6,0x3B,0x00,
           0x1A,0x23,0x41,0xE0,0x57,0xCC,0xDD,0xF2,0x1B,0xA3,0xC2,0xF1,0x12,0x1B,0x68,0x62,
           0x43,0xE0,0x23,0x00,0x3D,0xD6,0x21,0xCA,0x3B,0x0F,0x12,0x48,0x21,0xC9,0x2F,0x38,
           0x3B,0x00,0x12,0x2C,0x95,0xE7,0x68,0x6D,0x3B,0x10,0x12,0x43,0x21,0xC8,0x3B,0x7E,
           0x12,0x40,0x22,0x74,0x3B,0x47,0x12,0x3D,0x22,0x75,0x3B,0x0F,0x12,0x3D,0x21,0xE7,
           0xDE,0xF0,0x1A,0x4F,0xD6,0xF0,0x68,0x6E,0x02,0x56,0x23,0x04,0x3D,0xE8,0x02,0x56,
           0x23,0x03,0x3D,0xE8,0x02,0x56,0xCE,0xF0,0x68,0x6F,0x23,0x02,0x3D,0xE8,0x02,0x56,
           0x21,0xE8,0x2F,0x07,0x3B,0x01,0x1A,0x56,0xD1,0xE7,0x68,0x6E,0x02,0x56,0xA2,0x0A,
           0xCE,0xF4,0x68,0x6F,0xDD,0xE7,0x68,0x6E,0x23,0x07,0x3D,0xE8,0xA2,0x0A,0x23,0x00,
           0x3D,0xE7,0x8E,0xF4,0x68,0x6D,0x21,0xE7,0x2F,0x0F,0x3D,0xCA,0x2F,0x0C,0x3D,0xCB,
           0x3B,0x08,0x68,0x6E,0x21,0xE7,0xDE,0xF0,0x1A,0xD4,0xDA,0xF0,0x1A,0x80,0x99,0xE7,
           0x23,0x00,0x3D,0xD6,0x3D,0xE8,0x21,0xCA,0x3B,0x0B,0x12,0x77,0x23,0x81,0x3E,0x01,
           0x21,0xDA,0x3E,0x02,0x23,0x7E,0x3E,0x03,0x86,0x0A,0xAE,0x0A,0x68,0x6D,0x23,0x40,
           0x3E,0x01,0x21,0xC6,0x3E,0x02,0x21,0xC7,0x3E,0x03,0x86,0x0A,0xAE,0x0A,0x68,0x6D,
           0x21,0xD6,0x3B,0x00,0x12,0xA4,0x45,0xDE,0xDE,0xF1,0x12,0x8E,0x21,0xCA,0x3B,0x0B,
           0x12,0xDC,0xD1,0xE7,0x12,0xC0,0xC6,0x04,0x68,0x6E,0x02,0xDC,0x21,0xDF,0x3B,0x00,
           0x12,0x95,0x21,0xDE,0x3B,0x08,0xDA,0xF1,0x12,0x96,0x23,0x08,0x41,0xE0,0x55,0xCC,
           0xDD,0xF2,0x1B,0xA3,0xC2,0xF1,0x12,0x98,0x68,0x62,0x43,0xE0,0x45,0xDE,0x68,0x63,
           0x47,0xDE,0x3D,0xD6,0x23,0x00,0x3D,0xD8,0xC2,0x04,0x68,0x6E,0xD5,0xE7,0x1A,0xB1,
           0x21,0xCA,0x3B,0x0B,0x12,0xB1,0x23,0x7E,0x68,0x6A,0x3E,0x00,0x95,0xE7,0x96,0xF1,
           0xAE,0x0A,0x51,0xCC,0x21,0xD8,0x68,0x62,0x68,0x68,0x3D,0xD8,0x68,0x66,0x68,0x6B,
           0x3E,0x00,0x3E,0xB1,0xCE,0x0A,0x1A,0xD0,0x21,0xD6,0x68,0x69,0x3D,0xD6,0x02,0x80,
           0x22,0x05,0x2F,0x0F,0x3B,0x0C,0xDA,0xF1,0x68,0x6F,0x22,0x78,0x68,0x6B,0x3E,0x00,
           0x22,0x79,0x3E,0x00,0x23,0x7E,0x68,0x6A,0x3E,0x00,0x91,0xE7,0xCE,0x0A,0x68,0x6E,
           0x86,0x0A,0xAE,0x0A,0x99,0xE8,0x02,0xDC,0x86,0x0A,0xAE,0x0A,0xCE,0xF4,0x68,0x6F,
           0xDD,0xE7,0x68,0x6E,0x23,0x07,0x3D,0xE8,0x23,0x00,0x3D,0xE7,0x8E,0xF4,0x68,0x6D,
           0x22,0x86,0xD9,0xDD,0x12,0xE4,0x22,0x08,0x2F,0xF0,0x3B,0xB0,0x1B,0x13,0x22,0x86,
           0xD9,0xDD,0x12,0xEB,0x22,0x08,0x2F,0xF0,0x3B,0xF0,0x1B,0xA7,0xD9,0xDD,0x1A,0xF5,
           0x21,0xF0,0x37,0xFA,0x2F,0xFA,0x3E,0x08,0x02,0xFE,0xDD,0xF0,0x68,0x6C,0xF2,0x06,
           0xD9,0xF0,0x68,0x6C,0xE6,0x06,0xC5,0xF0,0x68,0x6C,0xE2,0x06,0xDD,0xF2,0x1B,0xA3,
           0xDD,0xF1,0x13,0x05,0xDD,0xD9,0x1B,0xAD,0xBD,0xF1,0x22,0x06,0x37,0xFF,0x39,0xEF,
           0x13,0x0A,0x68,0x6D,0x3D,0xC8,0x35,0xEF,0x2D,0xEE,0x3B,0x00,0x21,0xC8,0x3D,0xEF,
           0x68,0x6F,0x92,0xF4,0x68,0x6D,0x22,0x86,0xD9,0xDD,0x13,0x17,0x22,0x08,0x2F,0xF0,
           0x3B,0xF0,0x1B,0xA7,0xD9,0xDD,0x1B,0x20,0xDD,0xF0,0x68,0x6C,0xFE,0x08,0x03,0x23,
           0xDD,0xF0,0x68,0x6C,0xF2,0x06,0xDD,0xE9,0x13,0x2C,0xD9,0xE9,0x1B,0x2C,0x22,0xBC,
           0x3B,0x10,0x13,0x2D,0x99,0xE9,0x82,0xF4,0x3E,0xBC,0xDD,0xEA,0x13,0x36,0xD9,0xEA,
           0x1B,0x36,0x22,0xBD,0x3B,0x10,0x13,0x37,0x99,0xEA,0x82,0xF4,0x3E,0xBD,0xDD,0xEB,
           0x13,0x40,0xD9,0xEB,0x1B,0x40,0x22,0xBE,0x3B,0x10,0x13,0x41,0x99,0xEB,0x82,0xF4,
           0x3E,0xBE,0xDD,0xEC,0x13,0x4A,0xD9,0xEC,0x1B,0x4A,0x22,0xBF,0x3B,0x10,0x13,0x4B,
           0x99,0xEC,0x82,0xF4,0x3E,0xBF,0xDD,0xF2,0x1B,0xA3,0xDD,0xF1,0x13,0x52,0xDD,0xD9,
           0x1B,0xAD,0xBD,0xF1,0x22,0x06,0x37,0xFF,0x2F,0x80,0x39,0xEF,0x13,0x58,0x68,0x6D,
           0x3D,0xEF,0xDD,0xEE,0x68,0x6E,0x92,0xF4,0x68,0x6D,0x21,0xE7,0x2F,0x0F,0x3B,0x04,
           0x68,0x6E,0x21,0xE7,0xDE,0xF0,0x1B,0x83,0xDA,0xF0,0x1B,0x78,0x68,0x70,0x43,0xC8,
           0x21,0xCA,0xC2,0xF0,0x21,0xC9,0x68,0x64,0x3D,0xD8,0x23,0x81,0x3E,0x01,0x21,0xDA,
           0x33,0x20,0x3E,0x02,0x23,0x80,0x3E,0x01,0x23,0x00,0x3E,0xF5,0x99,0xE7,0x68,0x6D,
           0x68,0x70,0x43,0xC8,0x21,0xCA,0xC2,0xF0,0x21,0xC9,0x68,0x64,0x68,0x6B,0x29,0xD8,
           0x3B,0x3B,0xDA,0xF1,0x13,0x8E,0xCE,0xF4,0x68,0x6F,0xDD,0xE7,0x68,0x6E,0x21,0xDA,
           0x2F,0xDF,0x3E,0x02,0x68,0x6A,0xFE,0x08,0xBD,0xF0,0x03,0x9F,0xD6,0xF0,0x1B,0x9B,
           0x22,0xF5,0x3B,0x08,0xDA,0xF1,0x68,0x6E,0x21,0xDA,0x2F,0xDF,0x3E,0x02,0x68,0x6A,
           0xFE,0x08,0xBD,0xF0,0x95,0xE7,0x22,0xF5,0x3B,0x22,0xDA,0xF1,0x68,0x6E,0x23,0x00,
           0x3D,0xE7,0x8E,0xF4,0x68,0x6D,0x0B,0xC6,0xBD,0xF2,0x9E,0xF6,0x03,0xA4,0x23,0xCC,
           0x3D,0xF4,0x0B,0xC6,0x96,0xF4,0x9E,0xF6,0x03,0xAC,0xBD,0xD9,0xA2,0x0A,0x86,0x0A,
           0xAE,0x0A,0xBD,0xF1,0x0B,0x5D,0xD9,0xF1,0x1B,0xBD,0x0A,0xE0,0xDD,0xF3,0x13,0xB1,
           0x23,0x00,0x3D,0xF1,0xBD,0xF3,0x9D,0xD9,0x00,0x00,0x58,0x00,0x4B,0xC8,0x41,0xF8,
           0x22,0x7F,0x2F,0xBF,0x3E,0x7F,0x21,0xF6,0x4D,0xC8,0x03,0xC5,0xA2,0x0A,0x86,0x0A,
           0xAE,0x0A,0xD9,0xDD,0x1B,0xCD,0x23,0x00,0x3E,0x46,0x23,0x00,0x3D,0xF5,0x3D,0xF0,
           0x3D,0xEF,0x23,0x12,0x3E,0x06,0x23,0xC0,0x3E,0x08,0x68,0x6D,0x00,0x00,0x00,0x00};

static unsigned char resRVdce[192] = 
          {0x22,0x86,0xD9,0xDD,0x15,0x04,0x22,0x08,0x2F,0xF0,0x3B,0xF0,0x1D,0x30,0xD9,0xDD,
           0x1D,0x0E,0x21,0xF0,0x37,0xFA,0x2F,0xFA,0x3E,0x08,0x05,0x17,0xDD,0xF0,0x68,0x6C,
           0xF2,0x06,0xD9,0xF0,0x68,0x6C,0xE6,0x06,0xC5,0xF0,0x68,0x6C,0xE2,0x06,0xDD,0xF2,
           0x1D,0x2C,0xDD,0xF1,0x15,0x1E,0xDD,0xD9,0x1D,0x36,0xBD,0xF1,0x22,0x06,0x37,0xFF,
           0x39,0xEF,0x15,0x23,0x68,0x6D,0x3D,0xC8,0x35,0xEF,0x2D,0xEE,0x3B,0x00,0x21,0xC8,
           0x3D,0xEF,0x68,0x6F,0x92,0xF4,0x68,0x6D,0x0D,0x4F,0xBD,0xF2,0x9E,0xF6,0x05,0x2D,
           0x23,0xCC,0x3D,0xF4,0x0D,0x4F,0x96,0xF4,0x9E,0xF6,0x05,0x35,0xBD,0xD9,0xA2,0x0A,
           0x86,0x0A,0xAE,0x0A,0xBD,0xF1,0x0D,0x5F,0xD9,0xF1,0x1D,0x46,0x0D,0x00,0xDD,0xF3,
           0x15,0x3A,0x23,0x00,0x3D,0xF1,0xBD,0xF3,0x9D,0xD9,0x00,0x00,0x58,0x00,0x4B,0xC8,
           0x41,0xF8,0x22,0x7F,0x2F,0xBF,0x3E,0x7F,0x21,0xF6,0x4D,0xC8,0x05,0x4E,0xA2,0x0A,
           0x86,0x0A,0xAE,0x0A,0xD9,0xDD,0x1D,0x56,0x23,0x00,0x3E,0x46,0x23,0x00,0x3D,0xF5,
           0x3D,0xF0,0x3D,0xEF,0x23,0x12,0x3E,0x06,0x23,0xC0,0x3E,0x08,0x68,0x6D,0x68,0x6D};

static unsigned char funcLoad[1760] = 
          {0x81,0xDD,0xA1,0xC5,0x23,0x40,0x3E,0x01,0x21,0xC6,0x3E,0x02,0x21,0xC7,0x3E,0x03,
           0x23,0x10,0x3E,0xB7,0x3E,0xB5,0x23,0x20,0x3E,0xB6,0x3E,0xB4,0xCD,0xBD,0x18,0x13,
           0x23,0x7E,0x3D,0x9F,0x00,0x15,0x23,0xC0,0x3D,0x9F,0x50,0x00,0x43,0x84,0x23,0x00,
           0x3D,0x98,0x0B,0x20,0x09,0xB0,0xC1,0xC5,0x18,0x01,0x49,0x8C,0x68,0x6D,0x21,0xBF,
           0x3B,0x00,0x18,0x27,0xC2,0x04,0x10,0x34,0x3E,0x00,0x23,0x00,0x3D,0xBF,0xC5,0xC5,
           0x18,0x34,0xC9,0xC5,0x10,0x32,0xC2,0x04,0x10,0x34,0x23,0x00,0x68,0x6A,0x3E,0x00,
           0x3E,0x00,0x00,0x34,0x49,0x8E,0x68,0x6D,0x21,0xC5,0x39,0xC4,0x13,0x3C,0xC2,0xF1,
           0x10,0x5B,0xD5,0x98,0x18,0x46,0x95,0x98,0x45,0x8A,0xDE,0xF1,0x10,0x51,0x21,0x42,
           0x39,0x40,0x10,0x56,0x45,0x88,0xDE,0xF1,0x10,0x57,0x00,0x5B,0xB5,0x98,0x45,0x88,
           0xDE,0xF1,0x10,0x57,0x45,0x8A,0xDE,0xF1,0x10,0x51,0x21,0x42,0x39,0x40,0x10,0x56,
           0x00,0x5B,0x49,0x8A,0x45,0x84,0x47,0x8A,0x68,0x6D,0x00,0x5B,0x00,0xDB,0x49,0x88,
           0x45,0x84,0x47,0x88,0x68,0x6D,0x0D,0x00,0x00,0x1B,0x00,0x1F,0xDE,0x04,0x10,0x1F,
           0x78,0x62,0x67,0x8C,0xD9,0x97,0x10,0x66,0xB9,0x97,0x00,0x99,0xDE,0x04,0x10,0xB8,
           0x68,0x70,0x43,0x80,0x45,0x82,0x21,0xB7,0x68,0x62,0x47,0x82,0x22,0x00,0x3D,0x90,
           0xCA,0x0A,0x18,0x99,0x22,0x04,0x2F,0x28,0x3D,0x91,0x3B,0x00,0x18,0x80,0xD6,0xF0,
           0x10,0x7C,0x95,0xA4,0x8D,0xA4,0x00,0x80,0xCE,0xF0,0x10,0x80,0x9D,0xA4,0x8D,0xA4,
           0x45,0x70,0x21,0x90,0x68,0x67,0x68,0x60,0x47,0x70,0x21,0x99,0x68,0x68,0x3D,0x99,
           0x53,0x74,0x18,0xD9,0xCD,0xA4,0xAD,0xA4,0x18,0x99,0x3B,0x20,0x68,0x6E,0x21,0x70,
           0x3B,0x60,0xDA,0xF1,0x10,0x97,0x23,0x00,0x3D,0x70,0x39,0x74,0x18,0xD9,0x23,0x00,
           0x00,0xBC,0x78,0x5E,0x67,0x8C,0x21,0x70,0x3B,0x60,0xDA,0xF1,0x10,0xA3,0x23,0x00,
           0x3D,0x70,0x39,0x74,0x18,0xA7,0xCA,0x0A,0x18,0xA7,0xC1,0x97,0x10,0xAC,0xAA,0x0A,
           0xA1,0x97,0xA2,0x0A,0x23,0x50,0x00,0xB5,0xDD,0xA4,0x10,0xB0,0x23,0x90,0x00,0xB5,
           0xD5,0xA4,0x10,0xB4,0x23,0x11,0x00,0xB5,0x23,0x10,0xBD,0xA4,0xB5,0xA4,0x00,0xBC,
           0x41,0x80,0x68,0x71,0x68,0x6E,0x00,0x99,0x45,0x40,0x68,0x67,0x68,0x60,0x21,0x99,
           0x68,0x67,0x23,0x00,0x3D,0x99,0x21,0x40,0x68,0x6B,0x27,0x02,0x3B,0x40,0x10,0xC9,
           0x23,0x00,0x39,0x42,0x18,0xCD,0x3D,0x40,0x68,0x6D,0x45,0x40,0x3D,0x40,0x23,0x50,
           0x68,0x67,0x68,0x60,0x68,0x66,0x33,0x80,0x68,0x67,0xA2,0x0A,0x78,0x5E,0x67,0x8C,
           0x00,0x1F,0x81,0x97,0x00,0x99,0x45,0x42,0x68,0x66,0x3D,0x94,0x68,0x60,0x68,0x66,
           0x2F,0x3F,0x3D,0x95,0x3B,0x00,0x19,0x20,0xDD,0x97,0x19,0x00,0xD9,0x97,0x10,0xEA,
           0x9D,0x97,0x01,0x00,0x45,0x50,0x43,0x90,0x50,0x00,0x21,0x95,0x68,0x62,0x53,0x90,
           0xDA,0xF1,0x19,0x5B,0x45,0x50,0x68,0x63,0x47,0x50,0x41,0x4C,0x21,0x95,0x4F,0x74,
           0x68,0x62,0x43,0x4C,0x45,0x54,0x68,0x62,0x47,0x54,0x79,0x04,0x67,0x8A,0x00,0x5B,
           0x21,0x95,0x45,0x54,0x68,0x62,0x47,0x54,0x21,0x74,0x68,0x6B,0x25,0x95,0x3B,0x60,
           0xDA,0xF1,0x11,0x0B,0x23,0x00,0x3D,0x74,0x21,0x94,0xDA,0xF0,0x11,0x10,0x82,0x0A,
           0x21,0x94,0xD2,0xF0,0x19,0x20,0x45,0x50,0xDE,0xF1,0x11,0x88,0xDD,0x97,0x19,0x88,
           0x41,0x48,0xDE,0xF1,0x19,0x1E,0x23,0x0C,0x55,0x48,0x01,0x88,0x99,0x97,0x01,0x88,
           0xCD,0x94,0x11,0x24,0x8E,0xF2,0x01,0x88,0x41,0x44,0xDE,0xF1,0x19,0x45,0x45,0x42,
           0x68,0x60,0x68,0x66,0xDE,0xF0,0x11,0x2D,0x82,0x0A,0x21,0x94,0xDD,0x97,0x11,0x32,
           0x33,0x02,0xBD,0x97,0xB9,0x97,0x3D,0x56,0x41,0xB0,0x23,0x10,0x68,0x62,0x23,0x04,
           0x57,0x54,0x79,0x3C,0x67,0x8A,0x00,0x5B,0x92,0xF2,0x23,0x00,0x3D,0x54,0x3D,0x55,
           0x41,0x44,0x43,0xB0,0x23,0x10,0x55,0x44,0x01,0x88,0x41,0xB0,0x23,0x10,0x55,0x44,
           0x79,0x4B,0x67,0x8A,0x00,0x5B,0x41,0x44,0xDE,0xF1,0x11,0x27,0x68,0x70,0x23,0x0E,
           0x68,0x62,0x43,0x78,0x79,0x55,0x67,0x8A,0x00,0x5B,0x41,0x78,0x68,0x71,0x19,0x45,
           0x79,0x55,0x67,0x8A,0x00,0x5B,0x21,0x95,0x68,0x6B,0x29,0x50,0x3D,0x95,0x41,0x4C,
           0x21,0x50,0x4F,0x74,0x45,0x54,0x68,0x62,0x47,0x54,0x79,0x68,0x67,0x8A,0x00,0x5B,
           0x21,0x74,0x68,0x6B,0x25,0x50,0x3D,0x74,0x41,0x48,0xDE,0xF1,0x11,0x77,0x9D,0x97,
           0x21,0x95,0x45,0x54,0x68,0x62,0x47,0x54,0x50,0x00,0x47,0x50,0x01,0x04,0x23,0x0C,
           0x55,0x48,0x79,0x7C,0x67,0x8A,0x00,0x5B,0x45,0x50,0x43,0x90,0x50,0x00,0x21,0x95,
           0x68,0x62,0x53,0x90,0xDA,0xF1,0x19,0x5B,0x45,0x50,0x68,0x63,0x47,0x50,0x00,0xF5,
           0x21,0x42,0x68,0x6B,0x27,0x02,0x3B,0x40,0x11,0x8E,0x23,0x00,0x3D,0x42,0x00,0x5B,
           0x4B,0x92,0x09,0xB0,0x41,0xB0,0xDE,0xF1,0x11,0x9B,0x79,0x99,0x67,0x8A,0x49,0x92,
           0x68,0x6D,0x4B,0x92,0x01,0x92,0x23,0x10,0x55,0x44,0x79,0xA1,0x67,0x8A,0x49,0x92,
           0x68,0x6D,0x82,0x0A,0x78,0x5E,0x67,0x8C,0x50,0x00,0x43,0x70,0x43,0x74,0x23,0x00,
           0x3D,0xB5,0x3D,0x99,0x3D,0x54,0x3D,0x55,0x3D,0x97,0x00,0x55,0x81,0x98,0x01,0xB1,
           0xA1,0x98,0xA2,0x0A,0x51,0x00,0x47,0x40,0x47,0x42,0x45,0x84,0x47,0x8A,0x78,0x5D,
           0x67,0x8C,0xC1,0x98,0x68,0x6E,0x8A,0xF2,0x68,0x6D,0x00,0x34,0x96,0xF2,0xB1,0x98,
           0xDD,0xBC,0x10,0x34,0xBD,0xBC,0x79,0xC8,0x67,0x8E,0x7A,0x5F,0x67,0x88,0x00,0x34,
           0x00,0x34,0xC2,0x04,0x10,0x34,0x4B,0x92,0x0A,0x4F,0x49,0x92,0xC1,0x9D,0x11,0xD1,
           0x00,0x34,0x79,0xD4,0x67,0x8E,0x68,0x6D,0xC2,0x04,0x10,0x34,0x4B,0x92,0x0A,0x4F,
           0x49,0x92,0xC1,0x9D,0x11,0xDC,0x00,0x34,0x45,0x6E,0x68,0x66,0x68,0x6B,0x3E,0x00,
           0x21,0x6E,0x68,0x68,0x3B,0x00,0x11,0xE5,0x23,0x80,0x3D,0x6E,0x68,0x6B,0x29,0x6C,
           0x11,0xEC,0xC9,0x98,0x19,0xF9,0x01,0xEE,0xC9,0x98,0x19,0xF3,0x3B,0x00,0x68,0x6E,
           0x7A,0x10,0x67,0x8E,0x68,0x6D,0x3B,0x1F,0xDA,0xF1,0x19,0xF9,0x3B,0x00,0x19,0xFF,
           0x68,0x6D,0x45,0x88,0xDE,0xF1,0x68,0x6E,0x7A,0x82,0x67,0x88,0x68,0x6D,0x7A,0x02,
           0x67,0x8E,0x68,0x6D,0xC2,0x04,0x10,0x34,0x4B,0x92,0x0A,0x4F,0x49,0x92,0xC1,0x9D,
           0x12,0x0A,0x00,0x34,0x21,0x6C,0x39,0x6E,0x18,0x34,0x79,0xD4,0x67,0x8E,0x01,0xDC,
           0xC2,0x04,0x10,0x34,0x4B,0x92,0x0A,0x4F,0x49,0x92,0xC1,0x9D,0x12,0x18,0x00,0x34,
           0xBD,0x98,0x91,0x98,0xAD,0x98,0x7A,0x3F,0x67,0x8E,0x7A,0x20,0x67,0x88,0x68,0x6D,
           0x41,0x58,0xDE,0xF1,0x12,0x29,0x41,0x7C,0x23,0x14,0x55,0x58,0x7A,0x29,0x67,0x88,
           0x00,0x5B,0x23,0x80,0x3D,0x6A,0x41,0x7C,0x23,0x12,0x68,0x62,0x23,0x01,0x57,0x6A,
           0x7A,0x33,0x67,0x88,0x00,0x5B,0x8D,0x98,0x41,0x58,0xDE,0xF1,0x12,0x39,0x9D,0x98,
           0x68,0x6D,0x96,0xF2,0xBD,0xBC,0xB1,0x98,0x79,0xC8,0x67,0x8E,0x02,0x6D,0xDD,0x98,
           0x10,0x34,0xDD,0xBC,0x19,0xBE,0xD5,0x6B,0x1A,0x4A,0xD1,0x6B,0x1A,0x48,0x91,0x6B,
           0xC6,0x04,0x10,0x34,0x96,0xF2,0xB1,0x98,0x79,0xC0,0x67,0x8E,0x00,0x34,0xC1,0xBD,
           0x12,0x56,0x22,0x06,0xDA,0xF0,0x1A,0x57,0xBE,0x0A,0xA1,0x9D,0x68,0x6D,0x81,0x9D,
           0x22,0x05,0x2F,0x0F,0x3B,0x01,0xDA,0xF1,0x68,0x6E,0x9E,0x0A,0x68,0x6D,0x41,0xB8,
           0x23,0x04,0x55,0x7C,0x7A,0x65,0x67,0x88,0x00,0x5B,0x41,0x7C,0xDE,0xF1,0x12,0x6D,
           0x23,0x88,0x3D,0xBE,0x79,0xC0,0x67,0x8E,0x00,0x5B,0x23,0x14,0x55,0x58,0x43,0x7C,
           0x7A,0x74,0x67,0x88,0x99,0xB6,0x00,0x5B,0x41,0x58,0xDE,0xF1,0x12,0x7D,0x41,0xB8,
           0x23,0x04,0x57,0x84,0x7A,0x7D,0x67,0x88,0x00,0x5B,0x99,0x98,0x89,0x98,0x50,0x80,
           0x47,0x6C,0x47,0x6E,0x45,0x68,0xDE,0xF1,0x12,0xA7,0x23,0x80,0xDD,0x6B,0x13,0x19,
           0x23,0x10,0x3D,0x6A,0x41,0x7C,0x23,0x12,0x68,0x62,0x23,0x01,0x57,0x6A,0x7A,0x92,
           0x67,0x88,0x00,0x5B,0x41,0x58,0x23,0x82,0xDE,0xF1,0x1B,0x19,0x23,0x14,0x55,0x58,
           0x43,0x7C,0x7A,0x9C,0x67,0x88,0x00,0x5B,0xDD,0x6B,0x1A,0xA7,0x41,0x58,0xDE,0xF1,
           0x12,0xA7,0x41,0xB8,0x23,0x04,0x57,0x84,0x7A,0xA7,0x67,0x88,0x00,0x5B,0x45,0x66,
           0xDE,0xF1,0x1A,0xC2,0x65,0x66,0x63,0x90,0x45,0x64,0x53,0x90,0xDA,0xF1,0x1A,0xBB,
           0x68,0x5D,0x67,0x66,0x41,0x5C,0x23,0x84,0xDE,0xF1,0x1B,0x19,0x23,0x0A,0x55,0x5C,
           0x7A,0xAA,0x67,0x88,0x00,0x5B,0x68,0x7D,0x47,0x64,0x41,0x60,0x68,0x7C,0x43,0x60,
           0x70,0x00,0x67,0x66,0x45,0x64,0xDE,0xF1,0x12,0xCE,0x41,0x5C,0x23,0x86,0xDE,0xF1,
           0x1B,0x19,0x23,0x0A,0x55,0x5C,0x7A,0xCE,0x67,0x88,0x00,0x5B,0x21,0x6E,0x68,0x6B,
           0x29,0x6C,0x1A,0xD5,0x3B,0x00,0x1A,0xD5,0x02,0xD8,0x23,0x00,0x68,0x6B,0x29,0x6C,
           0x3D,0x96,0x45,0x68,0x43,0x90,0x70,0x00,0x68,0x42,0x73,0x90,0xDA,0xF1,0x12,0xE7,
           0x45,0x64,0x53,0x90,0xDA,0xF1,0x21,0x64,0x12,0xED,0x21,0x68,0x02,0xED,0x63,0x90,
           0x45,0x64,0x53,0x90,0xDA,0xF1,0x1A,0xEE,0x21,0x64,0x3D,0x96,0x21,0x96,0x41,0x60,
           0x4D,0x6C,0x68,0x62,0x43,0x60,0x45,0x64,0x68,0x63,0x47,0x64,0x45,0x68,0x68,0x63,
           0x47,0x68,0x7A,0xFC,0x67,0x88,0x00,0x5B,0x21,0x6C,0x68,0x6B,0x25,0x96,0x3B,0x00,
           0x13,0x02,0x23,0x80,0x3D,0x6C,0x45,0x68,0xDE,0xF1,0x13,0x0C,0xDD,0x6B,0x1B,0x0C,
           0xA9,0x98,0xD9,0x98,0x10,0x5B,0x03,0x11,0xD9,0x98,0x10,0x5B,0x21,0x6C,0x3B,0x80,
           0x12,0x82,0xB9,0x98,0x79,0xC9,0x67,0x8E,0xC2,0x04,0x10,0x5B,0x49,0x8E,0x68,0x6D,
           0x03,0x14,0x3D,0xBE,0x0B,0x20,0x09,0xB0,0x9E,0xF4,0x00,0x1B,0x81,0x98,0x03,0x21,
           0xA1,0x98,0x86,0x0A,0xAE,0x0A,0xC5,0x98,0x13,0x28,0x22,0x01,0x2F,0xFC,0x3E,0x01,
           0x45,0x84,0x47,0x88,0x79,0xBD,0x67,0x8E,0xC1,0x98,0x68,0x6E,0x86,0xF2,0x68,0x6D,
           0x79,0xC0,0x67,0x8E,0xB1,0x98,0xC5,0x98,0x13,0x5F,0x22,0x01,0x2F,0xFD,0xD5,0xBD,
           0x13,0x3A,0x33,0x03,0x3E,0x01,0x03,0x5F,0x3D,0x90,0x35,0xC4,0x3D,0x91,0xD1,0x90,
           0x1B,0x62,0xD5,0x90,0x13,0x4A,0xD5,0x91,0x10,0x37,0x09,0xB0,0x0B,0x20,0x82,0xF2,
           0x95,0xC4,0x00,0x37,0xDD,0x91,0x13,0x51,0xDD,0x90,0x13,0x50,0x09,0x90,0x03,0x51,
           0x09,0xAE,0xD9,0x91,0x13,0x5F,0xD9,0x90,0x1B,0x30,0xD1,0x98,0x13,0x5E,0xCD,0x98,
           0x1B,0x5C,0x21,0x90,0x33,0x40,0x03,0x60,0x96,0xF2,0xB1,0x98,0x0B,0x1E,0x21,0x90,
           0x3D,0xC4,0x00,0x37,0x91,0xC4,0x58,0x00,0x4B,0xC8,0x41,0xFC,0x22,0x7F,0x2F,0xBF,
           0x3E,0x7F,0x21,0xF7,0x4D,0xC8,0x03,0x6B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

static unsigned char topcidiag[192] = 
          {0x23,0x01,0x3C,0x04,0x23,0x80,0x3E,0x7F,0x23,0x00,0x3E,0x7C,0x20,0x00,0x3B,0x00,
           0x18,0x06,0x3B,0x03,0x10,0x0F,0x08,0x24,0x23,0x00,0x3C,0x00,0x00,0x06,0x3B,0x04,
           0x10,0x15,0x08,0x2B,0x23,0x00,0x3C,0x00,0x00,0x06,0x3B,0x06,0x10,0x1B,0x08,0x40,
           0x23,0x00,0x3C,0x00,0x00,0x06,0x3B,0x07,0x10,0x21,0x08,0x47,0x23,0x00,0x3C,0x00,
           0x00,0x06,0x20,0x00,0x3C,0x07,0x00,0x57,0x40,0x08,0x23,0x04,0x56,0x0C,0x3F,0x80,
           0x23,0x02,0x3C,0x04,0x00,0x57,0x23,0x03,0x3C,0x04,0x23,0x80,0x3E,0x7F,0x40,0x08,
           0x23,0x04,0x56,0x0C,0x3F,0x80,0x23,0x00,0x3E,0x7F,0x23,0x04,0x56,0x0C,0x3F,0x80,
           0x23,0x00,0x3C,0x00,0x23,0x80,0x3E,0x7F,0x82,0xF2,0x00,0x06,0x23,0x04,0x3C,0x04,
           0x23,0xFF,0x3E,0xF2,0x3E,0xF4,0x23,0x00,0x3C,0x00,0x3C,0x04,0x00,0x06,0x23,0x05,
           0x3C,0x04,0x40,0x10,0x20,0x18,0x54,0x48,0x3F,0x80,0x40,0x14,0x20,0x18,0x56,0x48,
           0x3F,0x80,0x20,0x18,0x3C,0x04,0x82,0xF2,0x23,0x00,0x3C,0x00,0x00,0x06,0x82,0xF4,
           0x00,0x58,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
 
static unsigned char toinstdiag[1776] = 
          {0x23,0x01,0x3C,0x04,0x20,0x00,0x3B,0x00,0x18,0x02,0x3B,0x01,0x10,0x0B,0x08,0x0E,
           0x23,0x00,0x3C,0x00,0x00,0x02,0x20,0x00,0x3C,0x07,0x03,0x75,0x23,0x80,0x3E,0x7F,
           0x23,0x02,0x3C,0x04,0x23,0x55,0x3B,0x55,0x18,0x19,0x3C,0x07,0x23,0x55,0x3C,0x06,
           0x03,0x75,0x23,0xAA,0x3B,0xAA,0x18,0x20,0x3C,0x07,0x23,0xAA,0x3C,0x06,0x03,0x75,
           0x23,0x03,0x3C,0x04,0x68,0x6A,0x3F,0x00,0x18,0x26,0x03,0x75,0x68,0x6B,0x3F,0x00,
           0x10,0x2A,0x03,0x75,0x23,0x04,0x3C,0x04,0x23,0x10,0x3C,0x68,0x24,0x68,0x3B,0x20,
           0x18,0x35,0x3C,0x07,0x23,0x20,0x3C,0x06,0x03,0x75,0x23,0x05,0x3C,0x04,0x23,0x20,
           0x68,0x6B,0x27,0x05,0x3B,0x25,0x18,0x40,0x3C,0x07,0x23,0x25,0x3C,0x06,0x03,0x75,
           0x23,0x06,0x3C,0x04,0x23,0x25,0x68,0x6B,0x2B,0x05,0x3B,0x20,0x18,0x4B,0x3C,0x07,
           0x23,0x20,0x3C,0x06,0x03,0x75,0x23,0x07,0x3C,0x04,0x23,0x20,0x68,0x6B,0x28,0x68,
           0x3B,0x10,0x18,0x56,0x3C,0x07,0x23,0x10,0x3C,0x06,0x03,0x75,0x23,0x08,0x3C,0x04,
           0x23,0x55,0x2C,0x68,0x3B,0x10,0x18,0x60,0x3C,0x07,0x23,0x10,0x3C,0x06,0x03,0x75,
           0x23,0x09,0x3C,0x04,0x23,0xFF,0x2F,0xAA,0x3B,0xAA,0x18,0x6A,0x3C,0x07,0x23,0xAA,
           0x3C,0x06,0x03,0x75,0x23,0x10,0x3C,0x04,0x23,0x55,0x3C,0x68,0x23,0xCC,0x30,0x68,
           0x3B,0xDD,0x18,0x76,0x3C,0x07,0x23,0xDD,0x3C,0x06,0x03,0x75,0x23,0x11,0x3C,0x04,
           0x23,0x55,0x33,0x33,0x3B,0x77,0x18,0x80,0x3C,0x07,0x23,0x77,0x3C,0x06,0x03,0x75,
           0x23,0x12,0x3C,0x04,0x23,0x55,0x3C,0x68,0x23,0xCC,0x34,0x68,0x3B,0x99,0x18,0x8C,
           0x3C,0x07,0x23,0x99,0x3C,0x06,0x03,0x75,0x23,0x13,0x3C,0x04,0x23,0x55,0x37,0x33,
           0x3B,0x66,0x18,0x96,0x3C,0x07,0x23,0x66,0x3C,0x06,0x03,0x75,0x23,0x14,0x3C,0x04,
           0x23,0x55,0x68,0x6B,0x68,0x64,0x3C,0x68,0x18,0xA1,0x3C,0x07,0x23,0x2A,0x3C,0x06,
           0x03,0x75,0x23,0x15,0x3C,0x04,0x20,0x68,0x3B,0x2A,0x18,0xAA,0x3C,0x07,0x23,0x2A,
           0x3C,0x06,0x03,0x75,0x23,0x16,0x3C,0x04,0x23,0xAA,0x68,0x6B,0x68,0x65,0x3C,0x68,
           0x18,0xB5,0x3C,0x07,0x23,0x54,0x3C,0x06,0x03,0x75,0x23,0x17,0x3C,0x04,0x20,0x68,
           0x3B,0x54,0x18,0xBE,0x3C,0x07,0x23,0x2A,0x3C,0x06,0x03,0x75,0x23,0x18,0x3C,0x04,
           0x23,0x55,0x3C,0x68,0x23,0xAA,0x20,0x68,0x3B,0x55,0x18,0xCA,0x3C,0x07,0x23,0x55,
           0x3C,0x06,0x03,0x75,0x23,0x19,0x3C,0x04,0x23,0x55,0x68,0x69,0x3B,0x54,0x18,0xD4,
           0x3C,0x07,0x23,0x54,0x3C,0x06,0x03,0x75,0x23,0x20,0x3C,0x04,0x23,0x54,0x68,0x68,
           0x3B,0x55,0x18,0xDE,0x3C,0x07,0x23,0x55,0x3C,0x06,0x03,0x75,0x23,0x21,0x3C,0x04,
           0x3C,0x68,0x68,0x6B,0x38,0x68,0x18,0xE8,0x3C,0x07,0x20,0x68,0x3C,0x06,0x03,0x75,
           0x23,0x22,0x3C,0x04,0x68,0x6B,0x68,0x6C,0x3F,0x00,0x18,0xEF,0x03,0x75,0x23,0x23,
           0x3C,0x04,0x68,0x6C,0x3F,0x00,0x10,0xF5,0x03,0x75,0x23,0x24,0x3C,0x04,0x08,0xFF,
           0x33,0x50,0x3B,0x55,0x11,0x02,0x3C,0x07,0x23,0x55,0x3C,0x06,0x03,0x75,0x33,0x05,
           0x68,0x6D,0x00,0xFB,0x23,0x25,0x3C,0x04,0x23,0x00,0x68,0x6B,0x09,0x0E,0x33,0x50,
           0x3B,0x55,0x19,0x11,0x3C,0x07,0x23,0x55,0x3C,0x06,0x03,0x75,0x33,0x05,0x68,0x6E,
           0x01,0x0A,0x23,0x26,0x3C,0x04,0x23,0x00,0x68,0x6A,0x09,0x1D,0x33,0x50,0x3B,0x55,
           0x19,0x20,0x3C,0x07,0x23,0x55,0x3C,0x06,0x03,0x75,0x33,0x05,0x68,0x6F,0x01,0x19,
           0x23,0x27,0x3C,0x04,0x23,0x55,0x3C,0x68,0xA0,0x68,0x20,0x68,0x3B,0x54,0x19,0x2C,
           0x3C,0x07,0x23,0x54,0x3C,0x06,0x03,0x75,0x23,0x28,0x3C,0x04,0x80,0x68,0x20,0x68,
           0x3B,0x55,0x19,0x36,0x3C,0x07,0x23,0x55,0x3C,0x06,0x03,0x75,0x23,0x29,0x3C,0x04,
           0xC0,0x68,0x19,0x3B,0x03,0x75,0x23,0x30,0x3C,0x04,0xC4,0x68,0x11,0x40,0x03,0x75,
           0x23,0x31,0x3C,0x04,0x23,0x55,0x3C,0x68,0x68,0x6A,0xE4,0x68,0x20,0x68,0x3B,0x57,
           0x19,0x4D,0x3C,0x07,0x23,0x57,0x3C,0x06,0x03,0x75,0x23,0x32,0x3C,0x04,0x68,0x6B,
           0xE4,0x68,0x20,0x68,0x3B,0x55,0x19,0x58,0x3C,0x07,0x23,0x55,0x3C,0x06,0x03,0x75,
           0x23,0x33,0x3C,0x04,0x23,0x5A,0x68,0x73,0x3B,0xA5,0x19,0x62,0x3C,0x07,0x23,0xA5,
           0x3C,0x06,0x03,0x75,0x23,0x34,0x3C,0x04,0x23,0x07,0x3C,0x49,0x23,0xFF,0x3C,0x48,
           0x48,0x48,0x4A,0x4A,0x20,0x4A,0x38,0x48,0x19,0x71,0x3C,0x07,0x20,0x48,0x3C,0x06,
           0x03,0x75,0x23,0x35,0x3C,0x04,0x20,0x4B,0x2F,0x07,0x38,0x49,0x19,0x7B,0x3C,0x07,
           0x20,0x49,0x3C,0x06,0x03,0x75,0x23,0x36,0x3C,0x04,0x23,0x02,0x3C,0x49,0x23,0x55,
           0x3C,0x48,0x48,0x48,0x4A,0x4A,0x20,0x4A,0x38,0x48,0x19,0x8A,0x3C,0x07,0x20,0x48,
           0x3C,0x06,0x03,0x75,0x23,0x37,0x3C,0x04,0x20,0x4B,0x2F,0x07,0x38,0x49,0x19,0x94,
           0x3C,0x07,0x20,0x49,0x3C,0x06,0x03,0x75,0x23,0x38,0x3C,0x04,0x23,0x05,0x3C,0x49,
           0x23,0xAA,0x3C,0x48,0x48,0x48,0x4A,0x4A,0x20,0x4A,0x38,0x48,0x19,0xA3,0x3C,0x07,
           0x20,0x48,0x3C,0x06,0x03,0x75,0x23,0x39,0x3C,0x04,0x20,0x4B,0x2F,0x07,0x38,0x49,
           0x19,0xAD,0x3C,0x07,0x20,0x49,0x3C,0x06,0x03,0x75,0x23,0x40,0x3C,0x04,0x23,0x00,
           0x3C,0x49,0x3C,0x48,0x48,0x48,0x4A,0x4A,0x20,0x4A,0x38,0x48,0x19,0xBB,0x3C,0x07,
           0x20,0x48,0x3C,0x06,0x03,0x75,0x23,0x41,0x3C,0x04,0x20,0x4B,0x2F,0x07,0x38,0x49,
           0x19,0xC5,0x3C,0x07,0x20,0x49,0x3C,0x06,0x03,0x75,0x23,0x2A,0x3C,0x04,0x23,0x55,
           0x68,0x72,0x4A,0x4A,0x20,0x4A,0x3B,0x55,0x19,0xD1,0x3C,0x07,0x23,0x55,0x3C,0x06,
           0x03,0x75,0x23,0x43,0x3C,0x04,0x20,0x4B,0x2F,0x07,0x3B,0x00,0x19,0xDB,0x3C,0x07,
           0x23,0x00,0x3C,0x06,0x03,0x75,0x23,0x44,0x3C,0x04,0x23,0x00,0x59,0xE1,0x68,0x6D,
           0x03,0x75,0x23,0x45,0x3C,0x04,0x23,0x00,0x3C,0x4F,0x23,0x55,0x3C,0x4E,0x23,0xAA,
           0x3C,0x4D,0x23,0xFF,0x3C,0x4C,0x40,0x4C,0x42,0x50,0x0A,0x5B,0x23,0x46,0x3C,0x04,
           0x23,0x55,0x3C,0x4F,0x23,0xAA,0x3C,0x4E,0x23,0xFF,0x3C,0x4D,0x23,0x00,0x3C,0x4C,
           0x40,0x4C,0x42,0x50,0x0A,0x5B,0x23,0x47,0x3C,0x04,0x23,0xAA,0x3C,0x4F,0x23,0xFF,
           0x3C,0x4E,0x23,0x00,0x3C,0x4D,0x23,0x55,0x3C,0x4C,0x40,0x4C,0x42,0x50,0x0A,0x5B,
           0x23,0x48,0x3C,0x04,0x23,0xFF,0x3C,0x4F,0x23,0x00,0x3C,0x4E,0x23,0x55,0x3C,0x4D,
           0x23,0xAA,0x3C,0x4C,0x40,0x4C,0x42,0x50,0x0A,0x5B,0x23,0x49,0x3C,0x04,0x68,0x60,
           0x42,0x50,0x20,0x4C,0x68,0x68,0x3C,0x4C,0x0A,0x5B,0x23,0x50,0x3C,0x04,0x68,0x61,
           0x42,0x50,0x20,0x4C,0x68,0x69,0x3C,0x4C,0x0A,0x5B,0x23,0x51,0x3C,0x04,0x23,0x10,
           0x68,0x62,0x42,0x50,0x20,0x4C,0x68,0x6B,0x27,0x10,0x3C,0x4C,0x0A,0x5B,0x23,0x52,
           0x3C,0x04,0x23,0x10,0x68,0x74,0x42,0x50,0x20,0x4D,0x68,0x6B,0x27,0x10,0x3C,0x4D,
           0x0A,0x5B,0x23,0x53,0x3C,0x04,0x23,0x10,0x68,0x63,0x42,0x50,0x20,0x4C,0x68,0x6B,
           0x2B,0x10,0x3C,0x4C,0x0A,0x5B,0x23,0x54,0x3C,0x04,0x23,0x55,0x3C,0x4D,0x23,0xAA,
           0x3C,0x4C,0x44,0x4C,0x42,0x50,0x23,0x00,0x3C,0x4E,0x3C,0x4F,0x0A,0x5B,0x23,0x55,
           0x3C,0x04,0x23,0xFF,0x3C,0x4E,0x3C,0x4F,0x3C,0x50,0x3C,0x51,0x3C,0x52,0x3C,0x53,
           0x46,0x50,0x0A,0x5B,0x02,0x7F,0x20,0x53,0x38,0x4F,0x1A,0x64,0x3C,0x07,0x20,0x4F,
           0x3C,0x06,0x23,0x04,0x3C,0x05,0x03,0x75,0x20,0x52,0x38,0x4E,0x1A,0x6D,0x3C,0x07,
           0x20,0x4E,0x3C,0x06,0x23,0x03,0x3C,0x05,0x03,0x75,0x20,0x51,0x38,0x4D,0x1A,0x76,
           0x3C,0x07,0x20,0x4D,0x3C,0x06,0x23,0x02,0x3C,0x05,0x03,0x75,0x20,0x50,0x38,0x4C,
           0x68,0x6F,0x3C,0x07,0x20,0x4C,0x3C,0x06,0x23,0x01,0x3C,0x05,0x03,0x75,0x23,0x56,
           0x3C,0x04,0x23,0x55,0x3C,0x68,0x50,0x68,0x23,0x00,0x68,0x66,0x3B,0x55,0x1A,0x8C,
           0x3C,0x07,0x23,0x55,0x3C,0x06,0x03,0x75,0x23,0x57,0x3C,0x04,0x23,0xAA,0x68,0x67,
           0x20,0x68,0x3B,0xAA,0x1A,0x97,0x3C,0x07,0x23,0xAA,0x3C,0x06,0x03,0x75,0x23,0x58,
           0x3C,0x04,0x23,0x11,0x3C,0x4F,0x23,0x22,0x3C,0x4E,0x23,0x33,0x3C,0x4D,0x23,0x44,
           0x3C,0x4C,0x40,0x4C,0x52,0x4C,0x23,0x59,0x3C,0x04,0x1A,0xA7,0x03,0x75,0x23,0x60,
           0x3C,0x04,0x68,0x61,0x52,0x4C,0x23,0x61,0x3C,0x04,0xDA,0xF1,0x12,0xB0,0x03,0x75,
           0x23,0x62,0x3C,0x04,0x68,0x60,0x68,0x60,0x52,0x4C,0x23,0x63,0x3C,0x04,0x12,0xB9,
           0x03,0x75,0x23,0x64,0x3C,0x04,0x68,0x70,0x23,0x08,0x68,0x62,0x68,0x71,0x12,0xC1,
           0x02,0xC2,0x23,0xAA,0x3B,0xAA,0x1A,0xC8,0x3C,0x07,0x23,0xAA,0x3C,0x06,0x03,0x75,
           0x23,0x65,0x3C,0x04,0x3F,0x20,0x68,0x71,0x1A,0xCE,0x03,0x75,0x23,0x66,0x3C,0x04,
           0x0B,0x0B,0x40,0x08,0x23,0x08,0x56,0x54,0x82,0xF3,0xC2,0xF3,0x1A,0xD8,0x03,0x75,
           0x23,0x67,0x3C,0x04,0x3F,0x80,0xC2,0xF3,0x12,0xDE,0x03,0x75,0x23,0x68,0x3C,0x04,
           0x40,0x08,0x23,0x08,0x54,0x5C,0x86,0xF3,0xC6,0xF3,0x1A,0xE7,0x03,0x75,0x23,0x69,
           0x3C,0x04,0x3F,0x80,0xC6,0xF3,0x12,0xED,0x03,0x75,0x23,0x70,0x3C,0x04,0x0B,0x25,
           0x23,0x71,0x3C,0x04,0x0B,0x0B,0x50,0x54,0x46,0x64,0x50,0x5C,0x46,0x66,0x40,0x08,
           0x23,0x08,0x4E,0x64,0xC2,0xF1,0x12,0xFD,0x03,0x75,0x23,0x72,0x3C,0x04,0x3F,0x80,
           0xC2,0xF1,0x1B,0x03,0x03,0x75,0x23,0x73,0x3C,0x04,0x40,0x08,0x23,0x08,0x4C,0x66,
           0x3F,0x80,0x0B,0x25,0x03,0x6D,0x23,0x11,0x3C,0x54,0x23,0x22,0x3C,0x55,0x23,0x33,
           0x3C,0x56,0x23,0x44,0x3C,0x57,0x23,0x55,0x3C,0x58,0x23,0x66,0x3C,0x59,0x23,0x77,
           0x3C,0x5A,0x23,0x88,0x3C,0x5B,0x23,0x00,0x3C,0x5C,0x3C,0x5D,0x3C,0x5E,0x3C,0x5F,
           0x3C,0x60,0x3C,0x61,0x3C,0x62,0x3C,0x63,0x68,0x6D,0x20,0x5C,0x38,0x54,0x1B,0x2E,
           0x3C,0x07,0x20,0x54,0x3C,0x06,0x23,0x01,0x3C,0x05,0x03,0x75,0x20,0x5D,0x38,0x55,
           0x1B,0x37,0x3C,0x07,0x20,0x55,0x3C,0x06,0x23,0x01,0x3C,0x05,0x03,0x75,0x20,0x5E,
           0x38,0x56,0x1B,0x40,0x3C,0x07,0x20,0x56,0x3C,0x06,0x23,0x01,0x3C,0x05,0x03,0x75,
           0x20,0x5F,0x38,0x57,0x1B,0x49,0x3C,0x07,0x20,0x57,0x3C,0x06,0x23,0x01,0x3C,0x05,
           0x03,0x75,0x20,0x60,0x38,0x58,0x1B,0x52,0x3C,0x07,0x20,0x58,0x3C,0x06,0x23,0x01,
           0x3C,0x05,0x03,0x75,0x20,0x61,0x38,0x59,0x1B,0x5B,0x3C,0x07,0x20,0x59,0x3C,0x06,
           0x23,0x01,0x3C,0x05,0x03,0x75,0x20,0x62,0x38,0x5A,0x1B,0x64,0x3C,0x07,0x20,0x5A,
           0x3C,0x06,0x23,0x01,0x3C,0x05,0x03,0x75,0x20,0x63,0x38,0x5B,0x68,0x6F,0x3C,0x07,
           0x20,0x5B,0x3C,0x06,0x23,0x01,0x3C,0x05,0x03,0x75,0x23,0x00,0x3C,0x04,0x3C,0x07,
           0x3C,0x06,0x3C,0x05,0x82,0xF2,0x58,0x08,0x68,0x6D,0x82,0xF4,0x03,0x76,0x00,0x00};

static unsigned char toregdiag[1728] = 
          {0x23,0x01,0x3C,0x04,0xD2,0xFC,0x10,0x08,0xC1,0xFE,0x10,0x08,0x8E,0xFC,0x81,0xFF,
           0x20,0x00,0x3B,0x00,0x18,0x08,0x3B,0x01,0x10,0x11,0x08,0x14,0x23,0x00,0x3C,0x00,
           0x00,0x08,0x20,0x00,0x3C,0x07,0x03,0x5E,0x23,0x02,0x3C,0x04,0x23,0xAA,0xC2,0xF0,
           0x10,0x1C,0x23,0x01,0x3C,0x05,0x03,0x5E,0xC6,0xF0,0x18,0x25,0x23,0x02,0x3C,0x05,
           0x23,0x01,0x3C,0x06,0x23,0x00,0x3C,0x07,0x03,0x5E,0xCA,0xF0,0x10,0x2E,0x23,0x03,
           0x3C,0x05,0x23,0x00,0x3C,0x06,0x23,0x01,0x3C,0x07,0x03,0x5E,0xCE,0xF0,0x18,0x37,
           0x23,0x04,0x3C,0x05,0x23,0x01,0x3C,0x06,0x23,0x00,0x3C,0x07,0x03,0x5E,0xD2,0xF0,
           0x10,0x40,0x23,0x05,0x3C,0x05,0x23,0x00,0x3C,0x06,0x23,0x01,0x3C,0x07,0x03,0x5E,
           0xD6,0xF0,0x18,0x49,0x23,0x06,0x3C,0x05,0x23,0x01,0x3C,0x06,0x23,0x00,0x3C,0x07,
           0x03,0x5E,0xDA,0xF0,0x10,0x52,0x23,0x07,0x3C,0x05,0x23,0x00,0x3C,0x06,0x23,0x01,
           0x3C,0x07,0x03,0x5E,0xDE,0xF0,0x18,0x5B,0x23,0x08,0x3C,0x05,0x23,0x01,0x3C,0x06,
           0x23,0x00,0x3C,0x07,0x03,0x5E,0x23,0x03,0x3C,0x04,0x23,0x55,0xC2,0xF0,0x18,0x67,
           0x23,0x01,0x3C,0x05,0x23,0x01,0x3C,0x06,0x23,0x00,0x3C,0x07,0x03,0x5E,0xC6,0xF0,
           0x10,0x70,0x23,0x02,0x3C,0x05,0x23,0x00,0x3C,0x06,0x23,0x01,0x3C,0x07,0x03,0x5E,
           0xCA,0xF0,0x18,0x79,0x23,0x03,0x3C,0x05,0x23,0x01,0x3C,0x06,0x23,0x00,0x3C,0x07,
           0x03,0x5E,0xCE,0xF0,0x10,0x82,0x23,0x04,0x3C,0x05,0x23,0x00,0x3C,0x06,0x23,0x01,
           0x3C,0x07,0x03,0x5E,0xD2,0xF0,0x18,0x8B,0x23,0x05,0x3C,0x05,0x23,0x01,0x3C,0x06,
           0x23,0x00,0x3C,0x07,0x03,0x5E,0xD6,0xF0,0x10,0x94,0x23,0x06,0x3C,0x05,0x23,0x00,
           0x3C,0x06,0x23,0x01,0x3C,0x07,0x03,0x5E,0xDA,0xF0,0x18,0x9D,0x23,0x07,0x3C,0x05,
           0x23,0x01,0x3C,0x06,0x23,0x00,0x3C,0x07,0x03,0x5E,0xDE,0xF0,0x10,0xA6,0x23,0x08,
           0x3C,0x05,0x23,0x00,0x3C,0x06,0x23,0x01,0x3C,0x07,0x03,0x5E,0x23,0x04,0x3C,0x04,
           0x23,0x05,0x3B,0x04,0xDA,0xF1,0x18,0xAD,0x03,0x5E,0x23,0x05,0x3C,0x04,0x23,0x05,
           0x3B,0x05,0xDA,0xF1,0x10,0xB4,0x03,0x5E,0x23,0x06,0x3C,0x04,0x23,0x05,0x3B,0x06,
           0xDA,0xF1,0x10,0xBB,0x03,0x5E,0x23,0x07,0x3C,0x04,0x23,0x04,0x3C,0x4C,0x23,0x05,
           0x38,0x4C,0xDA,0xF1,0x18,0xC4,0x03,0x5E,0x23,0x08,0x3C,0x04,0x23,0x05,0x3C,0x4C,
           0x38,0x4C,0xDA,0xF1,0x10,0xCC,0x03,0x5E,0x23,0x09,0x3C,0x04,0x23,0x06,0x3C,0x4C,
           0x23,0x05,0x38,0x4C,0xDA,0xF1,0x10,0xD5,0x03,0x5E,0x23,0x10,0x3C,0x04,0x23,0x00,
           0x3E,0x7C,0x22,0x7C,0x3B,0x00,0x18,0xE4,0x3C,0x4C,0x23,0x00,0x3E,0x7C,0x20,0x4C,
           0x3C,0x07,0x23,0x00,0x3C,0x06,0x03,0x5E,0x23,0x11,0x3C,0x04,0x23,0x01,0x3E,0x7C,
           0x22,0x7C,0x3B,0x01,0x18,0xF3,0x3C,0x4C,0x23,0x00,0x3E,0x7C,0x20,0x4C,0x3C,0x07,
           0x23,0x01,0x3C,0x06,0x03,0x5E,0x23,0x12,0x3C,0x04,0x23,0x02,0x3E,0x7C,0x22,0x7C,
           0x3B,0x02,0x19,0x02,0x3C,0x4C,0x23,0x00,0x3E,0x7C,0x20,0x4C,0x3C,0x07,0x23,0x02,
           0x3C,0x06,0x03,0x5E,0x23,0x13,0x3C,0x04,0x23,0x03,0x3E,0x7C,0x22,0x7C,0x3B,0x03,
           0x19,0x11,0x3C,0x4C,0x23,0x00,0x3E,0x7C,0x20,0x4C,0x3C,0x07,0x23,0x03,0x3C,0x06,
           0x03,0x5E,0x23,0x00,0x3E,0x7C,0x23,0x14,0x3C,0x04,0x22,0x7F,0x3C,0x4C,0x23,0x00,
           0x3E,0x7F,0x20,0x08,0x3B,0x00,0x11,0x23,0x22,0x7F,0x3B,0x00,0x19,0x2A,0x3C,0x07,
           0x23,0x00,0x3C,0x06,0x03,0x5E,0x22,0x7F,0x3B,0x04,0x19,0x2A,0x3C,0x07,0x23,0x00,
           0x3C,0x06,0x03,0x5E,0x23,0x15,0x3C,0x04,0x23,0x51,0x3E,0x7F,0x20,0x08,0x3B,0x00,
           0x11,0x38,0x22,0x7F,0x3B,0x51,0x19,0x3F,0x3C,0x07,0x23,0x51,0x3C,0x06,0x03,0x5E,
           0x22,0x7F,0x3B,0x55,0x19,0x3F,0x3C,0x07,0x23,0x55,0x3C,0x06,0x03,0x5E,0x23,0x16,
           0x3C,0x04,0x23,0xAA,0x3E,0x7F,0x20,0x08,0x3B,0x00,0x11,0x4D,0x22,0x7F,0x3B,0xAA,
           0x19,0x54,0x3C,0x07,0x23,0xAA,0x3C,0x06,0x03,0x5E,0x22,0x7F,0x3B,0xAE,0x19,0x54,
           0x3C,0x07,0x23,0xAE,0x3C,0x06,0x03,0x5E,0x23,0x17,0x3C,0x04,0x23,0xFB,0x3E,0x7F,
           0x20,0x08,0x3B,0x00,0x11,0x62,0x22,0x7F,0x3B,0xFB,0x19,0x69,0x3C,0x07,0x23,0xFB,
           0x3C,0x06,0x03,0x5E,0x22,0x7F,0x3B,0xFF,0x19,0x69,0x3C,0x07,0x23,0xFF,0x3C,0x06,
           0x03,0x5E,0x20,0x4C,0x3E,0x7F,0x23,0x18,0x3C,0x04,0x23,0xFF,0x3E,0xF5,0x22,0xF5,
           0x3B,0xFF,0x19,0x76,0x3C,0x07,0x23,0xFF,0x3C,0x06,0x03,0x5E,0x23,0x19,0x3C,0x04,
           0x23,0x00,0x3E,0xF5,0x22,0xF5,0x3B,0x10,0xDA,0xF1,0x11,0x82,0x3C,0x07,0x23,0xFF,
           0x3C,0x06,0x03,0x5E,0x23,0x20,0x3C,0x04,0x23,0x00,0x3C,0x4D,0x23,0x20,0x3E,0x01,
           0x23,0x14,0x3E,0x03,0x22,0xF5,0x3B,0x01,0xDA,0xF1,0x19,0x97,0x20,0x4D,0x68,0x68,
           0x3C,0x4D,0x3B,0x20,0xDA,0xF1,0x11,0x8A,0x22,0xF5,0x3C,0x05,0x03,0x5E,0x23,0x21,
           0x3C,0x04,0x23,0x00,0x3E,0x01,0x22,0x01,0x3B,0x00,0x19,0xA2,0x3C,0x07,0x23,0x00,
           0x3C,0x06,0x03,0x5E,0x23,0x22,0x3C,0x04,0x23,0x15,0x3E,0x01,0x22,0x01,0x3B,0x15,
           0x19,0xAD,0x3C,0x07,0x23,0x15,0x3C,0x06,0x03,0x5E,0x23,0x23,0x3C,0x04,0x23,0x0A,
           0x3E,0x01,0x22,0x01,0x3B,0x0A,0x19,0xB8,0x3C,0x07,0x23,0x0A,0x3C,0x06,0x03,0x5E,
           0x23,0x24,0x3C,0x04,0x23,0x1F,0x3E,0x01,0x22,0x01,0x3B,0x1F,0x19,0xC3,0x3C,0x07,
           0x23,0x1F,0x3C,0x06,0x03,0x5E,0x23,0x00,0x3E,0x01,0x23,0x25,0x3C,0x04,0x23,0x00,
           0x3E,0x02,0x22,0x02,0x3B,0x00,0x19,0xD0,0x3C,0x07,0x23,0x00,0x3C,0x06,0x03,0x5E,
           0x23,0x26,0x23,0x55,0x3E,0x02,0x22,0x02,0x3B,0x55,0x19,0xDA,0x3C,0x07,0x23,0x55,
           0x3C,0x06,0x03,0x5E,0x23,0x27,0x3C,0x04,0x23,0xAA,0x3E,0x02,0x22,0x02,0x3B,0xAA,
           0x19,0xE5,0x3C,0x07,0x23,0xAA,0x3C,0x06,0x03,0x5E,0x23,0x28,0x3C,0x04,0x23,0xFF,
           0x3E,0x02,0x22,0x02,0x3B,0xFF,0x19,0xF0,0x3C,0x07,0x23,0xFF,0x3C,0x06,0x03,0x5E,
           0x23,0x00,0x3E,0x02,0x23,0x29,0x3C,0x04,0x23,0x00,0x3E,0x03,0x22,0x03,0x3B,0x00,
           0x19,0xFD,0x3C,0x07,0x23,0x00,0x3C,0x06,0x03,0x5E,0x23,0x30,0x3C,0x04,0x23,0x15,
           0x3E,0x03,0x22,0x03,0x3B,0x15,0x1A,0x08,0x3C,0x07,0x23,0x15,0x3C,0x06,0x03,0x5E,
           0x23,0x31,0x3C,0x04,0x23,0x0A,0x3E,0x03,0x22,0x03,0x3B,0x0A,0x1A,0x13,0x3C,0x07,
           0x23,0x0A,0x3C,0x06,0x03,0x5E,0x23,0x32,0x3C,0x04,0x23,0x1F,0x3E,0x03,0x22,0x03,
           0x3B,0x1F,0x1A,0x1E,0x3C,0x07,0x23,0x1F,0x3C,0x06,0x03,0x5E,0x23,0x00,0x3E,0x03,
           0x23,0x33,0x3C,0x04,0x23,0xFF,0x3E,0x7D,0x22,0x7D,0x3B,0xFF,0x1A,0x2B,0x3C,0x07,
           0x23,0xFF,0x3C,0x06,0x03,0x5E,0x23,0x34,0x3C,0x04,0x23,0xAA,0x3E,0x7D,0x22,0x7D,
           0x3B,0xAA,0x1A,0x36,0x3C,0x07,0x23,0xAA,0x3C,0x06,0x03,0x5E,0x23,0x35,0x3C,0x04,
           0x23,0x55,0x3E,0x7D,0x22,0x7D,0x3B,0x55,0x1A,0x41,0x3C,0x07,0x23,0x55,0x3C,0x06,
           0x03,0x5E,0x23,0x36,0x3C,0x04,0x23,0x00,0x3E,0x7D,0x22,0x7D,0x3B,0x00,0x1A,0x4C,
           0x3C,0x07,0x23,0x00,0x3C,0x06,0x03,0x5E,0x23,0x37,0x3C,0x04,0x23,0xAA,0x3E,0x7D,
           0xC2,0x7D,0x12,0x55,0x23,0x01,0x3C,0x05,0x03,0x5E,0xC6,0x7D,0x1A,0x5E,0x23,0x02,
           0x3C,0x05,0x23,0x01,0x3C,0x06,0x23,0x00,0x3C,0x07,0x03,0x5E,0xCA,0x7D,0x12,0x67,
           0x23,0x03,0x3C,0x05,0x23,0x00,0x3C,0x06,0x23,0x01,0x3C,0x07,0x03,0x5E,0xCE,0x7D,
           0x1A,0x70,0x23,0x04,0x3C,0x05,0x23,0x01,0x3C,0x06,0x23,0x00,0x3C,0x07,0x03,0x5E,
           0xD2,0x7D,0x12,0x79,0x23,0x05,0x3C,0x05,0x23,0x00,0x3C,0x06,0x23,0x01,0x3C,0x07,
           0x03,0x5E,0xD6,0x7D,0x1A,0x82,0x23,0x06,0x3C,0x05,0x23,0x01,0x3C,0x06,0x23,0x00,
           0x3C,0x07,0x03,0x5E,0xDA,0x7D,0x12,0x8B,0x23,0x07,0x3C,0x05,0x23,0x00,0x3C,0x06,
           0x23,0x01,0x3C,0x07,0x03,0x5E,0xDE,0x7D,0x1A,0x94,0x23,0x08,0x3C,0x05,0x23,0x01,
           0x3C,0x06,0x23,0x00,0x3C,0x07,0x03,0x5E,0x23,0x38,0x3C,0x04,0x23,0x55,0x3E,0x7D,
           0xC2,0x7D,0x1A,0xA1,0x23,0x01,0x3C,0x05,0x23,0x01,0x3C,0x06,0x23,0x00,0x3C,0x07,
           0x03,0x5E,0xC6,0x7D,0x12,0xAA,0x23,0x02,0x3C,0x05,0x23,0x00,0x3C,0x06,0x23,0x01,
           0x3C,0x07,0x03,0x5E,0xCA,0x7D,0x1A,0xB3,0x23,0x03,0x3C,0x05,0x23,0x01,0x3C,0x06,
           0x23,0x00,0x3C,0x07,0x03,0x5E,0xCE,0x7D,0x12,0xBC,0x23,0x04,0x3C,0x05,0x23,0x00,
           0x3C,0x06,0x23,0x01,0x3C,0x07,0x03,0x5E,0xD2,0x7D,0x1A,0xC5,0x23,0x05,0x3C,0x05,
           0x23,0x01,0x3C,0x06,0x23,0x00,0x3C,0x07,0x03,0x5E,0xD6,0x7D,0x12,0xCE,0x23,0x06,
           0x3C,0x05,0x23,0x00,0x3C,0x06,0x23,0x01,0x3C,0x07,0x03,0x5E,0xDA,0x7D,0x1A,0xD7,
           0x23,0x07,0x3C,0x05,0x23,0x01,0x3C,0x06,0x23,0x00,0x3C,0x07,0x03,0x5E,0xDE,0x7D,
           0x12,0xE0,0x23,0x08,0x3C,0x05,0x23,0x00,0x3C,0x06,0x23,0x01,0x3C,0x07,0x03,0x5E,
           0x23,0x39,0x3C,0x04,0x23,0xAA,0xCA,0xF1,0x1A,0xEA,0x23,0x01,0x3C,0x06,0x23,0x00,
           0x3C,0x07,0x03,0x5E,0x23,0xAB,0xCA,0xF1,0x12,0xF2,0x23,0x00,0x3C,0x06,0x23,0x01,
           0x3C,0x07,0x03,0x5E,0x23,0x40,0x3C,0x04,0x23,0xAA,0x9A,0xF1,0xCE,0xF1,0x1A,0xFD,
           0x23,0x01,0x3C,0x06,0x23,0x00,0x3C,0x07,0x03,0x5E,0xCE,0xF1,0x13,0x04,0x23,0x00,
           0x3C,0x06,0x23,0x01,0x3C,0x07,0x03,0x5E,0x23,0x41,0x3C,0x04,0x23,0x00,0x3C,0x48,
           0x3C,0x49,0x3C,0x4A,0x3C,0x4B,0x40,0x48,0xDE,0xF1,0x1B,0x13,0x23,0x01,0x3C,0x06,
           0x23,0x00,0x3C,0x07,0x03,0x5E,0x23,0x42,0x3C,0x04,0x23,0x11,0x3C,0x4B,0x23,0x22,
           0x3C,0x4A,0x23,0x33,0x3C,0x49,0x23,0x44,0x3C,0x48,0x40,0x48,0xDE,0xF1,0x13,0x25,
           0x23,0x00,0x3C,0x06,0x23,0x01,0x3C,0x07,0x03,0x5E,0x23,0x43,0x3C,0x04,0x22,0x73,
           0x3B,0x11,0x1B,0x2E,0x3C,0x07,0x23,0x11,0x3C,0x06,0x03,0x5E,0x23,0x44,0x3C,0x04,
           0x22,0x72,0x3B,0x22,0x1B,0x37,0x3C,0x07,0x23,0x22,0x3C,0x06,0x03,0x5E,0x23,0x45,
           0x3C,0x04,0x22,0x71,0x3B,0x33,0x1B,0x40,0x3C,0x07,0x23,0x33,0x3C,0x06,0x03,0x5E,
           0x23,0x46,0x3C,0x04,0x22,0x70,0x3B,0x44,0x1B,0x49,0x3C,0x07,0x23,0x44,0x3C,0x06,
           0x03,0x5E,0x23,0x47,0x3C,0x04,0x8A,0x0A,0xCA,0x0A,0x1B,0x4F,0x03,0x5E,0x23,0x48,
           0x3C,0x04,0xAA,0x0A,0xCA,0x0A,0x13,0x55,0x03,0x5E,0x23,0x00,0x3E,0x7C,0x3C,0x04,
           0x3C,0x07,0x3C,0x06,0x3C,0x05,0x82,0xF2,0x58,0x0E,0x68,0x6D,0x82,0xF4,0x03,0x5F};

static unsigned char toreg2diag[672] = 
          {0x23,0x01,0x3C,0x04,0x20,0x00,0x3B,0x00,0x18,0x02,0x3B,0x01,0x10,0x0B,0x08,0x0E,
           0x23,0x00,0x3C,0x00,0x00,0x02,0x20,0x00,0x3C,0x07,0x01,0x4E,0x23,0x02,0x3C,0x04,
           0x23,0x10,0x3E,0xB7,0x3E,0xB5,0x23,0x20,0x3E,0xB6,0x3E,0xB4,0xB6,0xF1,0x3F,0x00,
           0x22,0x78,0x3B,0xFF,0x18,0x1F,0x3C,0x07,0x23,0xFF,0x3C,0x06,0x01,0x4E,0x23,0x03,
           0x3C,0x04,0x22,0x79,0x3B,0xFF,0x18,0x28,0x3C,0x07,0x23,0xFF,0x3C,0x06,0x01,0x4E,
           0x23,0x04,0x3C,0x04,0x96,0xF1,0x3F,0x00,0x22,0x78,0x3B,0x00,0x18,0x33,0x3C,0x07,
           0x23,0x00,0x3C,0x06,0x01,0x4E,0x23,0x05,0x3C,0x04,0x22,0x79,0x3B,0x00,0x18,0x3C,
           0x3C,0x07,0x23,0x00,0x3C,0x06,0x01,0x4E,0x23,0x06,0x3C,0x04,0x23,0x11,0x3E,0xB1,
           0x23,0x22,0x3E,0xB1,0x23,0x33,0x3E,0xB1,0x23,0x44,0x3E,0xB1,0x23,0x55,0x3E,0xB1,
           0x23,0x66,0x3E,0xB1,0x23,0x77,0x3E,0xB1,0x23,0x88,0x3E,0xB1,0x3F,0x00,0x22,0x78,
           0x3B,0x4A,0x18,0x56,0x3C,0x07,0x23,0x4A,0x3C,0x06,0x01,0x4E,0x23,0x07,0x3C,0x04,
           0x22,0x79,0x3B,0xF7,0x18,0x5F,0x3C,0x07,0x23,0xF7,0x3C,0x06,0x01,0x4E,0x23,0x08,
           0x3C,0x04,0xB2,0xF1,0x3F,0x00,0x22,0x74,0x3B,0xFF,0x18,0x6A,0x3C,0x07,0x23,0xFF,
           0x3C,0x06,0x01,0x4E,0x23,0x09,0x3C,0x04,0x22,0x75,0x3B,0xFF,0x18,0x73,0x3C,0x07,
           0x23,0xFF,0x3C,0x06,0x01,0x4E,0x23,0x10,0x3C,0x04,0x92,0xF1,0x3F,0x00,0x22,0x74,
           0x3B,0x00,0x18,0x7E,0x3C,0x07,0x23,0x00,0x3C,0x06,0x01,0x4E,0x23,0x11,0x3C,0x04,
           0x22,0x75,0x3B,0x00,0x18,0x87,0x3C,0x07,0x23,0x00,0x3C,0x06,0x01,0x4E,0x23,0x12,
           0x3C,0x04,0x23,0x11,0x3E,0xB0,0x23,0x22,0x3E,0xB0,0x23,0x33,0x3E,0xB0,0x23,0x44,
           0x3E,0xB0,0x23,0x55,0x3E,0xB0,0x23,0x66,0x3E,0xB0,0x23,0x77,0x3E,0xB0,0x23,0x88,
           0x3E,0xB0,0x3F,0x00,0x22,0x74,0x3B,0x4A,0x18,0xA1,0x3C,0x07,0x23,0x4A,0x3C,0x06,
           0x01,0x4E,0x23,0x13,0x3C,0x04,0x22,0x75,0x3B,0xF7,0x18,0xAA,0x3C,0x07,0x23,0xF7,
           0x3C,0x06,0x01,0x4E,0x23,0x14,0x3C,0x04,0x23,0x80,0x3E,0xB7,0x3E,0xB5,0x23,0x04,
           0x3E,0xB6,0x3E,0xB4,0xB6,0xF1,0x3F,0x00,0x22,0x78,0x3B,0xFF,0x18,0xBB,0x3C,0x07,
           0x23,0xFF,0x3C,0x06,0x01,0x4E,0x23,0x15,0x3C,0x04,0x22,0x79,0x3B,0xFF,0x18,0xC4,
           0x3C,0x07,0x23,0xFF,0x3C,0x06,0x01,0x4E,0x23,0x16,0x3C,0x04,0x96,0xF1,0x3F,0x00,
           0x22,0x78,0x3B,0x00,0x18,0xCF,0x3C,0x07,0x23,0x00,0x3C,0x06,0x01,0x4E,0x23,0x17,
           0x3C,0x04,0x22,0x79,0x3B,0x00,0x18,0xD8,0x3C,0x07,0x23,0x00,0x3C,0x06,0x01,0x4E,
           0x23,0x18,0x3C,0x04,0x23,0x11,0x3E,0xB1,0x23,0x22,0x3E,0xB1,0x23,0x33,0x3E,0xB1,
           0x23,0x44,0x3E,0xB1,0x23,0x55,0x3E,0xB1,0x23,0x66,0x3E,0xB1,0x23,0x77,0x3E,0xB1,
           0x23,0x88,0x3E,0xB1,0x3F,0x00,0x22,0x78,0x3B,0x5E,0x18,0xF2,0x3C,0x07,0x23,0x5E,
           0x3C,0x06,0x01,0x4E,0x23,0x19,0x3C,0x04,0x22,0x79,0x3B,0xBF,0x18,0xFB,0x3C,0x07,
           0x23,0xBF,0x3C,0x06,0x01,0x4E,0x23,0x20,0x3C,0x04,0xB2,0xF1,0x3F,0x00,0x22,0x74,
           0x3B,0xFF,0x19,0x06,0x3C,0x07,0x23,0xFF,0x3C,0x06,0x01,0x4E,0x23,0x21,0x3C,0x04,
           0x22,0x75,0x3B,0xFF,0x19,0x0F,0x3C,0x07,0x23,0xFF,0x3C,0x06,0x01,0x4E,0x23,0x22,
           0x3C,0x04,0x92,0xF1,0x3F,0x00,0x22,0x74,0x3B,0x00,0x19,0x1A,0x3C,0x07,0x23,0x00,
           0x3C,0x06,0x01,0x4E,0x23,0x23,0x3C,0x04,0x22,0x75,0x3B,0x00,0x19,0x23,0x3C,0x07,
           0x23,0x00,0x3C,0x06,0x01,0x4E,0x23,0x24,0x3C,0x04,0x23,0x11,0x3E,0xB0,0x23,0x22,
           0x3E,0xB0,0x23,0x33,0x3E,0xB0,0x23,0x44,0x3E,0xB0,0x23,0x55,0x3E,0xB0,0x23,0x66,
           0x3E,0xB0,0x23,0x77,0x3E,0xB0,0x23,0x88,0x3E,0xB0,0x3F,0x00,0x22,0x74,0x3B,0x5E,
           0x19,0x3D,0x3C,0x07,0x23,0x5E,0x3C,0x06,0x01,0x4E,0x23,0x25,0x3C,0x04,0x22,0x75,
           0x3B,0xBF,0x19,0x46,0x3C,0x07,0x23,0xBF,0x3C,0x06,0x01,0x4E,0x23,0x00,0x3C,0x04,
           0x3C,0x07,0x3C,0x06,0x3C,0x05,0x82,0xF2,0x58,0x08,0x68,0x6D,0x82,0xF4,0x01,0x4F};

static unsigned char tostsdiag[1232] = 
          {0x23,0x01,0x3C,0x04,0x23,0x00,0x3E,0x7C,0x23,0x14,0x3E,0x01,0x23,0x80,0x3E,0x02,
           0x23,0x1D,0x3E,0x03,0x23,0x14,0x3E,0x43,0x23,0x7C,0x3E,0x07,0xA2,0x0A,0x23,0x50,
           0x68,0x69,0x3B,0x00,0x10,0x10,0x23,0x02,0x3C,0x04,0x22,0x04,0x3B,0x03,0x18,0x1C,
           0x3C,0x07,0x23,0x03,0x3C,0x06,0x02,0x65,0x23,0x03,0x3C,0x04,0xA2,0x0A,0x23,0x50,
           0x68,0x69,0x3B,0x00,0x10,0x20,0x82,0x0A,0x0A,0x5C,0x68,0x6A,0x23,0x01,0x3E,0x00,
           0x3F,0x10,0x22,0x00,0xCE,0x04,0x18,0x31,0x22,0x04,0x3C,0x07,0x23,0x8B,0x3C,0x06,
           0x02,0x65,0x23,0x04,0x3C,0x04,0xA2,0x0A,0x23,0x30,0x68,0x69,0x3B,0x00,0x10,0x35,
           0x82,0x0A,0x23,0x05,0x3C,0x04,0xAA,0x0A,0xCA,0x0A,0x10,0x41,0x22,0x04,0x3C,0x07,
           0x02,0x65,0x23,0x06,0x3C,0x04,0x0A,0x22,0x23,0x07,0x3C,0x04,0x22,0x04,0x2F,0x07,
           0x3B,0x00,0x18,0x4E,0x3C,0x07,0x23,0x00,0x3C,0x06,0x02,0x65,0x23,0x08,0x3C,0x04,
           0xCA,0x0A,0x10,0x50,0x22,0x04,0x3B,0xC1,0x18,0x59,0x3C,0x07,0x23,0xC3,0x3C,0x06,
           0x02,0x65,0x23,0x09,0x3C,0x04,0x86,0x0A,0xA2,0x0A,0x23,0x10,0x3C,0x04,0x23,0x34,
           0x3E,0x01,0x23,0x80,0x3E,0x02,0x23,0x1D,0x3E,0x03,0x23,0x00,0x3E,0x7C,0x23,0x7C,
           0x3E,0x07,0x23,0x11,0x3C,0x04,0x22,0x04,0x3B,0x01,0x18,0x72,0x3C,0x07,0x23,0x03,
           0x3C,0x06,0x02,0x65,0x23,0x12,0x3C,0x04,0x82,0x0A,0x0A,0x5C,0x68,0x6A,0x20,0x08,
           0x3E,0x00,0x3F,0x10,0x22,0x00,0xCE,0x04,0x18,0x82,0x22,0x04,0x3C,0x07,0x23,0x8B,
           0x3C,0x06,0x02,0x65,0x23,0x14,0x3C,0x04,0xA2,0x0A,0x23,0x30,0x68,0x69,0x3B,0x00,
           0x10,0x86,0x82,0x0A,0x23,0x15,0x3C,0x04,0xAA,0x0A,0xCA,0x0A,0x10,0x92,0x22,0x04,
           0x3C,0x07,0x02,0x65,0x23,0x16,0x3C,0x04,0x0A,0x22,0x68,0x6A,0x23,0x02,0x3E,0x00,
           0x23,0x17,0x3C,0x04,0x22,0x04,0x2F,0x07,0x3B,0x00,0x18,0xA2,0x3C,0x07,0x23,0x00,
           0x3C,0x06,0x02,0x65,0x23,0x18,0x3C,0x04,0xCA,0x0A,0x10,0xA4,0xC6,0x04,0x10,0xA6,
           0x22,0x04,0x3B,0xC3,0x18,0xAF,0x3C,0x07,0x23,0xC3,0x3C,0x06,0x02,0x65,0x23,0x19,
           0x3C,0x04,0x86,0x0A,0xA2,0x0A,0x23,0x20,0x3C,0x04,0x23,0x8C,0x3E,0x01,0x23,0xA0,
           0x3E,0x02,0x23,0x7E,0x3E,0x03,0x23,0x00,0x3E,0x7C,0x23,0x7C,0x3E,0x07,0x23,0x21,
           0x3C,0x04,0x82,0x0A,0x23,0x0A,0x68,0x69,0x3B,0x00,0x10,0xC3,0x23,0x22,0x3C,0x04,
           0xAA,0x0A,0xCA,0x0A,0x10,0xCE,0x22,0x04,0x3C,0x07,0x02,0x65,0x23,0x23,0x3C,0x04,
           0x22,0x04,0x2F,0x03,0x3B,0x03,0x18,0xD8,0x3C,0x07,0x23,0x03,0x3C,0x06,0x02,0x65,
           0x23,0x7E,0x68,0x6A,0x3E,0x00,0x68,0x6B,0x0A,0x19,0x0A,0x19,0x0A,0x19,0x0A,0x19,
           0x23,0x7E,0x68,0x6A,0x3E,0x00,0x23,0x24,0x3C,0x04,0x22,0x04,0x2F,0x03,0x3B,0x00,
           0x18,0xED,0x3C,0x07,0x23,0x00,0x3C,0x06,0x02,0x65,0x23,0x25,0x3C,0x04,0xDA,0x04,
           0x18,0xEF,0xDA,0x04,0x18,0xF1,0x01,0x02,0x23,0x26,0x3C,0x04,0xCA,0x0A,0x10,0xF6,
           0xC6,0x04,0x10,0xF8,0x22,0x04,0x2F,0xBB,0x3B,0x83,0x19,0x02,0x3C,0x07,0x23,0x83,
           0x3C,0x06,0x02,0x65,0x23,0x27,0x3C,0x04,0xA2,0x0A,0x86,0x0A,0x23,0x30,0x68,0x69,
           0x3B,0x00,0x11,0x07,0x82,0x0A,0x23,0x28,0x3C,0x04,0x23,0x7E,0x68,0x6A,0x3E,0x00,
           0x68,0x6B,0x3E,0x00,0x68,0x6A,0x3E,0x00,0x3F,0x10,0x22,0x00,0x3F,0x10,0x22,0x00,
           0xD2,0x04,0x12,0x65,0x23,0x29,0x3C,0x04,0x23,0xFF,0x68,0x6A,0x3E,0x00,0x3E,0x00,
           0x3F,0x10,0x22,0x00,0xD6,0x04,0x12,0x65,0x3F,0x10,0x22,0x00,0x23,0x2A,0x3C,0x04,
           0xCE,0x04,0x12,0x65,0x23,0x2B,0x3C,0x04,0x3F,0x10,0x22,0x00,0xCE,0x04,0x11,0x2E,
           0x23,0x2C,0x3C,0x04,0x86,0x0A,0xA2,0x0A,0x23,0x30,0x3C,0x04,0x23,0x60,0x3E,0x01,
           0x23,0x80,0x3E,0x02,0x23,0x32,0x3E,0x03,0x23,0x00,0x3E,0x7C,0x23,0x7C,0x3E,0x07,
           0x23,0x31,0x3C,0x04,0xAA,0x0A,0xCA,0x0A,0x11,0x48,0x22,0x04,0x3C,0x07,0x02,0x65,
           0x23,0x32,0x3C,0x04,0x82,0x0A,0x23,0xAA,0x68,0x6A,0x3E,0x00,0x3E,0x00,0x23,0x32,
           0x3E,0x00,0x3E,0x00,0x0A,0x19,0x0A,0x19,0x0A,0x19,0x0A,0x19,0x23,0x33,0x3C,0x04,
           0x23,0x00,0x3E,0xF5,0x22,0xF5,0x3B,0x02,0x11,0x5A,0x22,0x04,0x2F,0x03,0x3B,0x00,
           0x19,0x65,0x3C,0x07,0x23,0x00,0x3C,0x06,0x02,0x65,0x23,0x34,0x3C,0x04,0xDA,0x04,
           0x19,0x67,0xDA,0x04,0x19,0x69,0x23,0x35,0x3C,0x04,0xCA,0x0A,0x11,0x6D,0xC6,0x04,
           0x11,0x6F,0x22,0x04,0x2F,0x83,0x3B,0x83,0x19,0x79,0x3C,0x07,0x23,0x83,0x3C,0x06,
           0x02,0x65,0x23,0x36,0x3C,0x04,0xA2,0x0A,0x86,0x0A,0x40,0x08,0x42,0x48,0x42,0x88,
           0x40,0x0C,0x42,0x4C,0x42,0x8C,0x40,0x10,0x42,0x50,0x42,0x90,0x40,0x14,0x42,0x54,
           0x42,0x94,0x23,0x40,0x68,0x6B,0x24,0xD3,0x3C,0x04,0x23,0x40,0x3E,0x01,0x23,0xA6,
           0x3E,0x02,0x23,0x14,0x3E,0x03,0xA2,0x0A,0x86,0x0A,0x23,0x30,0x68,0x69,0x3B,0x00,
           0x11,0x96,0x82,0x0A,0x23,0x7C,0x3E,0x07,0x23,0x41,0x68,0x6B,0x24,0xD3,0x3C,0x04,
           0x22,0x04,0x2F,0xAB,0x3B,0x03,0x19,0xA8,0x3C,0x07,0x23,0x03,0x3C,0x06,0x02,0x65,
           0x23,0x42,0x68,0x6B,0x24,0xD3,0x3C,0x04,0x23,0x30,0x68,0x69,0x3B,0x00,0x11,0xAD,
           0x23,0x00,0x68,0x6A,0x3E,0x00,0x68,0x6B,0x3E,0x00,0xDE,0x04,0x11,0xB5,0x22,0x00,
           0xD6,0x04,0x19,0xBB,0x02,0x65,0x23,0x43,0x68,0x6B,0x24,0xD3,0x3C,0x04,0x3B,0x43,
           0x19,0xD1,0xA2,0x0A,0x86,0x0A,0x23,0x30,0x68,0x69,0x3B,0x00,0x11,0xC4,0x82,0x0A,
           0x23,0x80,0x68,0x6A,0x3E,0x00,0xDE,0x04,0x11,0xCB,0x22,0x00,0xCE,0x04,0x19,0xD1,
           0x02,0x65,0xA2,0x0A,0x86,0x0A,0x23,0x30,0x68,0x69,0x3B,0x00,0x11,0xD4,0x82,0x0A,
           0x23,0x44,0x68,0x6B,0x24,0xD3,0x3C,0x04,0x0A,0x19,0x0A,0x19,0x0A,0x19,0x0A,0x19,
           0x23,0x45,0x68,0x6B,0x24,0xD3,0x3C,0x04,0x23,0x00,0x3E,0xF5,0x22,0xF5,0x3B,0x02,
           0x11,0xE6,0x22,0x04,0x2F,0x03,0x3B,0x00,0x19,0xF1,0x3C,0x07,0x23,0x00,0x3C,0x06,
           0x02,0x65,0x23,0x46,0x68,0x6B,0x24,0xD3,0x3C,0x04,0xDA,0x04,0x19,0xF5,0xDA,0x04,
           0x19,0xF7,0x23,0x47,0x68,0x6B,0x24,0xD3,0x3C,0x04,0xCA,0x0A,0x11,0xFD,0xC6,0x04,
           0x11,0xFF,0x22,0x04,0x2F,0xBB,0x3B,0x83,0x1A,0x09,0x3C,0x07,0x23,0x83,0x3C,0x06,
           0x02,0x65,0xA2,0x0A,0x86,0x0A,0x23,0x30,0x68,0x69,0x3B,0x00,0x12,0x0C,0x82,0x0A,
           0x23,0xAA,0x3C,0x04,0x3C,0x07,0x3C,0x06,0x3C,0x05,0x23,0x00,0x3E,0x7C,0x82,0xF2,
           0x02,0x66,0x20,0x08,0x3E,0x00,0x20,0x0C,0x3E,0x00,0x20,0x10,0x3E,0x00,0x20,0x14,
           0x3E,0x00,0x68,0x6D,0x4A,0xD1,0x0A,0x5C,0x23,0x01,0x3C,0xD0,0x20,0x08,0x0A,0x4A,
           0x68,0x64,0x3C,0xC4,0x20,0x0C,0x0A,0x4A,0x68,0x64,0x3C,0xC5,0x20,0x10,0x0A,0x4A,
           0x68,0x64,0x3C,0xC6,0x20,0x14,0x0A,0x4A,0x68,0x64,0x3C,0xC7,0x20,0x08,0x0A,0x4A,
           0x68,0x64,0x3C,0xC4,0x20,0x0C,0x0A,0x4A,0x68,0x64,0x3C,0xC5,0x20,0x10,0x0A,0x4A,
           0x68,0x64,0x3C,0xC6,0x23,0x07,0x3C,0xD0,0x20,0x14,0x0A,0x4A,0x68,0x64,0x3C,0xC7,
           0x48,0xD1,0x68,0x6D,0x68,0x6A,0x68,0x65,0xFA,0x7D,0xCA,0xF1,0xFE,0x7D,0x68,0x6B,
           0x3E,0x00,0xDA,0x7D,0x20,0xD0,0x2F,0x07,0x68,0x65,0xDE,0x7D,0xCE,0xF1,0x12,0x59,
           0x33,0x10,0x68,0x6B,0x3E,0x00,0x68,0x6D,0x23,0x40,0x3E,0x06,0x3E,0x08,0x68,0x6A,
           0x23,0x55,0x3E,0x00,0x23,0x1D,0x3E,0x00,0x68,0x6D,0x82,0xF4,0x02,0x66,0x00,0x00};

static unsigned char towrapdiag[1376] = 
          {0x23,0x01,0x3C,0x04,0x23,0x14,0x3E,0x01,0x23,0x80,0x3E,0x02,0x23,0x1D,0x3E,0x03,
           0x23,0x00,0x3E,0x7C,0x23,0x7C,0x3E,0x07,0x23,0x14,0x3E,0x43,0xA2,0x0A,0x23,0x50,
           0x68,0x69,0x3B,0x00,0x10,0x10,0x23,0x02,0x3C,0x04,0x22,0x04,0x3B,0x03,0x18,0x1C,
           0x3C,0x07,0x23,0x03,0x3C,0x06,0x02,0xA8,0x23,0x03,0x3C,0x04,0x82,0x0A,0x0A,0x1F,
           0x23,0x04,0x3C,0x04,0x0A,0x37,0x23,0x05,0x3C,0x04,0x23,0x00,0x3E,0xF5,0x22,0xF5,
           0x3B,0x02,0x10,0x27,0x22,0x04,0x3B,0x53,0x18,0x31,0x3C,0x07,0x23,0x53,0x3C,0x06,
           0x02,0xA8,0x23,0x04,0x68,0x69,0x3B,0x00,0x10,0x32,0x3E,0x06,0x3E,0x08,0xA2,0x0A,
           0x23,0x06,0x3C,0x04,0x0A,0x50,0x23,0x07,0x3C,0x04,0x0A,0x6D,0x23,0x08,0x3C,0x04,
           0x22,0x04,0x3B,0x03,0x18,0x47,0x3C,0x07,0x23,0x03,0x3C,0x06,0x02,0xA8,0x23,0x10,
           0x3C,0x04,0x23,0x34,0x3E,0x01,0x23,0x80,0x3E,0x02,0x23,0x1D,0x3E,0x03,0x23,0x00,
           0x3E,0x7C,0x3C,0xC0,0x3C,0xC1,0x3C,0xC2,0x3C,0xC3,0x3C,0xC8,0x3C,0xC9,0x3C,0xCA,
           0x3C,0xCB,0x3C,0xC4,0x3C,0xC5,0x3C,0xC6,0x3C,0xC7,0x23,0x7C,0x3E,0x07,0x23,0x12,
           0x3C,0x04,0x22,0x04,0x3B,0x03,0x18,0x68,0x3C,0x07,0x23,0x03,0x3C,0x06,0x02,0xA8,
           0x23,0x13,0x3C,0x04,0x82,0x0A,0x0A,0x1F,0x68,0x6A,0x23,0x02,0x3E,0x00,0x23,0x14,
           0x3C,0x04,0x0A,0x37,0x3F,0x10,0x22,0x00,0x3C,0xCC,0x23,0x15,0x3C,0x04,0xC6,0x04,
           0x10,0x77,0x22,0x04,0x3B,0x5B,0x18,0x80,0x3C,0x07,0x23,0x5B,0x3C,0x06,0x02,0xA8,
           0x3E,0x06,0x3E,0x08,0xA2,0x0A,0x23,0x16,0x3C,0x04,0x0A,0x50,0x23,0x17,0x3C,0x04,
           0x20,0xC4,0x2F,0x03,0x3C,0xC4,0x20,0xC5,0x2F,0x03,0x3C,0xC5,0x20,0xC6,0x2F,0x03,
           0x3C,0xC6,0x20,0xC7,0x2F,0x03,0x3C,0xC7,0x20,0xC8,0x2F,0x03,0x3C,0xC8,0x20,0xC9,
           0x2F,0x03,0x3C,0xC9,0x20,0xCA,0x2F,0x03,0x3C,0xCA,0x20,0xCB,0x2F,0x03,0x3C,0xCB,
           0x0A,0x6D,0x23,0x18,0x3C,0x04,0x20,0xCC,0x3B,0x00,0x18,0xAA,0x3C,0x07,0x23,0x00,
           0x3C,0x06,0x02,0x8A,0x23,0x19,0x3C,0x04,0x22,0x04,0x3B,0x03,0x18,0xB3,0x3C,0x07,
           0x23,0x03,0x3C,0x06,0x02,0xA8,0x23,0x20,0x3C,0x04,0x23,0x8C,0x3E,0x01,0x23,0xA0,
           0x3E,0x02,0x23,0x7E,0x3E,0x03,0x23,0x00,0x3E,0x7C,0x3C,0xC0,0x3C,0xC1,0x3C,0xC2,
           0x3C,0xC3,0x3C,0xC8,0x3C,0xC9,0x3C,0xCA,0x3C,0xCB,0x3C,0xC4,0x3C,0xC5,0x3C,0xC6,
           0x3C,0xC7,0x23,0x10,0x3E,0xB7,0x3E,0xB5,0x23,0x20,0x3E,0xB6,0x3E,0xB4,0x23,0x7C,
           0x3E,0x07,0x23,0x21,0x3C,0x04,0x82,0x0A,0x23,0x0A,0x68,0x69,0x3B,0x00,0x10,0xD5,
           0x23,0x7E,0x68,0x6A,0x3E,0x00,0x68,0x6B,0x0A,0x05,0x96,0xF1,0x92,0xF1,0x20,0x08,
           0x3E,0xB1,0x20,0x0C,0x3E,0xB1,0x20,0x10,0x3E,0xB1,0x20,0x14,0x3E,0xB1,0x68,0x6B,
           0x22,0x78,0x3E,0x00,0x22,0x79,0x3E,0x00,0x23,0x7E,0x68,0x6A,0x3E,0x00,0x23,0x22,
           0x3C,0x04,0x3F,0x10,0x22,0x00,0x1A,0xA8,0x3C,0xC0,0x3E,0xB0,0x3F,0x10,0x22,0x00,
           0x1A,0xA8,0x3C,0xC1,0x3E,0xB0,0x3F,0x10,0x22,0x00,0x1A,0xA8,0x3C,0xC2,0x3E,0xB0,
           0x3F,0x10,0x22,0x00,0x1A,0xA8,0x3C,0xC3,0x3E,0xB0,0x3F,0x10,0x22,0x00,0x1A,0xA8,
           0x3C,0xCD,0x3E,0xB0,0x3F,0x10,0x22,0x00,0x1A,0xA8,0x3C,0xCE,0x3E,0xB0,0x3F,0x10,
           0x22,0x00,0x12,0xA8,0x3C,0xCF,0x23,0x23,0x3C,0x04,0xD2,0x04,0x12,0xA8,0xA2,0x0A,
           0x23,0x24,0x3C,0x04,0x0A,0x50,0x23,0x25,0x3C,0x04,0x22,0x74,0x3B,0x47,0x19,0x24,
           0x3C,0x07,0x23,0x47,0x3C,0x06,0x02,0x8A,0x22,0x75,0x3B,0x0F,0x19,0x2B,0x3C,0x07,
           0x23,0x0F,0x3C,0x06,0x02,0x8A,0x23,0x26,0x3C,0x04,0x20,0xCF,0x3B,0x7E,0x19,0x34,
           0x3C,0x07,0x23,0x7E,0x3C,0x06,0x02,0x8A,0x23,0x27,0x3C,0x04,0x23,0x00,0x3E,0xF5,
           0x22,0xF5,0x3B,0x02,0x11,0x38,0x22,0x04,0x2F,0xFB,0x3B,0x03,0x19,0x43,0x3C,0x07,
           0x23,0x03,0x3C,0x06,0x02,0xA8,0x23,0x30,0x3C,0x04,0x23,0x60,0x3E,0x01,0x23,0x80,
           0x3E,0x02,0x23,0x32,0x3E,0x03,0x23,0x00,0x3E,0x7C,0x3C,0xC0,0x3C,0xC1,0x3C,0xC2,
           0x3C,0xC3,0x3C,0xC8,0x3C,0xC9,0x3C,0xCA,0x3C,0xCB,0x3C,0xC4,0x3C,0xC5,0x3C,0xC6,
           0x3C,0xC7,0x23,0x80,0x3E,0xB7,0x3E,0xB5,0x23,0x04,0x3E,0xB6,0x3E,0xB4,0x23,0x7C,
           0x3E,0x07,0x23,0x31,0x3C,0x04,0x82,0x0A,0x23,0xAA,0x3E,0x00,0x3E,0x00,0x23,0x32,
           0x3E,0x00,0x3E,0x00,0x0A,0x05,0xB6,0xF1,0xB2,0xF1,0x20,0x08,0x3E,0xB1,0x20,0x0C,
           0x3E,0xB1,0x20,0x10,0x3E,0xB1,0x20,0x14,0x3E,0xB1,0x68,0x6B,0x22,0x78,0x3E,0x00,
           0x22,0x79,0x3E,0x00,0x23,0x32,0x3C,0x04,0x0A,0x0E,0x20,0xC0,0x3E,0xB0,0x20,0xC1,
           0x3E,0xB0,0x20,0xC2,0x3E,0xB0,0x20,0xC3,0x3E,0xB0,0x3F,0x10,0x22,0x00,0x3C,0xCD,
           0x3E,0xB0,0x3F,0x10,0x22,0x00,0x3C,0xCE,0x3E,0xB0,0xA2,0x0A,0x23,0x33,0x3C,0x04,
           0x0A,0x50,0x23,0x34,0x3C,0x04,0x22,0x74,0x37,0xFF,0x3B,0x01,0x19,0x9B,0x3C,0x07,
           0x23,0x01,0x3C,0x06,0x02,0x8A,0x22,0x75,0x37,0xFF,0x3B,0xB0,0x19,0xA3,0x3C,0x07,
           0x23,0xB0,0x3C,0x06,0x02,0x8A,0x23,0x35,0x3C,0x04,0x23,0x00,0x3E,0xF5,0x22,0xF5,
           0x3B,0x02,0x11,0xA7,0x22,0x04,0x2F,0xC3,0x3B,0x03,0x19,0xB2,0x3C,0x07,0x23,0x03,
           0x3C,0x06,0x02,0xA8,0x40,0x08,0x42,0x48,0x42,0x88,0x40,0x0C,0x42,0x4C,0x42,0x8C,
           0x40,0x10,0x42,0x50,0x42,0x90,0x40,0x14,0x42,0x54,0x42,0x94,0x23,0x40,0x68,0x6B,
           0x24,0xD3,0x3C,0x04,0x23,0x40,0x3E,0x01,0x23,0xA0,0x3E,0x02,0x23,0x34,0x3E,0x03,
           0x23,0x0F,0x68,0x69,0x3B,0x00,0x11,0xC9,0x82,0x0A,0x3C,0xC0,0x3C,0xC1,0x3C,0xC2,
           0x3C,0xC3,0x3C,0xC8,0x3C,0xC9,0x3C,0xCA,0x3C,0xCB,0x3C,0xC4,0x3C,0xC5,0x3C,0xC6,
           0x3C,0xC7,0x23,0x7C,0x3E,0x07,0x23,0x41,0x68,0x6B,0x24,0xD3,0x3C,0x04,0x0A,0x05,
           0x23,0x42,0x68,0x6B,0x24,0xD3,0x3C,0x04,0x0A,0x0E,0xA2,0x0A,0x23,0x43,0x68,0x6B,
           0x24,0xD3,0x3C,0x04,0x0A,0x50,0x23,0x44,0x68,0x6B,0x24,0xD3,0x3C,0x04,0x23,0x00,
           0x3E,0xF5,0x22,0xF5,0x3B,0x02,0x11,0xF1,0x22,0x04,0x2F,0x2B,0x3B,0x03,0x19,0xFC,
           0x3C,0x07,0x23,0x03,0x3C,0x06,0x02,0xA8,0x23,0xAA,0x3C,0x04,0x3C,0x07,0x3C,0x06,
           0x3C,0x05,0x23,0x00,0x3E,0x7C,0x82,0xF2,0x02,0xA9,0x20,0x08,0x3E,0x00,0x20,0x0C,
           0x3E,0x00,0x20,0x10,0x3E,0x00,0x20,0x14,0x3E,0x00,0x68,0x6D,0xDE,0x04,0x12,0x0E,
           0x22,0x00,0x3C,0xC0,0xDE,0x04,0x12,0x12,0x22,0x00,0x3C,0xC1,0xDE,0x04,0x12,0x16,
           0x22,0x00,0x3C,0xC2,0xDE,0x04,0x12,0x1A,0x22,0x00,0x3C,0xC3,0x68,0x6D,0x4A,0xD1,
           0x0A,0x9F,0x23,0x01,0x3C,0xD0,0x20,0x08,0x0A,0x8D,0x68,0x64,0x3C,0xC4,0x20,0x0C,
           0x0A,0x8D,0x68,0x64,0x3C,0xC5,0x20,0x10,0x0A,0x8D,0x68,0x64,0x3C,0xC6,0x23,0x07,
           0x3C,0xD0,0x20,0x14,0x0A,0x8D,0x68,0x64,0x3C,0xC7,0x48,0xD1,0x68,0x6D,0x3F,0x10,
           0x22,0x00,0x3C,0xC0,0x3F,0x10,0x22,0x00,0x3C,0xC8,0x3F,0x10,0x22,0x00,0x3C,0xC1,
           0x3F,0x10,0x22,0x00,0x3C,0xC9,0x3F,0x10,0x22,0x00,0x3C,0xC2,0x3F,0x10,0x22,0x00,
           0x3C,0xCA,0x3F,0x10,0x22,0x00,0x3C,0xC3,0x3F,0x10,0x22,0x00,0x3C,0xCB,0x68,0x6D,
           0x20,0x08,0x38,0xC0,0x1A,0x57,0x3C,0x06,0x20,0xC0,0x3C,0x07,0x02,0x8A,0x20,0x0C,
           0x38,0xC1,0x1A,0x5E,0x3C,0x06,0x20,0xC1,0x3C,0x07,0x02,0x8A,0x20,0x10,0x38,0xC2,
           0x1A,0x65,0x3C,0x06,0x20,0xC2,0x3C,0x07,0x02,0x8A,0x20,0x14,0x38,0xC3,0x1A,0x6C,
           0x3C,0x06,0x20,0xC3,0x3C,0x07,0x02,0x8A,0x68,0x6D,0x20,0xC4,0x38,0xC8,0x1A,0x74,
           0x3C,0x06,0x20,0xC8,0x3C,0x07,0x02,0x8A,0x20,0xC5,0x38,0xC9,0x1A,0x7B,0x3C,0x06,
           0x20,0xC9,0x3C,0x07,0x02,0x8A,0x20,0xC6,0x38,0xCA,0x1A,0x82,0x3C,0x06,0x20,0xCA,
           0x3C,0x07,0x02,0x8A,0x20,0xC7,0x38,0xCB,0x1A,0x89,0x3C,0x06,0x20,0xCB,0x3C,0x07,
           0x02,0x8A,0x68,0x6D,0x22,0x04,0x3C,0x05,0x02,0xA8,0x68,0x6A,0x68,0x65,0xFA,0x7D,
           0xCA,0xF1,0xFE,0x7D,0x68,0x6B,0x3E,0x00,0xDA,0x7D,0x20,0xD0,0x2F,0x07,0x68,0x65,
           0xDE,0x7D,0xCE,0xF1,0x12,0x9C,0x33,0x10,0x68,0x6B,0x3E,0x00,0x68,0x6D,0x23,0x40,
           0x3E,0x06,0x3E,0x08,0x68,0x6A,0x23,0x55,0x3E,0x00,0x23,0x1D,0x3E,0x00,0x68,0x6D,
           0x82,0xF4,0x02,0xA9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

