/**********************************************************************
**                                                                   **
**                I N T E L   P R O P R I E T A R Y                  **
**                                                                   **
**   COPYRIGHT (c) 2004 - 2005  BY  INTEL  CORPORATION.  ALL         **
**   RIGHTS RESERVED.   NO PART OF THIS PROGRAM OR PUBLICATION MAY   **
**   BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A   **
**   RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER   **
**   LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,   **
**   MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT   **
**   THE PRIOR WRITTEN PERMISSION OF :                               **
**                                                                   **
**                      INTEL  CORPORATION                           **
**                                                                   **
**                2200 MISSION COLLEGE BOULEVARD                     **
**                                                                   **
**             SANTA  CLARA,  CALIFORNIA  95052-8119                 **
**                                                                   **
**********************************************************************/

/**********************************************************************
**                                                                   **
** INTEL CORPORATION PROPRIETARY INFORMATION                         **
** This software is supplied under the terms of a license agreement  **
** with Intel Corporation and may not be copied nor disclosed        **
** except in accordance with the terms of that agreement.            **
**                                                                   **
** Module Name:                                                      **
**   dmaengine.h                                                     **
**                                                                   **
** Abstract:                                                         **
**                                                                   **
**********************************************************************/

#ifndef DMAENGINE_H
#define DMAENGINE_H

#ifndef __VMKERNEL_MODULE__
#include <linux/device.h>
#endif // __VMKERNEL_MODULE__
#include <linux/uio.h>
#include <linux/skbuff.h>

#ifndef __VMKERNEL_MODULE__
DECLARE_PER_CPU(struct completion, kick_dma_poll);
#endif // __VMKERNEL_MODULE__

#if 0
#define INSTRUMENTATION
#define IOAT_PERF_CHANGE
#endif

#define DMA_DEFAULT_MIN_COPY_SIZE 16

/**
 * enum dma_event_t - resource PNP/power managment events
 * @DMA_RESOURCE_SUSPEND: DMA device going into low power state
 * @DMA_RESOURCE_RESUME: DMA device returning to full power
 * @DMA_RESOURCE_ADDED: DMA device added to the system
 * @DMA_RESOURCE_REMOVED: DMA device removed from the system
 */
enum dma_event_t {
	DMA_RESOURCE_SUSPEND,
	DMA_RESOURCE_RESUME,
	DMA_RESOURCE_ADDED,
	DMA_RESOURCE_REMOVED,
};

/**
 * typedef dma_cookie_t
 *
 * if dma_cookie_t is >0 it's a DMA request cookie, <0 it's an error code
 */
typedef s32 dma_cookie_t;

/*#define dma_submit_error(cookie) ((cookie) < 0 ? 1 : 0)*/

/**
 * enum dma_status_t - DMA transaction status
 * @DMA_SUCCESS: transaction completed successfully
 * @DMA_IN_PROGRESS: transaction not yet processed
 * @DMA_ERROR: transaction failed
 */
enum dma_status_t {
	DMA_SUCCESS,
	DMA_IN_PROGRESS,
	DMA_ERROR,
};

/**
 * struct dma_chan - devices supply DMA channels, clients use them
 * @client: ptr to the client user of this chan, will be NULL when unused
 * @device: ptr to the dma device who supplies this channel, always !NULL
 * @client_node: used to add this to the client chan list
 * @device_node: used to add this to the device chan list
 */
struct dma_chan
{
	struct dma_client *client;
	struct dma_device *device;
	dma_cookie_t cookie;

#ifndef __VMKERNEL_MODULE__
	/* sysfs */
	int chan_id;
	struct class_device class_dev;
#endif // __VMKERNEL_MODULE__

	/* stats */
	unsigned long memcpy_count;
	unsigned long bytes_transferred;
	unsigned int min_copy_size;

	struct list_head client_node;
	struct list_head device_node;

#ifndef __VMKERNEL_MODULE__
	cpumask_t cpumask;
#endif // __VMKERNEL_MODULE__
};

/*
 * typedef dma_event_callback - function pointer to a DMA event callback
 */
typedef void (*dma_event_callback) (struct dma_client *client, struct dma_chan *chan, enum dma_event_t event);

/**
 * struct dma_client - info on the entity making use of DMA services
 * @event_callback: func ptr to call when something happens
 * @chan_count: number of chans allocated
 * @chans_desired: number of chans requested. Can be +- chan_count
 * @port: upstream DMA port from the client's PCI device
 * @channels: the list of DMA channels allocated
 * @global_node: list_head for global dma_client_list
 */
struct dma_client {
	dma_event_callback	event_callback;
	unsigned int		chan_count;
	unsigned int		chans_desired;

	/* TODO keep some stats */
	struct list_head	channels;
	struct list_head	global_node;
};

/**
 * struct dma_device - info on the entity supplying DMA services
 * @chancnt: how many DMA channels are supported
 * @channels: the list of struct dma_chan
 * @global_node: list_head for global dma_device_list
 * Other func ptrs: used to make use of this device's capabilities
 */
struct dma_device {

	unsigned int chancnt;
	struct list_head channels;
	struct list_head global_node;

	int dev_id;
	/*struct class_device class_dev;*/

	int (*device_alloc_chan_resources)(struct dma_chan *chan);
	void (*device_free_chan_resources)(struct dma_chan *chan);
#ifdef __VMKERNEL_MODULE__
	dma_cookie_t (*device_memcpy_mach_buf_to_buf)(struct dma_chan *chan, dma_addr_t dest,
		dma_addr_t src, size_t len);
#endif // __VMKERNEL_MODULE__
	dma_cookie_t (*device_memcpy_buf_to_buf)(struct dma_chan *chan, void *dest,
		void *src, size_t len);
	dma_cookie_t (*device_memcpy_buf_to_pg)(struct dma_chan *chan, struct page *page,
		unsigned int offset, void *kdata, size_t len);
	dma_cookie_t (*device_memcpy_pg_to_pg)(struct dma_chan *chan, struct page *dest_pg,
		unsigned int dest_off, struct page *src_pg, unsigned int src_off,
		size_t len);
	void (*device_arm_interrupt)(struct dma_chan *chan);
	enum dma_status_t (*device_memcpy_complete)(struct dma_chan *chan, dma_cookie_t cookie, dma_cookie_t *last, dma_cookie_t *used);
	void (*device_memcpy_issue_pending)(struct dma_chan *chan);
};

#ifdef __VMKERNEL_MODULE__
struct vmk_ioatdevice {
   struct dma_client* (*client_register)(dma_event_callback event_callback);
   void (*client_unregister)(struct dma_client *client);
   void (*client_chan_request)(struct dma_client *client, unsigned int number);
   void (*inc_inuse)(void);
   void (*dec_inuse)(void);

   struct dma_device *ioat_device;
};
int VmkIoat_Register(struct vmk_ioatdevice *dev);
void VmkIoat_Cleanup(void);
#endif // __VMKERNEL_MODULE__

/* --- public DMA engine API --- */

struct dma_client *
dma_async_client_register(dma_event_callback event_callback);

void
dma_async_client_unregister(struct dma_client *client);

void
dma_async_client_chan_request(struct dma_client *client, unsigned int number);

#ifdef __VMKERNEL_MODULE__
dma_cookie_t
dma_async_memcpy_mach_buf_to_buf(
	struct dma_chan *chan,
	dma_addr_t dest,
	dma_addr_t src,
	size_t len);
#endif // __VMKERNEL_MODULE__

dma_cookie_t
dma_async_memcpy_buf_to_buf(
	struct dma_chan *chan,
	void *dest,
	void *src,
	size_t len);

dma_cookie_t
dma_async_memcpy_buf_to_pg(
	struct dma_chan *chan,
	struct page *page,
	unsigned int offset,
	void *kdata,
	size_t len);

dma_cookie_t
dma_async_memcpy_pg_to_pg(
	struct dma_chan *chan,
	struct page *dest_pg,
	unsigned int dest_off,
	struct page *src_pg,
	unsigned int src_off,
	size_t len);

void dma_async_memcpy_issue_pending(struct dma_chan *);

enum dma_status_t
dma_async_wait_for_completion(struct dma_chan *chan, dma_cookie_t cookie);

static inline enum dma_status_t
dma_async_is_complete(
	dma_cookie_t cookie,
	dma_cookie_t last_complete,
	dma_cookie_t last_used) {
	
	if (last_complete <= last_used) {
		if ((cookie <= last_complete) || (cookie > last_used))
			return DMA_SUCCESS;
	} else {
		if ((cookie <= last_complete) && (cookie > last_used))
			return DMA_SUCCESS;
	}
	return DMA_IN_PROGRESS;
}

enum dma_status_t
dma_async_memcpy_complete(struct dma_chan *chan, dma_cookie_t cookie, dma_cookie_t *last, dma_cookie_t *used);

u32
dma_async_get_errors(struct dma_chan *chan, dma_cookie_t cookie);

/* --- DMA device --- */

int dma_async_device_register(
	struct dma_device *device);

void dma_async_device_unregister(
	struct dma_device *device);

#ifndef __VMKERNEL_MODULE__
/* --- DMA completion --- */

struct dma_completion
{
	struct dma_chan *chan;
	dma_cookie_t cookie;
	enum dma_status_t status;
	struct completion comp;
};

#define DMA_COMPLETION_INITIALIZER(name, chan, cookie) \
{	.chan = chan, \
	.cookie = cookie, \
	.status = DMA_IN_PROGRESS, \
	.comp = COMPLETION_INITIALIZER((name).comp)	}

#define DECLARE_DMA_COMPLETION(name, chan, cookie) \
struct dma_completion name = DMA_COMPLETION_INITIALIZER(name, chan, cookie)

/* --- net iovec stuff --- */

DECLARE_PER_CPU(struct dma_chan *, net_dma);

struct dma_page_list
{
	char *base_address;
	int nr_pages;
	struct page **pages;
};

struct dma_locked_list
{
	int nr_iovecs;
	struct dma_page_list page_list[0];
};

int dma_lock_iovec_pages(struct iovec *iov, size_t len, struct dma_locked_list **locked_list);
void dma_unlock_iovec_pages(struct dma_locked_list* locked_list);
int
dma_skb_copy_datagram_iovec(struct dma_chan* chan, const struct sk_buff *skb, int offset,
			    struct iovec *to, size_t len, struct dma_locked_list *locked_list);
void dma_memcpy_toiovec_wait(struct dma_chan *chan, dma_cookie_t cookie);
void dma_async_try_early_copy(struct sock *sk, struct sk_buff *skb);

#ifdef INSTRUMENTATION

/* Performance monitoring counters */

/* Counter 0 and 1: */
#define MSR_BPU_COUNTER0        0x300
#define MSR_BPU_COUNTER1        0x301

/* CCCR's */
#define MSR_BPU_CCCR0           0x360
#define MSR_BPU_CCCR1           0x361

/* ESCR's */
#define MSR_BSU_ESCR0           0x3A0
#define MSR_FSB_ESCR0           0x3A2
#define MSR_MOB_ESCR0           0x3AA
#define MSR_PMH_ESCR0           0x3AC
#define MSR_BPU_ESCR0           0x3B2
#define MSR_IS_ESCR0            0x3B4
#define MSR_ITLB_ESCR0          0x3B6
#define MSR_IX_ESCR0            0x3C8

/* Counter 2 and 3: */
#define MSR_BPU_COUNTER2        0x302
#define MSR_BPU_COUNTER3        0x303

/* CCCR's */
#define MSR_BPU_CCR2            0x362
#define MSR_BPU_CCC3            0x363

/* ESCR's */
#define MSR_BSU_ESCR1           0x3A1
#define MSR_FSB_ESCR1           0x3A3
#define MSR_MOB_ESCR1           0x3AB
#define MSR_PMH_ESCR1           0x3AD
#define MSR_BPU_ESCR1           0x3B3
#define MSR_IS_ESCR1            0x3B5
#define MSR_ITLB_ESCR1          0x3B7
#define MSR_IX_ESCR1            0x3C9

/* Counter 4 and 5: */
#define MSR_MS_COUNTER0         0x304
#define MSR_MS_COUNTER1         0x305

/* CCCR's */
#define MSR_MS_CCCR0            0x364
#define MSR_MS_CCCR1            0x365

/* ESCR's */
#define MSR_MS_ESCR0            0x3C0
#define MSR_TBPU_ESCR0          0x3C2
#define MSR_TC_ESCR0            0x3C4

/* Counter 6 and 7: */
#define MSR_MS_COUNTER2         0x306
#define MSR_MS_COUNTER3         0x307

/* CCCR's */
#define MSR_MS_CCCR2            0x366
#define MSR_MS_CCCR3            0x367

/* ESCR's */
#define MSR_MS_ESCR1            0x3C1
#define MSR_TBPU_ESCR1          0x3C3
#define MSR_TC_ESCR1            0x3C5

/* Counter 8 and 9: */
#define MSR_FLAME_COUNTER0      0x308
#define MSR_FLAME_COUNTER1      0x309

/* CCCR's */
#define MSR_FLAME_CCCR0         0x368
#define MSR_FLAME_CCCR1         0x369

/* ESCR's */
#define MSR_FIRM_ESCR0          0x3A4
#define MSR_FLAME_ESCR0         0x3A6
#define MSR_DAC_ESCR0           0x3A8
#define MSR_SAAT_ESCR0          0x3AE
#define MSR_U2L_ESCR0           0x3B0

/* Counter 10 and 11: */
#define MSR_FLAME_COUNTER2      0x30A
#define MSR_FLAME_COUNTER3      0x30B

/* CCCR's */
#define MSR_FLAME_CCCR2         0x36A
#define MSR_FLAME_CCCR3         0x36B

/* ESCR's */
#define MSR_FIRM_ESCR1          0x3A5
#define MSR_FLAME_ESCR1         0x3A7
#define MSR_DAC_ESCR1           0x3A9
#define MSR_SAAT_ESCR1          0x3AF
#define MSR_U2L_ESCR1           0x3B1

/* Counter 12 and 13: */
#define MSR_IQ_COUNTER0         0x30C
#define MSR_IQ_COUNTER1         0x30D

/* CCCR's */
#define MSR_IQ_CCCR0            0x36C
#define MSR_IQ_CCCR1            0x36D

/* ESCR's */
#define MSR_CRU_ESCR0           0x3B8
#define MSR_CRU_ESCR2           0x3CC
#define MSR_CRU_ESCR4           0x3E0
#define MSR_IQ_ESCR0            0x3BA
#define MSR_RAT_ESCR0           0x3BC
#define MSR_SSU_ESCR0           0x3BE
#define MSR_ALF_ESCR0           0x3CA

/* Counter 14 and 15: */
#define MSR_IQ_COUNTER2         0x30E
#define MSR_IQ_COUNTER3         0x30F

/* CCCR's */
#define MSR_IQ_CCCR2            0x36E
#define MSR_IQ_CCCR3            0x36F

/* ESCR's */
#define MSR_CRU_ESCR1           0x3B9
#define MSR_CRU_ESCR3           0x3CD
#define MSR_CRU_ESCR5           0x3E1
#define MSR_IQ_ESCR1            0x3BA
#define MSR_RAT_ESCR1           0x3BD
#define MSR_ALF_ESCR0           0x3CA

/* Counter 16 and 17: */
#define MSR_IQ_COUNTER4         0x310
#define MSR_IQ_COUNTER5         0x311

/* CCCR's */
#define MSR_IQ_CCCR4            0x370
#define MSR_IQ_CCCR5            0x371

/* MSRs for cache config */
#define MSR_IA32_PEBS_ENABLE 0x3F1
#define MSR_PEBS_MATRIX_VERT 0x3F2

#define CACHE_LINE 64

#ifdef NOT_REQ

#define DPT_RDMSR(_MSR, _VAL1, _VAL2)                 \
    _asm{                           \
    _asm push eax                   \
    _asm push edx                   \
    _asm push ecx                   \
    _asm mov ecx, _MSR                      \
    _asm RDMSR                      \
    _asm mov _VAL1, eax                     \
        _asm mov _VAL2, edx                             \
    _asm pop ecx                    \
    _asm pop edx                    \
    _asm pop eax                    \
    }

#define DPT_WRMSR(_MSR, _VAL1, _VAL2)                 \
    _asm{                           \
    _asm push eax                   \
    _asm push edx                   \
    _asm push ecx                   \
    _asm mov ecx, _MSR                      \
    _asm mov eax,_VAL1                      \
        _asm mov edx,_VAL2                              \
    _asm WRMSR                          \
    _asm pop ecx                    \
    _asm pop edx                    \
    _asm pop eax                    \
    }

#define DPT_RDPMC(_MSR, _VAL1, _VAL2)                 \
    _asm{                           \
    _asm push eax                   \
    _asm push edx                   \
    _asm push ecx                   \
    _asm mov ecx, _MSR                      \
    _asm RDPMC                      \
    _asm mov eax,_VAL1                      \
        _asm mov edx,_VAL2                              \
    _asm pop ecx                    \
    _asm pop edx                    \
    _asm pop eax                    \
    }


#define DPT_RDTSC(_VAL2, _VAL1)                 \
    _asm{                           \
    _asm push eax                   \
    _asm push edx                   \
    _asm RDTSC                      \
        _asm mov _VAL2, edx                             \
    _asm mov _VAL1, eax                         \
    _asm pop edx                    \
    _asm pop eax                    \
    }


#define DPT_PREFETCH(cache_line)        \
{       _asm mov edx, cache_line        \
        _asm prefetcht0[edx]            \
}


#define DPT_PREFETCH1460(cache_line)    \
{       _asm mov edx, cache_line                        \
        _asm prefetcht0[edx]                            \
        _asm prefetcht0[edx+1*CACHE_LINE]       \
        _asm prefetcht0[edx+2*CACHE_LINE]       \
        _asm prefetcht0[edx+3*CACHE_LINE]       \
        _asm prefetcht0[edx+4*CACHE_LINE]       \
        _asm prefetcht0[edx+5*CACHE_LINE]       \
        _asm prefetcht0[edx+6*CACHE_LINE]       \
        _asm prefetcht0[edx+7*CACHE_LINE]       \
        _asm prefetcht0[edx+8*CACHE_LINE]       \
        _asm prefetcht0[edx+9*CACHE_LINE]       \
        _asm prefetcht0[edx+10*CACHE_LINE]      \
        _asm prefetcht0[edx+11*CACHE_LINE]      \
        _asm prefetcht0[edx+12*CACHE_LINE]      \
        _asm prefetcht0[edx+13*CACHE_LINE]      \
        _asm prefetcht0[edx+14*CACHE_LINE]      \
        _asm prefetcht0[edx+15*CACHE_LINE]      \
        _asm prefetcht0[edx+16*CACHE_LINE]      \
        _asm prefetcht0[edx+17*CACHE_LINE]      \
        _asm prefetcht0[edx+18*CACHE_LINE]      \
        _asm prefetcht0[edx+19*CACHE_LINE]      \
        _asm prefetcht0[edx+20*CACHE_LINE]      \
        _asm prefetcht0[edx+21*CACHE_LINE]      \
        _asm prefetcht0[edx+22*CACHE_LINE]      \
}


#define DPT_CACHE_FLUSH(cache_line) \
{       _asm mov edx, cache_line                        \
        _asm clflush[edx]                                       \
}

#endif

/* Performance Counter(s) setup and measurement: */

/* Branches Retired: */

#define BRANCHES_RET_ESCR2 0x0C001D0C           /* MSR_CRU_ESCR2 (all) */
#define BRANCHES_RET_CCCR1 0x0003B000           /* MSR_IQ_CCCR1 */

/* Branches mispredicted:*/

#define BRANCHES_MISPREDICTED_ALL_ESCR0 0x0A003C08
#define BRANCHES_MISPREDICTED_ALL_ESCR1 0x0A003C08

#define COUNT_BRANCHES_MISPREDICTED_ALL_CCCR0 0x00035000
#define CLEAR_BRANCHES_MISPREDICTED_ALL 0x00034000

/* FSB Activity: */

/*
* Instructions Retired:
*      Counters # 12->17
*/
#define INSTR_RET_ESCR0 0x04000608              /* MSR_CRU_ESCR0 */
#define INSTR_RET_ESCR1 0x04000608              /* MSR_CRU_ESCR1 */
#define COUNT_INSTR_RET_CCCR0 0x00039000        /* MSR_IQ_CCCR0 */
#define CLEAR_INSTR_RET_CCCR0 0x00038000        /* MSR_IQ_CCCR0 */

/*
** UOPS Retired:
**      Counters #12->17
*/
#define UOPS_RET_ESCR1  0x0200021C              /* MSR_CRU_ESCR2 (no-bogus)*/
#define UOPS_RET_CCCR2 0x00039000               /* MSR_IQ_CCCR2 */

#define IOQ_ALLOC_ALL_READ      0x075f420C
#define IOQ_ALLOC_ALL_WRITE     0x065F820C
#define IOQ_ALLOC_CCCR0         0x0107D000

/* Cache misses - Counters 12 - 17 */

#define REPLAY_EVENT_CRU_ESCR2                  0x12000208
#define REPLAY_EVENT_TAGGED_CRU_ESCR2   0x12000238
#define COUNT_REPLAY_EVENT_CRU_CCCR0    0x0003B000
#define CLEAR_REPLAY_EVENT_CRU_CCCR0    0x00035000

#define BSQ_CACHE_REFERENCE_CR_ESCR0    0x18020008
#define COUNT_BSQ_CACHE_REFERENCE_CR_CCCR0      0x0003F000
#define CLEAR_BSQ_CACHE_REFERENCE_CR_CCCR0      0x0003D000

/* Settings for replay tagging */

#define MSR_IA32_PEBS_ENABLE_2ndL_CACHE_LOAD_MISS_RETIRED       0x03000002
#define MSR_PEBS_MATRIX_VERT_2ndL_CACHE_LOAD_MISS_RETIRED       0x00000001


#define MSR_IA32_PEBS_ENABLE_DTLB_LOAD_MISS_RETIRED     0x03000002
#define MSR_PEBS_MATRIX_VERT_DTLB_LOAD_MISS_RETIRED     0x00000001


#define MSR_IA32_PEBS_ENABLE_DTLB_STORE_MISS_RETIRED    0x03000002
#define MSR_PEBS_MATRIX_VERT_DTLB_STORE_MISS_RETIRED    0x00000002


#define MSR_IA32_PEBS_ENABLE_DTLB_ALL_MISS_RETIRED      0x03000002
#define MSR_PEBS_MATRIX_VERT_DTLB_ALL_MISS_RETIRED      0x00000003

/* P6 family MSRs */

#define MSR_PerfEvtSel0 0x186
#define MSR_PerfEvtSel1 0x187

#define MSR_PerfEvtCtr0 0xC1
#define MSR_PerfEvtCtr1 0xC2

/* P6 Events */

#define DATA_MEM_REFS   0x43
#define DCU_LINES_IN    0x45
#define DCU_M_LINES_IN  0x46
#define DCU_M_LINES_OUT 0x47
#define DCU_MISS_OUTSTANDING    0x48

#define L2_LD           0x29
#define L2_ST           0x2A


#define COUNT_DATA_MEM_REFS                     0x00420043
#define CLEAR_DATA_MEM_REFS                     0x00020043
#define COUNT_L2_LD                                     0x00420F29
#define CLEAR_L2_LD                                     0x00020F29
#define COUNT_INST_RETIRED                      0x004200C0
#define CLEAR_INST_RETIRED                      0x000200C0
#define COUNT_DCU_MISS_OUTSTANDING      0x00420048
#define CLEAR_DCU_MISS_OUTSTANDING      0x00020048
#define COUNT_BUS_REQ_OUTSTANDING       0x00420060
#define CLEAR_BUS_REQ_OUTSTANDING       0x00020060
#define COUNT_BUS_TRAN_MEM                      0x0042006F
#define CLEAR_BUS_TRAN_MEM                      0x0002006F
#define COUNT_L2_LINES_IN                       0x00420024
#define CLEAR_L2_LINES_IN                       0x00020024
#define COUNT_BR_INST_RETIRED           0x004200C4
#define CLEAR_BR_INST_RETIRED           0x000200C4
#define COUNT_BR_MISS_PRED_RETIRED      0x004200C5
#define CLEAR_BR_MISS_PRED_RETIRED      0x000200C5

#define COUNT_EMON_KNI_PREF_DISPATCHED  0x00420007
#define CLEAR_EMON_KNI_PREF_DISPATCHED  0x00020007

#define COUNT_EMON_KNI_PREF_MISS                0x0042004B
#define CLEAR_EMON_KNI_PREF_MISS                0x0002004B

#define COUNT_DTLB_MISS                                 0x00420049
#define CLEAR_DTLB_MISS                                 0x00020049

#define COUNT_IFU_IFETCH_MISS                   0x00420081
#define CLEAR_IFU_IFETCH_MISS                   0x00020081

/* Defines for controlling instrumentation */

#define INSTR_DISABLE                           0x00000000
#define ACROSS_DMA_COPY_PREQUEUE                0x00000001
#define ACROSS_DMA_COPY_RECVMSG                 0x00000002
#define ACROSS_DMA_WAIT                         0x00000004
#define ACROSS_DMA_PG_TOIOVEC                   0x00000008

#define ACROSS_TCP_LOCK_SOCK                    0x00000100
#define ACROSS_TCP_WAKE_SOCK                    0x00000200

#define ACROSS_E1000_ICR_READ                   0x00001000
#define ACROSS_E1000_RX_IRQ                     0x00002000


struct ioat_perf {
        uint32_t prof_location;
        uint32_t cntr_val1;
        uint32_t cntr_val2;
        uint32_t tsc_count;
        uint32_t force_count;
        uint32_t tsc_delta;
        uint64_t begin_tsc;
        uint64_t end_tsc;
};

/* Setting up P4 counters */
void Init_P4_Counter(unsigned int configurationCounter, unsigned int configurationCounterValue, unsigned int eventCounter, unsigned int eventCounterValue);
unsigned int Read_P4_Counter(unsigned int counter);
void Clear_P4_Counter(unsigned int counterToClear, unsigned int counterValue);

/* Instrumentation */
void Start_Instrumentation(unsigned int Location);
void End_Instrumentation(unsigned int ForceCount, unsigned int Location);

#endif /* INSTRUMENTATION */

#endif // __VMKERNEL_MODULE__

#endif /* DMAENGINE_H */
