/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

#include <linux/init.h>
#include <linux/module.h>
#include <linux/pci.h>
#include <linux/interrupt.h>
#include <linux/dmaengine.h>
#include "ioat_compat.h"

extern void* kmalloc_align(size_t size, int priority, size_t align);

struct dma_pool*
dma_pool_create(const char *name, struct pci_dev *dev,
                size_t size, size_t align, size_t allocation)
{
   dma_pool *dpool = kmalloc(sizeof(dma_pool), GFP_ATOMIC);

   if (dpool) {
      dpool->blockSize = size;
      dpool->align = align;
      dpool->allocation = allocation;
      dpool->dev = dev;
      dpool->allocatedCount = 0;
   }
   return dpool;
}

void
dma_pool_destroy(struct dma_pool *pool)
{
   printk(KERN_ERR "dma_pool_destroy: allocatedCount: %d\n", pool->allocatedCount);
   kfree(pool);
}

void*
dma_pool_alloc(struct dma_pool *pool, int mem_flags, dma_addr_t *handle)
{
   void *va = kmalloc_align(pool->blockSize, GFP_ATOMIC, pool->align);
   pool->allocatedCount++;

   if (va && handle) {
      *handle = virt_to_bus(va);
   }

   return va;
}

void
dma_pool_free(struct dma_pool *pool, void *vaddr, dma_addr_t dma)
{
#ifdef VMX86_DEBUG
   // XXX: 64 bit printing
   if (virt_to_phys(vaddr) != dma) {
      panic("VA/PA mismatch: VA: 0x%p, PA: 0x%x", vaddr, dma);
   }
#endif
   pool->allocatedCount--;
   kfree(vaddr);
}
