/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

#ifndef _IOAT_COMPAT_H_
#define _IOAT_COMPAT_H_

#include <linux/types.h>

#ifndef PCI_DEVICE
#define PCI_DEVICE(vend,dev) \
           .vendor = (vend), .device = (dev), \
        .subvendor = PCI_ANY_ID, .subdevice = PCI_ANY_ID
#endif

#ifndef IRQ_NONE
typedef int irqreturn_t;
#define IRQ_NONE        (0)
#define IRQ_HANDLED     (1)
#endif

typedef struct dma_pool {
   size_t blockSize;
   size_t align;
   size_t allocation;
   struct pci_dev *dev;
   size_t allocatedCount;
} dma_pool;

struct dma_pool* dma_pool_create(const char *name, struct pci_dev *dev,
                                 size_t size, size_t align, size_t allocation);
void dma_pool_destroy(struct dma_pool *pool);
void* dma_pool_alloc(struct dma_pool *pool, int mem_flags, dma_addr_t *handle);
void dma_pool_free(struct dma_pool *pool, void *vaddr, dma_addr_t dma);

#endif /* _IOAT_COMPAT_H_ */
