/*
   3Com EtherLink 10/100 PCI (3C90x) Linux Network Driver, Copyright (c) 1999
   3Com Corporation. All rights reserved.
   3Com Linux Network Driver software is distributed as is, without any warranty
   of any kind, either express or implied as further specified in the GNU Public
   License. This software may be used and distributed according to the terms of
   the GNU Public License, located in the file LICENSE.

   3Com and EtherLink are registered trademarks of 3Com Corporation. Linux is a
   registered trademarks of Linus Torvalds. 
*/

//#define DEBUG	1
//#define BRIDGEPORT_SUPPORT 1  // 3c9201

#define SERR_NEEDED    1

#ifdef __VMKERNEL_MODULE__
#include "smp_drv.h"
#endif // __VMKERNEL_MODULE__

#include <linux/config.h>

#ifdef __VMKERNEL_MODULE__
#include "linux_skbuff.h"
#endif // __VMKERNEL_MODULE__

#ifdef MODULE
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif
/* don't define kernel_verion in module.h */
#define __NO_VERSION__ 

#include <linux/module.h>
#include <linux/version.h>
#else
#define MOD_INC_USE_COUNT
#define MOD_DEC_USE_COUNT
#endif


#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/ptrace.h>
#include <linux/errno.h>
#include <linux/in.h>
#include <linux/ioport.h>
#include <linux/slab.h>
#include <linux/interrupt.h>
#include <linux/pci.h>
#include <linux/init.h>

#include <linux/timer.h>
#include <asm/irq.h>
#include <asm/bitops.h>
#include <asm/io.h>

#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/tqueue.h>

#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#endif

#if LINUX_VERSION_CODE <= 0x20200
#include <linux/bios32.h>
#endif


/*
 * B NIC Extension support
 */
//#define NICE_SUPPORT 1
#ifdef NICE_SUPPORT
#include "nicext.h"
#endif  /* NICE_SUPPORT */

#if LINUX_VERSION_CODE < 0x10300
#define RUN_AT(x)			(x)
#define DEV_ALLOC_SKB(length)		alloc_skb(length, GFP_ATOMIC)

//#if defined(__alpha)
//#error "The Alpha architecture is only supported with kernel version 2.0."
//#endif

#define virt_to_bus(address)		((ULONG)address)
#define bus_to_virt(address)		((PVOID)address)
#define NR_IRQS                      16

#else

#define RUN_AT(x)			(jiffies + (x))
#define DEV_ALLOC_SKB(length)		dev_alloc_skb(length)

#endif


#if LINUX_VERSION_CODE < 0x20159
#define DEV_FREE_SKB(skb)		dev_kfree_skb(skb, FREE_WRITE);
#else
#define DEV_FREE_SKB(skb)		dev_kfree_skb(skb);
#endif

#if LINUX_VERSION_CODE >= 0x20343
#define DEV_FREE_SKB_IRQ(skb)		dev_kfree_skb_irq(skb);
#endif

#ifdef SA_SHIRQ
#define FREE_IRQ(irqnum, dev)		free_irq(irqnum, dev)
#define REQUEST_IRQ(i,h,f,n,instance)	request_irq(i,h,f,n,instance)
#define IRQ(irq, dev_id, pt_regs)	(irq, dev_id, pt_regs)
#else
#define FREE_IRQ(irqnum, dev)		free_irq(irqnum)
#define REQUEST_IRQ(i,h,f,n,instance)	request_irq(i,h,f,n)
#define IRQ(irq, dev_id, pt_regs)	(irq, pt_regs)
#endif


#if (LINUX_VERSION_CODE >= 0x10344)
#define NEW_MULTICAST
#include <linux/delay.h>
#else
#define udelay(microsec) \
    do { int _i = 4*microsec; while (--_i > 0) { __SLOW_DOWN_IO; }} while (0)
#endif


#if LINUX_VERSION_CODE < 0x20138
#define test_and_set_bit(value, address)  \
    set_bit(value, address)
#endif




#define BIT_0       (1 << 0)
#define BIT_1       (1 << 1)
#define BIT_2       (1 << 2)
#define BIT_3       (1 << 3)
#define BIT_4       (1 << 4)
#define BIT_5       (1 << 5)
#define BIT_6       (1 << 6)
#define BIT_7       (1 << 7)
#define BIT_8       (1 << 8)
#define BIT_9       (1 << 9)
#define BIT_10      (1 << 10)
#define BIT_11      (1 << 11)
#define BIT_12      (1 << 12)
#define BIT_13      (1 << 13)
#define BIT_14      (1 << 14)
#define BIT_15      (1 << 15)
#define BIT_16      (1 << 16)
#define BIT_17      (1 << 17)
#define BIT_18      (1 << 18)
#define BIT_19      (1 << 19)
#define BIT_20      (1 << 20)
#define BIT_21      (1 << 21)
#define BIT_22      (1 << 22)
#define BIT_23      (1 << 23)
#define BIT_24      (1 << 24)
#define BIT_25      (1 << 25)
#define BIT_26      (1 << 26)
#define BIT_27      (1 << 27)
#define BIT_28      (1 << 28)
#define BIT_29      (1 << 29)
#define BIT_30      (1 << 30)
#define BIT_31      (1 << 31)


#ifndef HIBYTE
 
#define HIBYTE(_w) (((USHORT)(_w)) >> 8)

#endif

#ifndef LOBYTE

#define LOBYTE(_w) ((UCHAR)((_w) & 0xFF))

#endif

/* This macro should be written whenever the "virt_to_bus" address 
   doesn't fall within 4MB address limit as 3c90x card accept only
   32 bit addresses.
 */
#define LIMIT_TO_32BIT_ADDR(x) (x)

typedef char *PCHAR;
typedef long LONG;
typedef unsigned long ULONG;
typedef unsigned short USHORT;
typedef unsigned char UCHAR;
typedef void VOID;
typedef char CHAR;
typedef int INT;
typedef unsigned int UINT;
typedef unsigned int* PUINT;
typedef unsigned long *PULONG;
typedef unsigned short *PUSHORT;
typedef unsigned char *PUCHAR;
typedef void *PVOID;
typedef UCHAR BOOLEAN;
typedef BOOLEAN *PBOOLEAN;

/* typedef struct enet_statistics ENET_STATISTICS; */
typedef struct net_device_stats ENET_STATISTICS;
typedef struct dev_mc_list DEV_MC_LIST, *PDEV_MC_LIST;
typedef struct timer_list TIMER;
typedef struct tq_struct TASKQ;

#define FALSE		0
#define TRUE		1

//
// Linux Error code.
//
typedef UINT LINUX_ERROR_CODE;
#define LINUX_ERROR_CODE_OUT_OF_RESOURCES	0x1

#define IN 
#define OUT


/*
 * Typedefs for Linux structures
 */
#if LINUX_VERSION_CODE < 0x20212
typedef ULONG dma_addr_t;
#endif

#if LINUX_VERSION_CODE >= 0x20334
typedef struct net_device *PDEVICE;
typedef struct net_device DEVICE;
#else
typedef struct device *PDEVICE;
typedef struct device DEVICE;
#endif
typedef struct ifreq *PIFREQ;
typedef struct sk_buff *PSKB;
typedef struct pt_regs *PTREGS;
/* typedef struct enet_statistics *PENET_STATISTICS; */
typedef struct net_device_stats *PENET_STATISTICS;





/*
 * 3Com Node Address
 */

#define EEPROM_NODE_ADDRESS_WORD_0		0x00
#define EEPROM_NODE_ADDRESS_WORD_1		0x01
#define EEPROM_NODE_ADDRESS_WORD_2		0x02

#define EEPROM_DEVICE_ID			0x03
/*++

    Possible values:

        0x9055 - PCI 10/100 Mbps; shared 10BASE-T/100BASE-TX connector.
        0x9056 - PCI 10/100 Mbps; shared 10BASE-T/100BASE-T4 connector.
        0x9004 - PCI 10BASE-T (TPO)
        0x9005 - PCI 10BASE-T/10BASE-2/AUI(COMBO)
        0x9006 - PCI 10BASE-T/10BASE-2/(TPC)

--*/
#define EEPROM_MANUFACTURING_DATE		0x04

typedef struct _MANUFACTURING_DATE {

	USHORT Day:5;
        USHORT Month:4;
        USHORT Year:7;

} MANUFACTURING_DATE;

#define EEPROM_MANUFACTURING_DIVISION		0x05
#define EEPROM_MANUFACTURING_PRODUCT_CODE	0x06
#define EEPROM_MANUFACTURING_ID			0x07
#define EEPROM_PCI_PARAMETERS_1			0x08

typedef struct _PCI_PARAMETERS_1 {
    
        USHORT Bit0:1;
        USHORT Lower1Meg:1;
        USHORT DisableMemoryBase:1;
        USHORT D3SupportCold:1;
        USHORT D1Support:1;
        USHORT D2Support:1;
        USHORT MinimumGrant:4;
        USHORT MaximumLatency:6;

} PCI_PARAMETERS_1, *PPCI_PARAMETERS_1;

#define EEPROM_ROM_INFORMATION			0x09

typedef struct _ROM_INFORMATION {

        USHORT Reserved:11;
        USHORT ROMPresent:1;
        //
        // 0x00 - 64k * 8.
        // 0x01 - 128k * 8.
        // 0x1x - Reserved.
        //
        USHORT RomSize:2;

} ROM_INFORMATION, *PROM_INFORMATION;

/*
 * OEM Node address
 */
#define EEPROM_OEM_NODE_ADDRESS_WORD_0		0x0A
#define EEPROM_OEM_NODE_ADDRESS_WORD_1		0x0B
#define EEPROM_OEM_NODE_ADDRESS_WORD_2		0x0C

#define EEPROM_SOFTWARE_INFORMATION_1		0x0D

typedef struct _SOFTWARE_INFORMATION_1 {

        USHORT Reserved1:4;

        #define EEPROM_OPTIMIZE_NORMAL              0x1
        #define EEPROM_OPTIMIZE_FOR_THROUGHPUT      0x2
        #define EEPROM_OPTIMIZE_FOR_CPU             0x3 
        USHORT OptimizeFor:2;
        
        USHORT Reserved2:8;
        USHORT LinkBeatDisable:1;

        #define EEPROM_DISABLE_FULL_DUPLEX          0x00
        #define EEPROM_ENABLE_FULL_DUPLEX           0x01
        USHORT FullDuplexMode:1;

} SOFTWARE_INFORMATION_1, *PSOFTWARE_INFORMATION_1;

#define EEPROM_COMPATABILITY_WORD		0x0E
#define EEPROM_COMPATABILITY_LEVEL		0x00
typedef struct _COMPATABILITY_WORD {

	USHORT WarningLevel:8;
	USHORT FailureLevel:8;

} COMPATABILITY_WORD, *PCOMPATABILITY_WORD;

#define EEPROM_SOFTWARE_INFORMATION_2		0x0F
#define ENABLE_MWI_WORK			0x0020

typedef struct _SOFTWARE_INFORMATION_2 {

        USHORT Reserved1:1;
        USHORT BroadcastRxErrDone:1;
        USHORT EncoderDecoderLoopBackErrDone:1;
        USHORT WOLConnectorPresent:1;
        USHORT PMEPulsed:1;
        USHORT MWIErrDone:1;
        USHORT AutoResetToD0:1;
	USHORT D3Work:1;

} SOFTWARE_INFORMATION_2, *PSOFTWARE_INFORMATION_2;

#define EEPROM_CAPABILITIES_WORD		0x10
typedef struct _CAPABILITIES_WORD {

        USHORT SupportsPlugNPlay:1;
        USHORT SupportsFullDuplex:1;
        USHORT SupportsLargePackets:1;
        USHORT SupportsSlaveDMA:1;
        USHORT SupportsSecondDMA:1;
        USHORT SupportsFullBusMaster:1;
        USHORT SupportsFragBusMaster:1;
        USHORT SupportsCRCPassThrough:1;
        USHORT SupportsTxDone:1;
        USHORT SupportsNoTxLength:1;
        USHORT SupportsRxRepeat:1;
        USHORT Supports100Mbps:1;
        USHORT SupportsPowerManagement:1;

} CAPABILITIES_WORD, *PCAPABILITIES_WORD;

#define EEPROM_RESERVED_LOCATION		0x11
#define EEPROM_INTERNAL_CONFIG_WORD_0		0x12
#define EEPROM_INTERNAL_CONFIG_WORD_1		0x13
#define EEPROM_ANALOG_DIAGNOSTICS		0x14
#define EEPROM_SOFTWARE_INFORMATION_3		0x15

typedef struct _SOFTWARE_INFORMATION_3 {

        #define EEPROM_GENERIC_MII                  0x00
        #define EEPROM_100BASE_T4_MII               0x01
        #define EEPROM_10BASE_T_MII                 0x02         
        #define EEPROM_100BASE_TX_MII               0x03
        #define EEPROM_10_BASE_T_AUTONEGOTIATION    0x04
        #define EEPROM_100_BASE_TX_AUTONEGOTIATION  0x04                  
        USHORT ForceXcvr:4;

        USHORT Reserved:12;

} SOFTWARE_INFORMATION_3, *PSOFTWARE_INFORMATION_3;
/*
 * Locations 0x1E - 0x1F are reserved.
 */
#define EEPROM_CHECKSUM_1			0x20
/*
 * Locations 0x21 - 0x2F are reserved.
 */
#define EEPROM_SOS_PINS_1_TO_4			0x21
#define EEPROM_SOS_PINS_5_TO_7			0x22
/*
 * Locations 0x00 - 0xFD are flexible format locations (4kb EEPROMs)
 */
#define EEPROM_CHECKSUM_2_UPPER			0xFE
#define EEPROM_CHECKSUM_2_LOWER			0xFF
/*
 * Locations 0x00 - 0x3FD are flexible format locations (16Kb EEPROMs)
 */
#define EEPROM_CHECKSUM_3_UPPER                0x3FE
#define EEPROM_CHECKSUM_3_LOWER                0x3FF
#define EEPROM_COMMAND_MASK			0xE000
#define EEPROM_COMMAND_AUTOINIT_DONE		0xE000
#define EEPROM_COMMAND_PCI_CONFIG_WRITE		0xA000
#define EEPROM_COMMAND_REGISTER_WRITE		0x6000
#define EEPROM_COMMAND_TX_FIFO_WRITE		0x2000
#define EEPROM_CURRENT_WINDOW_MASK		0x7000
#define EEPROM_ADDRESS_MASK			0x00FF
#define EEPROM_TX_BYTE_COUNT			0x03FF
#define EEPROM_FLEXIBLE_FORMAT_START		0x40
#define EEPROM_WORD_ACCESS			0x1000
#define MAX_FLEX_EEPROM_SIZE			2048

#define EEPROM_WINDOW_0				(0x0 << 0x8)
#define EEPROM_WINDOW_1				(0x1 << 0x8)
#define EEPROM_WINDOW_2				(0x2 << 0x8)	
#define EEPROM_WINDOW_3				(0x3 << 0x8)
#define EEPROM_WINDOW_4				(0x4 << 0x8)
#define EEPROM_WINDOW_5				(0x5 << 0x8)	
#define EEPROM_WINDOW_6				(0x6 << 0x8)
#define EEPROM_WINDOW_7				(0x7 << 0x8)



typedef struct _PCI_CONFIG_CONFIGURATION_REGISTERS {

    USHORT VendorId;
    USHORT DeviceId;
    USHORT Command;
    USHORT Status;
    UCHAR RevisionId;
    UCHAR ClassCode[3];
    UCHAR CacheLineSize;
    UCHAR LatencyTimer;
    UCHAR HeaderType;
    UCHAR Reserved1;
    UINT IoBaseAddress;
    UINT MemoryBaseAddress;
    UINT Reserved2;
    UINT Reserved3;
    UINT Reserved4;
    UINT Reserved5;
    UINT Reserved6;
    USHORT SubSystemVendorId;
    USHORT SubSystemId;
    UINT BIOSRomControl;
    UCHAR CapabilityPointer;
    UCHAR Reserved7[3];
    UINT Reserved8;
    UCHAR InterruptLine;
    UCHAR InterruptPin;
    UCHAR MinimumGrant;
    UCHAR MaximumLatency;
    UINT Reserved9;
    UINT Reserved10;
    UINT Reserved11;
    UINT Reserved12;
    UCHAR MediaTestModeLow;
    UCHAR Reserved13[3];
    UCHAR MediaTestModeHigh;
    UCHAR Reserved14[3];
    UCHAR MediaTestOutput;
    UCHAR Reserved15[3];
    UCHAR MediaTestPattern;
    UCHAR Reserved16[3];
    UINT Reserved17[31];
    UCHAR CapabilityId;
    UCHAR NextPointer;
    USHORT PowerManagementCapability;
    USHORT PowerManagementControl;
    UCHAR Reserved18;
    UCHAR Data;

} PCI_CONFIG_CONFIGURATION_REGISTERS, *PPCI_CONFIG__CONFIGURATION_REGISTERS;

typedef struct _PCI_CONFIG_COMMAND {

    USHORT IoSpace:1;
    USHORT MemorySpace:1;
    USHORT BusMasterEnable:1;
    USHORT Reserved1:1;
    USHORT MWIEnable:1;
    USHORT Reserved2:1;
    USHORT ParityErrorResponse:1;
    USHORT Reserved3:1;
    USHORT SERREnable:1;

} PCI_CONFIG_COMMAND, *PPCI_CONFIG_COMMAND;


typedef struct _PCI_CONFIG_STATUS {

    USHORT Reserved1:4;
    USHORT CapabilitiesList:1;
    USHORT Reserved2:2;
    USHORT FastBackToBack:1;
    USHORT DmaParityDetected:1;
    USHORT DevselTiming:2;
    USHORT SignalTargetAbort:1;
    USHORT ReceivedTargetAbort:1;
    USHORT ReceivedMasterAbort:1;
    USHORT SignaledSystemError:1;
    USHORT DetectedParityError:1;

} PCI_CONFIG__STATUS, *PPCI_CONFIG_STATUS;

typedef struct _PCI_CONFIG_REVISION_ID {

    UCHAR Revision:5;
    UCHAR ChipVersion:3;

} PCI_CONFIG_REVISION_ID, *PCI_CONFIG_PREVISION_ID;


#define PCI_POWER_CONTROL		0xE0
#define PCI_PME_ENABLE			0x0100
#define PCI_PME_STATUS			0x8000


typedef struct _PCI_CONFIG_POWER_MANAGEMENT_CONTROL {

    #define PCI_POWER_STATE_D0      0x00
    #define PCI_POWER_STATE_D1      0x01
    #define PCI_POWER_STATE_D2      0x02
    #define PCI_POWER_STATE_D3      0x03   
    USHORT PowerState:2;

    USHORT Reserved1:6;
    USHORT PMEEnable:1;
    USHORT DataSelect:4;
    USHORT DataScale:2;
    USHORT PMEStatus:1;

} PCI_CONFIG_POWER_MANAGEMENT_CONTROL, 
 *PPCI_CONFIG_POWER_MANAGEMENT_CONTROL;


//
// Supported PCI device id's
//
#define NIC_VENDOR_ID				0x10B7
#define NIC_PCI_DEVICE_ID_9055			0x9055
#define NIC_PCI_DEVICE_ID_9056			0x9056
#define NIC_PCI_DEVICE_ID_9058			0x9058
#define NIC_PCI_DEVICE_ID_9004			0x9004
#define NIC_PCI_DEVICE_ID_9005			0x9005
#define NIC_PCI_DEVICE_ID_9006			0x9006
#define NIC_PCI_DEVICE_ID_900A			0x900A
#define NIC_PCI_DEVICE_ID_905A			0x905A
#define NIC_PCI_DEVICE_ID_9200			0x9200
#define NIC_PCI_DEVICE_ID_9201			0x9201
#define NIC_PCI_DEVICE_ID_9800			0x9800
#define NIC_PCI_DEVICE_ID_9805			0x9805
#define NIC_PCI_DEVICE_ID_4500			0x4500
#define NIC_PCI_DEVICE_ID_7646			0x7646
//
// ASIC versions.
//
#define NIC_ASIC_CYCLONE_KRAKATOA_LUCENT        0x0
#define NIC_ASIC_HURRICANE_TORNADO_LUCENT       0x1
#define NIC_ASIC_HURRICANE_NATIONAL             0x2
#define NIC_ASIC_HURRICANE_TORNADO_BROADCOM     0x3
//
// Window definitions.
//
#define REGISTER_WINDOW_0		0x0  // setup/configuration
#define REGISTER_WINDOW_1		0x1  // operating set
#define REGISTER_WINDOW_2		0x2  // station address setup/read
#define REGISTER_WINDOW_3		0x3 // FIFO management
#define REGISTER_WINDOW_4		0x4 // diagnostics
#define REGISTER_WINDOW_5		0x5 // registers set by commands
#define REGISTER_WINDOW_6		0x6 // statistics
#define REGISTER_WINDOW_7		0x7 // bus master control
#define REGISTER_WINDOW_MASK		0xE000

//
// ------------------ Register definitions ---------------------
//
#define INTSTATUS_INTERRUPT_MASK	0x6EE  
//
// Window 0 registers.
//

#define BIOS_ROM_ADDRESS_REGISTER	0x4
#define BIOS_ROM_DATA_REGISTER		0x8

#define EEPROM_COMMAND_REGISTER		0xA
#define EEPROM_BUSY_BIT			BIT_15
#define EEPROM_COMMAND_READ		0x0080   
#define EEPROM_WRITE_ENABLE		0x0030
#define EEPROM_ERASE_REGISTER		0x00C0
#define EEPROM_WRITE_REGISTER		0x0040

#define EEPROM_DATA_REGISTER		0xC

#define INTSTATUS_COMMAND_REGISTER	0xE
#define INTSTATUS_INTERRUPT_LATCH	BIT_0
#define INTSTATUS_HOST_ERROR		BIT_1
#define INTSTATUS_TX_COMPLETE		BIT_2
#define INTSTATUS_RX_COMPLETE		BIT_4
#define INTSTATUS_INTERRUPT_REQUESTED	BIT_6
#define INTSTATUS_UPDATE_STATISTICS	BIT_7
#define INTSTATUS_LINK_EVENT		BIT_8
#define INTSTATUS_DOWN_COMPLETE		BIT_9
#define INTSTATUS_UP_COMPLETE		BIT_10
#define INTSTATUS_COMMAND_IN_PROGRESS	BIT_12
#define INTSTATUS_INTERRUPT_NONE	0
#define INTSTATUS_INTERRUPT_ALL		0x6EE  
#define INTSTATUS_ACKNOWLEDGE_ALL	0x7FF


//
// Window 2 registers.
//
#define STATION_ADDRESS_LOW_REGISTER		0x0
#define STATION_ADDRESS_MID_REGISTER		0x2
#define STATION_ADDRESS_HIGH_REGISTER		0x4

//
// Window 3 registers.
//

#define INTERNAL_CONFIG_REGISTER		0x0
#define INTERNAL_CONFIG_DISABLE_BAD_SSD		BIT_8
#define INTERNAL_CONFIG_ENABLE_TX_LARGE		BIT_14
#define INTERNAL_CONFIG_ENABLE_RX_LARGE		BIT_15
#define INTERNAL_CONFIG_AUTO_SELECT		BIT_24
#define INTERNAL_CONFIG_DISABLE_ROM		BIT_25
#define INTERNAL_CONFIG_TRANSCEIVER_MASK	0x00F00000

#define MAXIMUM_PACKET_SIZE_REGISTER		0x4

#define MAC_CONTROL_REGISTER			0x6
#define MAC_CONTROL_FULL_DUPLEX_ENABLE		BIT_5
#define MAC_CONTROL_ALLOW_LARGE_PACKETS		BIT_6
#define MAC_CONTROL_FLOW_CONTROL_ENABLE 	BIT_8
#define MEDIA_OPTIONS_REGISTER			0x8
#define MEDIA_OPTIONS_100BASET4_AVAILABLE	BIT_0
#define MEDIA_OPTIONS_100BASETX_AVAILABLE	BIT_1
#define MEDIA_OPTIONS_100BASEFX_AVAILABLE	BIT_2
#define MEDIA_OPTIONS_10BASET_AVAILABLE		BIT_3
#define MEDIA_OPTIONS_10BASE2_AVAILABLE		BIT_4
#define MEDIA_OPTIONS_10AUI_AVAILABLE		BIT_5
#define MEDIA_OPTIONS_MII_AVAILABLE		BIT_6
#define MEDIA_OPTIONS_10BASEFL_AVAILABLE	BIT_8

#define RX_FREE_REGISTER			0xA
#define TX_FREE_REGISTER			0xC

//
// Window 4 registers.
//
#define PHYSICAL_MANAGEMENT_REGISTER		0x8
#define NETWORK_DIAGNOSTICS_REGISTER		0x6
#define NETWORK_DIAGNOSTICS_ASIC_REVISION	0x003E
#define NETWORK_DIAGNOSTICS_ASIC_REVISION_LOW  	0x000E 
#define NETWORK_DIAGNOSTICS_UPPER_BYTES_ENABLE 	BIT_6
#define MEDIA_STATUS_REGISTER				0xA
#define MEDIA_STATUS_SQE_STATISTICS_ENABLE	BIT_3
#define MEDIA_STATUS_CARRIER_SENSE		BIT_5
#define MEDIA_STATUS_JABBER_GUARD_ENABLE	BIT_6
#define MEDIA_STATUS_LINK_BEAT_ENABLE		BIT_7
#define MEDIA_STATUS_LINK_DETECT		BIT_11
#define MEDIA_STATUS_TX_IN_PROGRESS		BIT_12
#define MEDIA_STATUS_DC_CONVERTER_ENABLED	BIT_14
#define BAD_SSD_REGISTER			0xC
#define UPPER_BYTES_OK_REGISTER			0xD
//
// Window 5 registers.
//
#define RX_FILTER_REGISTER		0x8
#define INTERRUPT_ENABLE_REGISTER	0xA
#define INDICATION_ENABLE_REGISTER	0xC
//
// Window 6 registers.
//
#define CARRIER_LOST_REGISTER		0x0
#define SQE_ERRORS_REGISTER		0x1
#define MULTIPLE_COLLISIONS_REGISTER	0x2
#define SINGLE_COLLISIONS_REGISTER	0x3
#define LATE_COLLISIONS_REGISTER	0x4
#define RX_OVERRUNS_REGISTER		0x5
#define FRAMES_TRANSMITTED_OK_REGISTER	0x6
#define FRAMES_RECEIVED_OK_REGISTER	0x7
#define FRAMES_DEFERRED_REGISTER	0x8
#define UPPER_FRAMES_OK_REGISTER	0x9
#define BYTES_RECEIVED_OK_REGISTER	0xA
#define BYTES_TRANSMITTED_OK_REGISTER	0xC
//
// Window 7 registers.
//
#define TIMER_REGISTER			0x1A
#define TX_STATUS_REGISTER		0x1B
#define TX_STATUS_MAXIMUM_COLLISION	BIT_3
#define TX_STATUS_HWERROR		BIT_4
#define TX_STATUS_JABBER		BIT_5
#define TX_STATUS_INTERRUPT_REQUESTED	BIT_6
#define TX_STATUS_COMPLETE		BIT_7
#define INT_STATUS_AUTO_REGISTER	0x1E
#define DMA_CONTROL_REGISTER		0x20
#define DMA_CONTROL_DOWN_STALLED	BIT_2
#define DMA_CONTROL_UP_COMPLETE		BIT_3
#define DMA_CONTROL_DOWN_COMPLETE	BIT_4

#define DMA_CONTROL_ARM_COUNTDOWN       BIT_6
#define DMA_CONTROL_DOWN_IN_PROGRESS    BIT_7
#define DMA_CONTROL_COUNTER_SPEED       BIT_8
#define DMA_CONTROL_COUNTDOWN_MODE      BIT_9
#define DMA_CONTROL_DOWN_SEQ_DISABLE    BIT_17
#define DMA_CONTROL_DEFEAT_MWI          BIT_20
#define DMA_CONTROL_DEFEAT_MRL          BIT_21
#define DMA_CONTROL_UPOVERDISC_DISABLE	BIT_22
#define DMA_CONTROL_TARGET_ABORT        BIT_30
#define DMA_CONTROL_MASTER_ABORT        BIT_31

#define DOWN_LIST_POINTER_REGISTER	0x24
#define DOWN_POLL_REGISTER		0x2D
#define UP_PACKET_STATUS_REGISTER		0x30
#define UP_PACKET_STATUS_ERROR			BIT_14
#define UP_PACKET_STATUS_COMPLETE		BIT_15
#define UP_PACKET_STATUS_OVERRUN		BIT_16
#define UP_PACKET_STATUS_RUNT_FRAME		BIT_17
#define UP_PACKET_STATUS_ALIGNMENT_ERROR	BIT_18
#define UP_PACKET_STATUS_CRC_ERROR             	BIT_19
#define UP_PACKET_STATUS_OVERSIZE_FRAME        	BIT_20
#define UP_PACKET_STATUS_DRIBBLE_BITS		BIT_23
#define UP_PACKET_STATUS_OVERFLOW		BIT_24
#define UP_PACKET_STATUS_IP_CHECKSUM_ERROR	BIT_25
#define UP_PACKET_STATUS_TCP_CHECKSUM_ERROR	BIT_26
#define UP_PACKET_STATUS_UDP_CHECKSUM_ERROR	BIT_27
#define UP_PACKET_STATUS_IMPLIED_BUFFER_ENABLE	BIT_28
#define UP_PACKET_STATUS_IP_CHECKSUM_CHECKED	BIT_29
#define UP_PACKET_STATUS_TCP_CHECKSUM_CHECKED	BIT_30
#define UP_PACKET_STATUS_UDP_CHECKSUM_CHECKED	BIT_31
#define UP_PACKET_STATUS_ERROR_MASK		0x1F0000
#define FREE_TIMER_REGISTER			0x34
#define COUNTDOWN_REGISTER			0x36
#define UP_LIST_POINTER_REGISTER		0x38
#define UP_POLL_REGISTER			0x3D
#define REAL_TIME_COUNTER_REGISTER		0x40
#define CONFIG_ADDRESS_REGISTER			0x44
#define CONFIG_DATA_REGISTER			0x48
#define DEBUG_DATA_REGISTER			0x70
#define DEBUG_CONTROL_REGISTER			0x74
// ------------------ Commands ---------------------------------
//
// Global reset command.
//

#define COMMAND_GLOBAL_RESET		(0x0 << 0xB)
#define GLOBAL_RESET_MASK_TP_AUI_RESET	BIT_0
#define GLOBAL_RESET_MASK_ENDEC_RESET   BIT_1
#define GLOBAL_RESET_MASK_NETWORK_RESET	BIT_2
#define GLOBAL_RESET_MASK_FIFO_RESET    BIT_3
#define GLOBAL_RESET_MASK_AISM_RESET    BIT_4
#define GLOBAL_RESET_MASK_HOST_RESET	BIT_5
#define GLOBAL_RESET_MASK_SMB_RESET     BIT_6
#define GLOBAL_RESET_MASK_VCO_RESET     BIT_7
#define GLOBAL_RESET_MASK_UP_DOWN_RESET BIT_8

#define COMMAND_SELECT_REGISTER_WINDOW	(0x1 << 0xB)
#define COMMAND_ENABLE_DC_CONVERTER	(0x2 << 0xB)
#define COMMAND_RX_DISABLE		(0x3 << 0xB)
#define COMMAND_RX_ENABLE		(0x4 << 0xB)
//
// Receiver reset command.
//
#define COMMAND_RX_RESET		(0x5 << 0xB)
#define RX_RESET_MASK_TP_AUI_RESET	BIT_0
#define RX_RESET_MASK_ENDEC_RESET	BIT_1
#define RX_RESET_MASK_NETWORK_RESET	BIT_2
#define RX_RESET_MASK_FIFO_RESET	BIT_3
#define RX_RESET_MASK_UP_RESET		BIT_8

#define COMMAND_UP_STALL		((0x6 << 0xB) | 0x0)
#define COMMAND_UP_UNSTALL		((0x6 << 0xB) | 0x1)
#define COMMAND_DOWN_STALL		((0x6 << 0xB) | 0x2)
#define COMMAND_DOWN_UNSTALL		((0x6 << 0xB) | 0x3)
#define COMMAND_TX_DONE			(0x7 << 0xB)
#define COMMAND_RX_DISCARD		(0x8 << 0xB)
#define COMMAND_TX_ENABLE		(0x9 << 0xB)
#define COMMAND_TX_DISABLE		(0xA << 0xB)
//
// Transmitter reset command.
//
#define COMMAND_TX_RESET		(0xB << 0xB) 
#define TX_RESET_MASK_TP_AUI_RESET	BIT_0
#define TX_RESET_MASK_ENDEC_RESET	BIT_1
#define TX_RESET_MASK_NETWORK_RESET	BIT_2
#define TX_RESET_MASK_FIFO_RESET	BIT_3
#define TX_RESET_MASK_DOWN_RESET	BIT_8
#define COMMAND_REQUEST_INTERRUPT	(0xC << 0xB)
//
// Interrupt acknowledge command.
//

#define COMMAND_ACKNOWLEDGE_INTERRUPT	(0xD << 0xB)
#define ACKNOWLEDGE_INTERRUPT_LATCH	BIT_0
#define ACKNOWLEDGE_LINK_EVENT		BIT_1
#define ACKNOWLEDGE_INTERRUPT_REQUESTED	BIT_6
#define ACKNOWLEDGE_DOWN_COMPLETE	BIT_9
#define ACKNOWLEDGE_UP_COMPLETE		BIT_10
#define ACKNOWLEDGE_ALL_INTERRUPT	0x7FF   
#define COMMAND_SET_INTERRUPT_ENABLE	(0xE << 0xB)
#define DISABLE_ALL_INTERRUPT		0x0 
#define ENABLE_ALL_INTERRUPT		0x6EE 
#define COMMAND_SET_INDICATION_ENABLE	(0xF << 0xB)
//
// Receive filter command.
//
#define COMMAND_SET_RX_FILTER		(0x10 << 0xB)
#define RX_FILTER_INDIVIDUAL            BIT_0
#define RX_FILTER_ALL_MULTICAST         BIT_1
#define RX_FILTER_BROADCAST             BIT_2
#define RX_FILTER_PROMISCUOUS           BIT_3
#define RX_FILTER_MULTICAST_HASH        BIT_4
#define COMMAND_TX_AGAIN		(0x13 << 0xB)
#define COMMAND_STATISTICS_ENABLE	(0x15 << 0xB)
#define COMMAND_STATISTICS_DISABLE	(0x16 << 0xB)
#define COMMAND_DISABLE_DC_CONVERTER	(0x17 << 0xB)
#define COMMAND_SET_HASH_FILTER_BIT	(0x19 << 0xB)
#define COMMAND_TX_FIFO_BISECT		(0x1B << 0xB)
//
// ------------------ Adapter limits ---------------------------
//
#define TRANSMIT_FIFO_SIZE         0x800
#define RECEIVE_FIFO_SIZE          0x800
//
// Ethernet limits.
//
#define ETHERNET_MAXIMUM_FRAME_SIZE	1514
#define ETHERNET_MINIMUM_FRAME_SIZE	60
#define ETHERNET_ADDRESS_SIZE		6
#define ETHERNET_HEADER_SIZE		14
//
// Flow Control Address that gets put into the hash filter for 
// flow control enable
//
#define NIC_FLOW_CONTROL_ADDRESS_0	0x01
#define NIC_FLOW_CONTROL_ADDRESS_1	0x80
#define NIC_FLOW_CONTROL_ADDRESS_2	0xC2
#define NIC_FLOW_CONTROL_ADDRESS_3	0x00
#define NIC_FLOW_CONTROL_ADDRESS_4	0x00
#define NIC_FLOW_CONTROL_ADDRESS_5	0x01
//
// DPD Frame Start header bit definitions.
//
#define FSH_CRC_APPEND_DISABLE		BIT_13
#define FSH_TX_INDICATE			BIT_15
#define FSH_DOWN_COMPLETE		BIT_16
#define FSH_LAST_KEEP_ALIVE_PACKET	BIT_24
#define FSH_ADD_IP_CHECKSUM		BIT_25
#define FSH_ADD_TCP_CHECKSUM		BIT_26
#define FSH_ADD_UDP_CHECKSUM		BIT_27
#define FSH_ROUND_UP_DEFEAT		BIT_28
#define FSH_DPD_EMPTY			BIT_29
#define FSH_DOWN_INDICATE		BIT_31
#define MAXIMUM_SCATTER_GATHER_LIST     0x10
//
// Scatter Gather entry defintion.
//
typedef struct _SCATTER_GATHER_ENTRY {

    UINT Address;
    UINT Count;

} SCATTER_GATHER_ENTRY, *PSCATTER_GATHER_ENTRY;


typedef struct _DPD_LIST_ENTRY {
	UINT DownNextPointer;
	UINT FrameStartHeader;
	SCATTER_GATHER_ENTRY SGList[MAXIMUM_SCATTER_GATHER_LIST];
	struct _DPD_LIST_ENTRY *Next;
	struct _DPD_LIST_ENTRY *Previous;
	UINT DPDPhysicalAddress;
	PSKB SocketBuffer;
	UINT PacketLength;

} DPD_LIST_ENTRY, *PDPD_LIST_ENTRY;


typedef struct _UPD_LIST_ENTRY {
	UINT UpNextPointer;
	UINT UpPacketStatus;
	SCATTER_GATHER_ENTRY SGList[1];
	struct _UPD_LIST_ENTRY *Next;
	struct _UPD_LIST_ENTRY *Previous;
	UINT UPDPhysicalAddress;
	PUCHAR RxBufferVirtual;
	PSKB SocketBuffer;
} UPD_LIST_ENTRY, *PUPD_LIST_ENTRY;
//
// Connector Type
//
typedef enum _CONNECTOR_TYPE {

	CONNECTOR_10BASET = 0,
	CONNECTOR_10AUI = 1,
	CONNECTOR_10BASE2 = 3,
	CONNECTOR_100BASETX = 4,
	CONNECTOR_100BASEFX = 5,
	CONNECTOR_MII = 6,
	CONNECTOR_AUTONEGOTIATION = 8,
	CONNECTOR_EXTERNAL_MII = 9,
	CONNECTOR_UNKNOWN = 0xFF

} CONNECTOR_TYPE, *PCONNECTOR_TYPE;

typedef enum _LINK_STATE {

    LINK_UP				= 0, // Link established
    LINK_DOWN			= 1, // Link lost
    LINK_DOWN_AT_INIT	= 2	 // Link lost and needs notification to NDIS

} LINK_STATE;

typedef struct _NIC_PCI_INFORMATION {
	INT InterruptVector;
	ULONG IoBaseAddress;

} NIC_PCI_INFORMATION;


typedef struct _NIC_HARDWARE_INFORMATION {

	UCHAR CacheLineSize;
	UCHAR RevisionId;
	UCHAR Status;
#define HARDWARE_STATUS_WORKING		0x0
#define HARDWARE_STATUS_HUNG		0x1    
#define HARDWARE_STATUS_FAILURE		0x2

	USHORT XcvrType;
	USHORT DeviceId;
	UINT BitsInHashFilter;
	UINT LinkSpeed;
	UINT UpdateInterval;

	CONNECTOR_TYPE Connector;			 
	CONNECTOR_TYPE ConfigConnector;    

	BOOLEAN HurricaneEarlyRevision;
	UCHAR FeatureSet;
	#define MOTHERBOARD_FEATURE_SET         0x0
	#define LOW_COST_ADAPTER_FEATURE_SET    0x1
	#define STANDARD_ADAPTER_FEATURE_SET    0x2
	#define SERVER_ADAPTER_FEATURE_SET      0x4

	BOOLEAN OptimizeForThroughput;
	BOOLEAN OptimizeForCPU;
	BOOLEAN OptimizeNormal;

	BOOLEAN BroadcastErrDone;
	BOOLEAN UDPChecksumErrDone;
	BOOLEAN FullDuplexEnable;
	BOOLEAN DuplexCommandOverride;

	BOOLEAN MWIErrDone;
	BOOLEAN FlowControlEnable;
	BOOLEAN FlowControlSupported;
	BOOLEAN LinkBeatDisable;

	BOOLEAN SupportsPowerManagement;
	BOOLEAN WOLConnectorPresent;
	BOOLEAN AutoResetToD0;
	BOOLEAN	DontSleep;
	BOOLEAN D3Work;

	BOOLEAN WakeOnMagicPacket;
	BOOLEAN WakeOnLinkChange;

	BOOLEAN SQEDisable;
	BOOLEAN AutoSelect;
	BOOLEAN LightTen;
	LINK_STATE LinkState;
	//
	// TryMII sets these parameters.
	//
	USHORT MIIReadCommand;
	USHORT MIIWriteCommand;
	USHORT MIIPhyOui;
	USHORT MIIPhyModel;
	USHORT MIIPhyUsed;
	USHORT MediaOverride;

	USHORT phys;	/* MII device addr. - for Becker's diag */

} NIC_HARDWARE_INFORMATION , *PNIC_HARDWARE_INFORMATION;
//
// Command line media override values
//
#define MEDIA_NONE			0
#define MEDIA_10BASE_T			1
#define MEDIA_10AUI			2
#define MEDIA_10BASE_2			3
#define MEDIA_100BASE_TX		4
#define MEDIA_100BASE_FX		5
#define MEDIA_10BASE_FL			6
#define MEDIA_AUTO_SELECT		7


#define MII_PHY_ADDRESS				0x0C00

//
//--------------------- MII register definitions --------------------
//
#define MII_PHY_CONTROL			0   // control reg address
#define MII_PHY_STATUS              	1   // status reg address
#define MII_PHY_OUI                 	2   // most of the OUI bits
#define MII_PHY_MODEL               	3   // model/rev bits, and rest of OUI
#define MII_PHY_ANAR                	4   // Auto negotiate advertisement reg
#define MII_PHY_ANLPAR              	5   // auto negotiate Link Partner
#define MII_PHY_ANER                	0x6
#define MII_PAR                     	0x19
#define MII_PCR                     	0x17 // PCS Config register

#define MII_PHY_REGISTER_24		24   // Register 24 of the MII
#define MII_PHY_REGISTER_24_PVCIRC	0x01 // Process Variation Circuit bit

//
//--------------------- Bit definitions: Physical Management --------------------
//
#define PHY_WRITE			0x0004  // Write to PHY (drive MDIO)
#define PHY_DATA1			0x0002  // MDIO data bit
#define PHY_CLOCK			0x0001  // MII clock signal

//
//--------------------- Bit definitions: MII Control --------------------
//
#define MII_CONTROL_RESET		0x8000  // reset bit in control reg
#define MII_CONTROL_100MB		0x2000  // 100Mbit or 10 Mbit flag
#define MII_CONTROL_ENABLE_AUTO		0x1000  // autonegotiate enable
#define MII_CONTROL_ISOLATE		0x0400  // islolate bit
#define MII_CONTROL_START_AUTO		0x0200  // restart autonegotiate
#define MII_CONTROL_FULL_DUPLEX		0x0100


//
//--------------------- Bit definitions: MII Status --------------------
//
#define MII_STATUS_100MB_MASK	0xE000  // any of these indicate 100 Mbit
#define MII_STATUS_10MB_MASK	0x1800  // either of these indicate 10 Mbit
#define MII_STATUS_AUTO_DONE	0x0020  // auto negotiation complete
#define MII_STATUS_AUTO		0x0008  // auto negotiation is available
#define MII_STATUS_LINK_UP	0x0004  // link status bit
#define MII_STATUS_EXTENDED	0x0001  // extended regs exist
#define MII_STATUS_100T4	0x8000  // capable of 100BT4
#define MII_STATUS_100TXFD	0x4000  // capable of 100BTX full duplex
#define MII_STATUS_100TX	0x2000  // capable of 100BTX
#define MII_STATUS_10TFD	0x1000  // capable of 10BT full duplex
#define MII_STATUS_10T		0x0800  // capable of 10BT


//
//----------- Bit definitions: Auto-Negotiation Link Partner Ability ----------
//
#define MII_ANLPAR_100T4	0x0200  // support 100BT4
#define MII_ANLPAR_100TXFD	0x0100  // support 100BTX full duplex
#define MII_ANLPAR_100TX	0x0080  // support 100BTX half duplex
#define MII_ANLPAR_10TFD	0x0040  // support 10BT full duplex
#define MII_ANLPAR_10T		0x0020  // support 10BT half duplex

//
//----------- Bit definitions: Auto-Negotiation Advertisement ----------
//
#define MII_ANAR_100T4		0x0200  // support 100BT4
#define MII_ANAR_100TXFD	0x0100  // support 100BTX full duplex
#define MII_ANAR_100TX		0x0080  // support 100BTX half duplex
#define MII_ANAR_10TFD		0x0040  // support 10BT full duplex
#define MII_ANAR_10T		0x0020  // support 10BT half duplex
#define MII_ANAR_FLOWCONTROL	0x0400  // support Flow Control

#define MII_ANAR_MEDIA_MASK		0x07E0	// Mask the media selection bits
#define MII_ANAR_MEDIA_100_MASK	(MII_ANAR_100TXFD | MII_ANAR_100TX)
#define MII_ANAR_MEDIA_10_MASK	(MII_ANAR_10TFD | MII_ANAR_10T)

#define MII_100TXFD		0x01
#define MII_100T4		0x02
#define MII_100TX		0x03
#define MII_10TFD		0x04
#define MII_10T			0x05

//
//----------- Bit definitions: Auto-Negotiation Expansion ----------
//
#define MII_ANER_LPANABLE	0x0001  // Link partner autonegotiatable ?
#define MII_ANER_MLF		0x0010  // Multiple Link Fault bit

//
// MII Transceiver Type store in miiSelect
//
#define MIISELECT_GENERIC	0x0000
#define MIISELECT_100BT4	0x0001
#define MIISELECT_10BT		0x0002
#define MIISELECT_100BTX	0x0003
#define MIISELECT_10BT_ANE	0x0004
#define MIISELECT_100BTX_ANE	0x0005
#define MIITXTYPE_MASK		0x000F
									 



#define NIC_STATUS UINT

#define NIC_STATUS_SUCCESS		0x1
#define NIC_STATUS_FAILURE		0x2

//
// Software limits defined here.
//
#define NIC_DEFAULT_SEND_COUNT		0x40
#define NIC_DEFAULT_RECEIVE_COUNT	0x40
#define NIC_MINIMUM_SEND_COUNT		0x2
#define NIC_MAXIMUM_SEND_COUNT		0x80
#define NIC_MINIMUM_RECEIVE_COUNT	0x2
#define NIC_MAXIMUM_RECEIVE_COUNT	0x80

#define LINK_SPEED_100			100000000L
#define LINK_SPEED_10			10000000L

#define ETH_ADDR_SIZE		6
#define ETH_MULTICAST_BIT	1

typedef struct _ETH_ADDR {
	UCHAR	Addr[ETH_ADDR_SIZE];
} ETH_ADDR, *PETH_ADDR;

typedef struct _NIC_RESOURCES {

	UINT ReceiveCount;
	UINT SendCount;
	UINT SharedMemorySize;
	PUCHAR SharedMemoryVirtual;
	VOID *SharedMemoryPhysical;
	TIMER Timer;
	TASKQ hostErr_task;
	ULONG TimerInterval;
	UINT DownPollRate;

} NIC_RESOURCES, *PNIC_RESOURCES;

//
// Statistics maintained by the driver.
//


typedef struct _NIC_STATISTICS {

	//
	// Transmit statistics.
	//
	ULONG TxFramesOk;
	ULONG TxBytesOk;
	ULONG TxFramesDeferred;
	ULONG TxSingleCollisions;
	ULONG TxMultipleCollisions;
	ULONG TxLateCollisions;
	ULONG TxCarrierLost;

	ULONG TxMaximumCollisions;
	ULONG TxSQEErrors;
	ULONG TxHWErrors;
	ULONG TxJabberError; 
	ULONG TxUnknownError;

	ULONG TxLastPackets;
	ULONG TxLastCollisions;
	ULONG TxLastDeferred;

	//
	// Receive statistics.
	//
	ULONG RxFramesOk;
	ULONG RxBytesOk;

	ULONG RxOverruns;
	ULONG RxBadSSD;
	ULONG RxAlignmentError;
	ULONG RxBadCRCError;
	ULONG RxOversizeError;

	ULONG RxNoBuffer;

	ULONG RxLastPackets;
	ULONG UpdateInterval;

	//
	// Multicasts statistics
	//
	ULONG Rx_MulticastPkts;

} NIC_STATISTICS, *PNIC_STATISTICS;
//
// Memory allocation
//
#define NIC_IO_PORT_REGISTERED			0x00000001
#define NIC_INTERRUPT_REGISTERED		0x00000002
#define NIC_SHARED_MEMORY_ALLOCATED		0x00000004
#define WAIT_TIMER_REGISTERED			0x00000008
#define NIC_TIMER_REGISTERED			0x00000010

#define MAXIMUM_TEST_BUFFERS			1
//
// This queue maintains the pending packets.
// 
typedef struct _PACKET_PENDING_QUEUE {

    PSKB Head;
    PSKB Tail;

} PACKET_PENDING_QUEUE;

typedef enum _NIC_WAIT_CASES {

    	CHECK_UPLOAD_STATUS,
    	CHECK_DOWNLOAD_STATUS,
	CHECK_DC_CONVERTER,
	CHECK_PHY_STATUS,
	CHECK_TRANSMIT_IN_PROGRESS,
	CHECK_DOWNLOAD_SELFDIRECTED,
	AUTONEG_TEST_PACKET,
	CHECK_DMA_CONTROL,
	CHECK_CARRIER_SENSE,
	NONE
} NIC_WAIT_CASES;


typedef struct _NIC_INFORMATION {

	ULONG IoBaseAddress;
	UCHAR DeviceName[8];
	UCHAR PermanentAddress[6];
	UCHAR StationAddress[6];
	UINT ResourcesReserved;
	NIC_PCI_INFORMATION PCI;

	PUPD_LIST_ENTRY HeadUPDVirtual;
    	PDPD_LIST_ENTRY HeadDPDVirtual;
	PDPD_LIST_ENTRY TailDPDVirtual;

    	ULONG TestDPDVirtual[MAXIMUM_TEST_BUFFERS];
	ULONG TestDPDPhysical[MAXIMUM_TEST_BUFFERS];
	ULONG TestBufferVirtual[MAXIMUM_TEST_BUFFERS];
	ULONG TestBufferPhysical[MAXIMUM_TEST_BUFFERS];

	NIC_RESOURCES Resources;
	NIC_STATISTICS Statistics;
	ENET_STATISTICS EnetStatistics;
	NIC_HARDWARE_INFORMATION Hardware;
	UINT BytesInDPDQueue;
	PDEVICE NextDevice;
	PDEVICE Device;
	BOOLEAN InTimer;
	BOOLEAN DelayStart;
	INT Index;
	PACKET_PENDING_QUEUE PendingQueue;
   	UINT TxPendingQueueCount;
#if LINUX_VERSION_CODE >= 0x20200
	spinlock_t SpinLock_m;
	spinlock_t SpinLock_misc;
	spinlock_t SpinLock_send;
	spinlock_t SpinLock_int;
#endif
	BOOLEAN DPDRingFull;
	BOOLEAN DeviceGivenByOS;

	UINT keepForGlobalReset;	
	NIC_WAIT_CASES WaitCases;
#if LINUX_VERSION_CODE >= 0x20343
        UCHAR start;
        /*UCHAR interrupt; */
        UINT txing;
	struct pci_dev* pciDevice;
#endif

#ifdef NICE_SUPPORT
	void (*nice_rx)( struct sk_buff*, void* );
	void* nice_ctx;
#endif  /* NICE_SUPPORT */

#ifdef __VMKERNEL_MODULE__
   BOOLEAN intr_enabled;
#endif // __VMKERNEL_MODULE__
} NIC_INFORMATION, *PNIC_INFORMATION;

#define TX_TIMEOUT ((400*HZ)/1000)






#ifndef LOBYTE
#define LOBYTE(_w) ((UCHAR)((_w) & 0xFF))
#endif

#ifndef HIBYTE
#define HIBYTE(_w) (((USHORT)(_w)) >> 8)
#endif


#ifndef LOWORD
#define LOWORD(_d) ((USHORT)((_d) & 0xFFFF))
#endif

#ifndef HIWORD
#define HIWORD(_d) (((UINT)(_d)) >> 16)
#endif


#define NIC_READ_PORT_UCHAR(pAdapter, Register) \
	inb(pAdapter->IoBaseAddress + Register)

#define NIC_READ_PORT_USHORT(pAdapter, Register) \
	inw(pAdapter->IoBaseAddress + Register)
 
#define NIC_READ_PORT_UINT(pAdapter, Register) \
	inl(pAdapter->IoBaseAddress + Register)

#define NIC_WRITE_PORT_UCHAR(pAdapter, Register, Value) \
	outb(Value, pAdapter->IoBaseAddress + Register)

#define NIC_WRITE_PORT_USHORT(pAdapter, Register, Value) \
	outw(Value, pAdapter->IoBaseAddress + Register)
 
#define NIC_WRITE_PORT_UINT(pAdapter, Register, Value) \
	outl(Value, pAdapter->IoBaseAddress + Register)

#define NIC_COMMAND(pAdapter, Command) \
	NIC_WRITE_PORT_USHORT(pAdapter, INTSTATUS_COMMAND_REGISTER, Command)

#define NIC_MASK_ALL_INTERRUPT(pAdapter) { \
	NIC_COMMAND( \
        	pAdapter, \
		COMMAND_SET_INTERRUPT_ENABLE | DISABLE_ALL_INTERRUPT \
		); \
	NIC_READ_PORT_USHORT(pAdapter, INTSTATUS_COMMAND_REGISTER); \
}

#ifdef __VMKERNEL_MODULE__
static void inline NIC_UNMASK_ALL_INTERRUPT(PNIC_INFORMATION pAdapter)
{
   if (pAdapter->intr_enabled) {
      NIC_COMMAND(pAdapter, COMMAND_SET_INTERRUPT_ENABLE | ENABLE_ALL_INTERRUPT);
      NIC_READ_PORT_USHORT(pAdapter, INTSTATUS_COMMAND_REGISTER);
   }
}
#else // ! __VMKERNEL_MODULE__
#define NIC_UNMASK_ALL_INTERRUPT(pAdapter){ \
	NIC_COMMAND( \
		pAdapter, \
		COMMAND_SET_INTERRUPT_ENABLE | ENABLE_ALL_INTERRUPT \
	); \
	NIC_READ_PORT_USHORT(pAdapter, INTSTATUS_COMMAND_REGISTER); \
}
#endif
                
#define NIC_ACKNOWLEDGE_ALL_INTERRUPT(pAdapter) \
	NIC_COMMAND( \
		pAdapter, \
		COMMAND_ACKNOWLEDGE_INTERRUPT | ACKNOWLEDGE_ALL_INTERRUPT \
		)

#define NIC_ENABLE_ALL_INTERRUPT_INDICATION(pAdapter) \
	NIC_COMMAND( \
		pAdapter, \
		COMMAND_SET_INDICATION_ENABLE | ENABLE_ALL_INTERRUPT \
		)

#define NIC_DISABLE_ALL_INTERRUPT_INDICATION(pAdapter) \
	NIC_COMMAND( \
		pAdapter, \
		COMMAND_SET_INDICATION_ENABLE | DISABLE_ALL_INTERRUPT \
		)

#define COMPARE_MACS(pAddr1, pAddr2) \
	( *((PUINT)((PUCHAR)(pAddr1)+2)) == *((PUINT)((PUCHAR)(pAddr2)+2)) && \
	  *((PUINT)(pAddr1)) == *((PUINT)(pAddr2))) 

#define NIC_DELAY(A)		udelay(A)

#define MIN(A, B) ((A) < (B) ? (A) : (B))
#define MAX(A, B) ((A) > (B) ? (A) : (B))


#ifdef DEBUG
extern UINT debug;
#endif

#define DEBUG_INITIALIZE	0x00000001
#define DEBUG_FUNCTION		0x00000002
#define DEBUG_IOCTL		0x00000004
#define DEBUG_GET_STATISTICS	0x00000008
#define DEBUG_SEND		0x00000010
#define DEBUG_RECEIVE		0x00000020
#define DEBUG_INTERRUPT		0x00000040
#define DEBUG_ERROR		0x80000000

#ifdef DEBUG

#define DBGPRINT_INITIALIZE(A) if (debug & DEBUG_INITIALIZE) printk A
#define DBGPRINT_FUNCTION(A) if (debug & DEBUG_FUNCTION) printk A
#define DBGPRINT_SEND(A) if (debug & DEBUG_SEND) printk A
#define DBGPRINT_RECEIVE(A) if (debug & DEBUG_RECEIVE) printk A
#define DBGPRINT_INTERRUPT(A) if (debug & DEBUG_INTERRUPT) printk A
#define DBGPRINT_GET_STATISTICS(A) \
	if (debug & DEBUG_GET_STATISTICS) printk A
#define DBGPRINT_IOCTL(A) if (debug & DEBUG_IOCTL) printk A
#define DBGPRINT_ERROR(A) printk A
#define DBGPRINT_INIT(A) printk A

#else

#define DBGPRINT_INITIALIZE(A)
#define DBGPRINT_FUNCTION(A)
#define DBGPRINT_SEND(A)
#define DBGPRINT_RECEIVE(A)
#define DBGPRINT_INTERRUPT(A)
#define DBGPRINT_GET_STATISTICS(A)
#define DBGPRINT_QUERY(A)
#define DBGPRINT_SET(A)
#define DBGPRINT_IOCTL(A)
#define DBGPRINT_ERROR(A)
#define DBGPRINT_INIT(A)

#endif

#define LOG_LABEL(A, B)
#define ASSERT(A)


extern TIMER WaitTimer;
extern BOOLEAN InWaitTimer;
extern BOOLEAN DCConverterEnabledState_g;
extern ULONG TimeOutCount;
extern USHORT volatile MediaStatus_g;
extern BOOLEAN PhyResponding_g;
extern USHORT volatile PhyStatus_g;
extern UINT volatile DownListPointer_g;
extern UINT volatile UpListPointer_g;
extern UINT volatile portValue_g;
extern UINT volatile dmaControl_g;

extern PCHAR ProductName;
extern UINT tc90x_SendCount[];
extern UINT tc90x_ReceiveCount[];
extern UINT tc90x_Index;
extern UCHAR BroadcastAddr[];

#ifdef DEBUG
extern UINT debug;
#endif

extern INT switchdelay[];
extern INT media_select[];
extern INT full_duplex[];
extern INT downpoll[];
extern INT flowcontrol[];
//
//-------------------------- NIC.C Definitions --------------------------
//

NIC_STATUS
tc90xbc_ScanDevices(
	IN PDEVICE Device
	);

NIC_STATUS 
tc90x_FillDeviceStructure(
	IN PNIC_INFORMATION Adapter
	);

INT
NICOpen(
	IN PDEVICE Device
	);

INT
NICClose(
	IN PDEVICE Device
	);

INT
NICSetMacAddress(
	IN PDEVICE Device, 
	PVOID SockPtr
	);

VOID
NICTxTimeOut(
        IN PDEVICE Device
        );


//
//-------------------------- INIT.C Definitions --------------------------
//

VOID
tc90x_FreeAdapterResources(
	IN PNIC_INFORMATION Adapter
	);

NIC_STATUS
tc90x_RegisterAdapter(
	IN PNIC_INFORMATION Adapter
	);

NIC_STATUS
tc90x_GetAdapterProperties(
	IN PNIC_INFORMATION Adapter
    	);

NIC_STATUS
tc90x_BasicInitializeAdapter(
	IN PNIC_INFORMATION Adapter
	);

NIC_STATUS
tc90x_AllocateSharedMemory(
	IN PNIC_INFORMATION Adapter
    	);

NIC_STATUS 
tc90x_TestAdapter(
	IN PNIC_INFORMATION Adapter
	);

NIC_STATUS
tc90x_StartAdapter(
	IN PNIC_INFORMATION Adapter
    	);

VOID
ReStartAdapter(
	//IN PNIC_INFORMATION Adapter
	PVOID Adapter
    	);

NIC_STATUS
GlobalReset(
	IN PNIC_INFORMATION Adapter,
	IN USHORT Command
	);

//-------------------------- SEND.C Definitions --------------------------
//

INT
NICSendPacket(
	IN PSKB SocketBuffer,
	IN PDEVICE Device
	);

VOID
tc90x_TxCompleteEvent(
	IN PNIC_INFORMATION Adapter
	);

NIC_STATUS
tc90x_ResetAndEnableTransmitter(
	IN PNIC_INFORMATION Adapter
    	);


VOID
tc90x_CleanupSendLogic(
	IN PDEVICE Device
    	);



//
//-------------------------- REQUEST.C Definitions --------------------------
//


INT
NICIoctl(
	IN PDEVICE Device,
	IN PIFREQ Request,
	IN INT command
	);

VOID
NICSetReceiveMode(
	IN PDEVICE Device
	);

PENET_STATISTICS
NICGetStatistics(
	IN PDEVICE Device
	);
VOID
NICSetMulticastList(
	IN PDEVICE Device,
	IN INT NumberOfAddresses,
	PVOID AddressList
	);


USHORT
tc90x_HashAddress(
	IN PUCHAR Address
    	);


NIC_STATUS
tc90x_SetMulticastAddresses(
	IN PNIC_INFORMATION Adapter
    	);


VOID
tc90x_InitializeHashFilter(
	IN PNIC_INFORMATION Adapter
	);


//
//-------------------------- WORK.C Definitions -------------------
//

VOID
tc90x_FlowControl(
	IN PNIC_INFORMATION Adapter
	);


VOID
tc90x_HurricaneEarlyRevision(
	IN PNIC_INFORMATION Adapter
	);


NIC_STATUS 
tc90x_SoftwareWork(
	IN PNIC_INFORMATION Adapter
	);


/*NIC_STATUS
RxResetAndWork(
	IN PNIC_INFORMATION Adapter
	);*/
//
//-------------------------- AUTOSELECT.C Definitions -------------------
//

VOID 
tc90x_MainAutoSelectionRoutine(
	IN PNIC_INFORMATION Adapter,
	IN USHORT Options
	);

BOOLEAN 
tc90x_CheckDCConverter (
	IN PNIC_INFORMATION Adapter,
	IN BOOLEAN EnabledState
	);


VOID
tc90x_SetupConnector(    
	IN PNIC_INFORMATION Adapter,
 	IN CONNECTOR_TYPE NewConnector,
  	OUT PCONNECTOR_TYPE OldConnector 
  	) ;


BOOLEAN
tc90x_TryMII(    
	IN PNIC_INFORMATION Adapter,
  	IN USHORT MediaOptions 
  	);

BOOLEAN
tc90x_TryLinkBeat(   
	IN PNIC_INFORMATION Adapter,
	IN CONNECTOR_TYPE NewConnector
	);


BOOLEAN
DownloadSelfDirected(  
	IN PNIC_INFORMATION Adapter
	) ;

BOOLEAN
CheckTransmitInProgress(
	IN PNIC_INFORMATION Adapter
	);


BOOLEAN
TestPacket(    
	IN PNIC_INFORMATION Adapter
	);

BOOLEAN
GetLinkSpeed(  
	IN PNIC_INFORMATION Adapter,
	OUT PBOOLEAN handles100Mbitptr 
	) ;

//
// --------------------- EEPROM.C definitions -------------------
//

NIC_STATUS
tc90x_CheckIfEEPROMBusy(
	IN PNIC_INFORMATION Adapter
	);

NIC_STATUS
tc90x_ReadEEPROM(
	IN PNIC_INFORMATION Adapter,
	IN USHORT EEPROMAddress,
	OUT PUSHORT Contents
	);

NIC_STATUS
tc90x_WriteEEPROM(
	IN PNIC_INFORMATION Adapter,
	IN USHORT EEPROMAddress,
	IN USHORT Data
	);

USHORT
tc90x_CalculateEEPROMChecksum1(  
	IN PNIC_INFORMATION Adapter
    	) ;


//
// --------------------- ISR.C definitions -------------------
//

VOID
NICInterrupt IRQ(
	INT Irq,
	PVOID DeviceId,
	PTREGS Registers
	);

VOID
tc90x_HostErrorEvent(
	IN PNIC_INFORMATION Adapter
	);

VOID
tc90x_CountDownTimerEvent(
	IN PNIC_INFORMATION Adapter
    	);


VOID
tc90x_UpdateStatisticsEvent(
	IN PNIC_INFORMATION Adapter
    	);




//
// --------------------- RECEIVE.C definitions -------------------
//

VOID
tc90x_UpCompleteEvent(
	IN PNIC_INFORMATION Adapter
    	);

NIC_STATUS
tc90x_ResetAndEnableReceiver(
	IN PNIC_INFORMATION Adapter
    	);


//
// --------------------- TIMER.C definitions -------------------
//

VOID
NICTimer(
	IN ULONG Data
	);

VOID
WaitTimerHandler(
	IN ULONG Data
	);
//
// --------------------- CMDLINE.C definitions -------------------
//

NIC_STATUS
tc90x_ReadCommandLineChanges(
	IN PNIC_INFORMATION Adapter
	);

//
// --------------------- XCVR.C definitions -------------------
//

NIC_STATUS
tc90x_SetupMedia( 
	IN PDEVICE Device
	);

VOID
ProcessMediaOverrides(
	IN PNIC_INFORMATION Adapter, 
	IN USHORT OptionAvailable
	);


VOID
tc90x_TickMediaHandler(
	IN PNIC_INFORMATION Adapter
	);

VOID
CheckTPLinkState(
	IN PNIC_INFORMATION Adapter
	);

VOID
CheckFXLinkState(
	IN PNIC_INFORMATION Adapter
	);

NIC_STATUS
tc90x_SetupNewDuplex(
	IN PNIC_INFORMATION Adapter
	);

VOID
tc90x_SetupNewSpeed(
	IN PNIC_INFORMATION Adapter
	);


VOID
IndicateToOSLinkStateChange(
	IN PNIC_INFORMATION Adapter
	);

/**************************** MIIPHY.C *********************************/

BOOLEAN
FindMIIPhy( 
	IN PNIC_INFORMATION Adapter
	) ;

VOID
SendMIIPhyPreamble(    
	IN PNIC_INFORMATION Adapter
	) ;

VOID
WriteMIIPhy(   
	IN PNIC_INFORMATION Adapter,
	IN USHORT RegAddr,
	IN USHORT Output 
	);

BOOLEAN
ReadMIIPhy(    
	IN PNIC_INFORMATION Adapter,
	IN USHORT RegisterAddress,
	OUT PUSHORT pInput 
	) ;


BOOLEAN
MIIMediaOverride(
	IN PNIC_INFORMATION Adapter,
	IN USHORT PhyModes,
	OUT PUSHORT MiiType
	);

BOOLEAN
ProgramMII(   
	IN PNIC_INFORMATION Adapter,
  	IN CONNECTOR_TYPE NewConnector 
  	) ;

BOOLEAN
ConfigureMII(
	IN PNIC_INFORMATION Adapter,
    IN USHORT MediaOptions
  	);

BOOLEAN
CheckMIIConfiguration(    
	IN PNIC_INFORMATION Adapter,
	IN USHORT MediaOptions
  	);

VOID
CheckMIIAutoNegotiationStatus(    
	IN PNIC_INFORMATION Adapter
  	);


/*++

Routine:

    NIC_COMMAND_WAIT.

Description:

    This routine issues a command and spins for the completion.

Arguments:

    MiniportAdapterContext - Pointer to the adapter structure.
    Command - Command to be issued.

Return Value:

    NIC_STATUS_SUCCESS if hardware executes the command. 
    NIC_STATUS_FAILURE if hardware does not respond. 

--*/

__inline
static
NIC_STATUS
NIC_COMMAND_WAIT(
	IN PNIC_INFORMATION Adapter,
    	IN USHORT Command
    )
{
	PNIC_INFORMATION pAdapter = Adapter;
	ULONG count;
	USHORT value;

	NIC_WRITE_PORT_USHORT(
		pAdapter,
		INTSTATUS_COMMAND_REGISTER,
		Command);

	count = jiffies + HZ;
	do {
		value = NIC_READ_PORT_USHORT(
				pAdapter, 
				INTSTATUS_COMMAND_REGISTER);
		NIC_DELAY(10);
	} while ( (value & INTSTATUS_COMMAND_IN_PROGRESS) &&
		      (count > jiffies) );

	if (count < jiffies) {
		DBGPRINT_ERROR(("NIC_COMMAND_WAIT: timeout\n"));
		return NIC_STATUS_FAILURE;
    }
	return NIC_STATUS_SUCCESS;
}

/*++

Routine Name:

    tc90x_SetCountDownTimer.

Routine Description:

    This routine sets the countdown timer on the hardware.

Arguments:

    MiniportAdapterContext - Pointer to the adapter structure.

Return Value:

    None.

--*/

__inline
static
VOID
tc90x_SetCountDownTimer(
	IN PNIC_INFORMATION Adapter
    	)
{
    PNIC_INFORMATION pAdapter = Adapter;
    UINT countDownValue;

    countDownValue = pAdapter->BytesInDPDQueue /4; 

    if (countDownValue < 10)
	countDownValue = 10;

    NIC_WRITE_PORT_USHORT(
	    pAdapter,
	    COUNTDOWN_REGISTER,
	    (USHORT)countDownValue
	    );

}


/*++

Routine Name:

	GetPacketFromPendingQueueAtHead

Routine Description:

	This routine gets a packet from the pending queue.

Arguments:

	pAdapter - Pointer to the adapter structure.

Return Value:

	
	SocketBuffer - if there is a socket buffer in the queue.
	NULL - if there is no socket buffer in the queue.

--*/

__inline
static
PSKB
GetPacketFromPendingQueueAtHead(
	IN PNIC_INFORMATION Adapter
	)
{
	PSKB socketBuffer;

	//
	// Get the socket buffer from the queue head.
	//
	socketBuffer = Adapter->PendingQueue.Head;

	if (socketBuffer) {

		//
		// Move the head.
		//
		Adapter->PendingQueue.Head = socketBuffer->next;
		Adapter->TxPendingQueueCount--;

    	}

	//
	// return the socket buffer pointer.
	//
	socketBuffer->next = NULL;

	return socketBuffer;

}

/*++

Routine Name:

	PutPacketInPendingQueueAtHead

Routine Description:

    	This routine puts the packet in the pending queue.

Arguments:

    	Adapter - Pointer to the adapter structure.
	SocketBuffer - Socket buffer

Return Value:

    None.

--*/

__inline
static
VOID
PutPacketInPendingQueueAtHead(
	IN PNIC_INFORMATION Adapter,
	IN PSKB SocketBuffer
    	)
{

	//
	// This packet points to head.
	//      
	SocketBuffer->next = Adapter->PendingQueue.Head;

    	if (NULL == Adapter->PendingQueue.Head) {

		//
		// Nothing in queue, tail points to this packet.
		//

		Adapter->PendingQueue.Tail = SocketBuffer;

    	}

    	//
    	// Point head to this packet.
    	//

    	Adapter->PendingQueue.Head = SocketBuffer;
    	Adapter->TxPendingQueueCount++;

}



/*++

Routine Name:

    PutPacketPendingQueueAtTail.

Routine Description:

    This routine puts the packet in the pending queue.

Arguments:

    Adapter - Pointer to the adapter structure.
    Packet - Packet pointer.

Return Value:

    None.

--*/

__inline
static
VOID
PutPacketInPendingQueueAtTail(
	IN PNIC_INFORMATION Adapter,
	IN PSKB SocketBuffer
    	)
{

	SocketBuffer->next = NULL;

    	if (NULL == Adapter->PendingQueue.Head) {

		//
		// Head is NULL, point head to this one.
		//

		Adapter->PendingQueue.Head = SocketBuffer ;

    	}
    	else {

		//
		// Head is valid, add this packet to the tail.
		//
		Adapter->PendingQueue.Tail->next = SocketBuffer;

    }

    //
    // Point tail to this one.
    //

    Adapter->PendingQueue.Tail = SocketBuffer;
    Adapter->TxPendingQueueCount++;

}


/*++

Routine Name:

	SetRxTcpIpChecksumFlagsInPacket.

Routine Description:

    	This routine sets the checksum information.

Arguments:

	Adapter - Pointer to the adapter structure.
	SocketBuffer - Pointer to the socket buffer.
	UpPacketStatus - UpPacketStatus given by hardware.

Return Value:

    None.

--*/

__inline
static
VOID
SetRxTcpIpChecksumOffloadFlagsInSocketBuffer(
	IN PNIC_INFORMATION Adapter,
	IN PSKB SocketBuffer,
	IN UINT UpPacketStatus
    	)

{
    	PNIC_INFORMATION pAdapter = Adapter;
	//
	// Check if this is IP packet.
	//
	if (UpPacketStatus & UP_PACKET_STATUS_IP_CHECKSUM_CHECKED) {

		if (UpPacketStatus & UP_PACKET_STATUS_IP_CHECKSUM_ERROR) {
			DBGPRINT_ERROR((
				KERN_CRIT "IP checksum error\n"));
			SocketBuffer->ip_summed = CHECKSUM_NONE;
			return;
		}
		//
		// Check if packet is TCP packet. 
		//
		if (UpPacketStatus & UP_PACKET_STATUS_TCP_CHECKSUM_CHECKED) {
			//
			// Check if TCP checksum has been offloaded to us.
			//
			if (UpPacketStatus & 
			    UP_PACKET_STATUS_TCP_CHECKSUM_ERROR) {
				DBGPRINT_ERROR((
					KERN_CRIT "TCP Checksum error\n"));
				SocketBuffer->ip_summed = CHECKSUM_NONE;
				return;
			}
		}
	    	//
	    	// Check if this is UDP packet.
		//
	    	if (UpPacketStatus & UP_PACKET_STATUS_UDP_CHECKSUM_CHECKED) {
			if (TRUE == pAdapter->Hardware.UDPChecksumErrDone) {
		    		if (UpPacketStatus & 
				    UP_PACKET_STATUS_UDP_CHECKSUM_ERROR) {
					DBGPRINT_ERROR((
						KERN_CRIT "UDP Error"));
					SocketBuffer->ip_summed = CHECKSUM_NONE;
					return;
				}
				else {
					SocketBuffer->ip_summed = CHECKSUM_NONE;
					return;
				}
	    		}
		}
	}	
	SocketBuffer->ip_summed = CHECKSUM_UNNECESSARY;	
	return;
}	    

