/*
 * 3C90X stress specific macros
 *
 */

#ifndef _3C90X_STRESS_H_
#define _3C90X_STRESS_H_
#ifdef __VMKERNEL_MODULE__

#include "linux_stress.h"

/*
 * VMWARE_STRESS_ONLY_STOP_QUEUE
 *
 * The macro takes two parameters. The first one is the 
 * device for which queuing is to be disabled. The second
 * parameter is a hack to specify where control should
 * be transferred when the stress counter is hit. Typically,
 * it is either a continue or a return statement.
 *
 */
#define VMWARE_STRESS_ONLY_STOP_QUEUE(dev, CONTINUE_CMD)                   \
if (VMK_STRESS_DEBUG_COUNTER(NET_HW_STOP_QUEUE)) {                         \
      netif_stop_queue(dev);                                               \
      CONTINUE_CMD;                                                        \
} else {                                                                   \
   if (netif_queue_stopped(dev) && netif_carrier_ok(dev)) {                \
      netif_wake_queue(dev);                                               \
   }                                                                       \
}


/*
 * LinuxStress_StressIntrRate
 *
 * Dummy Handler.
 */

static
void LinuxStress_StressIntrRate(unsigned long data)
{
}
#else
/* These are definitions when __VMKERNEL_MODULE__ is not defined.
 * Some of them are from linux_stress.h. The reason the default cases
 * are defined here is that linux_stress.h is not in the include
 * path when __VMKERNEL_MODULE__ is not defined.
 */
#define VMWARE_STRESS_RETAIN_BUFFER(skb, CONTINUE_CMD, ELSE_CMD) ELSE_CMD;
#define VMWARE_STRESS_ONLY_STOP_QUEUE(dev, CONTINUE_CMD)
#define VMWARE_STRESS_ONLY_SET_INTR_RATE(param, compare)
#define VMWARE_STRESS_ONLY_CORRUPT_BUFFER(COUNTER, skb, len)
#define VMWARE_STRESS_ONLY_FAIL_BUFFER(COUNTER, skb, FREE_SKB, CONTINUE_CMD)
#endif // __VMKERNEL_MODULE__
#define NO_ELSE_CMD
#define NO_CONTINUE_CMD
#endif // _3C90X_STRESS_H_
