/*
 * YOU SHOULD CAREFULLY READ THE FOLLOWING TERMS AND CONDITIONS BEFORE 
 * INSTALLING AND USING THIS PRODUCT, 
 * THE USE OF WHICH IS LICENSED BY 3COM CORPORATION ("3COM") 
 * and others as set forth below for your USE ONLY AS SET FORTH BELOW. 
 * DOWNLOADING, INSTALLING OR OTHERWISE USING ANY PART OF THE SOFTWARE OR 
 * DOCUMENTATION INDICATES THAT YOU ACCEPT THESE TERMS AND CONDITIONS.  
 * IF YOU DO NOT AGREE TO THE TERMS AND CONDITIONS OF THIS AGREEMENT, 
 * DO NOT DOWNLOAD, INSTALL OR OTHERWISE USE THE SOFTWARE OR DOCUMENTATION. 
 * AND IF YOU HAVE RECEIVED THE SOFTWARE AND DOCUMENTATION ON PHYSICAL MEDIA, 
 * RETURN THE ENTIRE PRODUCT WITH THE SOFTWARE AND DOCUMENTATION UNUSED TO THE
 * SUPPLIER WHERE YOU OBTAINED IT.

 * This driver (3c990.c) has been written to work with the 3cr990 product line
 * of network cards, manufactured by 3Com Corp.
 * This driver is not intended for any other product line, including the 3c59x 
 * or 3C90x product lines (although drivers with both of these names,
 * and for both of these product lines, are available ). 
 *
 * It does not work with the 2.3 kernel; only the 2.0 and 2.2 at this point.
 * The driver contains no support now for architectures other than IA-32 bit.
 *
 * To force the media selection, use the command line argument force=X, 
 * where X denotes the selection as follows:
 * 0=10(megabit)Half(Duplex); 1=10Full; 2=100Half; 3=100Full; 4=auto (default)
 * e.g. insmod 3c990.o force=1   
 * ... should give you 10 megabit full duplex forced action.
 *
 * You may contact 3Com for updates and information (regarding this driver) at:
 * http://support.3com.com/infodeli/tools/nic/3c990.htm
 *
 * You may request or submit driver modifications at:
 * http://support.3com.com/infodeli/tools/nic/linuxrequest.htm
 *
 * If you would like more information about compiling the driver than is 
 * available at the bottom of this file, you may choose to reference:
 * http://cesdis.gsfc.nasa.gov/linux/misc/modules.html
 * and/or you may reference the readme file for the 3c90x driver.
 *
 * License to "tc990image"
 * The binary image "tc990image" is licensed to users by 3Com Corporation, 
 * with intended use for 3Com's Network Interface Card models 3CR990-x.
 * (Where x indicates any extension model number.)
 * LICENSE:  3Com grants you a nonexclusive, nontransferable 
 * (except as specified herein) license to use the tc990image in conjunction 
 * with your use of 3Com's Network Interface Card models 3CR990-x as specified 
 * above. You are not permitted to lease, rent, distribute or sublicense 
 * (except as specified herein) the tc990image or to use the tc990image or in 
 * any other unauthorized manner.  Further, no license is granted to you in the
 * human readable code of the Software (source code).  Except as provided 
 * below, this Agreement does not grant you any rights to patents, copyrights, 
 * trade secrets, trademarks, or any other rights with respect to the Software 
 * or Documentation.
 * Subject to the restrictions set forth herein, the tc990image is licensed to 
 * be used on any workstation or any network server owned by or leased to you, 
 * for your internal use, provided that the tc990image is used only in 
 * connection with this 3Com product.  You may reproduce and provide one (1) 
 * copy of the tc990image for each such workstation or network server on which 
 * the Software is used as permitted hereunder.  Otherwise, the Software and 
 * Documentation may be copied only as essential for backup or archive purposes
 * in support of your use of the Software as permitted hereunder.  Each copy 
 * of the tc990image must contain 3Com's and its licensors' proprietary rights 
 * and copyright notices in the same form as on the original.  You agree not to
 * remove or deface any portion of any legend provided on any licensed program 
 * or documentation delivered to you under this Agreement.
 * ASSIGNMENT;   You may transfer the tc990image and the licenses granted 
 * herein to another party in the same country in which you obtained it if the 
 * other party agrees in writing to accept and be bound by the terms and 
 * conditions of this Agreement. If you transfer the tc990image, you must at 
 * the same time either transfer all copies of the Software and Documentation 
 * to the party or you must destroy any copies not transferred. Except as set 
 * forth above, you may not assign or transfer your rights.
 *
 * NO REVERSE ENGINEERING:  Modification, reverse engineering, reverse 
 * compiling, or disassembly of the tc990image is expressly prohibited. 
 * However, if you are a European Union ("EU") resident, information necessary 
 * to achieve interoperability of the tc990image with other programs within the
 * meaning of the EU Directive on the Legal Protection of Computer Programs is 
 * available to you from 3Com upon written request.
 * TRADE SECRETS; TITLE:  You acknowledge and agree that the structure, 
 * sequence and organization of the tc990image are the valuable trade secrets 
 * of 3Com and its suppliers. You agree to hold such trade secrets in 
 * confidence. You further acknowledge and agree that ownership of, and title 
 * to, the tc990image and all subsequent copies thereof regardless of the form 
 * or media are held by 3Com.
 *
 * License to this driver
 * Some material in this driver has been adopted from pci-skeleton.c, 
 * a Linux PCI network adapter skeleton device driver. 
 * pci-skeleton.c written in 1998-1999 by Donald Becker.
 * The author of pci-skeleton.c may be reached as becker@scyld.com.
 * More information about Becker is available at http://www.scyld.com/
 *
 * Except as otherwise provided, This software and pci-skeleton.c, may be used 
 * and distributed according to the terms of the GNU Public License (GPL), 
 * incorporated herein by reference.
 *
 * UNITED STATES GOVERNMENT LEGENDS:  The portions of this Driver developed by 
 * 3Com, and the tc990image ("Software") is commercial in nature and developed 
 * solely at private expense.  The Software is delivered as 
 * "Commercial Computer Software" as defined in DFARS 252.227-7014 (June 1995) 
 * or as a commercial item as defined in FAR 2.101(a) and as such is provided 
 * with only such rights as are provided herein.  Technical data is provided 
 * with limited rights only as provided in DFAR 252.227-7015 (Nov. 1995) or 
 * FAR 52.227-14 (June 1987), whichever is applicable.
 *
 * TERM AND TERMINATION:  The licenses to the Software granted hereunder are 
 * perpetual unless terminated earlier as specified below or otherwise 
 * provided. You may terminate the licenses and this Agreement at any time by 
 * destroying the Software and Documentation together with all copies and 
 * merged portions in any form. The licenses and this Agreement will also 
 * terminate immediately if you fail to comply with any term or condition of 
 * this Agreement. Upon such termination you agree to destroy the Software and 
 * Documentation, together with all copies and merged portions in any form.
 *
 * LIMITED WARRANTIES AND LIMITATION OF LIABILITY: This driver and  tc990image 
 * are provided with no warranty, including warranty of fitness for any 
 * particular purpose.  3Com assumes no liability for any damages or injuries 
 * resulting from use of the driver or tc990image file.
 * GOVERNING LAW:   This License shall be governed by the laws of the State of 
 * California, U.S.A. excluding its conflicts of laws principles and excluding 
 * the United Nations Convention on Contracts for the 
 * International Sale of Goods.
 * SEVERABILITY:  In the event any provision of this License is found to be 
 * invalid, illegal or unenforceable, the validity, legality and enforceability
 * of any of the remaining provisions shall not in any way be affected or 
 * impaired and a valid, legal and enforceable provision of similar intent and 
 * economic impact shall be substituted therefor.
 * ENTIRE AGREEMENT:  This Agreement sets forth the entire understanding and 
 * agreement between you and 3Com and supersedes all prior agreements, whether 
 * written or oral, with respect to the Software and Documentation, and may be 
 * amended only in a writing signed by both parties.
 * Should you have any questions concerning this Agreement or if you desire to 
 * contact 3Com for any reason, please contact the 3Com subsidiary serving your
 * country, or write: 
 * 3Com Corporation, Customer Support Information, 
 * 5400 Bayfront Plaza, Santa Clara, CA  95052
 */

static const char *version = "3Com  3c990.c  v1.0.0b  10/2000  \n";

#if !defined(__OPTIMIZE__)  ||  !defined(__KERNEL__)
#warning  You must compile this file with the correct options!
#warning  See the last lines of the source file.
#error You must compile this driver with "-O".
#endif

#define UPDATE_INDEX( index, size, entries ) { index += size; if ( index == (entries * size ) )  index = 0; }

#ifdef __VMKERNEL_MODULE__
#include "smp_drv.h"
#endif // __VMKERNEL_MODULE__

/*
 * Include files to support kernel versions 2.0.x and 2.2.x
 */
#include <linux/config.h>
#include <linux/version.h>
#ifdef MODULE
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif
#include <linux/module.h>
#else
#define MOD_INC_USE_COUNT
#define MOD_DEC_USE_COUNT
#endif

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/slab.h>
#include <linux/interrupt.h>
#include <linux/pci.h>
#include <linux/init.h>
#include <asm/bitops.h>
#include <asm/io.h>

#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/delay.h>    

#ifdef SMP
#include <linux/spinlock.h>
#endif

#ifdef __VMKERNEL_MODULE__
#include "vmklinux_dist.h"
#endif

#if (LINUX_VERSION_CODE >= 0x20100)
char kernel_version[] = UTS_RELEASE;
#else
#ifndef __alpha__
#define ioremap vremap
#define iounmap vfree
#endif
#endif

#define POLYNOMIAL 0x04c11db7 

#if defined(MODULE) && LINUX_VERSION_CODE > 0x20115

#if 1 // __VMKERNEL_MODULE__
#define MAX_UNITS 32
#else
#define MAX_UNITS 8
#endif

MODULE_AUTHOR("3Com <linux_support@3com.com>");
MODULE_DESCRIPTION("Driver for 3Com EtherLink 10/100 PCI NIC with 3XP Processor");

MODULE_PARM(min_pci_latency, "1-" __MODULE_STRING(8) "i");
MODULE_PARM(force, "1-" __MODULE_STRING(8) "i");

static u32 tc990_index = 0;
#ifdef __VMKERNEL_MODULE__
static u32 force[MAX_UNITS] = { [0 ... MAX_UNITS-1 ] = 4 };
static u32 min_pci_latency[MAX_UNITS] = { [0 ... MAX_UNITS-1 ] = 64 };
#else
static u32 force[MAX_UNITS] = { 4, 4, 4, 4, 4, 4, 4, 4};
static u32 min_pci_latency[MAX_UNITS] = {64,64,64,64,64,64,64,64};
#endif
#endif

#if (LINUX_VERSION_CODE < 0x02030e)
#define net_device device
#endif

#if (LINUX_VERSION_CODE >= 0x02031b)
#define NEW_NETINIT
#endif


#if (LINUX_VERSION_CODE < 0x02032a)
typedef u32 dma_addr_t;

static inline void *pci_alloc_consistent(struct pci_dev *hwdev, size_t size,
                     dma_addr_t *dma_handle)
{
    void *virt_ptr;

    virt_ptr = kmalloc(size, GFP_KERNEL);
    *dma_handle = virt_to_bus(virt_ptr);
    return virt_ptr;

}

#define pci_free_consistent(cookie, size, ptr, dma_ptr)    kfree(ptr)
#define pci_map_single(cookie, address, size, dir)    virt_to_bus(address)
#define pci_unmap_single(cookie, address, size, dir)
#endif

#if (LINUX_VERSION_CODE < 0x02032b)
/*
 * SoftNet
 */
#define dev_kfree_skb_irq(a)    dev_kfree_skb(a)
#define netif_wake_queue(dev)    clear_bit(0, &dev->tbusy)

static inline void netif_start_queue(struct net_device *dev)
{
    dev->tbusy = 0;
    dev->interrupt = 0;
    dev->start = 1;
}
static inline void netif_stop_queue(struct net_device *dev) 
{
	dev->tbusy = 1;
	dev->start = 0;
}

#define netif_queue_stopped(dev)    dev->tbusy
#define netif_running(dev)        dev->start
#else
#define NET_BH            0
#define tc990_mark_net_bh(foo)    {do{} while(0);}
#define tc990_if_down(dev)    {do{} while(0);}
#endif

#if LINUX_VERSION_CODE < 0x20123
#define test_and_set_bit(val, addr) set_bit(val, addr)
#endif
#if LINUX_VERSION_CODE <= 0x20139
#define    net_device_stats enet_statistics
#else
#define NETSTATS_VER2
#endif
#if LINUX_VERSION_CODE < 0x20155
#include <linux/bios32.h>
#define PCI_SUPPORT_VER1
#else
#define PCI_SUPPORT_VER2
#endif
#if LINUX_VERSION_CODE < 0x20159
#define dev_free_skb(skb) dev_kfree_skb(skb, FREE_WRITE);
#else
#define dev_free_skb(skb) dev_kfree_skb(skb);
#endif
#if ! defined(CAP_NET_ADMIN)
#define capable(CAP_XXX) (suser())
#endif

#define tc990_IMAGE_SIZE 0x10000
#include "3c990img.h"

#define tc990_VENDOR_ID 0x10B7

#define TX_ENTRIES        128 
#define RX_ENTRIES        128 
#define CMD_ENTRIES        64
#define RESPONSE_ENTRIES   64

/*
 * 3cr990 commands
 */
#define tc990_CMD_TX_ENABLE             0x1
#define tc990_CMD_TX_DISABLE            0x2
#define tc990_CMD_RX_ENABLE             0x3
#define tc990_CMD_RX_DISABLE            0x4
#define tc990_CMD_RX_FILT_WRITE         0x5
#define tc990_CMD_READ_STATS            0x7
#define tc990_CMD_XCVR_SELECT           0x13
#define tc990_CMD_MAX_PKT_SIZE_WRITE    0x1A
#define tc990_CMD_PHYSICAL_MNGT_READ    0x1F
#define tc990_CMD_MCAST_HASH_MASK_WRITE 0x25
#define tc990_CMD_STATION_ADR_READ      0x27

/*
 * Descriptor type
 */
#define CMD_DSC_TYPE_CMD_FRAME       0x2
#define CMD_DSC_FRAME_VALID          ( 1 << 7 ) 
#define CMD_DSC_RESPONSE_NEEDED      ( 1 << 6 )
#define CMD_DSC_RESPONSE_NOT_NEEDED  0 

#define RESPONSE_DSC_ERROR_SET       ( 1 << 6 )
#define tc990_STATUS_CMD_FOUND         2

/*
 * 3cr990 registers
 */
#define tc990_SOFT_RESET_REG         0x0
#define tc990_INT_STATUS_REG         0x4
#define tc990_INT_ENABLE_REG         0x8
#define tc990_INT_MASK_REG           0xC
#define tc990_HostTo3XP_COMM_5_REG   0x1C
#define tc990_HostTo3XP_COMM_4_REG   0x20
#define tc990_HostTo3XP_COMM_3_REG   0x24
#define tc990_HostTo3XP_COMM_2_REG   0x28
#define tc990_HostTo3XP_COMM_1_REG   0x2C
#define tc990_HostTo3XP_COMM_0_REG   0x30
#define tc990_3XP2HOST_COMM_0_REG    0x40

#define tc990_MASK_ALL_INT        0xFFFFFFFF
#define tc990_UNMASK_ALL_INT      0x0
#define tc990_ENABLE_ALL_INT      0xFFFFFFEF
#define tc990_RESET_ALL           0x7F

/*
 * 3cr990 commands for handshake with firmware
 */
#define tc990_NULL_CMD                  0x00
#define tc990_BOOTCMD_REG_BOOT_RECORD   0x0FF
#define tc990_BOOTCMD_RUNTIME_IMAGE     0xFD
#define tc990_BOOTCMD_DOWNLOAD_COMPLETE 0xFB
#define tc990_BOOTCMD_SEGMENT_AVAILABLE 0xFC

/*
 * Waiting for boot signature
 */
#define tc990_WAITING_FOR_BOOT          0x7
#define tc990_WAITING_FOR_HOST_REQUEST  0xD
#define tc990_WAITING_FOR_SEGMENT       0x10

#define tc990_3XP_COMM_INT0  0x2

/*
 * Resource allocations
 */
#define TC990_SHARED_MEMORY_ALLOCATED           0x1
#define TC990_SLOT_MEMORY_ALLOCATED             0x2
#define TC990_BASE_ADDR_RESERVED                0x4
#define TC990_IO_MAPPED                         0x8
#define TC990_BASE_MEMORY_RESERVED              0x10
#define TC990_IRQ_RESERVED                      0x20
#define TC990_DEVICE_REGISTERED                 0x40
#define TC990_DEVICE_IN_ROOT_CHAIN              0x80
/*
 * Delay in microseconds to wait for the reset to be over
 */
#define tc990_WAIT_COUNTER        100000

#define ETHERNET_MAXIMUM_FRAME_SIZE 1514

#define tc990_RX_FILT_DIRECTED          0x1
#define tc990_RX_FILT_ALL_MULTICAST     0x2
#define tc990_RX_FILT_BROADCAST         0x4
#define tc990_RX_FILT_PROMISCUOUS       0x8
#define tc990_RX_FILT_HASH_MULTICAST    0x10

#define tc990_MULTICAST_BITS               0x3f

/*
 * Slot information
 */
/*
 * Slot information
 */
struct SLOT {

    u32 physical_addr_lo;
    u32 physical_addr_hi;
    u32 virtual_addr_lo;
    u32 virtual_addr_hi;
    u32 buffer_length;
    u32 skb;
};


typedef struct _tc990_RING {

    u32 RingBase;          /* ring address (sharedmemory) */
    u32 NoEntries;         /* number of entries in ring */
    u32 LastWriteUL;       /* send: last insert */

} tc990_RING;

typedef struct _TX_RING {
    u32 RingBase;          /* ring address (sharedmemory) */
    u32 NoEntries;         /* number of entries in ring */
    u32 LastWriteUL;       /* send: last insert */
    u32 LastReadUL;           /* cleanup: last read - current read */
    u32 WriteRegister;     /* register used to single NIC */
    u32 PacketPendingNo;   /* Number of packets sent - not completed */
} TX_RING;

/*
 * This structure is updated by the driver and reaad by the f/w
 */
typedef struct _HOST_WRITE_INDEXES {
    volatile u32 regRxHiReadUL;
    volatile u32 regRxLoReadUL;
    volatile u32 regRxBuffWriteUL;
    volatile u32 regRespReadUL;
} HOST_WRITE_INDEXES;

/*
 * This structure is updated by the f/w and read by the driver
 */
typedef struct _HOST_READ_INDEXES {
    volatile u32 regTxLoReadUL;
    volatile u32 regTxHiReadUL;
    volatile u32 regRxLoWriteUL;
    volatile u32 regRxBuffReadUL;
    volatile u32 regCmdReadUL;
    volatile u32 regRespWriteUL;
    volatile u32 regRxHiWriteUL;
} HOST_READ_INDEXES;

/*
 * Main variable structure
 */
typedef struct _HOST_VAR_S {
    HOST_WRITE_INDEXES hvWriteS;
    HOST_READ_INDEXES hvReadS;
} HOST_VAR_S;

typedef struct _HOST_INIT_S {
    HOST_VAR_S  *hostVarsPS;     /* points to host variable data struct */
    u32 hostVarsHiUL;
    u32 hostTxLoStartUL;         /* Tx Lo priority ring */
    u32 hostTxLoStartHiUL;
    u32 hostTxLoSizeUL;
    u32 hostTxHiStartUL;         /* Tx Hi priority ring */
    u32 hostTxHiStartHiUL;
    u32 hostTxHiSizeUL;
    u32 hostRxLoStartUL;         /* Rx Lo priority ring */
    u32 hostRxLoStartHiUL;
    u32 hostRxLoSizeUL;
    u32 hostRxFreeStartUL;       /* Rx free buffer ring */
    u32 hostRxFreeStartHiUL;
    u32 hostRxFreeSizeUL;
    u32 hostCtrlStartUL;         /* Comand ring */
    u32 hostCtrlStartHiUL;
    u32 hostCtrlSizeUL;
    u32 hostRespStartUL;         /* Command Response ring */
    u32 hostRespStartHiUL;
    u32 hostRespSizeUL;
    u32 hostZeroWordUL;          /* (lo) physical address of zero word */
    u32 hostZeroWordHiUL;        /* (Hi) used for dma */
    u32 hostRxHiStartUL;         /* Rx Hi priority ring */
    u32 hostRxHiStartHiUL;
    u32 hostRxHiSizeUL;
} HOST_INIT_S;

/*
 * Receive descriptor. This structure is updated by the f/w
 */
typedef struct _RX_DSC {

    u32 Flags:8;
    u32 num_descriptor:8;
    u32 FrameLength:16;
    u32 virtual_addr_lo;
    u32 virtual_addr_hi;
    u32 RxStatus;
    u16 FilterResults;
    u16 res1;
    u32 res2;

} RX_DSC;

/*
 * Receive free descriptor. This structure is filled by the driver to
 * give a buffer to the firmware
 */

typedef struct _RX_FREE_DSC {

    u32 physical_addr_lo;
    u32 physical_addr_hi;
    u32 virtual_addr_lo;
    u32 virtual_addr_hi;

} RX_FREE_DSC;
/*
 * Usef for both commands and responses
 */

typedef struct {

    u32 Flags:8;
    u32 num_descriptor:8;
    u32 Command:16;
    u32 SequenceNo:16;
    u32 Parameter1:16;
    u32 Parameter2;
    u32 Parameter3;

} CMD_DSC;
/*
 * Stats response labels 
 */
typedef struct {
    u32 reserved;
    u32 reservedB;
    u32 pkt;
    u32 byte;
}rtnTx;

typedef struct {
    u32 reserved;
    u32 deferred;
    u32 lateCollision;
    u32 collisions;
}rtnTxMore;

typedef struct {
    u32 carrierLost;
    u32 multCollision;
    u32 reserved;
    u32 reservedB;
}rtnTxCrit;

typedef struct {
    u32 reserved;
    u32 txFiltered;
    u32 rxPkt;
    u32 rxByte;
}rtnTxRx;

typedef struct {
    u32 reserved;
    u32 fifoOverrun;
    u32 badSSD;
    u32 crcError;
}rtnRx;

typedef struct {
    u32 oversize;
    u32 reserved;
    u32 reservedB;
    u32 reservedC;
}rtnRxGeneral;

typedef struct {
    u32 filtered;
    u32 reserved;
    u32 reservedB;
    u32 reservedC;
}rtnRxEtc;

typedef union {
    CMD_DSC nrml;                 /* "normal" response values */
    rtnTx tx;
    rtnTxMore txMore;
    rtnTxCrit txCrit;
    rtnTxRx txRx;
    rtnRx rx;
    rtnRxGeneral rxGeneral;
    rtnRxEtc rxEtc;
} RESPONSE_DSC;

/* individual descriptors for each Fragment of a packet */

typedef struct _TX_DESC
{
    u8 fragFlagsUC;
    u8 fragReservedUC;
    u16 fragLenUW;

    u32 fragHostAddrLoUL;
    u32    fragHostAddrHiUL;
    u32 fragSpareUL;

} TX_DESC;

typedef struct
{
    u8 frFlagsUC;
    u8 frNumDescUC;            /* No of fragments in this packet */
    u16 frPktLen;

} TX_PKT_FLAGS;

typedef struct _TX_FRAME_DESC
{
      union
      {
            TX_PKT_FLAGS frFlagsS;
            u32 frFlagsUL;
      } frU;

    u32    pktPtrLoUL;            
    u32 pktPtrHiUL;
    u32 frProcFlagsUL;
} TX_FRAME_DESC;

/* bit defines for frFlagsUC */

#define FRAME_TYPE_FRAG_HDR 0x00    /* bottom 2 bits describe pkt */
#define FRAME_TYPE_PKT_HDR  0x01    /* bottom 2 bits describe pkt */

#define HOST_DESC_VALID     0x80    /* set when this pkt contains data */

typedef struct _tc990_FILE_HEADER {
    u8 tagID[8];
    u32 Version;
    u32 NumSections;
    u32 ExecuteAddress;
} tc990_FILE_HEADER; 

typedef struct _tc990_FILE_SECTION {

    u32 num_bytes;
    u16 checksum;
    u16 reserved;
    u32 start_address;

} tc990_FILE_SECTION;

struct pci_id_info {
    const char *name;
    u16 device_id;
};

static struct pci_id_info pci_tbl[] = {
    {"3Com 10/100 PCI NIC w/3XP (3CR990-TX-95)",0x9902},
    {"3Com 10/100 PCI NIC w/3XP (3CR990-TX-97)",0x9903},
    {"3Com 10/100 PCI NIC w/3XP (3C990B-TX-M)",0x9904},
    {"3Com 10/100 PCI Server NIC w/3XP (3CR990SVR95)", 0x9908},
    {"3Com 10/100 PCI Server NIC w/3XP (3CR990SVR97)", 0x9909},
    {"3Com 10/100 PCI Server NIC w/3XP (3C990BSVR)", 0x990A},
    {0,},                  /* 0 terminated list. */
};

struct tc990_shared {

    HOST_INIT_S init; 
    u32 slack;
    HOST_VAR_S var; 
    RX_FREE_DSC rxFree[RX_ENTRIES];
    RX_DSC rxLo[RX_ENTRIES], rxHi[RX_ENTRIES]; 
    CMD_DSC cmd[CMD_ENTRIES];
    RESPONSE_DSC rsp[RESPONSE_ENTRIES];

};

struct tc990_ring_info {

    tc990_RING RxHiRing, RxLoRing, RxBuffRing;  /* receive information */
    TX_RING TxHiRing, TxLoRing;             /* send information */
    tc990_RING CmdRing, RspRing;            /* command ring information */

};

struct tc990_private { 

    struct tc990_shared *shared;   
    u32 shared_size;
    dma_addr_t shared_dma_addr;
 
    struct tc990_ring_info ring_info;     

    u8 *DownloadPageVirtual;
    dma_addr_t DownloadPagePhysical;
    u32 ringPhysical;
    u32 BufferPhysical;
    struct SLOT* slot;
    u32 slot_memory_size;
    dma_addr_t slot_physical;

    struct net_device *next_module;    /* Link for devices of this type. */
    const char *product_name;
    struct net_device_stats stats;
    u16 chip_id;
    unsigned char pci_bus, pci_devfn;
    u8 tx_full;        
    spinlock_t lock; 
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,43)
    wait_queue_head_t wait_q;
#else
    struct wait_queue *wait_q;   
#endif
    struct pci_dev *pdev;
    u32 index;
    u32 resources_reserved;
    void *nonAlignedAddr;         //Added by VMWARE
#ifdef  __VMKERNEL_MODULE__
    struct timer_list timer_id;   /* link status timer ID     */
    int timer_val;                /* link status timer value  */
	int intr_enabled;            
#endif

};

static void update_tx_ring_index (u32 *writePUW);
static struct net_device *tc990probe( struct net_device *dev, long ioaddr, u16 irq, u16 chp_idx, u16 fnd_cnt);

static int  tc990_open(struct net_device *dev);                    
static void tc990_interrupt(int irq, void *dev_inst, struct pt_regs *regs);  
static int  tc990_close(struct net_device *dev);                   
static int  tc990_start_tx(struct sk_buff *skb, struct net_device *dev);  
static struct net_device_stats *tc990_get_stats(struct net_device *dev);  

static void stats_handler(struct tc990_private *np);
static void release_buf_to_firmware( struct net_device *dev, u32 slot_index );
static void process_receive(struct net_device *dev, tc990_RING *pRxRing,
volatile u32 *regRxReadUL, volatile u32 *regRxWriteUL);

static u16 calculate_buffer_checksum(u16 *Buffer,  u32 Count);
static u16 download_boot_record(struct net_device *dev, u16 process);
static u16 download_runtime_image(struct net_device *dev);
static u16 init_ring_zone( struct net_device *dev ) ;
static u16 issue_command( struct net_device *dev, u16 command, u16 parameter1, 
u32 parameter2, u32 parameter3, u16 *return1, u32 *return2, u32 *return3, 
u8 wait_for_response);

static u8 process_response( struct tc990_private *np, u32 response_read_index, u16 command );

static void free_resources(struct net_device *dev);

static void process_send_complete( struct net_device *dev, TX_RING *pTxRing,
    volatile u32 *xmitReadIndex)    ;
static void tc990_set_rx_mode(struct net_device *dev);                    

int tc990_init_module(void);
void tc990_cleanup_module(void);

#ifdef __VMKERNEL_MODULE__
/*
 * we use this as a callback to allow the receive clustering
 * code to turn interrupts off when it is in polling mode
 */
int tc990_enable_intr(struct net_device * dev, int enable)
{
    struct tc990_private *np = (struct tc990_private *)dev->priv;
    
    if(enable) {
       np->intr_enabled = 1;
	   writel(tc990_UNMASK_ALL_INT, dev->base_addr + tc990_INT_MASK_REG);
    } else {
       np->intr_enabled = 0;
	   writel(tc990_MASK_ALL_INT, dev->base_addr + tc990_INT_MASK_REG );    
    }
    return 0;
}

inline
void *vmware_bus_to_virt(u32 basePhysical, void *baseVirt, u32 physical)
{
    
    if (basePhysical > physical) {
        printk(KERN_WARNING "3c990: Invalid bus_to_virt basePhysical = 0x%x, \
                             baseVirt = %p, physical = 0x%x\n",
               basePhysical, baseVirt, physical);
        return NULL;
    }

    return (baseVirt + physical - basePhysical);
}

#define bus_to_virt vmware_bus_to_virt

#endif // __VMKERNEL_MODULE__


/* A list of our installed devices, for removing the driver module. */

static struct net_device *root_net_dev = NULL;

static u16 pci_etherdev_probe( struct net_device *dev, struct pci_id_info pci_tbl[] )
{
    u16 pci_command;
    u16 chip_idx, irq = 0;
    struct pci_dev *pdev = 0;
    u16 cards_found = 0;
    unsigned char cacheSz;
    u8 pci_latency;
    u16 vendor, device;
    long pciaddr, ioaddr ;
    u8 rev;


#if LINUX_VERSION_CODE < 0x20193
    static u16 pci_index = 0;
    unsigned char pci_bus, pci_device_fn;
#endif


#if LINUX_VERSION_CODE < 0x20193
    for (;pci_index < 0xff; pci_index++) {
        if (pcibios_find_class(PCI_CLASS_NETWORK_ETHERNET << 8, pci_index,
                               &pci_bus, &pci_device_fn) != PCIBIOS_SUCCESSFUL)
            break;

        pcibios_read_config_word(pci_bus, pci_device_fn, PCI_VENDOR_ID, &vendor);
        pcibios_read_config_word(pci_bus, pci_device_fn, PCI_DEVICE_ID, &device);

#else

        while ((pdev = pci_find_class(PCI_CLASS_NETWORK_ETHERNET<<8, pdev))) {

        vendor = pdev->vendor;
        device = pdev->device;


#endif
        if (vendor != tc990_VENDOR_ID) continue;

        for (chip_idx = 0; pci_tbl[chip_idx].device_id; chip_idx++)
            if (device == pci_tbl[chip_idx].device_id) break;
            
        if (pci_tbl[chip_idx].device_id == 0) continue;

#if LINUX_VERSION_CODE < 0x20193
           pcibios_read_config_byte(pci_bus, pci_device_fn,
                                 PCI_CLASS_REVISION, &rev); 
#else
        pci_read_config_byte(pdev, PCI_CLASS_REVISION, &rev);
#endif

        {
#if ((LINUX_VERSION_CODE >= 0x20155) && (LINUX_VERSION_CODE < 0x20193))
            pdev = pci_find_slot( pci_bus, pci_device_fn);
            pciaddr = pdev->base_address[1];
            irq = pdev->irq;

#elif ((LINUX_VERSION_CODE >= 0x20193) && (LINUX_VERSION_CODE <= 0x20312))
            pciaddr = pdev->base_address[1];
            irq = pdev->irq;

#elif LINUX_VERSION_CODE > 0x20312
               pciaddr = pdev->resource[1].start;
               irq = pdev->irq;

#else
            u32 pci_addr;
            u8 pci_irq;

            pcibios_read_config_byte(pci_bus, pci_device_fn, 
                    PCI_INTERRUPT_LINE, &pci_irq);
            pcibios_read_config_dword(pci_bus, pci_device_fn,
                    PCI_BASE_ADDRESS_0, &pciaddr);

            irq        = pci_irq;
#endif
        }


           if ((ioaddr = (long)ioremap(pciaddr & PCI_BASE_ADDRESS_MEM_MASK,
                                    0x200)) == 0) {
               printk(KERN_INFO "Failed to map PCI address %#lx.\n", pciaddr);
               continue;
           }

#if LINUX_VERSION_CODE < 0x20193
           /* Read the cache line size from the PCI space. */
           pcibios_read_config_byte(pci_bus, pci_device_fn,
                                PCI_CACHE_LINE_SIZE, &cacheSz);
#else
        pci_read_config_byte(pdev, PCI_CACHE_LINE_SIZE, &cacheSz);
#endif

           // Cache line size is in DWORDS, calculate bytes. 
           cacheSz *= 4;

        /*
         * Check the cache line size
         */

        if ((cacheSz % 0x10) || (!cacheSz)) {
            printk(KERN_INFO "Cacheline size not proper.\n");
            cacheSz = 0x20;    //default:Use the paragraph boundary for alignment.
        }  

        /*
         * Here the Command reg is read and modified if necessary
         */

#if LINUX_VERSION_CODE < 0x20193
        pcibios_read_config_word(pci_bus, pci_device_fn,
                                 PCI_COMMAND, &pci_command);
#else
        pci_read_config_word(pdev, PCI_COMMAND, &pci_command);
#endif
        if ( (pci_command & (PCI_COMMAND_MASTER | PCI_COMMAND_INVALIDATE) )
             != (PCI_COMMAND_MASTER | PCI_COMMAND_INVALIDATE) ) {
#if LINUX_VERSION_CODE < 0x20193
            printk(KERN_INFO "The PCI BIOS has not enabled the"
                   " device at %d/%d.  Updating PCI command %4.4x->"
                   " | (PCI_COMMAND_MASTER | PCI_COMMAND_INVALIDATE).\n",
                   pci_bus, pci_device_fn, pci_command);
            pci_command |= (PCI_COMMAND_MASTER | PCI_COMMAND_INVALIDATE);
            pcibios_write_config_word(pci_bus, pci_device_fn,
                                      PCI_COMMAND, pci_command);
#else
        pci_write_config_byte(pdev, PCI_COMMAND, pci_command);
#endif
        }

        dev = tc990probe(dev, ioaddr, irq, chip_idx, cards_found);

        if (!dev) break;

#ifdef __VMKERNEL_MODULE__
        dev->enable_intr = &tc990_enable_intr;
        if(vmk_net_register_dev(dev, pdev, TRUE) != 0) {
            free_resources(dev);
            continue;
        }
#endif // __VMKERNEL_MODULE__

        /* PCI latency check (set) */
#if LINUX_VERSION_CODE < 0x20193
        pcibios_read_config_byte(pci_bus, pci_device_fn,
                                 PCI_LATENCY_TIMER, &pci_latency);
#else
        pci_read_config_byte(pdev, PCI_LATENCY_TIMER, &pci_latency);
#endif
        if (pci_latency < min_pci_latency[tc990_index]) {
            printk(KERN_INFO "  PCI latency timer (CFLT) is "
                   "unreasonably low at %d.  Setting to %d clocks.\n",
                   pci_latency, min_pci_latency[tc990_index]);

#if LINUX_VERSION_CODE < 0x20193
            pcibios_write_config_byte(pci_bus, pci_device_fn,
                            PCI_LATENCY_TIMER, min_pci_latency[tc990_index]);
#else

            pci_write_config_byte(pdev, PCI_LATENCY_TIMER, min_pci_latency[tc990_index]);
#endif
            /*
             * Save the pdev variable
             */
            ((struct tc990_private *)(dev->priv))->pdev = pdev;
            ((struct tc990_private *)(dev->priv))->index = tc990_index++;
        }
        dev = 0;
        cards_found++;
    }
    return cards_found ? 0 : -ENODEV;
}

static struct net_device *tc990probe ( struct net_device *dev, long ioaddr, u16 irq, u16 chip_id, u16 card_idx )
{
    struct tc990_private *np;
    u16 retval;
    u32 stationAddressLo = 0;
    u16 stationAddressHi = 0;
    u32 i;
    void *nonAlignedAddr;


    dev = init_etherdev(dev, sizeof(struct tc990_private));  

    dev->base_addr = ioaddr;
    dev->irq = irq;

    // VMWARE: need to keep around the original non aligned
    // address so we can properly free it at cleanup time.
    
    nonAlignedAddr = kmalloc (sizeof(*np) + 15, GFP_KERNEL);

    /* Make certain the descriptor lists are aligned. */
    np = (void *)((((long)nonAlignedAddr) + 15) & ~15);

    if (!np) { 
        free_resources(dev); 
        return NULL; 
    }
    memset( np, 0, sizeof(*np) );  

    np->nonAlignedAddr = nonAlignedAddr; 
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,43)
    init_waitqueue_head(&np->wait_q);
#endif

    dev->priv = np;

    np->shared = (struct tc990_shared *) pci_alloc_consistent( np->pdev, sizeof(struct tc990_shared), &np->shared_dma_addr);

    if (!np->shared) { 

        free_resources(dev); 
        return NULL; 

    }

    np->shared_size = sizeof(struct tc990_shared); 
    memset( np->shared, 0, sizeof(struct tc990_shared) );  
    np->resources_reserved |= TC990_SHARED_MEMORY_ALLOCATED;


    retval = init_ring_zone(dev); 

    if (retval) { 

        free_resources(dev);
        return NULL; 
    }

    

    np->chip_id = chip_id;

    spin_lock_init(&np->lock); 

    /* The chip-specific entries in the device structure. */
    dev->open = &tc990_open;
    dev->hard_start_xmit = &tc990_start_tx;
    dev->stop = &tc990_close;
    dev->get_stats = &tc990_get_stats;
    dev->set_multicast_list = &tc990_set_rx_mode;

    if ((retval = download_runtime_image(dev))) {;

        free_resources(dev);
        return NULL; 
    }

    if ((retval = download_boot_record(dev, tc990_WAITING_FOR_BOOT))) {

        free_resources(dev);
        return NULL; 
    }

    /* Set the maximum packet size for the firmware  */
    retval = issue_command(dev, tc990_CMD_MAX_PKT_SIZE_WRITE,
                           0x800, 0, 0, NULL, NULL, NULL, 1);
    retval |= issue_command(dev, 69, 0, 0, 0, NULL, NULL, NULL, 0); 

    if (retval) { 

        free_resources(dev); 
        return NULL; 
    }

    /* Read the station address from the adapter. */
    retval = issue_command(dev, tc990_CMD_STATION_ADR_READ,
             0, 0, 0, &stationAddressHi, &stationAddressLo, NULL, 1);

    if (retval) { 

        free_resources(dev);
        return NULL; 

    }

    dev->dev_addr[0] = ((u8*)(&stationAddressHi))[1];
    dev->dev_addr[1] = ((u8*)(&stationAddressHi))[0];
    dev->dev_addr[2] = ((u8*)(&stationAddressLo))[3];
    dev->dev_addr[3] = ((u8*)(&stationAddressLo))[2];
    dev->dev_addr[4] = ((u8*)(&stationAddressLo))[1];
    dev->dev_addr[5] = ((u8*)(&stationAddressLo))[0];

    printk(KERN_INFO "%s: %s at %#3lx, ", 
            dev->name, 
            pci_tbl[chip_id].name, 
            ioaddr
            );

    for (i = 0; i < 5; i++)
        printk("%2.2X:", dev->dev_addr[i]);

    printk("%2.2X, IRQ %d.\n", dev->dev_addr[i], irq);

    np->next_module = root_net_dev;
    root_net_dev = dev;
    /*
     * Update the resources reserved
     */
    np->resources_reserved |= TC990_DEVICE_IN_ROOT_CHAIN;

    return dev;
}


#ifdef __VMKERNEL_MODULE__
/*
 * tc990_link_watcher
 *
 * Used to check link state, which is now done in vmklinux via
 * ethtool. What's left here is periodic update of stats.
 *
 * See http://www.scyld.com/diag/mii-status.html for an explanation
 * of the commands being sent to the MII transceiver.
 */

void 
tc990_link_watcher(struct net_device *dev)
{  
   unsigned long flags;
   struct tc990_private *np = (struct tc990_private *)dev->priv;

   /* 
    * Added for ESX. Keep stats up to date by polling the NIC stats every
    * 4 seconds.
    */
   tc990_get_stats(dev);
   spin_lock_irqsave(&np->lock, flags); 
   np->timer_id.expires = np->timer_val = jiffies + (4 * HZ);
   np->timer_id.data = dev;
   np->timer_id.function = (void *) &tc990_link_watcher;
   add_timer(&np->timer_id);
   spin_unlock_irqrestore(&np->lock, flags); 
}  
#endif


static int tc990_open(struct net_device *dev)
{
    struct tc990_private *np = (struct tc990_private *)dev->priv;
    long ioaddr = dev->base_addr;
    u16 retval = 0;

    np->lock = (spinlock_t) SPIN_LOCK_UNLOCKED; 

    if (request_irq(dev->irq, &tc990_interrupt, SA_SHIRQ, dev->name, dev))
        return -EAGAIN;  

    np->resources_reserved |= TC990_IRQ_RESERVED;

    MOD_INC_USE_COUNT;

#if LINUX_VERSION_CODE < 0x20343

    dev->tbusy = 0;
    dev->interrupt = 0;
    dev->start = 1;
#endif
  
    if ( (force[np->index] < 0) || (force[np->index] > 4) ) 
        printk (KERN_WARNING "3c990: Bad value -- ""force=%x"".  Autonegotiation default used instead. \n", force[np->index]);
    else
        retval = issue_command(dev, tc990_CMD_XCVR_SELECT, 
                         force[np->index], 0, 0, NULL, NULL, NULL, 0);
    retval |= issue_command(dev, tc990_CMD_TX_ENABLE, 
                     0, 0, 0, NULL, NULL, NULL, 1);
    retval |= issue_command(dev, tc990_CMD_RX_ENABLE, 
                       0, 0, 0, NULL, NULL, NULL, 1);
    if (retval) return -EAGAIN;  
        writel(tc990_ENABLE_ALL_INT, ioaddr + tc990_INT_ENABLE_REG); 
    writel(tc990_UNMASK_ALL_INT, ioaddr + tc990_INT_MASK_REG );

#ifdef __VMKERNEL_MODULE__
	np->intr_enabled = 1;
#endif // __VMKERNEL_MODULE__

    netif_start_queue(dev);

#ifdef __VMKERNEL_MODULE__
    /* check link status every 4 seconds */
    init_timer(&np->timer_id);
    np->timer_id.expires = np->timer_val = jiffies + (4 * HZ);
    np->timer_id.data = dev;
    np->timer_id.function = (void *) &tc990_link_watcher;
    add_timer(&np->timer_id);
#endif // __VMKERNEL_MODULE__

    return 0;
}


static int tc990_start_tx(struct sk_buff *skb, struct net_device *dev)
{
    struct tc990_private *np = (struct tc990_private *)dev->priv;
    unsigned long flags;
    TX_RING *pTxRing = &np->ring_info.TxLoRing;    
    u32 xmitReadIndex;
    u32 xmitWriteIndex;
    u32 xmitDescriptorSpace;
    TX_DESC *pXmitWritePtr;
    TX_FRAME_DESC *pFramePtr;
#if LINUX_VERSION_CODE >= 0x20343
    unsigned long addr;
#endif

    /* 
     * Block a timer-based transmit from overlapping.  This could better 
     * be done with atomic_swap(1, dev->tbusy), but set_bit() works i
     * as well
     */

#if LINUX_VERSION_CODE < 0x20343
    if ( (test_and_set_bit(0, (void*)&dev->tbusy) != 0)) 
        return 1;
#endif

    spin_lock_irqsave(&np->lock, flags); 

    xmitReadIndex = pTxRing->LastReadUL;
    xmitWriteIndex = pTxRing->LastWriteUL;

    if ( xmitWriteIndex >= xmitReadIndex )
        xmitDescriptorSpace = (sizeof(TX_DESC)*TX_ENTRIES) -
                              (xmitWriteIndex - xmitReadIndex);
    else 
        xmitDescriptorSpace =  xmitReadIndex - xmitWriteIndex;
    
    if (xmitDescriptorSpace < (4 * sizeof(TX_DESC))) {

        np->tx_full  = 1; 
        netif_stop_queue(dev);
        spin_unlock_irqrestore(&np->lock, flags);
        return 1;

    }

    pXmitWritePtr = (TX_DESC *)(pTxRing->RingBase + xmitWriteIndex);
    pFramePtr = (TX_FRAME_DESC *) pXmitWritePtr;

    pFramePtr->frU.frFlagsS.frFlagsUC = FRAME_TYPE_PKT_HDR;
    pFramePtr->pktPtrLoUL = (u32)skb;
    pFramePtr->pktPtrHiUL = 0;

    update_tx_ring_index(&xmitWriteIndex);
    pXmitWritePtr = (TX_DESC *)(pTxRing->RingBase + xmitWriteIndex); 

    pXmitWritePtr->fragLenUW = (u16)skb->len;
    pXmitWritePtr->fragFlagsUC = FRAME_TYPE_FRAG_HDR | HOST_DESC_VALID;
    pXmitWritePtr->fragReservedUC = 0;
    pXmitWritePtr->fragSpareUL = 0;
#ifdef __VMKERNEL_MODULE__
    pXmitWritePtr->fragHostAddrLoUL = skb->headMA & 0xFFFFFFFF;
    pXmitWritePtr->fragHostAddrHiUL = skb->headMA >> 32;
#else // ! __VMKERNEL_MODULE__
#if LINUX_VERSION_CODE < 0x20343
    pXmitWritePtr->fragHostAddrLoUL =  virt_to_bus(skb->data) & 0xFFFFFFFF;
#else
    addr = pci_map_single(np->pdev, skb->data, skb->len, PCI_DMA_TODEVICE);
#if (BITS_PER_LONG == 64)
    pXmitWritePtr->fragHostAddrHiUL =  addr >> 32;
#else
    pXmitWritePtr->fragHostAddrHiUL =  0;
#endif
    pXmitWritePtr->fragHostAddrLoUL =  addr;
#endif
#endif // (!) __VMKERNEL_MODULE__

    pXmitWritePtr->fragHostAddrHiUL= 0;


    pFramePtr->frU.frFlagsS.frFlagsUC |= HOST_DESC_VALID;
    pFramePtr->frU.frFlagsS.frNumDescUC = 1;
    pFramePtr->frU.frFlagsS.frPktLen = (u16)skb->len;
    update_tx_ring_index(&xmitWriteIndex);

    pTxRing->LastWriteUL = xmitWriteIndex;
    writel(pTxRing->LastWriteUL, dev->base_addr + pTxRing->WriteRegister);

    spin_unlock_irqrestore(&np->lock, flags); 
#if LINUX_VERSION_CODE < 0x20343
    clear_bit(0, (void*)&dev->tbusy);    
#endif
    dev->trans_start = jiffies;

    return 0;
}

static void tc990_interrupt(int irq, void *dev_instance, struct pt_regs *rgs)
{
    struct net_device *dev = (struct net_device *)dev_instance;
    struct tc990_private *np;
    volatile u32 intr_status; 
    volatile u32 *rxReadIndex;
    volatile u32 *rxWriteIndex;
    long ioaddr; 
    volatile u32 *xmitReadIndex;

    ioaddr = dev->base_addr;
    np = (struct tc990_private *)dev->priv;

    spin_lock(&np->lock); 

    /* mask all the interrupts */

    writel(tc990_MASK_ALL_INT, ioaddr + tc990_INT_MASK_REG);

    intr_status = readl(ioaddr + tc990_INT_STATUS_REG);

     while (1) {

        writel(intr_status, ioaddr + tc990_INT_STATUS_REG);
        if (!intr_status) break;

        rxReadIndex =  &np->shared->var.hvWriteS.regRxHiReadUL;
        rxWriteIndex = &np->shared->var.hvReadS.regRxHiWriteUL;
        if(*rxReadIndex != *rxWriteIndex)
        process_receive(dev, &np->ring_info.RxHiRing, rxReadIndex, 
                        rxWriteIndex );

        /* Check the Low ring */
        rxReadIndex =  &np->shared->var.hvWriteS.regRxLoReadUL;
        rxWriteIndex = &np->shared->var.hvReadS.regRxLoWriteUL;        
        if (*rxReadIndex != *rxWriteIndex)
            process_receive(dev, &np->ring_info.RxLoRing, rxReadIndex, 
                            rxWriteIndex);

        /* check the transmit ring */
        xmitReadIndex = &np->shared->var.hvReadS.regTxLoReadUL;

        if (np->ring_info.TxLoRing.LastReadUL != *xmitReadIndex) 
            process_send_complete(dev, &np->ring_info.TxLoRing, xmitReadIndex);

        /* check the response ring */
        if ( np->shared->var.hvWriteS.regRespReadUL != 
             np->shared->var.hvReadS.regRespWriteUL)
            process_response( np, np->shared->var.hvWriteS.regRespReadUL, 0 );

        intr_status = readl(ioaddr + tc990_INT_STATUS_REG);

    } 
    
#ifdef __VMKERNEL_MODULE__
	 vmk_net_inc_dev_intrcount(dev);
	 if (!np->intr_enabled) {
		 spin_unlock(&np->lock);       
		 return;
	 }
#endif // __VMKERNEL_MODULE__

    /* unmask all the interrupts */
    writel(tc990_UNMASK_ALL_INT, ioaddr + tc990_INT_MASK_REG );    
    spin_unlock(&np->lock);       

    return;
}

static void process_receive(struct net_device *dev, tc990_RING *pRxRing,
                    volatile u32 *regRxReadUL, volatile u32 *regRxWriteUL)
{
    struct sk_buff *skb;
    RX_DSC  *rxDescriptor ;

    u32 slotIndex, rxReadIndex = *regRxReadUL, writeVal = *regRxWriteUL;
    u32 rxBufferSize =  ETHERNET_MAXIMUM_FRAME_SIZE + 4; 

    struct tc990_private *np = (struct tc990_private *)dev->priv;
    u16 count = 0; 

    while ( rxReadIndex != writeVal ){

        rxDescriptor = (RX_DSC*)(pRxRing->RingBase + rxReadIndex);
        slotIndex   = rxDescriptor->virtual_addr_lo;

        if (!rxDescriptor->RxStatus ) {

            skb = (struct sk_buff*)np->slot[slotIndex].skb;
            if (skb){  

                /*Add the pci_unmap code here */

                skb_put(skb, rxDescriptor->FrameLength);
                skb->protocol = eth_type_trans(skb, dev);
                netif_rx(skb);
                dev->last_rx = jiffies;
            }
        }

        UPDATE_INDEX( rxReadIndex, sizeof( RX_DSC ), RX_ENTRIES );
        writeVal = *regRxWriteUL;
        count++; 
    }

    /* Refill buffer slots */
    rxReadIndex = *regRxReadUL;

    while ( rxReadIndex != writeVal ) {

        /* Give this receive descriptor back to firmware. */
        rxDescriptor = (RX_DSC*)(pRxRing->RingBase + rxReadIndex);
        slotIndex   = rxDescriptor->virtual_addr_lo;

        UPDATE_INDEX( rxReadIndex, sizeof( RX_DSC ), RX_ENTRIES );
        *regRxReadUL = rxReadIndex ;

        if ((skb = dev_alloc_skb(rxBufferSize)) == NULL) {
            printk(KERN_CRIT "3c990: Memory squeeze (alloc rx buff failed) Danger!\n"); 
            return; 
        }
        skb->dev = dev;
#ifdef TC990_DEBUG
        printk(KERN_CRIT "*A:Data %x; tail %x; ", skb->data, skb->tail); //##
        printk(KERN_CRIT "Head %x; end %x \n", skb->head, skb->end); //##
#endif

        /* Save the information in the slot. */
        np->slot[slotIndex].virtual_addr_lo = (u32)skb->tail;
        np->slot[slotIndex].virtual_addr_hi = 0;
        np->slot[slotIndex].skb = (u32)skb;

        /* Add the pci unmap code */

        np->slot[slotIndex].physical_addr_lo = 
                   pci_map_single(
                    np->pdev, (u8 *)np->slot[slotIndex].virtual_addr_lo,
                    rxBufferSize,
                    PCI_DMA_FROMDEVICE
                    );

         np->slot[slotIndex].physical_addr_hi = 0;
         np->slot[slotIndex].buffer_length      = rxBufferSize;
         release_buf_to_firmware(dev, slotIndex );
#ifdef TC990_DEBUG
         printk(KERN_CRIT "*B:Data %x; tail %x=%x; ", skb->data, np->slot[slotIndex].virtual_addr_lo, skb->tail); 
        printk(KERN_CRIT "Head %x; end %x \n", skb->head, skb->end);
#endif

    }
} 

static void release_buf_to_firmware( struct net_device *dev, u32 slot_index )
{
    RX_FREE_DSC *rxFreeDescriptor;
    HOST_VAR_S *pHostVar;
    struct tc990_private *np = (struct tc990_private *)dev->priv;    
 
#ifdef __VMKERNEL_MODULE__   
    pHostVar = (HOST_VAR_S*)bus_to_virt((u32)np->shared_dma_addr,
                                        (void *)np->shared,
                                        (u32) np->shared->init.hostVarsPS);
#else
    pHostVar = (HOST_VAR_S*)bus_to_virt((u32)np->shared->init.hostVarsPS);
#endif // __VMKERNEL_MODULE__

    rxFreeDescriptor = (RX_FREE_DSC*) 
        (np->ring_info.RxBuffRing.RingBase + pHostVar->hvWriteS.regRxBuffWriteUL);
    
    rxFreeDescriptor->physical_addr_lo =np->slot[slot_index].physical_addr_lo;
    rxFreeDescriptor->physical_addr_hi =np->slot[slot_index].physical_addr_hi;
    rxFreeDescriptor->virtual_addr_lo = slot_index;
    rxFreeDescriptor->virtual_addr_hi = 0; 
    
    UPDATE_INDEX( pHostVar->hvWriteS.regRxBuffWriteUL, 
                  sizeof( RX_FREE_DSC ), RX_ENTRIES );
}


static u8 process_response( struct tc990_private *np, u32 responseReadIndex, 
                           u16 Command )
{
    RESPONSE_DSC* responseDesc;
    
        while ( responseReadIndex !=  np->shared->var.hvReadS.regRespWriteUL ){
        responseDesc = (RESPONSE_DSC*)
                (np->ring_info.RspRing.RingBase + responseReadIndex);
        
        if ( Command == responseDesc->nrml.Command ) 
            return tc990_STATUS_CMD_FOUND; 
        if (responseDesc->nrml.Command == tc990_CMD_READ_STATS){ 
            stats_handler( np );
            responseReadIndex =  np->shared->var.hvWriteS.regRespReadUL;
            return 0;
        }
        else {
            if ( responseDesc->nrml.Flags & RESPONSE_DSC_ERROR_SET ) 
                printk(KERN_WARNING "tc990: Response error bit set \n");
            UPDATE_INDEX( np->shared->var.hvWriteS.regRespReadUL,
                          sizeof(RESPONSE_DSC), RESPONSE_ENTRIES );
            responseReadIndex =  np->shared->var.hvWriteS.regRespReadUL;
        }
    }
    return 0;
}


static void process_send_complete(struct net_device *dev, TX_RING *pTxRing, volatile u32 *xmitReadIndex)    
{

    TX_FRAME_DESC *pXmitReadPtr;
    struct sk_buff *skb;
    struct tc990_private *np = (struct tc990_private *)dev->priv;
    while (pTxRing->LastReadUL != *xmitReadIndex) {
        
        pXmitReadPtr = (TX_FRAME_DESC *)
                       (pTxRing->RingBase + pTxRing->LastReadUL);

        if(pXmitReadPtr->frU.frFlagsS.frFlagsUC & FRAME_TYPE_PKT_HDR) {

            skb = (struct sk_buff *)pXmitReadPtr->pktPtrLoUL;
            /* Add the PCI unmap code here */
            dev_kfree_skb_irq(skb);

        }

        update_tx_ring_index(&pTxRing->LastReadUL);
    }

    if (np->tx_full){

        np->tx_full = 0;
        netif_wake_queue(dev); /* Attention: under a spinlock.  --SAW */
    }


}
static void stats_handler( struct tc990_private  *np )
{    
    RESPONSE_DSC* responseDescriptor;
    
    responseDescriptor = (RESPONSE_DSC*) (np->ring_info.RspRing.RingBase + 
                         np->shared->var.hvWriteS.regRespReadUL);

    if ( responseDescriptor->nrml.Flags & RESPONSE_DSC_ERROR_SET ) {

        printk(KERN_WARNING "3c990: Stats error flag set.\n" ); 
        return;

    }

    np->stats.tx_packets = responseDescriptor->tx.pkt; 
#if LINUX_VERSION_CODE > 0x20024
    np->stats.tx_bytes = responseDescriptor->tx.byte;
#endif

    UPDATE_INDEX( np->shared->var.hvWriteS.regRespReadUL, sizeof(RESPONSE_DSC),
                  RESPONSE_ENTRIES );
    responseDescriptor = (RESPONSE_DSC*) (np->ring_info.RspRing.RingBase + 
                          np->shared->var.hvWriteS.regRespReadUL );

    UPDATE_INDEX(np->shared->var.hvWriteS.regRespReadUL, sizeof(RESPONSE_DSC),
                 RESPONSE_ENTRIES );

    responseDescriptor = (RESPONSE_DSC*) (np->ring_info.RspRing.RingBase + 
                         np->shared->var.hvWriteS.regRespReadUL );

    np->stats.tx_carrier_errors = responseDescriptor->txCrit.carrierLost;
    np->stats.collisions = responseDescriptor->txCrit.multCollision;
    np->stats.tx_errors = responseDescriptor->txCrit.carrierLost;        
    
    UPDATE_INDEX(np->shared->var.hvWriteS.regRespReadUL, sizeof(RESPONSE_DSC), 
                 RESPONSE_ENTRIES );

    responseDescriptor = (RESPONSE_DSC*) (np->ring_info.RspRing.RingBase + 
                          np->shared->var.hvWriteS.regRespReadUL );
 
    np->stats.rx_packets = responseDescriptor->txRx.rxPkt;
#if LINUX_VERSION_CODE > 0x20024
    np->stats.rx_bytes = responseDescriptor->txRx.rxByte;
#endif
    
    UPDATE_INDEX(np->shared->var.hvWriteS.regRespReadUL, sizeof(RESPONSE_DSC),
                  RESPONSE_ENTRIES );
    responseDescriptor = (RESPONSE_DSC*) (np->ring_info.RspRing.RingBase + 
                         np->shared->var.hvWriteS.regRespReadUL );    

    np->stats.rx_fifo_errors = responseDescriptor->rx.fifoOverrun;
    np->stats.rx_errors = responseDescriptor->rx.fifoOverrun;
    np->stats.rx_errors += responseDescriptor->rx.badSSD;
    np->stats.rx_errors += responseDescriptor->rx.crcError;
    np->stats.rx_crc_errors = responseDescriptor->rx.crcError;
    
    UPDATE_INDEX( np->shared->var.hvWriteS.regRespReadUL, 
                  sizeof( RESPONSE_DSC ), RESPONSE_ENTRIES );
    responseDescriptor = (RESPONSE_DSC*) 
        (np->ring_info.RspRing.RingBase + np->shared->var.hvWriteS.regRespReadUL );
    np->stats.rx_length_errors = responseDescriptor->rxGeneral.oversize;    

    UPDATE_INDEX( np->shared->var.hvWriteS.regRespReadUL, 
                  sizeof( RESPONSE_DSC ), RESPONSE_ENTRIES );
    responseDescriptor = (RESPONSE_DSC*) 
        (np->ring_info.RspRing.RingBase + np->shared->var.hvWriteS.regRespReadUL );
    
    UPDATE_INDEX(np->shared->var.hvWriteS.regRespReadUL, sizeof(RESPONSE_DSC), 
                 RESPONSE_ENTRIES );
    responseDescriptor = (RESPONSE_DSC*) (np->ring_info.RspRing.RingBase + 
                         np->shared->var.hvWriteS.regRespReadUL );


#ifndef __VMKERNEL_MODULE__

    /*
     * See comment below surrounding the call to interruptible_sleep_on_timeout.
     * Given no goes to sleep in the vmkernel version of this driver, we can safely
     * comment out the call to wake_up_interruptible.
     */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,43)
    wake_up_interruptible(&np->wait_q);
#else
    wake_up_interruptible(&np->wait_q);
#endif

#endif
}

static struct net_device_stats *tc990_get_stats(struct net_device *dev)
{
    u16 errVal = 0;  
    unsigned long flags;
    struct tc990_private *np = (struct tc990_private *)dev->priv;

    if (netif_running(dev)) {
        spin_lock_irqsave(&np->lock, flags); 
        errVal = issue_command( dev, (u16)tc990_CMD_READ_STATS,
                               0, 0, 0, NULL, NULL, NULL, 0 ); 
        spin_unlock_irqrestore(&np->lock, flags); 
        if (errVal) printk(KERN_CRIT "3c990: Stats command gone BAD." );
#ifndef __VMKERNEL_MODULE__
        /*
         * We can't do an interruptible sleep in the vmkernel because
         * unlike linux we have no notion of process context. We get around
         * this by returning immediately with the stats currently available.
         * It is possible we are returning stats that are out of date. But this
         * bounded by a periodic stats poll we do every 4 seconds.
         * (see tc990_link_watcher for more details).
         */
        interruptible_sleep_on_timeout( &np->wait_q, HZ);
#endif
    }

    return &np->stats;
}


static void tc990_set_rx_mode(struct net_device *dev)
{
    u32 filter = 0;
    u32 Crc, Carry;
    u16 i, j;
    u8 ThisByte;
    u8 Address[6];
    u32 hashFilterArray[(tc990_MULTICAST_BITS + 1) / 32];
    u32 hashBit, count;

    if (dev->flags & IFF_PROMISC) {       /* Set promiscuous. log net taps */
        printk(KERN_NOTICE "%s: Promiscuous mode enabled.\n", dev->name);
        filter |= tc990_RX_FILT_PROMISCUOUS;
    } 
    else if (dev->flags & IFF_ALLMULTI) {
        filter |= tc990_RX_FILT_DIRECTED; 
        filter |= tc990_RX_FILT_ALL_MULTICAST;
        filter |= tc990_RX_FILT_BROADCAST;
    }
    else if (dev->flags & IFF_MULTICAST) {
        filter |= tc990_RX_FILT_DIRECTED;
        filter |= tc990_RX_FILT_HASH_MULTICAST;
        filter |= tc990_RX_FILT_BROADCAST;
        /*
         *SetMulticastAddressList on the adapter.
         * Clear all bits   
         */
        memset( hashFilterArray, 0, sizeof( hashFilterArray ) ); 
        /* 
         * Calculate hash bit for eash address and stuff in bit array             */

        for ( count = 0; count < dev->mc_count; count++ ) {            
            /* CalculateHashBits */
            /* Compute CRC for the address value  */
            Crc = 0xffffffff;  // initial value 
            /* For each byte of the address */
            for ( i = 0; i < 6; i++ ) {
                ThisByte = Address[i];
                /* For each bit in the byte */
                for ( j = 0; j < 8; j++ ) {
                    Carry = ((Crc & 0x80000000) ? 1 : 0) ^ (ThisByte & 0x01);
                    Crc  <<= 1;
                    ThisByte >>= 1;
                    if ( Carry )
                        Crc = (Crc ^ POLYNOMIAL) | Carry;
                }
            }
            /* filter bit position  */
            hashBit = (u16)(Crc & tc990_MULTICAST_BITS) ;            
            hashFilterArray[ hashBit / 32 ] |=  ( 1 << hashBit % 32 ) ;
        }
        i = issue_command( dev, (u16)tc990_CMD_MCAST_HASH_MASK_WRITE,
                          (u16)2, hashFilterArray[0], hashFilterArray[1], 
                          NULL,  NULL,  NULL,  0 ); 
    }
    else {
        filter |= tc990_RX_FILT_DIRECTED;
        filter |= tc990_RX_FILT_BROADCAST;
    }
    i = issue_command(dev, (u16)tc990_CMD_RX_FILT_WRITE,
                     (u16)filter, 0, 0, NULL, NULL, NULL, 0); 
}

static int tc990_close(struct net_device *dev)
{
    u16 errVal; 
    long ioaddr = dev->base_addr; 

    netif_stop_queue(dev);

#ifdef __VMKERNEL_MODULE__
    del_timer(&(((struct tc990_private *)dev->priv)->timer_id));
#endif 

    /* Disable interrupts by clearing the interrupt mask. */
    writel(tc990_MASK_ALL_INT, ioaddr + tc990_INT_MASK_REG);
    /* Stop the chip's Tx and Rx processes. */
    errVal = issue_command(dev, tc990_CMD_TX_DISABLE,
                          0, 0, 0, NULL, NULL, NULL, 1);
    errVal |= issue_command(dev, tc990_CMD_RX_DISABLE,
                           0, 0, 0, NULL, NULL, NULL, 1);
    if (errVal) printk(KERN_CRIT 
      "3c990: Unaccounted for failure of command to network adapter. DANGER!");
    free_irq(dev->irq, dev);

    MOD_DEC_USE_COUNT;
    return 0;
}

#ifdef MODULE
#if (LINUX_VERSION_CODE < 0x02032a)
int init_module(void)
{
    return tc990_init_module();
}


void cleanup_module(void)
{
    tc990_cleanup_module();
}
#else
module_init(tc990_init_module);
module_exit(tc990_cleanup_module);
#endif
#endif

#ifdef MODULE

int tc990_init_module(void)
{
#ifdef __VMKERNEL_MODULE__
    if (!vmk_set_module_version("%s", version)) {
       return -ENODEV;
    }
#endif
    printk(KERN_INFO "%s", version);
    return pci_etherdev_probe(NULL, pci_tbl);
}

void tc990_cleanup_module(void)
{
    struct net_device *next_dev;
    u16 index;

    /* No need to check MOD_IN_USE, as sys_delete_module() checks. */

    while (root_net_dev) {
        struct tc990_private *np=(struct tc990_private *)root_net_dev->priv;

        next_dev = np->next_module;

        unregister_netdev(root_net_dev);

        iounmap((char *)root_net_dev->base_addr);

        /* Free all receive buffers in the receive buffer descriptor ring. */
        for  ( index = 0 ; index < RX_ENTRIES - 1; index++ ) {
            if (np->slot[index].skb != (u32)NULL) {
                dev_kfree_skb((void*)np->slot[index].skb);
            }
            np->slot[index].virtual_addr_lo = 0;
            np->slot[index].physical_addr_lo = 0;
        }

        pci_free_consistent(np->pdev, np->slot_memory_size,
                            np->slot, np->slot_physical);
        pci_free_consistent(np->pdev, np->shared_size,
                            np->shared, np->shared_dma_addr);

        kfree(np->nonAlignedAddr);
        kfree(root_net_dev);
        root_net_dev = next_dev;
    }

}

#endif  // * MODULE *

static void free_resources(struct net_device *dev)
{
    u16 index;
    struct tc990_private *np=(struct tc990_private *)dev->priv;


    printk(KERN_INFO"3c990: There appear to be inadequate resources at this time and on this machine for this driver.  Killing further initialization. \n" );

    if (!np) return;

    unregister_netdev(dev);

    if (np->resources_reserved & TC990_DEVICE_IN_ROOT_CHAIN) {

        root_net_dev = np->next_module;

    }

    if (np->resources_reserved & TC990_IO_MAPPED)
        iounmap((char *)dev->base_addr);


    if (np->resources_reserved & TC990_SLOT_MEMORY_ALLOCATED) {

        /* Free all the receive buffers */
        if (np->slot){
            for( index = 0 ; index < RX_ENTRIES - 1; index++ ) {

                if (np->slot[index].skb != (u32)NULL) {
                    dev_kfree_skb((void*)np->slot[index].skb);
                }

                np->slot[index].virtual_addr_lo = 0;
                np->slot[index].physical_addr_lo = 0;
            }
        }

        pci_free_consistent(
            np->pdev, 
            np->slot_memory_size,
            np->slot,
            np->slot_physical
            );

    }

    if (np->resources_reserved & TC990_SHARED_MEMORY_ALLOCATED) {
        pci_free_consistent(
            np->pdev,
            sizeof(struct tc990_shared),
            np->shared,
            np->shared_dma_addr
            );    

    }


    //modifed by VMWARE
    if (np) {
       kfree(np->nonAlignedAddr);
    }
    kfree(dev);
    return;
}


static u16 issue_command(struct net_device *dev, u16 Command, u16 Parameter1,
u32 Parameter2, u32 Parameter3, u16 *Return1, u32 *Return2, u32 *Return3, 
u8 WaitForResponse) {

      struct tc990_private *np = (struct tc990_private *)dev->priv;
      CMD_DSC*      commandDescriptor;
      RESPONSE_DSC* responseDescriptor;
      u32 count, responseStatus;
      long ioaddr = dev->base_addr; 

      commandDescriptor = (CMD_DSC*) (np->ring_info.CmdRing.RingBase + 
                 np->ring_info.CmdRing.LastWriteUL );
      memset(commandDescriptor, 0, sizeof( CMD_DSC )); 

      if ( WaitForResponse )   /* Check if wait for response is needed.*/
            /*
         * Set the flag indicating the need for a response 
         * to the command.
          */
            responseStatus = CMD_DSC_RESPONSE_NEEDED;
      else
            responseStatus = CMD_DSC_RESPONSE_NOT_NEEDED;

      commandDescriptor->Command       = Command;
      commandDescriptor->num_descriptor = 0;
      commandDescriptor->Parameter1    = Parameter1;
      commandDescriptor->Parameter2    = Parameter2;
      commandDescriptor->Parameter3    = Parameter3;
      commandDescriptor->Flags         = CMD_DSC_FRAME_VALID 
                  | responseStatus | CMD_DSC_TYPE_CMD_FRAME ; 
     commandDescriptor->SequenceNo    = 0x11;

      UPDATE_INDEX( np->ring_info.CmdRing.LastWriteUL, sizeof( CMD_DSC ), 
                CMD_ENTRIES) ; 

      writel(np->ring_info.CmdRing.LastWriteUL, ioaddr + tc990_HostTo3XP_COMM_2_REG);

      if ( WaitForResponse ) {    /* Check for response */
        for ( count = 0; count < tc990_WAIT_COUNTER; count++ ){
          /* 
                  * If firmware has posted the response then break from loop
                   */
          if ( np->shared->var.hvWriteS.regRespReadUL != 
               np->shared->var.hvReadS.regRespWriteUL ){
              if(tc990_CMD_READ_STATS==commandDescriptor->Command){
                  process_response (np, np->shared->var.hvWriteS.regRespReadUL, 0);
                  return 0;
              }
              if (tc990_STATUS_CMD_FOUND == process_response 
                  (np, np->shared->var.hvWriteS.regRespReadUL, 
                   (u16)commandDescriptor->Command))               break;
          }
          udelay(50);  
      }
      /*
       * If no response for tc990_WAIT_COUNTER, return failure.
       */

      if ( count >= tc990_WAIT_COUNTER ) 
          return 1;
    
        responseDescriptor = (RESPONSE_DSC*) (np->ring_info.RspRing.RingBase + 
                      np->shared->var.hvWriteS.regRespReadUL);
    if ( responseDescriptor->nrml.Flags & RESPONSE_DSC_ERROR_SET ) 
              return 1;
        /* Command is successful, pass the response results back. */
        if ( Return1 ) *Return1 = (u16)responseDescriptor->nrml.Parameter1;
        if ( Return2 ) *Return2 = responseDescriptor->nrml.Parameter2;
        if ( Return3 ) *Return3 = responseDescriptor->nrml.Parameter3;
        UPDATE_INDEX(np->shared->var.hvWriteS.regRespReadUL, 
                 sizeof( RESPONSE_DSC ), RESPONSE_ENTRIES);
      }
      return 0;
}

static u16 reset_adapter(struct net_device *dev)
{
    u32  count;
    long ioaddr = dev->base_addr;

    writel(tc990_RESET_ALL, ioaddr + tc990_SOFT_RESET_REG);
    udelay(10);     // Give the board some time to adjust
    writel(0,    ioaddr + tc990_SOFT_RESET_REG);   
    for ( count = 0; count < tc990_WAIT_COUNTER; count++ ) {
        if ( readl(ioaddr + tc990_3XP2HOST_COMM_0_REG) == 
             tc990_WAITING_FOR_HOST_REQUEST ) break;
        udelay(50); 
    }
    if ( count >= tc990_WAIT_COUNTER )  return 1;
    return 0;

}


static 
u16 download_boot_record(struct net_device *dev, u16 process)
{
    struct tc990_private *np = (struct tc990_private *)dev->priv;
    u32  val, counter;
    long ioaddr = dev->base_addr;

    /* Check if the adapter status is waiting for boot. */
    for ( counter = 0; counter < tc990_WAIT_COUNTER; counter++ ) {
        val = readl(ioaddr + tc990_3XP2HOST_COMM_0_REG); 
        if ( val == process ) break;
        udelay(50);      
    }

    if ( tc990_WAIT_COUNTER == counter  ) return 21;
    
    /* register the ring with the firmware */
    writel(0, ioaddr +  tc990_HostTo3XP_COMM_2_REG);
    writel( np->ringPhysical, 
           ioaddr + tc990_HostTo3XP_COMM_1_REG );

    writel(tc990_BOOTCMD_REG_BOOT_RECORD, 
           ioaddr + tc990_HostTo3XP_COMM_0_REG);
        
    /* wait for the firmware to pick up the command. */
    for ( counter = 0; counter < tc990_WAIT_COUNTER; counter++ ) {
        val = readl(ioaddr + tc990_3XP2HOST_COMM_0_REG);
        if ( val != process )
            break;
        udelay(50);
    }
    
    if ( tc990_WAIT_COUNTER == counter ) return 22;
    
    /* clear the tx and cmd ring write registers */
    writel(tc990_NULL_CMD, ioaddr + tc990_HostTo3XP_COMM_1_REG);
    writel(tc990_NULL_CMD, ioaddr + tc990_HostTo3XP_COMM_2_REG);
    writel(tc990_NULL_CMD, ioaddr + tc990_HostTo3XP_COMM_3_REG);
    writel(tc990_NULL_CMD, ioaddr + tc990_HostTo3XP_COMM_0_REG);
    
    return 0;
}

static u16 init_ring_zone( struct net_device *dev ) 
{
    struct tc990_private *np = (struct tc990_private *)dev->priv;
    u32 physicalLow  = (u32)np->shared_dma_addr;
#ifdef __VMKERNEL_MODULE__
    void *baseVirt        = (void *)np->shared;
    u32 basePhysical = physicalLow;
#endif // __VMKERNEL_MODULE__

    u16 index;
    RX_FREE_DSC *rxFreeDescriptor; 
    u16 rxBufferSize =  ETHERNET_MAXIMUM_FRAME_SIZE + 4; 
    struct sk_buff *skb;

    np->ringPhysical = physicalLow;   

    /* initialize the BootRecord and HostRingReadWrite registers */

    np->shared->init.hostZeroWordUL     = physicalLow + sizeof(HOST_INIT_S); 
    np->shared->init.hostZeroWordHiUL     = 0;

    physicalLow                     += sizeof(HOST_INIT_S) + sizeof(u32); 

    np->shared->init.hostVarsPS     = (HOST_VAR_S*)physicalLow;
    np->shared->init.hostVarsHiUL     = 0;

    physicalLow                         += sizeof(HOST_VAR_S);

#ifdef __VMKERNEL_MODULE__
    np->ring_info.TxLoRing.RingBase        = 
        (u32)bus_to_virt(basePhysical, baseVirt, physicalLow); 
#else
     np->ring_info.TxLoRing.RingBase = (u32)bus_to_virt(physicalLow); 
#endif // __VMKERNEL_MODULE__

    np->shared->init.hostTxLoStartUL     =  physicalLow;
    np->shared->init.hostTxLoStartHiUL    = 0;
    np->shared->init.hostTxLoSizeUL        = TX_ENTRIES * sizeof(TX_DESC);
    
    physicalLow += np->shared->init.hostTxLoSizeUL;

#ifdef __VMKERNEL_MODULE__
    np->ring_info.TxHiRing.RingBase = 
        (u32)bus_to_virt(basePhysical, baseVirt, physicalLow); 
#else
    np->ring_info.TxHiRing.RingBase = (u32)bus_to_virt(physicalLow); 
#endif // __VMKERNEL_MODULE__

    np->shared->init.hostTxHiStartUL =  physicalLow;
    np->shared->init.hostTxHiStartHiUL = 0;
    np->shared->init.hostTxHiSizeUL = TX_ENTRIES * sizeof(TX_DESC);
    
    physicalLow += np->shared->init.hostTxHiSizeUL;
    /* 
     * Save the address of RxLo descriptor ring. 
     * This ring is filled by f/w.
     */
#ifdef __VMKERNEL_MODULE__
    np->ring_info.RxLoRing.RingBase =         
        (u32)bus_to_virt(basePhysical, baseVirt, physicalLow); 
#else
     np->ring_info.RxLoRing.RingBase = (u32)bus_to_virt(physicalLow); 
#endif // __VMKERNEL_MODULE__

    np->shared->init.hostRxLoStartUL = physicalLow;
    np->shared->init.hostRxLoStartHiUL = 0;
    np->shared->init.hostRxLoSizeUL = RX_ENTRIES * sizeof(RX_DSC);

    physicalLow += np->shared->init.hostRxLoSizeUL;
    
    /*
     * Save the address of RxHi descriptor ring. 
     * This ring is filled by f/w.
     */
#ifdef __VMKERNEL_MODULE__
    np->ring_info.RxHiRing.RingBase = 
        (u32)bus_to_virt(basePhysical, baseVirt, physicalLow); 
#else
    np->ring_info.RxHiRing.RingBase =  (u32)bus_to_virt(physicalLow); 
#endif // __VMKERNEL_MODULE__

    np->shared->init.hostRxHiStartUL = physicalLow;
    np->shared->init.hostRxHiStartHiUL = 0;
    np->shared->init.hostRxHiSizeUL = RX_ENTRIES * sizeof(RX_DSC);

    physicalLow += np->shared->init.hostRxHiSizeUL;
    /* 
     * Save the address of Rx buffer ring. 
     * This ring is filled by driver.
     */
#ifdef __VMKERNEL_MODULE__
    np->ring_info.RxBuffRing.RingBase         = 
        (u32)bus_to_virt(basePhysical, baseVirt, physicalLow); 
#else
    np->ring_info.RxBuffRing.RingBase         = (u32)bus_to_virt(physicalLow);
#endif // __VMKERNEL_MODULE__

    np->shared->init.hostRxFreeStartUL         = physicalLow;
    np->shared->init.hostRxFreeStartHiUL     = 0;
    np->shared->init.hostRxFreeSizeUL        = RX_ENTRIES * sizeof(RX_FREE_DSC);

    physicalLow += np->shared->init.hostRxFreeSizeUL;
    /*
     * Save the command and response buffers
     */
#ifdef __VMKERNEL_MODULE__
    np->ring_info.CmdRing.RingBase        = 
        (u32)bus_to_virt(basePhysical, baseVirt, physicalLow); 
#else
    np->ring_info.CmdRing.RingBase        = (u32)bus_to_virt(physicalLow);
#endif // __VMKERNEL_MODULE__

    np->shared->init.hostCtrlStartUL     = physicalLow;      
    np->shared->init.hostCtrlStartHiUL     = 0;
    np->shared->init.hostCtrlSizeUL     = CMD_ENTRIES * sizeof(CMD_DSC);

    physicalLow += np->shared->init.hostCtrlSizeUL;
#ifdef __VMKERNEL_MODULE__
    np->ring_info.RspRing.RingBase         = 
                (u32)bus_to_virt(basePhysical, baseVirt, physicalLow); 
#else
    np->ring_info.RspRing.RingBase         = (u32)bus_to_virt(physicalLow);
#endif

    np->shared->init.hostRespStartUL     = physicalLow;
    np->shared->init.hostRespStartHiUL     = 0;
    np->shared->init.hostRespSizeUL     = RESPONSE_ENTRIES *  
                                          sizeof(RESPONSE_DSC);

    np->shared->var.hvWriteS.regRxBuffWriteUL = (RX_ENTRIES - 1) * 
                                             sizeof(RX_FREE_DSC);

    /*
     * Initialize counters  (from ResetRingStructures) 
     */
     np->ring_info.RxLoRing.LastWriteUL       = 0;        
     np->ring_info.RxHiRing.LastWriteUL       = 0;        
     np->ring_info.RxBuffRing.LastWriteUL     = 0;
     np->ring_info.TxLoRing.LastWriteUL       = 0;        
     np->ring_info.TxHiRing.LastWriteUL       = 0;        
     np->ring_info.CmdRing.LastWriteUL        = 0;

     np->ring_info.TxLoRing.LastReadUL        = 0;        
     np->ring_info.TxHiRing.LastReadUL        = 0;        
     np->ring_info.TxLoRing.WriteRegister     = tc990_HostTo3XP_COMM_3_REG;   
     np->ring_info.TxHiRing.WriteRegister     = tc990_HostTo3XP_COMM_1_REG; 
     np->ring_info.TxLoRing.PacketPendingNo   = 0;
     np->ring_info.TxHiRing.PacketPendingNo   = 0;

     np->ring_info.TxLoRing.NoEntries = TX_ENTRIES;
     np->ring_info.TxHiRing.NoEntries = TX_ENTRIES;
     np->ring_info.CmdRing.NoEntries = CMD_ENTRIES;
     np->ring_info.RspRing.NoEntries = RESPONSE_ENTRIES;

     np->slot_memory_size = ((RX_ENTRIES-1)*(sizeof(struct SLOT)));

     np->slot = pci_alloc_consistent(
                    np->pdev,
                    np->slot_memory_size,
                    &np->slot_physical
                    );

     if (!np->slot) return 50;
     memset( np->slot, 0, np->slot_memory_size);
     np->resources_reserved |= TC990_SLOT_MEMORY_ALLOCATED;

     /*
      * Alloc slots
      * Put the addresses of all the receive buffers in the receive buffer
      * descriptor ring.    
      */
     for ( index = 0 ; index < RX_ENTRIES - 1; index++ ) {
        if ((skb = dev_alloc_skb(rxBufferSize)) == NULL) {

            printk(KERN_INFO "3c990: Allocate rx skb failed.\n");
            printk(KERN_INFO "Try reducing RX_ENRIES value and recompile\n");
            return 52; 

         }
         skb->dev = dev;

         /* Save the information in the slot. */
         np->slot[index].virtual_addr_lo = (u32)skb->tail;
         np->slot[index].virtual_addr_hi = 0;
         np->slot[index].skb = (u32)skb;
         np->slot[index].physical_addr_lo = 
                        pci_map_single(
                            np->pdev, 
                            (void *)np->slot[index].virtual_addr_lo,
                            rxBufferSize,
                            PCI_DMA_FROMDEVICE
                            );

         np->slot[index].physical_addr_hi = 0;
         np->slot[index].buffer_length = rxBufferSize;

     }
        
    /* Indicate all the buffers are free.  */
    rxFreeDescriptor = (RX_FREE_DSC*)np->ring_info.RxBuffRing.RingBase; 
    for(index = 0; index < RX_ENTRIES - 1; index++ ) {
        
        rxFreeDescriptor->physical_addr_lo = np->slot[index].physical_addr_lo;
        rxFreeDescriptor->physical_addr_hi = np->slot[index].physical_addr_hi;
        rxFreeDescriptor->virtual_addr_lo = index;
        rxFreeDescriptor->virtual_addr_hi = 0;
        rxFreeDescriptor++;

     }
    return 0;
}

static u16 
download_runtime_image(struct net_device *dev)
{
    struct tc990_private *np = (struct tc990_private *)dev->priv;
    tc990_FILE_HEADER *fileHeader;
    u32 index;
    tc990_FILE_SECTION *fileSection;
    u32 count, value, oldIntMask, oldIntEnable;
    u32 tempLength, thisSectionHeaderLocation, thisSectionDataLocation;
    void *sectionDataBuffer; 
    u32 start_address, numBytesInThisSection, checksum;
    u32  sections;
    long ioaddr = dev->base_addr; 

    np->DownloadPageVirtual = pci_alloc_consistent(np->pdev,tc990_IMAGE_SIZE,
                                                   &np->DownloadPagePhysical);
                        
    if (np->DownloadPageVirtual == NULL) return 1;

    fileHeader = (tc990_FILE_HEADER*)tc990image; 

    if((fileHeader->tagID[0] != 'T') || (fileHeader->tagID[1] != 'Y') ||
       (fileHeader->tagID[2] != 'P') || (fileHeader->tagID[3] != 'H') ||
       (fileHeader->tagID[4] != 'O') || (fileHeader->tagID[5] != 'O') ||
       (fileHeader->tagID[6] != 'N')) { 

        pci_free_consistent(np->pdev, tc990_IMAGE_SIZE, 
                            np->DownloadPageVirtual, np->DownloadPagePhysical);

        return 1;

    }

    if (reset_adapter(dev)) {

        pci_free_consistent(np->pdev, tc990_IMAGE_SIZE, 
                            np->DownloadPageVirtual, 
                            np->DownloadPagePhysical
                            );
        return 1;

    }

    udelay(5000);    
    oldIntEnable = readl(ioaddr + tc990_3XP2HOST_COMM_0_REG); 

    /* Mask the interrupts and enable the interrupts. */
    oldIntEnable = readl(ioaddr + tc990_INT_ENABLE_REG); 
    writel(oldIntEnable | tc990_3XP_COMM_INT0, ioaddr + tc990_INT_ENABLE_REG);
    oldIntMask = readl(ioaddr + tc990_INT_MASK_REG);
    writel(oldIntMask | tc990_3XP_COMM_INT0, ioaddr + tc990_INT_MASK_REG );

    for ( count = 0; count < tc990_WAIT_COUNTER ; count++ ) {

        value   = readl(ioaddr + tc990_3XP2HOST_COMM_0_REG);
        if ( value == tc990_WAITING_FOR_HOST_REQUEST ) break;
        udelay(50);    

    }

    if ( count == tc990_WAIT_COUNTER ) {

        pci_free_consistent(np->pdev, tc990_IMAGE_SIZE, 
                            np->DownloadPageVirtual, 
                            np->DownloadPagePhysical);
        return 1;

    }

    udelay(5000);    

    /* Acknowledge the status. */

    writel(tc990_3XP_COMM_INT0, ioaddr + tc990_INT_STATUS_REG);
    writel(fileHeader->ExecuteAddress, ioaddr + tc990_HostTo3XP_COMM_1_REG);
    writel(tc990_BOOTCMD_RUNTIME_IMAGE, ioaddr + tc990_HostTo3XP_COMM_0_REG); 

    thisSectionHeaderLocation = sizeof(struct _tc990_FILE_HEADER ); 

    sections = fileHeader->NumSections;   

    for (index = 0; index < sections; index++) {   

        fileSection = (tc990_FILE_SECTION*)
              (tc990image +  thisSectionHeaderLocation );

        numBytesInThisSection      = fileSection->num_bytes;
        start_address              = fileSection->start_address;
        thisSectionDataLocation    = sizeof( tc990_FILE_SECTION );

        while(numBytesInThisSection) {

            /* wait for 3cr990 to be ready to accept this section.  */

            for ( count = 0; count < tc990_WAIT_COUNTER; count++ ) {

                value = readl(ioaddr + tc990_INT_STATUS_REG );
                if ( value & tc990_3XP_COMM_INT0 ) break;
                udelay(50);

            }
            
            if ( count == tc990_WAIT_COUNTER ) {
                pci_free_consistent(np->pdev, tc990_IMAGE_SIZE, 
                                    np->DownloadPageVirtual, 
                                    np->DownloadPagePhysical);
                return 1;
            }

            udelay(5000);    
            writel(tc990_3XP_COMM_INT0, ioaddr + tc990_INT_STATUS_REG);
            value = readl(ioaddr + tc990_3XP2HOST_COMM_0_REG);

            if ( value != tc990_WAITING_FOR_SEGMENT ){

                pci_free_consistent(np->pdev, tc990_IMAGE_SIZE, 
                    np->DownloadPageVirtual, np->DownloadPagePhysical);
                return 1;

            } 

            /* Calculate the location of the data. */
            sectionDataBuffer = (u8*)(tc990image +  
                                      thisSectionHeaderLocation +
                                      thisSectionDataLocation );
            /* 
             * 3cr990 is ready to accept section. 
             * Prepare the section. Download entire 
             * segment if it fits 
             */
            tempLength  = numBytesInThisSection;
            memcpy(np->DownloadPageVirtual, sectionDataBuffer, tempLength);
            checksum = calculate_buffer_checksum(
                           (u16 *)np->DownloadPageVirtual, tempLength);

            writel(tempLength, ioaddr + tc990_HostTo3XP_COMM_1_REG);
            writel(checksum, ioaddr + tc990_HostTo3XP_COMM_2_REG);
            writel(start_address, ioaddr + tc990_HostTo3XP_COMM_3_REG);
            writel(0, ioaddr + tc990_HostTo3XP_COMM_4_REG);
            writel(np->DownloadPagePhysical, 
                   ioaddr + tc990_HostTo3XP_COMM_5_REG);

            writel(tc990_BOOTCMD_SEGMENT_AVAILABLE, 
                   ioaddr + tc990_HostTo3XP_COMM_0_REG);

            /* Update length and load address for next pass.*/
            numBytesInThisSection    -= tempLength;
            start_address            += tempLength;
            
            /* Update the section data location. */
            thisSectionDataLocation += tempLength;

        }  

        /* Update the section header location */
        numBytesInThisSection     = fileSection->num_bytes;
        thisSectionHeaderLocation += (numBytesInThisSection +
                                      sizeof(tc990_FILE_SECTION));
    }

    udelay(5000);        
    /*
     * We have been able to download all the sections successfully.
     * Tell 3cr990 we are done and wait for a boot message.
     */
        
    writel(tc990_BOOTCMD_DOWNLOAD_COMPLETE, ioaddr+tc990_HostTo3XP_COMM_0_REG);
    for ( count = 0; count < tc990_WAIT_COUNTER; count++ ) {

        value = readl(ioaddr + tc990_3XP2HOST_COMM_0_REG);
        if ( value == tc990_WAITING_FOR_BOOT ) break;
        udelay(50);

    }

    if ( count == tc990_WAIT_COUNTER ) {
        pci_free_consistent(np->pdev, tc990_IMAGE_SIZE, 
                            np->DownloadPageVirtual, np->DownloadPagePhysical);
        return 1;
    }

    udelay(100); 

    /* Program the original values back on IntEnable and IntMask */
    writel(oldIntMask, ioaddr + tc990_INT_MASK_REG);
    writel(oldIntEnable, ioaddr + tc990_INT_ENABLE_REG);
    
    pci_free_consistent(np->pdev, tc990_IMAGE_SIZE, np->DownloadPageVirtual,
                        np->DownloadPagePhysical);
    return 0;
}

static u16 calculate_buffer_checksum(u16 *Buffer,  u32 Count)
{
    u32   checksum = 0;
    while ( Count > 1 ){
        /* This is the inner loop. */
        checksum    += *Buffer++; 
        Count       -= 2;
        /* Fold 32-bit checksum to 16 bits. */
        while ( checksum >> 16 )
            checksum = ( checksum & 0xffff ) + ( checksum >> 16 );
    }    
    if ( Count > 0 ) 
        checksum += *Buffer;
    while ( checksum >> 16 )
        checksum = ( checksum & 0xffff ) + ( checksum >> 16 );
    return (u16)(~checksum );
}

static void update_tx_ring_index (u32 *writePUW)
{

    *writePUW += sizeof(TX_DESC);
      if (*writePUW >= (TX_ENTRIES * sizeof(TX_DESC)))
        *writePUW = 0;
}
/*
 * Local variables:
 *  UP-compile-command: "gcc -DMODULE -D__KERNEL__ -Wall -Wstrict-prototypes -I/usr/src/linux/include -O6 -c 3c990.c `[ -f /usr/include/linux/modversions.h ] && echo -DMODVERSIONS`"
 *  SMP-compile-command: "gcc -D__SMP__ -DMODULE -D__KERNEL__ -Wall -Wstrict-prototypes -I/usr/src/linux/include -O6 -c 3c990.c `[ -f /usr/include/linux/modversions.h ] && echo -DMODVERSIONS`"
 *  c-indent-level: 4
 *  c-basic-offset: 4
 *  tab-width: 4
 * End:
 */




