/*
 * Acenic stress specific macros
 *
 */

#ifndef _ACENIC_STRESS_H_
#define _ACENIC_STRESS_H_
#ifdef __VMKERNEL_MODULE__
#include "linux_stress.h"
#include "acenic.h"

/*
 * VMWARE_STRESS_ONLY_STOP_QUEUE
 *
 * The macro takes two parameters. The first one is the 
 * device for which queuing is to be disabled. The second
 * parameter is a hack to specify where control should
 * be transferred when the stress counter is hit. Typically,
 * it is either a continue or a return statement.
 *
 */
#define VMWARE_STRESS_ONLY_STOP_QUEUE(dev, CONTINUE_CMD)                   \
if (VMK_STRESS_DEBUG_COUNTER(NET_HW_STOP_QUEUE)) {                         \
   netif_stop_queue(dev);                                                  \
   CONTINUE_CMD;                                                           \
} else {                                                                   \
   if (netif_queue_stopped(dev) && netif_carrier_ok(dev)) {                \
      netif_wake_queue(dev);                                               \
   }                                                                       \
}


/*
 * LinuxStress_StressIntrRate
 *
 * This is the Acenic specific interrupt rate control function.
 * This is invoked through a tasklet that is scheduled in the
 * Acenic interrupt handler whenever the interrupt rate is changed.
 *
 */

static
void LinuxStress_StressIntrRate(unsigned long data)
{
   struct ace_private *ap = (struct ace_private *)data;
   struct ace_regs *regs   = ap->regs;
   printk(KERN_EMERG" Changing interrupt rate to %u\n",
	  VMK_STRESS_DEBUG_VALUE(NET_HW_INTR_RATE));
   
   writel(VMK_STRESS_DEBUG_VALUE(NET_HW_INTR_RATE),
	  &regs->TuneTxCoalTicks);
   writel(VMK_STRESS_DEBUG_VALUE(NET_HW_INTR_RATE),
          &regs->TuneRxCoalTicks);
   wmb();
}
#else
/* These are definitions when __VMKERNEL_MODULE__ is not defined.
 * Some of them are from linux_stress.h. The reason the default cases
 * are defined here is that linux_stress.h is not in the include
 * path when __VMKERNEL_MODULE__ is not defined.
 */
#define VMWARE_STRESS_RETAIN_BUFFER(skb, CONTINUE_CMD, ELSE_CMD) ELSE_CMD;
#define VMWARE_STRESS_ONLY_STOP_QUEUE(dev, CONTINUE_CMD)
#define VMWARE_STRESS_ONLY_SET_INTR_RATE(param, compare)
#define VMWARE_STRESS_ONLY_CORRUPT_BUFFER(COUNTER, skb, len)
#define VMWARE_STRESS_ONLY_FAIL_BUFFER(COUNTER, skb, FREE_SKB, CONTINUE_CMD)
#endif // __VMKERNEL_MODULE__
#define NO_ELSE_CMD
#define NO_CONTINUE_CMD
#endif // _ACENIC_STRESS_H_
